/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.factory;

import com.kingdee.eas.hr.ats.validator.BillValidator;
import com.kingdee.eas.hr.ats.validator.OtherOutBillValidator;
import com.kingdee.eas.hr.ats.validator.OutsideBillValidator;
import com.kingdee.eas.hr.ats.validator.TelecommuteBillValidator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

public class BillValidatorFactroy {
    private static Map<String, BillValidator> validatorMap = new ConcurrentHashMap<String, BillValidator>(16);
    private static String OUTSIDE_NUMBER = "0001";
    private static String OTHER_NUMBER = "0002";
    private static String TC_NUMBER = "0003";

    public static BillValidator createValidator(String type) {
        BillValidator validator = null;
        if (StringUtils.equals((String)type, (String)"FD5kbNUETbmUYC/iDDZ9hcVD0ro=")) {
            if (validatorMap.containsKey(OUTSIDE_NUMBER)) {
                validator = validatorMap.get(OUTSIDE_NUMBER);
            } else {
                validator = new OutsideBillValidator();
                validatorMap.put(OUTSIDE_NUMBER, validator);
            }
        } else if (StringUtils.equals((String)type, (String)"Ea7azLiFTva0RW/ne7bGc8VD0ro=")) {
            if (validatorMap.containsKey(OTHER_NUMBER)) {
                validator = validatorMap.get(OTHER_NUMBER);
            } else {
                validator = new TelecommuteBillValidator();
                validatorMap.put(OTHER_NUMBER, validator);
            }
        } else if (validatorMap.containsKey(TC_NUMBER)) {
            validator = validatorMap.get(TC_NUMBER);
        } else {
            validator = new OtherOutBillValidator();
            validatorMap.put(TC_NUMBER, validator);
        }
        return validator;
    }
}

