/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.formula.limit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsHolidayResEnum;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.timezone.Date;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.formulaplatform.FormulaException;
import com.kingdee.shr.formulaplatform.FormulaItemInfo;
import com.kingdee.shr.formulaplatform.UpdateTypeEnum;
import com.kingdee.shr.formulaplatform.app.CollectionUtil;
import com.kingdee.shr.formulaplatform.baseconfig.FormulaSqlParam;
import com.kingdee.shr.formulaplatform.formulaexecutor.DefaultFormulaExecutor;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LimitFormulaExecutor
extends DefaultFormulaExecutor {
    private static Logger logger = Logger.getLogger(LimitFormulaExecutor.class);
    private String hrOrgUnit;
    private String adminOrgUnit;
    private String holidayType;
    private String persons;
    private String adminOrgUnitNum;
    private String holidayTypeName;
    private String personsNum;
    private java.util.Date cycleDate;

    public LimitFormulaExecutor() {
        this.getFormulaCtx().addPrimaryField("proposer");
        this.getFormulaCtx().addPrimaryField("holidayPolicy");
        this.getFormulaCtx().addPrimaryField("hrOrgUnit");
    }

    protected String getSelectSql(Context ctx, List<FormulaItemInfo> items, List<CoreBaseInfo> waitSaveData) {
        String sql = super.getSelectSql(ctx, items, waitSaveData);
        sql = sql.replace("fid", "fcycleBeginDate,fcycleEndDate,fid");
        sql = sql + "and fcycleBeginDate<={ts '" + this.cycleDate + "'} and fcycleEndDate>={ts '" + this.cycleDate + "'}";
        return sql;
    }

    protected BatchMessageTipsBody validateSaveData(Context ctx, CoreBaseInfo coreBaseInfo, Map<List<Object>, Object> existDataMap) {
        List existData = (List)existDataMap.get(this.getExistKey(coreBaseInfo));
        if (CollectionUtil.isEmpty((Collection)existData)) {
            return null;
        }
        HolidayLimitInfo curData = (HolidayLimitInfo)coreBaseInfo;
        if (this.getFormulaCtx().getUpdateType() == UpdateTypeEnum.NEW_ADD) {
            return new BatchMessageTipsBody(null, false, MLUtile.getRes((ResourceEnum)AtsHolidayResEnum.IgnoreUpdateHolidayPolicy, ctx, curData.getProposer().getName(), curData.getHolidayPolicy().getName()));
        }
        for (HolidayLimitInfo existInfo : existData) {
            if (existInfo.getCycleBeginDate().equals(curData.getCycleBeginDate()) && curData.getCycleEndDate().equals(curData.getCycleEndDate())) continue;
            logger.error((Object)MessageFormat.format("exist data but not the same date range,{0}~{1}~{2};", curData.getProposer().getString("id"), curData.getCycleBeginDate(), curData.getCycleEndDate()));
            return null;
        }
        curData.put("id", ((HolidayLimitInfo)existData.get(0)).getId());
        return null;
    }

    protected void pupolateExistData(IRowSet rowSet, Map<List<Object>, Object> existDataMap) throws SQLException {
        List<HolidayLimitInfo> existData;
        HolidayLimitInfo limitInfo = new HolidayLimitInfo();
        limitInfo.setId(BOSUuid.read((String)rowSet.getString("fid")));
        limitInfo.setCycleBeginDate(rowSet.getTimestamp("fcycleBeginDate"));
        limitInfo.setCycleEndDate(rowSet.getTimestamp("fcycleEndDate"));
        List key = this.getExistKey(rowSet);
        if (existDataMap.containsKey(key)) {
            existData = (List)existDataMap.get(key);
        } else {
            existData = new ArrayList();
            existDataMap.put(key, existData);
        }
        existData.add(limitInfo);
    }

    protected FormulaSqlParam createSqlParam(Context ctx, List<FormulaItemInfo> items, int curBatch) throws FormulaException {
        FormulaSqlParam param = super.createSqlParam(ctx, items, curBatch);
        param.setNeedReplaceVar("ats_baseDate", (Object)this.cycleDate);
        return param;
    }

    public void init(Context ctx) {
        this.cycleDate = Date.getNoNullDate((Object)this.cycleDate);
        this.getFormulaCtx().addExecutorConfig((Object)"ats_baseDate", (Object)this.cycleDate);
        FilterInfo filterInfo = new FilterInfo();
        try {
            filterInfo.mergeFilter(this.getAdminOrgFilter(ctx), "AND");
            filterInfo.mergeFilter(this.getHrOrgFilter(ctx), "AND");
            filterInfo.mergeFilter(this.getHolidayTypeFilter(ctx), "AND");
            filterInfo.mergeFilter(this.getPersonFilter(ctx), "AND");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.getFormulaCtx().setSchemeDataFilterInfo(filterInfo);
        this.initFormulaFilterInfo(ctx);
    }

    protected FilterInfo getHrOrgFilter(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        if (StringUtils.isNotBlank((String)this.hrOrgUnit)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("hROrgUnit.id", (Object)this.hrOrgUnit, CompareType.EQUALS));
        }
        return filterInfo;
    }

    protected FilterInfo getPersonFilter(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        if (StringUtils.isNotBlank((String)this.persons)) {
            HashSet<String> personSet = new HashSet<String>(Arrays.asList(this.persons.split(",")));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", personSet, CompareType.INCLUDE));
        }
        if (StringUtils.isNotBlank((String)this.personsNum)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("person.number", new HashSet<String>(Arrays.asList(this.personsNum.split(","))), CompareType.INCLUDE));
        }
        if (filterInfo.getFilterItems().size() == 2) {
            filterInfo.setMaskString("#0 or #1");
        }
        return filterInfo;
    }

    protected FilterInfo getHolidayTypeFilter(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        if (StringUtils.isNotBlank((String)this.holidayType)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("holidayType.id", (Object)this.holidayType, CompareType.EQUALS));
        }
        if (StringUtils.isNotBlank((String)this.holidayTypeName)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("holidayType.name", new HashSet<String>(Arrays.asList(this.holidayTypeName.split(","))), CompareType.INCLUDE));
        }
        if (filterInfo.getFilterItems().size() == 0) {
            // empty if block
        }
        if (filterInfo.getFilterItems().size() == 2) {
            filterInfo.setMaskString("#0 or #1");
        }
        return filterInfo;
    }

    protected FilterInfo getAdminOrgFilter(Context ctx) {
        HashSet<String> filterSet = new HashSet<String>();
        if (StringUtils.isNotBlank((String)this.adminOrgUnitNum)) {
            filterSet.addAll(Arrays.asList(this.adminOrgUnitNum.split(",")));
        }
        FilterInfo filterInfo = new FilterInfo();
        if (StringUtils.isNotBlank((String)this.adminOrgUnit)) {
            try {
                AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.adminOrgUnit));
                filterSet.add(adminOrgUnitInfo.getLongNumber());
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (filterSet.size() == 0) {
            return filterInfo;
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", filterSet, CompareType.INCLUDE));
        int i = 0;
        StringBuffer mask = new StringBuffer("#0");
        for (String filter : filterSet) {
            mask.append(" or #").append(++i);
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(filter + "!%"), CompareType.LIKE));
        }
        filterInfo.setMaskString(mask.toString());
        return filterInfo;
    }

    protected void initFormulaFilterInfo(Context ctx) {
        String whereSql = this.getFormulaCtx().getSchemeDataFilterInfo().toString();
        if (whereSql.length() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select ruleFormula.fid,takeFormula.fid from T_HR_ATS_AtsHolidayFileHis hfileHis");
        sql.append(" join T_BD_PERSON person on person.fid=hfileHis.FproposerID");
        sql.append(" join T_ORG_Admin adminOrg on adminOrg.fid=hfileHis.FAdminOrgUnitID");
        sql.append(" join T_HR_ATS_HolidayPolicySet hpolicySet on hpolicySet.fid=hfileHis.FHolidayPolicySetID");
        sql.append(" join T_HR_ATS_HolidayPolicy hpolicy on hpolicy.FHolidayPolicySetID=hpolicySet.fid");
        sql.append(" join T_HR_ATS_HolidayType htype on htype.fid=hpolicy.FHolidayTypeID");
        sql.append(" left join T_HR_ATS_HolidayRule hRule on hpolicy.FHolidayRuleID=hRule.fid");
        sql.append(" left join T_ATS_LimitFormulaItem ruleFormula on hRule.fid=ruleFormula.FormulaID");
        sql.append(" left join T_HR_ATS_TakeWorking takeWorking on hpolicy.FTakeWorkingRuleID=takeWorking.fid");
        sql.append(" left join T_ATS_TakeWorkingItem takeFormula on takeWorking.fid=takeFormula.FormulaID");
        String cycleDateStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.cycleDate);
        sql.append(" where hfileHis.feffdt<={ts'").append(cycleDateStr).append("'} and hfileHis.fleffdt>={ts '").append(cycleDateStr).append("'} and ");
        sql.append(whereSql.replaceAll("adminOrgUnit\\.longNumber", "adminOrg.flongNumber").replace("person.id", "person.fid").replace("person.number", "person.fnumber").replace("holidayType.id", "htype.fid").replace("holidayType.name", "htype.fname_" + LocaleUtils.getShortCode((Locale)ctx.getLocale())).replace("hROrgUnit.id", "hfileHis.fhrOrgUnitId"));
        HashSet<String> formulaId = new HashSet<String>();
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (iRowSet.next()) {
                if (StringUtils.isNotBlank((String)iRowSet.getString(1))) {
                    formulaId.add(iRowSet.getString(1));
                }
                if (!StringUtils.isNotBlank((String)iRowSet.getString(2))) continue;
                formulaId.add(iRowSet.getString(2));
            }
            FilterInfo formulaFilterInfo = new FilterInfo();
            formulaFilterInfo.getFilterItems().add(new FilterItemInfo("formula", formulaId, CompareType.INCLUDE));
            this.getFormulaCtx().setFormulaFilterInfo(formulaFilterInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getHrOrgUnit() {
        return this.hrOrgUnit;
    }

    public LimitFormulaExecutor setHrOrgUnit(String hrOrgUnit) {
        this.hrOrgUnit = hrOrgUnit;
        return this;
    }

    public String getAdminOrgUnit() {
        return this.adminOrgUnit;
    }

    public LimitFormulaExecutor setAdminOrgUnit(String adminOrgUnit) {
        this.adminOrgUnit = adminOrgUnit;
        return this;
    }

    public String getHolidayType() {
        return this.holidayType;
    }

    public LimitFormulaExecutor setHolidayType(String holidayType) {
        this.holidayType = holidayType;
        return this;
    }

    public String getPersons() {
        return this.persons;
    }

    public LimitFormulaExecutor setPersons(String persons) {
        this.persons = persons;
        return this;
    }

    public String getAdminOrgUnitNum() {
        return this.adminOrgUnitNum;
    }

    public LimitFormulaExecutor setAdminOrgUnitNum(String adminOrgUnitNum) {
        this.adminOrgUnitNum = adminOrgUnitNum;
        return this;
    }

    public String getHolidayTypeName() {
        return this.holidayTypeName;
    }

    public LimitFormulaExecutor setHolidayTypeName(String holidayTypeName) {
        this.holidayTypeName = holidayTypeName;
        return this;
    }

    public String getPersonsNum() {
        return this.personsNum;
    }

    public LimitFormulaExecutor setPersonsNum(String personsNum) {
        this.personsNum = personsNum;
        return this;
    }

    public java.util.Date getCycleDate() {
        return this.cycleDate;
    }

    public LimitFormulaExecutor setCycleDate(java.util.Date cycleDate) {
        this.cycleDate = cycleDate;
        return this;
    }

    public static UpdateTypeEnum getUpdateTypeEnum(String existedDealType) {
        if ("0".equals(existedDealType)) {
            return UpdateTypeEnum.NEW_ADD;
        }
        return UpdateTypeEnum.OVERRIDE_ADD;
    }
}

