/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.function;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.app.formula.calculate.data.Tools;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AtsTripBillEntryDataFunc {
    private final long oneDayTime = 86400000L;

    public Object getCurrentTripEntryData(Map paramMap) throws ParseException, BOSException, SQLException {
        Context ctx = Tools.getInstance().getCtx();
        String personId = (String)paramMap.get("T_HR_ATS_ATTENDANCERESULT_FPROPOSERID");
        String currDateStr = (String)paramMap.get("T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE");
        return this.getTripEntryData(ctx, personId, currDateStr, currDateStr);
    }

    public Object getTripEntryData(Context ctx, String personIds, String strBeginDate, String strEndDate) throws BOSException, SQLException {
        HashMap resultMap = new HashMap();
        if (StringUtils.isEmpty((CharSequence)personIds)) {
            return resultMap;
        }
        String personsWhere = "(";
        for (String personId : personIds.split(",")) {
            personsWhere = personsWhere + "'" + personId + "',";
        }
        personsWhere = personsWhere + "'')";
        String sql = "select bill.fnumber as billNum,bill.fapplyDate,entry.fbillId,entry.fpersonId,entry.FTripTypeID,entry.ftripStartTime,entry.ftripEndTime,entry.ftripDays,entry.FTripStartPlace,entry.ftripEndPlace,entry.FRemark,tripType.fid as tripType_id ,tripType.fname" + MLUtile.getMlFlag(ctx) + " as tripType_name,tripType.fnumber as tripType_number from T_HR_ATS_TripBill bill  inner join t_hr_ats_tripbillentry entry on bill.fid = entry.fbillid left join T_HR_ATS_TripType tripType on entry.FTripTypeID = tripType.fid where entry.fpersonId in " + personsWhere + " and bill.fbillState = " + 3 + " and entry.FTripStartTime <= {ts '" + strBeginDate + "'}  and entry.FTripEndTime >= {ts '" + strEndDate + "'}  order by entry.FTripStartTime";
        IRowSet iRow = DbUtil.executeQuery((Context)ctx, (String)sql, null);
        if (iRow != null) {
            while (iRow.next()) {
                String personId;
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                personId = iRow.getString("fpersonId");
                String tripStartTime = AtsDateUtils.dateShortToString(iRow.getTimestamp("FTripStartTime"));
                String tripEndTime = AtsDateUtils.timestampToString(iRow.getTimestamp("ftripEndTime"));
                tempMap.put("applyDate", AtsDateUtils.dateShortToString(iRow.getDate("fapplyDate")));
                tempMap.put("billId", iRow.getString("fbillId"));
                tempMap.put("billId.number", iRow.getString("billNum"));
                tempMap.put("tripType.id", iRow.getString("tripType_id"));
                tempMap.put("tripType.name", iRow.getString("tripType_name"));
                tempMap.put("tripType.number", iRow.getString("tripType_number"));
                tempMap.put("tripReason.id", iRow.getString("tripType_id"));
                tempMap.put("tripReason", iRow.getString("tripType_name"));
                tempMap.put("tripStartTime", tripStartTime);
                tempMap.put("tripEndTime", tripEndTime);
                BigDecimal tripDays = iRow.getBigDecimal("ftripDays");
                tempMap.put("tripDays", tripDays == null ? "" : Double.valueOf(tripDays.doubleValue()));
                tempMap.put("tripStartPlace", iRow.getString("FTripStartPlace"));
                tempMap.put("tripEndPlace", iRow.getString("ftripEndPlace"));
                tempMap.put("remark", iRow.getString("FRemark"));
                Date beginDate = AtsDateUtils.stringToShortDate(tripStartTime);
                Date endDate = AtsDateUtils.stringToShortDate(tripEndTime);
                HashMap dataMap = (HashMap)resultMap.get(personId);
                while (beginDate.getTime() <= endDate.getTime()) {
                    HashSet<HashMap<String, Object>> set;
                    String dateKey = AtsDateUtils.dateShortToString(beginDate);
                    if (dataMap != null) {
                        if (dataMap.containsKey(dateKey)) {
                            ((HashSet)dataMap.get(dateKey)).add(tempMap);
                        } else {
                            set = new HashSet<HashMap<String, Object>>();
                            set.add(tempMap);
                            dataMap.put(dateKey, set);
                        }
                    } else {
                        dataMap = new HashMap();
                        set = new HashSet();
                        set.add(tempMap);
                        dataMap.put(dateKey, set);
                        resultMap.put(personId, dataMap);
                    }
                    beginDate.setTime(beginDate.getTime() + 86400000L);
                }
            }
        }
        return resultMap;
    }
}

