/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbstractAtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.eas.hr.ats.CancelLeaveBillEntryFactory;
import com.kingdee.eas.hr.ats.CancelLeaveBillEntryInfo;
import com.kingdee.eas.hr.ats.CancelLeaveBillFactory;
import com.kingdee.eas.hr.ats.CancelLeaveBillInfo;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.app.AtsLeaveBillEntryControllerBean;
import com.kingdee.eas.hr.ats.holidayLimit.CoreBaseRockBackLimit;
import com.kingdee.eas.hr.ats.result.AttendCalculateJob;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsLeaveBillLimitServer;
import com.kingdee.eas.hr.ats.util.AtsLeaveBillSplitHelper;
import com.kingdee.eas.hr.ats.util.AtsServerUtils;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashMap;

public class CancelLeaveBillRockBackLimit
extends CoreBaseRockBackLimit {
    private CancelLeaveBillInfo cancelLeaveBillInfo;
    private String entryBillId;

    public CancelLeaveBillInfo getCancelLeaveBillInfo() {
        return this.cancelLeaveBillInfo;
    }

    public void setCancelLeaveBillInfo(CancelLeaveBillInfo cancelLeaveBillInfo) {
        this.cancelLeaveBillInfo = cancelLeaveBillInfo;
    }

    public String getEntryBillId() {
        return this.entryBillId;
    }

    public void setEntryBillId(String entryBillId) {
        this.entryBillId = entryBillId;
    }

    public CancelLeaveBillRockBackLimit(Context ctx, String billId, CancelLeaveBillInfo cancelLeaveBillInfo, String leavebillId) throws EASBizException, BOSException {
        super(ctx, billId, 4);
        this.setCancelLeaveBillInfo(cancelLeaveBillInfo);
        this.setEntryBillId(leavebillId);
    }

    @Override
    public void beforeRockBackLimit(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo, HRBillStateEnum hRBillStateEnum) throws BOSException {
        super.beforeRockBackLimit(ctx, atsLeaveBillInfo, HRBillStateEnum.SAVED);
    }

    @Override
    public void baseRockBackLimit(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo) throws EASBizException, BOSException {
        AtsLeaveBillEntryInfo entry = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo(" where id='" + this.entryBillId + "'");
        super.baseRockBackLimit(ctx, entry, atsLeaveBillInfo.getHrOrgUnit().getId().toString());
        atsLeaveBillInfo = this.updateLeaveBillInfoData(ctx, this.cancelLeaveBillInfo);
        String policyId = entry.getPolicy().getId().toString();
        HolidayPolicyInfo holidayPolicyInfo = AtsServerUtils.getHolidayPolicyInfoById(ctx, policyId);
        if (holidayPolicyInfo.isIsCtrlLimit()) {
            HashMap<String, Object> billInfoMap = new HashMap<String, Object>();
            billInfoMap.put("billInfo", atsLeaveBillInfo);
            billInfoMap.put("atsLeaveBillEntryInfo", entry);
            AtsLeaveBillLimitServer leaveBillLimitServer = new AtsLeaveBillLimitServer();
            leaveBillLimitServer.updateYearVacationLimitBysubmitEffectNew(ctx, atsLeaveBillInfo.getId(), billInfoMap);
        }
    }

    @Override
    public void afterRockBackLimit(Context ctx, AtsLeaveBillInfo atsLeaveBillInfo) throws BOSException {
        try {
            this.deleteAtsLeaveBillDetail(ctx, this.getEntryBillId());
            AtsLeaveBillEntryInfo info = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo(" where id='" + this.getEntryBillId() + "'");
            AtsLeaveBillSplitHelper atsLeaveBillSplitHelper = new AtsLeaveBillSplitHelper(ctx, atsLeaveBillInfo, info);
            atsLeaveBillSplitHelper.splitLeaveBill();
            this.againstApproveBill(ctx, this.cancelLeaveBillInfo.getId().toString());
            this.triggerAttendanceCal(ctx, this.cancelLeaveBillInfo.getId().toString());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    private void deleteAtsLeaveBillDetail(Context ctx, String leaveBillId) {
        String sql = "delete  from T_HR_ATS_LeaveBillDetail  where  FLeavebillEntryID ='" + leaveBillId + "'";
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public AtsLeaveBillInfo updateLeaveBillInfoData(Context ctx, CancelLeaveBillInfo cancelLeaveBillInfo) {
        AtsLeaveBillEntryControllerBean leaveEntryControllerBean = new AtsLeaveBillEntryControllerBean();
        CoreBaseCollection coll = new CoreBaseCollection();
        AtsLeaveBillInfo info = this.getAtsLeaveBillInfo();
        AbstractAtsLeaveBillEntryInfo entryinfo = null;
        try {
            entryinfo = AtsLeaveBillEntryFactory.getLocalInstance(ctx).getAtsLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(cancelLeaveBillInfo.getEntries().get(0).getLeaveEntryBill().getId().toString()));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        if (entryinfo != null) {
            entryinfo.setRealBeginTime(info.getEntries().get(0).getBeginTime());
            entryinfo.setRealEndTime(info.getEntries().get(0).getEndTime());
            entryinfo.setRealLeaveLength(info.getEntries().get(0).getLeaveLength());
            coll.add((CoreBaseInfo)entryinfo);
        }
        try {
            leaveEntryControllerBean.update(ctx, coll);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return info;
    }

    public void againstApproveBill(Context ctx, String billId) {
        try {
            String sql = "update  T_HR_ATS_CanLeaveBill   set fbillState = 0  where fid =  '" + billId + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void triggerAttendanceCal(Context ctx, String billIds) throws EASBizException, BOSException {
        CancelLeaveBillInfo cancelleaveInfo = CancelLeaveBillFactory.getLocalInstance(ctx).getCancelLeaveBillInfo(" where id='" + billIds + "'");
        AttendCalculateJob backJob = new AttendCalculateJob();
        String canleavebillId = cancelleaveInfo.getId().toString();
        String billNumber = cancelleaveInfo.getNumber();
        CancelLeaveBillEntryInfo entryInfo = CancelLeaveBillEntryFactory.getLocalInstance(ctx).getCancelLeaveBillEntryInfo(" where bill='" + canleavebillId + "' ");
        String personId = entryInfo.getPerson().getId().toString();
        String beginTime = AtsDateUtils.timestampToString(entryInfo.getRealLeaBeginTime());
        String endTime = AtsDateUtils.timestampToString(entryInfo.getRealLeaEndTime());
        backJob.createCancelLeaveBillAgainstTriggerAttendCalJob(ctx, beginTime, endTime, canleavebillId, personId, billNumber);
    }
}

