/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit.generate.manager;

import com.kingdee.eas.hr.ats.LimitGrantStyle;
import com.kingdee.eas.hr.ats.holidayLimit.generate.rule.GenPiecewiseBO;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;

public class GenPiecewiseManager {
    private static final Logger logger = Logger.getLogger(GenPiecewiseManager.class);
    private static final int YEAR_OF_DAY = 365;
    private static final int YEAR_OF_MONTH = 12;

    public static BigDecimal processPiecewiseCal(GenPiecewiseBO genPiecewiseBO, LimitGrantStyle limitGrantStyle) {
        logger.error((Object)MessageFormat.format("-------genPiecewiseBO={0},limitGrantStyle={1}", new Object[]{genPiecewiseBO, limitGrantStyle}));
        if (genPiecewiseBO == null || genPiecewiseBO.getCycleBeginDate() == null || genPiecewiseBO.getCycleEndDate() == null || genPiecewiseBO.getYearCnt1() <= 0.0f || AtsCollectionUtile.isEmpty(genPiecewiseBO.getPiecewiseBOList()) || genPiecewiseBO.getPiecewiseBOList().size() <= 1 || limitGrantStyle == null) {
            return null;
        }
        float yearCtn1 = genPiecewiseBO.getYearCnt1();
        Date beginDate = genPiecewiseBO.getCycleBeginDate();
        Date endDate = genPiecewiseBO.getLeftDate();
        float yearCtn2 = genPiecewiseBO.getYearCnt2();
        if (endDate == null) {
            endDate = genPiecewiseBO.getCycleEndDate();
        }
        Date calDate = HRTimeWebUtils.stringToShortDate(HRTimeWebUtils.getCurentShortStringDate());
        return GenPiecewiseManager.getPiecewiseStandardVal(genPiecewiseBO, yearCtn1, yearCtn2, beginDate, endDate, calDate, limitGrantStyle);
    }

    private static BigDecimal getPiecewiseStandardVal(GenPiecewiseBO genPiecewiseBO, float yearCtn1, float yearCtn2, Date beginDate, Date endDate, Date calDate, LimitGrantStyle limitGrantStyle) {
        if (limitGrantStyle == null || limitGrantStyle != LimitGrantStyle.grantByMonth && limitGrantStyle != LimitGrantStyle.grantByQuarter) {
            return null;
        }
        logger.error((Object)MessageFormat.format("-----------calDate={0}", calDate));
        if (limitGrantStyle == LimitGrantStyle.grantByMonth) {
            calDate = AtsDateUtils.getMonthLastDay(calDate);
        } else if (limitGrantStyle == LimitGrantStyle.grantByQuarter) {
            calDate = AtsDateUtils.getSeasonLastDay(calDate);
        }
        if (calDate.after(endDate)) {
            calDate = endDate;
        }
        logger.error((Object)MessageFormat.format("-----------calDate={0}", calDate));
        BigDecimal standardVal = BigDecimal.ZERO;
        Date lastDate = beginDate;
        boolean isFirst = true;
        int i = 0;
        for (GenPiecewiseBO.PiecewiseBO piecewiseBO : genPiecewiseBO.getPiecewiseBOList()) {
            BigDecimal segConvertVal;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(beginDate);
            BigDecimal next = piecewiseBO.getNext();
            boolean isEnd = false;
            if (genPiecewiseBO.getPiecewiseBOList().size() - 1 == i) {
                isEnd = true;
            }
            if (next.compareTo(new BigDecimal(yearCtn2)) > 0) {
                next = new BigDecimal(yearCtn2);
            }
            calendar.add(6, (int)(next.subtract(new BigDecimal(yearCtn1)).floatValue() * 365.0f + 0.002739726f));
            Date criticalDate = calendar.getTime();
            if (!piecewiseBO.isEqualNext()) {
                if (genPiecewiseBO.getConvertType() == 1) {
                    criticalDate = DateUtils.addDays((Date)criticalDate, (int)-1);
                } else if (genPiecewiseBO.getConvertType() == 2) {
                    criticalDate = DateUtils.addMonths((Date)criticalDate, (int)-1);
                }
            }
            if (criticalDate.after(endDate) || isEnd) {
                criticalDate = endDate;
            }
            if (calDate.before(criticalDate)) {
                segConvertVal = GenPiecewiseManager.calSegVal(genPiecewiseBO, piecewiseBO, calDate, lastDate, isFirst);
                if (segConvertVal == null) break;
                standardVal = standardVal.add(segConvertVal);
                break;
            }
            segConvertVal = GenPiecewiseManager.calSegVal(genPiecewiseBO, piecewiseBO, criticalDate, lastDate, isFirst);
            if (segConvertVal != null) {
                standardVal = standardVal.add(segConvertVal);
            }
            lastDate = criticalDate;
            isFirst = false;
            ++i;
        }
        return standardVal;
    }

    private static BigDecimal calSegVal(GenPiecewiseBO genPiecewiseBO, GenPiecewiseBO.PiecewiseBO piecewiseBO, Date calDate, Date lastDate, boolean isFirst) {
        Integer subLength = null;
        Integer totalLength = null;
        if (genPiecewiseBO.getConvertType() == 1) {
            subLength = (int)((calDate.getTime() - lastDate.getTime()) / 86400000L) + 1;
            totalLength = 365;
        } else if (genPiecewiseBO.getConvertType() == 2) {
            subLength = AtsDateUtils.getTwoDateDiffMonth(lastDate, calDate);
            totalLength = 12;
        } else {
            logger.error((Object)"not konw type............");
            return null;
        }
        if (!isFirst) {
            subLength = subLength - 1;
        }
        if (totalLength != null && totalLength > 0 && subLength != null && subLength > 0) {
            return piecewiseBO.getSegVal().multiply(new BigDecimal(subLength)).divide(new BigDecimal(totalLength), 5, RoundingMode.HALF_UP);
        }
        return null;
    }
}

