/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.holidayLimit.generate.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.HolidayLimitBillTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitChangeType;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailCollection;
import com.kingdee.eas.hr.ats.HolidayLimitDetailFactory;
import com.kingdee.eas.hr.ats.HolidayLimitDetailInfo;
import com.kingdee.eas.hr.ats.HolidayLimitDetailStatusEnum;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.IHolidayLimitDetail;
import com.kingdee.eas.hr.ats.holidayLimit.generate.manager.GenHolidayLimitManager;
import com.kingdee.eas.hr.ats.holidayLimit.generate.preparedata.InitHolidayLimitData;
import com.kingdee.eas.hr.ats.holidayLimit.generate.service.ReCalHolidayLimitService;
import com.kingdee.eas.hr.ats.holidayLimit.generate.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.util.common.DataSaver;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ReCalHolidayLimitServiceImpl
implements ReCalHolidayLimitService {
    private Logger logger = Logger.getLogger(ReCalHolidayLimitServiceImpl.class);
    protected Map<Object, Object> globalMap = new HashMap<Object, Object>();
    private static final int LIMITSIZE = 200;

    @Override
    public void initData(Context ctx, Map<Object, Object> globalMap) {
        this.globalMap = globalMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initDeal(Context ctx, CoreBaseCollection allColls) {
        block11: {
            Map holidayPolicyMap = (Map)this.globalMap.get("holidayPolicyMap");
            Map personPositionMap = (Map)this.globalMap.get("personPositionMap");
            if (null == holidayPolicyMap || personPositionMap == null || null == allColls) {
                return;
            }
            HashMap<String, HolidayLimitInfo> holidayLimitInfoMap = new HashMap<String, HolidayLimitInfo>();
            for (int i = 0; i < allColls.size(); ++i) {
                HolidayLimitInfo holidayLimitInfo = (HolidayLimitInfo)allColls.get(i);
                holidayLimitInfoMap.put(holidayLimitInfo.getId().toString(), holidayLimitInfo);
            }
            String tempTableName = null;
            String holidayLimitIdStr = null;
            try {
                Set<String> limitIdSet = holidayLimitInfoMap.keySet();
                if (null != limitIdSet && limitIdSet.size() > 200) {
                    tempTableName = this.genHolidayLimitTempTable(ctx, new ArrayList<String>(limitIdSet));
                } else {
                    holidayLimitIdStr = AtsUtil.convertSetToString(limitIdSet);
                }
                this.initDealUsedLimit(ctx, holidayLimitInfoMap, tempTableName, holidayLimitIdStr);
                this.initDealFreezedLimit(ctx, holidayLimitInfoMap, tempTableName, holidayLimitIdStr);
                Map<String, HolidayLimitInfo> preHolidayLimitMap = InitHolidayLimitData.getPreHolidayLimit(ctx, tempTableName, holidayLimitIdStr);
                this.dealRealLimit(ctx, allColls, preHolidayLimitMap);
                DataSaver dataSaver = new DataSaver();
                dataSaver.setCtx(ctx).save(allColls);
                this.mergeHolidayLimitDetail(ctx, allColls, tempTableName, limitIdSet);
                this.dealOverdraftLimitDetail(ctx, allColls);
                this.clearData();
            }
            catch (Exception e) {
                e.printStackTrace();
                break block11;
            }
            finally {
                this.clearData();
                if (!StringUtils.isEmpty(tempTableName)) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                }
            }
            if (!StringUtils.isEmpty((String)tempTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
        }
    }

    private void dealRealLimit(Context ctx, CoreBaseCollection newColls, Map<String, HolidayLimitInfo> preHolidayLimitMap) {
        if (newColls != null && newColls.size() > 0) {
            HolidayLimitCollection holidayLimitCollection = new HolidayLimitCollection();
            for (int i = 0; i < newColls.size(); ++i) {
                HolidayLimitInfo holidayLimitInfo = (HolidayLimitInfo)newColls.get(i);
                if (holidayLimitInfo.getHolidayPolicy().isIsOverAutoSub()) {
                    HolidayLimitInfo preHolidayLimitInfo = preHolidayLimitMap.get(holidayLimitInfo.getProposer().getId().toString());
                    if (preHolidayLimitInfo != null && preHolidayLimitInfo.getRemainLimit().doubleValue() < 0.0) {
                        holidayLimitInfo.setRemainLimit(holidayLimitInfo.getRealLimit().subtract(holidayLimitInfo.getUsedLimit()).subtract(holidayLimitInfo.getFreezeLimit()).add(preHolidayLimitInfo.getRemainLimit()));
                        holidayLimitInfo.setPreOverdraftLimit(preHolidayLimitInfo.getRemainLimit().abs());
                    } else {
                        holidayLimitInfo.setRemainLimit(holidayLimitInfo.getRealLimit().subtract(holidayLimitInfo.getUsedLimit()).subtract(holidayLimitInfo.getFreezeLimit()));
                        holidayLimitInfo.setPreOverdraftLimit(BigDecimal.valueOf(0.0));
                    }
                } else {
                    holidayLimitInfo.setRemainLimit(holidayLimitInfo.getRealLimit().subtract(holidayLimitInfo.getUsedLimit()).subtract(holidayLimitInfo.getFreezeLimit()));
                    holidayLimitInfo.setPreOverdraftLimit(BigDecimal.valueOf(0.0));
                }
                holidayLimitCollection.add(holidayLimitInfo);
            }
            this.logger.debug((Object)"execute shiftTotalRemainLimit and remainLimit update ");
            GenHolidayLimitManager genHolidayLimitManager = new GenHolidayLimitManager();
            genHolidayLimitManager.addShiftTotalRemainLimit(holidayLimitCollection, (boolean)Boolean.FALSE, ctx);
        }
    }

    @Override
    public void initDealUsedLimit(Context ctx, Map<String, HolidayLimitInfo> holidayLimitInfoMap, String tempTableName, String holidayLimitIdStr) {
        String queryIdStr = null;
        queryIdStr = !StringUtils.isEmpty((String)tempTableName) ? " exists (select 1 from " + tempTableName + " tmpt where L.fid =tmpt.fid) " : " L.FID IN (" + holidayLimitIdStr + ") ";
        HashMap<String, HolidayLimitInfo> unExistUsedLimitMap = new HashMap<String, HolidayLimitInfo>(holidayLimitInfoMap);
        try {
            StringBuilder sqlSB = new StringBuilder();
            sqlSB.append(" SELECT fholidaylimitid,SUM(usedleavelength) usedleavelength FROM ( ").append(" select fholidaylimitid,SUM (usedleavelength) AS usedleavelength ").append(" FROM( ").append(" SELECT DISTINCT  ").append(" L.Fid AS fholidaylimitid, ").append(" hld.Fid AS fdetailid, ").append(" p.fholidaytypeid, ").append(" hld.FCHANGEVALUE AS usedleavelength ").append(" FROM T_HR_ATS_LeaveBillEntry e ").append(" INNER JOIN T_HR_ATS_LeaveBill M ON e.FBILLID = M.FID ").append(" INNER JOIN t_hr_ats_holidaypolicy p ON e.fpolicyid = p.fid ").append(" INNER JOIN T_HR_ATS_HolidayLimitDetail hld ON hld.FLEAVEBILLID = M.FID AND hld.FLEAVEBILLENTRYID = E.FID ").append(" INNER JOIN t_Hr_Ats_Holidaylimit L ON hld.FHOLIDAYLIMITID = L.FID ").append("\tINNER JOIN t_hr_ats_holidaypolicy Lhp ON Lhp.fid = L.FHOLIDAYPOLICYID ").append("and L.Fproposerid = E.Fpersonid  AND Lhp.fholidaytypeid =p.fholidaytypeid AND L.FHRORGUNITID = M.FHRORGUNITID ").append(" AND L.Fproposerid = e.Fpersonid ").append(" WHERE M.FBILLSTATE = 3").append(" AND hld.FCANCELLEAVEBILLID IS NULL ").append(" AND hld.FCHANGETYPE = 4").append(" AND " + queryIdStr).append(" ) TT ").append(" GROUP BY TT.fholidaylimitid ").append("UNION ALL  ").append(" SELECT fholidaylimitid,SUM (FREALLEAVELENGTH) AS usedleavelength  ").append(" FROM ( ").append(" SELECT DISTINCT ").append(" L.Fid AS fholidaylimitid, ").append(" hld.Fid AS fdetailid, ").append(" E.FREALLEAVELENGTH, ").append(" P.fholidaytypeid ").append(" FROM T_HR_ATS_LeaveBillEntry E ").append(" LEFT JOIN t_hr_ats_holidaypolicy P ON E.fpolicyid = P.fid ").append(" INNER JOIN T_HR_ATS_LeaveBill M ON E.FBILLID = M.FID ").append(" INNER JOIN T_HR_ATS_HolidayLimitDetail hld ON hld.FLEAVEBILLID = M.FID  AND hld.FLEAVEBILLENTRYID = E.FID").append(" INNER JOIN t_Hr_Ats_Holidaylimit L ON L.Fproposerid = E.Fpersonid ").append("\tINNER JOIN t_hr_ats_holidaypolicy Lhp ON Lhp.fid = L.FHOLIDAYPOLICYID ").append(" and  Lhp.fholidaytypeid =p.fholidaytypeid AND L.FHRORGUNITID = M.FHRORGUNITID").append(" WHERE M.FBILLSTATE = 3").append(" AND L.fcyclebegindate <= E.Frealbegintime ").append(" AND E.Frealbegintime <= L.FDELAYDATE ").append(" AND hld.FCANCELLEAVEBILLID IS NULL ").append(" AND hld.FHOLIDAYLIMITID IS NULL ").append(" AND hld.FCHANGETYPE = 4").append(" AND " + queryIdStr).append(" ) tt ").append(" GROUP BY fholidaylimitid  ").append(" )A GROUP BY fholidaylimitid ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString());
            while (rs.next()) {
                String fholidaylimitid = rs.getString("fholidaylimitid");
                HolidayLimitInfo holidayLimitInfo = holidayLimitInfoMap.get(fholidaylimitid);
                if (holidayLimitInfo == null) continue;
                holidayLimitInfo.setUsedLimit(rs.getBigDecimal("usedleavelength"));
                unExistUsedLimitMap.remove(fholidaylimitid);
            }
            sqlSB = new StringBuilder();
            sqlSB.append("  select    P.fholidaytypeid,L.Fyear,L.Fproposerid,hld.FLEAVEBILLID,L.Fid as fholidaylimitid,hld.fid holidayLimitDetailId \n").append("        FROM T_HR_ATS_LeaveBillEntry E \n").append("        left join t_hr_ats_holidaypolicy P on E.fpolicyid=P.fid \n").append("        INNER JOIN T_HR_ATS_LeaveBill  M ON E.FBILLID=M.FID \n").append("        INNER JOIN T_HR_ATS_HolidayLimitDetail  hld ON hld.FLEAVEBILLID=M.FID  AND hld.FLEAVEBILLENTRYID = E.FID \n").append("        INNER JOIN t_Hr_Ats_Holidaylimit L on L.Fproposerid=E.Fpersonid and L.FHOLIDAYPOLICYID = P.FID AND L.FHRORGUNITID = M.FHRORGUNITID \n").append("        where M.FBILLSTATE = 3 \n").append("        and ( L.fcyclebegindate<=E.Frealbegintime and E.Frealbegintime<=L.FDELAYDATE)  \n").append(" AND " + queryIdStr).append("        and hld.FCANCELLEAVEBILLID is null  and hld.FHOLIDAYLIMITID is null and hld.FCHANGETYPE = 4");
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString());
            HashMap<String, String> map = new HashMap<String, String>();
            HashSet<String> holidayLimitDetailIdSet = new HashSet<String>();
            while (rs.next()) {
                map.put(rs.getString("holidayLimitDetailId"), rs.getString("fholidaylimitid"));
                holidayLimitDetailIdSet.add(rs.getString("holidayLimitDetailId"));
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", holidayLimitDetailIdSet, CompareType.INCLUDE));
            evi.setFilter(fi);
            IHolidayLimitDetail holidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
            HolidayLimitDetailCollection holidayLimitDetailCollection = holidayLimitDetail.getHolidayLimitDetailCollection(evi);
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            for (int i = 0; i < holidayLimitDetailCollection.size(); ++i) {
                HolidayLimitDetailInfo holidayLimitDetailInfo = holidayLimitDetailCollection.get(i);
                HolidayLimitInfo li = new HolidayLimitInfo();
                li.setId(BOSUuid.read((String)((String)map.get(holidayLimitDetailInfo.getId().toString()))));
                holidayLimitDetailInfo.setHolidayLimit(li);
                coreBaseCollection.add((CoreBaseInfo)holidayLimitDetailInfo);
            }
            DataSaver dataSaver = new DataSaver();
            dataSaver.setCtx(ctx).save(coreBaseCollection);
            Set unExistUsedLimitColl = unExistUsedLimitMap.entrySet();
            for (Map.Entry entry : unExistUsedLimitColl) {
                HolidayLimitInfo unExistUsedLimitInfo = (HolidayLimitInfo)entry.getValue();
                unExistUsedLimitInfo.setUsedLimit(BigDecimal.ZERO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initDealFreezedLimit(Context ctx, Map<String, HolidayLimitInfo> holidayLimitInfoMap, String tempTableName, String holidayLimitIdStr) {
        String queryIdStr = null;
        queryIdStr = !StringUtils.isEmpty((String)tempTableName) ? " exists (select 1 from " + tempTableName + " tmpt where L.fid =tmpt.fid) " : " L.FID IN (" + holidayLimitIdStr + ") ";
        HashMap<String, HolidayLimitInfo> unExistFreezedLimitMap = new HashMap<String, HolidayLimitInfo>(holidayLimitInfoMap);
        try {
            StringBuilder sqlSB = new StringBuilder();
            sqlSB.append(" SELECT fholidaylimitid ,SUM(freezedlimitlength) freezedlimitlength FROM ( ").append(" SELECT fholidaylimitid, SUM (FREALLEAVELENGTH) AS freezedlimitlength ").append(" FROM( ").append(" SELECT DISTINCT L.Fid AS fholidaylimitid,P.fholidaytypeid,E.FREALLEAVELENGTH, hld.Fid AS fdetailid ").append(" FROM T_HR_ATS_LeaveBillEntry E ").append(" LEFT JOIN t_hr_ats_holidaypolicy P ON E.fpolicyid = P.fid ").append(" INNER JOIN T_HR_ATS_LeaveBill M ON E.FBILLID = M.FID ").append(" INNER JOIN T_HR_ATS_HolidayLimitDetail hld ON hld.FLEAVEBILLID = M.FID  AND hld.FLEAVEBILLENTRYID = E.FID ").append(" INNER JOIN t_Hr_Ats_Holidaylimit L ON L.Fproposerid = E.Fpersonid and L.FHOLIDAYPOLICYID = P.FID AND L.FHRORGUNITID = M.FHRORGUNITID ").append(" WHERE M.FBILLSTATE IN (1, 2) ").append(" AND L.fcyclebegindate <= E.Frealbegintime ").append(" AND E.Frealbegintime <= L.FDELAYDATE ").append(" AND hld.FCANCELLEAVEBILLID IS NULL ").append(" AND hld.FHOLIDAYLIMITID IS NULL ").append(" AND hld.FCHANGETYPE = 6 ").append(" AND " + queryIdStr).append(" ) tt ").append(" GROUP BY fholidaylimitid ").append(" UNION ALL ").append(" SELECT fholidaylimitid, SUM (FCHANGEVALUE) AS freezedlimitlength ").append(" FROM ( ").append(" SELECT DISTINCT L.Fid AS fholidaylimitid,P.fholidaytypeid,hld.FCHANGEVALUE, hld.Fid AS fdetailid ").append(" FROM T_HR_ATS_LeaveBillEntry E ").append(" LEFT JOIN t_hr_ats_holidaypolicy P ON E.fpolicyid = P.fid ").append(" INNER JOIN T_HR_ATS_LeaveBill M ON E.FBILLID = M.FID ").append(" INNER JOIN T_HR_ATS_HolidayLimitDetail hld ON hld.FLEAVEBILLID = M.FID  AND hld.FLEAVEBILLENTRYID = E.FID").append(" INNER JOIN t_Hr_Ats_Holidaylimit L ON hld.FHOLIDAYLIMITID = L.FID AND L.Fproposerid = E.Fpersonid and L.FHOLIDAYPOLICYID = P.FID AND L.FHRORGUNITID = M.FHRORGUNITID").append(" WHERE M.FBILLSTATE IN (1, 2) ").append(" AND hld.FCANCELLEAVEBILLID IS NULL ").append(" AND hld.FCHANGETYPE = 6 ").append(" AND " + queryIdStr).append(" ) tt ").append(" GROUP BY fholidaylimitid ").append(" )A GROUP BY A.fholidaylimitid ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString());
            while (rs.next()) {
                String fholidaylimitid = rs.getString("fholidaylimitid");
                HolidayLimitInfo holidayLimitInfo = holidayLimitInfoMap.get(fholidaylimitid);
                if (holidayLimitInfo == null) continue;
                holidayLimitInfo.setFreezeLimit(rs.getBigDecimal("freezedlimitlength"));
                unExistFreezedLimitMap.remove(fholidaylimitid);
            }
            sqlSB = new StringBuilder();
            sqlSB.append("  select    P.fholidaytypeid,L.Fyear,L.Fproposerid,hld.FLEAVEBILLID,L.Fid as fholidaylimitid,hld.fid holidayLimitDetailId \n").append("        FROM T_HR_ATS_LeaveBillEntry E \n").append("        left join t_hr_ats_holidaypolicy P on E.fpolicyid=P.fid \n").append("        INNER JOIN T_HR_ATS_LeaveBill  M ON E.FBILLID=M.FID \n").append("        INNER JOIN T_HR_ATS_HolidayLimitDetail  hld ON hld.FLEAVEBILLID=M.FID  AND hld.FLEAVEBILLENTRYID = E.FID \n").append("        INNER JOIN t_Hr_Ats_Holidaylimit L on L.Fproposerid=E.Fpersonid and L.FHOLIDAYPOLICYID = P.FID AND L.FHRORGUNITID = M.FHRORGUNITID \n").append("        where M.FBILLSTATE in(1,2) \n").append("        and ( L.fcyclebegindate<=E.Frealbegintime and E.Frealbegintime<=L.FDELAYDATE)  \n").append(" AND " + queryIdStr).append("        and hld.FCANCELLEAVEBILLID is null  and hld.FHOLIDAYLIMITID is null and hld.FCHANGETYPE  = 6");
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString());
            HashMap<String, String> map = new HashMap<String, String>();
            HashSet<String> holidayLimitDetailIdSet = new HashSet<String>();
            while (rs.next()) {
                map.put(rs.getString("holidayLimitDetailId"), rs.getString("fholidaylimitid"));
                holidayLimitDetailIdSet.add(rs.getString("holidayLimitDetailId"));
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", holidayLimitDetailIdSet, CompareType.INCLUDE));
            evi.setFilter(fi);
            IHolidayLimitDetail holidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
            HolidayLimitDetailCollection holidayLimitDetailCollection = holidayLimitDetail.getHolidayLimitDetailCollection(evi);
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            for (int i = 0; i < holidayLimitDetailCollection.size(); ++i) {
                HolidayLimitDetailInfo holidayLimitDetailInfo = holidayLimitDetailCollection.get(i);
                HolidayLimitInfo li = new HolidayLimitInfo();
                li.setId(BOSUuid.read((String)((String)map.get(holidayLimitDetailInfo.getId().toString()))));
                holidayLimitDetailInfo.setHolidayLimit(li);
                coreBaseCollection.add((CoreBaseInfo)holidayLimitDetailInfo);
            }
            DataSaver dataSaver = new DataSaver();
            dataSaver.setCtx(ctx).save(coreBaseCollection);
            Set unExistFreezedLimitColl = unExistFreezedLimitMap.entrySet();
            for (Map.Entry entry : unExistFreezedLimitColl) {
                HolidayLimitInfo unExistFreezedLimitInfo = (HolidayLimitInfo)entry.getValue();
                unExistFreezedLimitInfo.setFreezeLimit(BigDecimal.ZERO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void mergeHolidayLimitDetail(Context ctx, CoreBaseCollection colls, String tempTableName, Set<String> holidayLimitIdSet) {
        if (colls != null && colls.size() > 0) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            if (!StringUtils.isEmpty((String)tempTableName)) {
                fi.getFilterItems().add(new FilterItemInfo("holidayLimit.id", (Object)(" select fid from " + tempTableName + " tmpt "), CompareType.INNER));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("holidayLimit.id", holidayLimitIdSet, CompareType.INCLUDE));
            }
            fi.getFilterItems().add(new FilterItemInfo("changeType", (Object)HolidayLimitChangeType.init.getValue(), CompareType.EQUALS));
            evi.setFilter(fi);
            HashMap<String, HolidayLimitDetailInfo> holidayLimitDetailMap = new HashMap<String, HolidayLimitDetailInfo>();
            try {
                IHolidayLimitDetail holidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
                HolidayLimitDetailCollection holidayLimitDetailCollection = holidayLimitDetail.getHolidayLimitDetailCollection(evi);
                for (int i = 0; i < holidayLimitDetailCollection.size(); ++i) {
                    holidayLimitDetailMap.put(holidayLimitDetailCollection.get(i).getHolidayLimit().getId().toString(), holidayLimitDetailCollection.get(i));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Timestamp nowTimestamp = new Timestamp(new Date().getTime());
            CoreBaseCollection existedHolidayLimitDetailCollection = new CoreBaseCollection();
            CoreBaseCollection newHolidayLimitDetailCollection = new CoreBaseCollection();
            for (int i = 0; i < colls.size(); ++i) {
                HolidayLimitDetailInfo holidayLimitDetailInfo;
                HolidayLimitInfo holidayLimitInfo = (HolidayLimitInfo)colls.get(i);
                if (holidayLimitDetailMap.containsKey(holidayLimitInfo.getId().toString())) {
                    holidayLimitDetailInfo = (HolidayLimitDetailInfo)holidayLimitDetailMap.get(holidayLimitInfo.getId().toString());
                    holidayLimitDetailInfo.setChangeDate(nowTimestamp);
                    holidayLimitDetailInfo.setChangeType(HolidayLimitChangeType.init);
                    holidayLimitDetailInfo.setChangeValue(holidayLimitInfo.getRemainLimit());
                    existedHolidayLimitDetailCollection.add((CoreBaseInfo)holidayLimitDetailInfo);
                    continue;
                }
                holidayLimitDetailInfo = new HolidayLimitDetailInfo();
                holidayLimitDetailInfo.setYear(holidayLimitInfo.getYear());
                holidayLimitDetailInfo.setChangeDate(nowTimestamp);
                holidayLimitDetailInfo.setChangeType(HolidayLimitChangeType.init);
                holidayLimitDetailInfo.setHolidayLimit(holidayLimitInfo);
                holidayLimitDetailInfo.setChangeValue(holidayLimitInfo.getRemainLimit());
                holidayLimitDetailInfo.setChangeUnit(holidayLimitInfo.getHolidayUnit());
                holidayLimitDetailInfo.setStatus(HolidayLimitDetailStatusEnum.valid);
                holidayLimitDetailInfo.setProposer(holidayLimitInfo.getProposer());
                holidayLimitDetailInfo.setAdminOrgUnit(holidayLimitInfo.getAdminOrgUnit());
                holidayLimitDetailInfo.setHrOrgUnit(holidayLimitInfo.getHrOrgUnit());
                holidayLimitDetailInfo.setPosition(holidayLimitInfo.getPosition());
                newHolidayLimitDetailCollection.add((CoreBaseInfo)holidayLimitDetailInfo);
            }
            try {
                DataSaver dataSaver = new DataSaver();
                dataSaver.setCtx(ctx).save(newHolidayLimitDetailCollection);
                dataSaver = new DataSaver();
                dataSaver.setCtx(ctx).save(existedHolidayLimitDetailCollection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealOverdraftLimitDetail(Context ctx, CoreBaseCollection colls) {
        if (colls == null || colls.size() == 0) {
            return;
        }
        String tempTableName = null;
        String holidayLimitIdStr = "";
        HashSet<String> limitIdSet = new HashSet<String>();
        StringBuilder holidayLimitIdSB_L0 = new StringBuilder("''");
        StringBuilder holidayLimitIdSB_GE0 = new StringBuilder("''");
        HashMap<String, HolidayLimitInfo> holidayLimit_L0_Map = new HashMap<String, HolidayLimitInfo>();
        HashSet<String> holidayLimit_L0_Set = new HashSet<String>();
        try {
            int size = colls.size();
            int k = 0;
            int j = 0;
            while (k < size) {
                HolidayLimitInfo holidayLimitInfo = (HolidayLimitInfo)colls.get(k);
                if (holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) == -1) {
                    String limitId = holidayLimitInfo.getId().toString();
                    holidayLimitIdSB_L0.append(",'" + limitId + "'");
                    holidayLimit_L0_Map.put(limitId, holidayLimitInfo);
                    holidayLimit_L0_Set.add(limitId);
                    limitIdSet.add(limitId);
                } else {
                    holidayLimitIdSB_GE0.append(",'" + holidayLimitInfo.getId().toString() + "'");
                }
                if (j > 100) {
                    String sql = " delete  from T_HR_ATS_HolidayLimitDetail where FHOLIDAYLIMITID in(?) and FCHANGETYPE =  7";
                    Object[] params1_GE0 = new Object[]{holidayLimitIdSB_GE0.toString()};
                    Object[] params2_L0 = new Object[]{holidayLimitIdSB_L0.toString()};
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])params1_GE0);
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])params2_L0);
                    j = 0;
                    holidayLimitIdSB_GE0.setLength(0);
                    holidayLimitIdSB_GE0.append("''");
                    holidayLimitIdSB_L0.setLength(0);
                    holidayLimitIdSB_L0.append("''");
                }
                ++k;
                ++j;
            }
            if (null != limitIdSet && limitIdSet.size() > 200) {
                tempTableName = this.genHolidayLimitTempTable(ctx, new ArrayList<String>(limitIdSet));
            } else {
                holidayLimitIdStr = AtsUtil.convertSetToString(limitIdSet);
            }
            IHolidayLimitDetail holidayLimitDetail = HolidayLimitDetailFactory.getLocalInstance(ctx);
            HolidayLimitDetailCollection limitDetailColl_FR_DE = null;
            try {
                limitDetailColl_FR_DE = !StringUtils.isEmpty(tempTableName) ? holidayLimitDetail.getHolidayLimitDetailCollection(" where holidayLimit.id in ( select fid from " + tempTableName + " tmpt ) and changeType in(" + 4 + "," + 6 + ")  order by holidayLimit.id asc, changeDate asc ") : holidayLimitDetail.getHolidayLimitDetailCollection(" where holidayLimit.id in(" + holidayLimitIdStr + ") and changeType in(" + 4 + "," + 6 + ")  order by holidayLimit.id asc, changeDate asc ");
            }
            finally {
                if (!StringUtils.isEmpty((String)tempTableName)) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                }
            }
            String FHOLIDAYLIMITID_Temp = "";
            BigDecimal FCHANGEVALUE_SUM = BigDecimal.valueOf(0.0);
            BigDecimal FHolidayLimitValue_avaluable = BigDecimal.valueOf(0.0);
            CoreBaseCollection detailColls = new CoreBaseCollection();
            HolidayLimitDetailInfo holidayLimitDetailInfo_H1 = new HolidayLimitDetailInfo();
            for (int i = 0; i < limitDetailColl_FR_DE.size(); ++i) {
                HolidayLimitDetailInfo holidayLimitDetailInfo = limitDetailColl_FR_DE.get(i);
                String FHOLIDAYLIMITID = holidayLimitDetailInfo.getHolidayLimit().getId().toString();
                BigDecimal FCHANGEVALUE = holidayLimitDetailInfo.getChangeValue();
                if (!FHOLIDAYLIMITID_Temp.equals(FHOLIDAYLIMITID)) {
                    FHOLIDAYLIMITID_Temp = FHOLIDAYLIMITID;
                    FHolidayLimitValue_avaluable = ((HolidayLimitInfo)holidayLimit_L0_Map.get(FHOLIDAYLIMITID)).getStandardLimit().subtract(((HolidayLimitInfo)holidayLimit_L0_Map.get(FHOLIDAYLIMITID)).getPreOverdraftLimit());
                    FCHANGEVALUE_SUM = FCHANGEVALUE;
                    holidayLimitDetailInfo_H1 = holidayLimitDetailInfo;
                } else {
                    FCHANGEVALUE_SUM = FCHANGEVALUE_SUM.add(FCHANGEVALUE);
                }
                if (FCHANGEVALUE_SUM.compareTo(FHolidayLimitValue_avaluable) != 1) continue;
                HolidayLimitDetailInfo detailInfo = new HolidayLimitDetailInfo();
                detailInfo.setProposer(holidayLimitDetailInfo_H1.getProposer());
                detailInfo.setAdminOrgUnit(holidayLimitDetailInfo_H1.getAdminOrgUnit());
                detailInfo.setPosition(holidayLimitDetailInfo_H1.getPosition());
                detailInfo.setHrOrgUnit(holidayLimitDetailInfo_H1.getHrOrgUnit());
                detailInfo.setYear(holidayLimitDetailInfo_H1.getYear());
                detailInfo.setChangeDate(HRTimeWebUtils.dateToTimestamp(new Date()));
                detailInfo.setCreateTime(HRTimeWebUtils.dateToTimestamp(new Date()));
                detailInfo.setBillType(HolidayLimitBillTypeEnum.leaveBill);
                detailInfo.setLeaveBill(holidayLimitDetailInfo_H1.getLeaveBill());
                detailInfo.setLeaveBillNumber(holidayLimitDetailInfo_H1.getLeaveBill().getNumber());
                detailInfo.setHolidayLimit(holidayLimitDetailInfo_H1.getHolidayLimit());
                detailInfo.setChangeType(HolidayLimitChangeType.overdraft);
                if (FCHANGEVALUE_SUM.compareTo(FHolidayLimitValue_avaluable.add(FCHANGEVALUE)) >= 0) {
                    detailInfo.setChangeValue(FCHANGEVALUE);
                } else {
                    detailInfo.setChangeValue(FCHANGEVALUE_SUM.subtract(FHolidayLimitValue_avaluable));
                }
                detailInfo.setChangeUnit(holidayLimitDetailInfo_H1.getChangeUnit());
                detailColls.add((CoreBaseInfo)detailInfo);
            }
            DataSaver dataSaver = new DataSaver();
            dataSaver.setCtx(ctx).save(detailColls);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String genHolidayLimitTempTable(Context ctx, List<String> params) {
        ArrayList<String[]> param = new ArrayList<String[]>();
        for (int i = 0; i < params.size(); ++i) {
            param.add(new String[]{params.get(i)});
        }
        String tempTableName = null;
        try {
            if (!params.isEmpty()) {
                tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(" CREATE TABLE T_HR_ATS_HOLIDAYLIMIT_TMP (FID varchar(44))");
                String tempSql = "insert into " + tempTableName + " values(?)";
                DbUtil.executeBatch((Context)ctx, (String)tempSql.toString(), param);
                String tmpIndexSql = "CREATE  INDEX IDX_HLTMP" + System.currentTimeMillis() + " ON " + tempTableName + " (FID) ;";
                DbUtil.execute((Context)ctx, (String)tmpIndexSql.toString());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"create temp table fail while reCal limit");
            e.printStackTrace();
        }
        return tempTableName;
    }

    public Map<Object, Object> getGlobalMap() {
        return this.globalMap;
    }

    public void setGlobalMap(Map<Object, Object> globalMap) {
        this.globalMap = globalMap;
    }

    public void clearData() {
        this.globalMap.clear();
    }
}

