/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.lightapp.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AtsPrepareExtendData {
    private Map<String, PropertyInfo> properTyInfoMap = null;
    private Map<String, Integer> sqlMap = new HashMap<String, Integer>();
    private Set<String> colNameSet = new HashSet<String>();

    public Set<String> getColNameSet() {
        return this.colNameSet;
    }

    public void setColNameSet(Set<String> colNameSet) {
        this.colNameSet = colNameSet;
    }

    public Map<String, PropertyInfo> getProperTyInfoMap() {
        return this.properTyInfoMap;
    }

    public void setProperTyInfoMap(Map<String, PropertyInfo> properTyInfoMap) {
        this.properTyInfoMap = properTyInfoMap;
    }

    public Map<String, Integer> getSqlMap() {
        return this.sqlMap;
    }

    public void setSqlMap(Map<String, Integer> sqlMap) {
        this.sqlMap = sqlMap;
    }

    public AtsPrepareExtendData(Context ctx, String metadataPath) {
        this.properTyInfoMap = AtsPrepareExtendData.getProperties(ctx, metadataPath);
        for (Map.Entry<String, PropertyInfo> entry : this.properTyInfoMap.entrySet()) {
            String name;
            PropertyInfo propertyInfo = entry.getValue();
            ColumnInfo colInfo = propertyInfo.getMappingField();
            if (colInfo == null || !(name = colInfo.getName()).startsWith("CF")) continue;
            int colInt = colInfo.getSQLType();
            this.sqlMap.put(name, colInt);
            this.colNameSet.add(name);
        }
    }

    public void setObjectValue(AbstractObjectValue object, IRowSet rowRes) {
        for (Map.Entry<String, Integer> entry : this.sqlMap.entrySet()) {
            String colName = entry.getKey();
            Integer colType = entry.getValue();
            this.setObjectExtendValue(object, colName, colType, rowRes);
        }
    }

    public void setObjectExtendValue(AbstractObjectValue object, String colName, Integer colType, IRowSet rowRes) {
        Object extendVal = null;
        try {
            switch (colType) {
                case 4: {
                    extendVal = rowRes.getInt(colName);
                    break;
                }
                case 2: {
                    extendVal = rowRes.getBigDecimal(colName);
                    break;
                }
                case 1: {
                    extendVal = rowRes.getString(colName);
                    break;
                }
                case 12: {
                    extendVal = rowRes.getString(colName);
                    break;
                }
                case 6: {
                    extendVal = Float.valueOf(rowRes.getFloat(colName));
                    break;
                }
                case 8: {
                    extendVal = rowRes.getDouble(colName);
                    break;
                }
                case 91: {
                    extendVal = rowRes.getDate(colName);
                    break;
                }
                case 93: {
                    extendVal = rowRes.getTimestamp(colName);
                    break;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (extendVal != null) {
            object.put(colName, extendVal);
        }
    }

    public static Map<String, PropertyInfo> getProperties(Context ctx, String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection collection = entityInfo.getInheritedNoDuplicatedProperties();
        LinkedHashMap<String, PropertyInfo> map = new LinkedHashMap<String, PropertyInfo>();
        PropertyInfo propertyInfo = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            propertyInfo = collection.get(i);
            map.put(propertyInfo.getName(), propertyInfo);
        }
        return map;
    }
}

