/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.backCal.manager;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.hr.ats.common.AtsTempTableUtil;
import com.kingdee.eas.hr.ats.sum.backCal.service.impl.AtsSumBackCalImpl;
import com.kingdee.eas.hr.ats.sum.backCal.util.AtsSumBackCalSQL;
import com.kingdee.eas.hr.ats.sum.backCal.vo.AtsSumBackCalVO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AtsSumBackCalManager {
    private static Logger logger = Logger.getLogger(AtsSumBackCalManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> sumBackCal(Context ctx, Map<Object, Object> param) {
        try {
            String adminOrgTempTable = "";
            Set<AtsSumBackCalVO> policyPeriodSet = null;
            try {
                String transaction = (String)param.get("transaction");
                if (StringUtils.isEmpty((CharSequence)transaction)) {
                    String serviceId = (String)param.get("serviceId");
                    UserInfo currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
                    String userId = currentUserInfo.getId().toString();
                    String adminOrgUnitSql = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)serviceId);
                    adminOrgUnitSql = "select fid from t_org_admin adminOrgUnit where fid in (" + adminOrgUnitSql + ")";
                    adminOrgTempTable = AtsTempTableUtil.createTempTable(ctx, adminOrgUnitSql);
                    param.put("adminOrgTempTable", adminOrgTempTable);
                }
                String policyPeriodSql = AtsSumBackCalSQL.getSumBackCalSql(ctx, param);
                logger.error((Object)("------------AtsSumBackCalManager start sumBackCalSql:" + policyPeriodSql));
                policyPeriodSet = this.getPolicyPeriodMap(ctx, policyPeriodSql, param);
            }
            finally {
                AtsTempTableUtil.releaseTable(ctx, adminOrgTempTable);
            }
            if (null != policyPeriodSet && policyPeriodSet.size() > 0) {
                Iterator<AtsSumBackCalVO> iter = policyPeriodSet.iterator();
                AtsSumBackCalImpl backCal = new AtsSumBackCalImpl();
                while (iter.hasNext()) {
                    AtsSumBackCalVO backCalVO = iter.next();
                    backCal.sumResult(ctx, backCalVO);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"generateAllHolidayLimit error");
            e.printStackTrace();
        }
        return null;
    }

    public Set<AtsSumBackCalVO> getPolicyPeriodMap(Context ctx, String policyPeriodSql, Map<Object, Object> param) throws Exception {
        long startTime = System.currentTimeMillis();
        HashSet<AtsSumBackCalVO> policyPeriodSet = new HashSet<AtsSumBackCalVO>();
        AtsSumBackCalVO policybackCalVO = null;
        String backCalPeriod = (String)param.get("backCalPeriod");
        String sumCalPeriod = (String)param.get("sumCalPeriod");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)policyPeriodSql, (Object[])new Object[]{sumCalPeriod, backCalPeriod, sumCalPeriod});
        while (rs.next()) {
            policybackCalVO = new AtsSumBackCalVO();
            policybackCalVO.setPersonId(rs.getString("personId"));
            policybackCalVO.setBackCalPeriodId(rs.getString("backCalPeriodId"));
            policybackCalVO.setBackCalPeriod(rs.getString("backCalPeriod"));
            policybackCalVO.setSumCalPeriod(rs.getString("sumCalPeriod"));
            policybackCalVO.setSumCalPeriodId(rs.getString("sumCalPeriodId"));
            policybackCalVO.setStartDate(rs.getDate("startDate"));
            policybackCalVO.setEndDate(rs.getDate("endDate"));
            policyPeriodSet.add(policybackCalVO);
        }
        logger.error((Object)("Back cal query policy period cost\uff1a" + (System.currentTimeMillis() - startTime) + "ms,total count:" + policyPeriodSet.size()));
        return policyPeriodSet;
    }

    public static String[] getPrePeriod(String backCalPeriod, int Period) {
        String[] calPeriod = new String[Period];
        String year = backCalPeriod.substring(0, 4);
        String month = backCalPeriod.substring(4, 6);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = sdf.parse(year + "-" + month + "-28");
            for (int i = 1; i <= Period; ++i) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                cal.add(2, -i);
                int tmpYear = cal.get(1);
                int tmpMonth = cal.get(2) + 1;
                calPeriod[i - 1] = tmpYear + "" + (tmpMonth < 10 ? "0" + tmpMonth : Integer.valueOf(tmpMonth));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return calPeriod;
    }
}

