/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.backCal.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.common.AtsTempTableUtil;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.sum.backCal.vo.AtsSumBackCalVO;
import com.kingdee.eas.hr.ats.util.AtsBaseUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AtsSumBackCalHelper {
    private static Logger logger = Logger.getLogger(AtsSumBackCalHelper.class);

    public static String createResultToSumTempTable(Context ctx, AtsSumBackCalVO backCalVO) throws Exception {
        String sql = AtsSumBackCalHelper.getAttendResultSumSql(ctx, backCalVO);
        String tempTableName = AtsSumBackCalHelper.getAttenceResultTempTable(ctx, backCalVO.getSession(), sql);
        backCalVO.setTempTableName(tempTableName);
        backCalVO.setSumSql(sql);
        logger.error((Object)("RESULT TO SUM GROUP SQL:getGridResultToSumDataSql resultToSum dynamicSql: " + sql.toString()));
        return tempTableName;
    }

    public static String getAttenceResultTempTable(Context ctx, HttpSession session, String sql) {
        String tempTableName = null;
        try {
            String table_key;
            String staticTable = "PA2AtdcResultToSumBackCalTmp";
            String sessionId = "backGroundBackcal";
            if (null != session) {
                sessionId = session.getId();
            }
            if (ctx.get((Object)(table_key = staticTable + "_" + sessionId)) != null) {
                tempTableName = (String)ctx.get((Object)table_key);
            }
            if (!StringUtils.isEmpty(tempTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
            }
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
            String tempSql = "select * into " + tempTableName + " from (" + sql + ") T ";
            DbUtil.execute((Context)ctx, (String)tempSql.toString());
            AtsSumBackCalHelper.createSumBackCalIndex(ctx, tempTableName);
            ctx.put((Object)table_key, (Object)tempTableName);
        }
        catch (Exception e) {
            AtsTempTableUtil.releaseTable(ctx, tempTableName);
            e.printStackTrace();
        }
        return tempTableName;
    }

    private static void createSumBackCalIndex(Context ctx, String tempTableName) {
        try {
            String dbType = ContextUtil.getDbType((Context)ctx);
            if (!StringUtils.isEmpty((String)dbType) && (dbType.equalsIgnoreCase("Oracle") || dbType.startsWith("Oracle"))) {
                DbUtil.execute((Context)ctx, (String)("CREATE  INDEX " + tempTableName + " ON " + tempTableName + " (fhrorgunitid,fproposerid,fadminorgunitid) ;"));
            } else {
                DbUtil.execute((Context)ctx, (String)("CREATE  INDEX IX" + tempTableName + " ON " + tempTableName + " (fhrorgunitid,fproposerid,fadminorgunitid) ;"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getAttendResultSumSql(Context ctx, AtsSumBackCalVO backCalVO) throws Exception {
        StringBuffer sumSql = new StringBuffer();
        sumSql.append(" SELECT FHIS.FHrOrgUnitID,FHIS.FAdminOrgUnitID,FHIS.FProposerID ");
        sumSql.append(" FROM T_HR_ATS_AttendanceFileHIS FHIS ");
        sumSql.append(" INNER JOIN T_BD_Person person on FHIS.FProposerID = person.FID ");
        sumSql.append(" WHERE FHIS.FLEFFDT >= {ts '" + AtsDateUtils.dateShortToString(backCalVO.getStartDate()) + "'}");
        sumSql.append(" AND FHIS.FEFFDT <= {ts '" + AtsDateUtils.dateShortToString(backCalVO.getEndDate()) + "'} ");
        String personJson = backCalVO.getPersonJson();
        if (!(StringUtils.isEmpty((String)personJson) || "\"\"".equals(personJson) || "All".equalsIgnoreCase(personJson))) {
            Set<String> personKeys = AtsSumBackCalHelper.getSelectPersonKey(personJson);
            sumSql.append(" and concat(FHIS.fhrOrgUnitId,concat(FHIS.fproposerid,FHIS.fadminorgunitid)) in (" + AtsUtil.convertSetToString(personKeys) + ")");
        } else {
            String filterItem = backCalVO.getFilterItems();
            if (!StringUtils.isEmpty((String)filterItem)) {
                if (filterItem.indexOf("name") != -1) {
                    filterItem = filterItem.replaceAll("name", "fname" + MLUtile.getMlFlag(ctx));
                }
                if (filterItem.indexOf("number") != -1) {
                    filterItem = filterItem.replaceAll("number", "fnumber");
                }
                sumSql.append(" and " + filterItem);
            }
            sumSql.append(backCalVO.getOrgRangSql());
        }
        sumSql.append(" AND NOT EXISTS (SELECT 1 FROM T_HR_ATS_ATTENDANCESUMBACKCAL BACKCAL  ").append("WHERE BACKCAL.FHRORGUNITID =FHIS.FHRORGUNITID  ").append("AND BACKCAL.FADMINORGUNITID= FHIS.FADMINORGUNITID  ").append("AND BACKCAL.FPROPOSERID = FHIS.FPROPOSERID ").append("WHERE BACKCAL.FSUMCALPERIOD = '" + backCalVO.getSumCalPeriod() + "' ").append("AND BACKCAL.FBackCalPERIOD ='" + backCalVO.getBackCalPeriod() + "' AND BACKCAL.FSALARYSTATUS NOT IN (1,2) ) ");
        sumSql.append(" GROUP BY FHIS.FHrOrgUnitID,FHIS.FAdminOrgUnitID,FHIS.FProposerID ");
        return sumSql.toString();
    }

    public static Set<String> getSelectPersonKey(String personJson) {
        HashSet<String> personKeys = new HashSet<String>();
        try {
            JSONArray myJsonArray = new JSONArray(personJson);
            for (int i = 0; i < myJsonArray.length(); ++i) {
                JSONObject myjObject = myJsonArray.getJSONObject(i);
                String per = myjObject.getString("personId");
                String adminOrgUnitId = myjObject.getString("adminOrgUnitId");
                String hrOrgUnitId = myjObject.getString("hrOrgUnitId");
                personKeys.add(hrOrgUnitId + per + adminOrgUnitId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return personKeys;
    }

    public static List<LinkedHashMap<String, Object>> getSumRowLinkedList(Context ctx, Map<String, Object> sumParams, IRowSet sumKeyRows) {
        ArrayList<LinkedHashMap<String, Object>> dataList = new ArrayList<LinkedHashMap<String, Object>>();
        Map filterItems = (Map)sumParams.get("sumParams");
        String backCalPeriod = (String)filterItems.get("backCalPeriod");
        String sumPeriod = (String)filterItems.get("sumCalPeriod");
        try {
            while (sumKeyRows.next()) {
                String hrOrgUnitId = sumKeyRows.getString("fhrOrgUnitId");
                String personId = sumKeyRows.getString("fproposerid");
                String adminOrgUnitId = sumKeyRows.getString("fadminorgunitid");
                LinkedHashMap<String, String> hm = new LinkedHashMap<String, String>();
                hm.put("hrOrgUnitId", hrOrgUnitId);
                hm.put("personId", personId);
                hm.put("adminOrgUnitId", adminOrgUnitId);
                hm.put("backCalPeriod", backCalPeriod);
                hm.put("sumCalPeriod", sumPeriod);
                hm.put("key", hrOrgUnitId + personId + adminOrgUnitId);
                dataList.add(hm);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dataList;
    }

    public static ArrayList<LinkedHashMap<String, Object>> getSumRowLinkedListBySelected(Context ctx, Map<String, Object> sumParams) {
        Map filterItems = (Map)sumParams.get("sumParams");
        String backCalPeriod = (String)filterItems.get("backCalPeriod");
        String sumPeriod = (String)filterItems.get("sumCalPeriod");
        ArrayList<LinkedHashMap<String, Object>> dataList = new ArrayList<LinkedHashMap<String, Object>>();
        try {
            JSONArray myJsonArray = new JSONArray((String)filterItems.get("personJson"));
            for (int i = 0; i < myJsonArray.length(); ++i) {
                JSONObject myjObject = myJsonArray.getJSONObject(i);
                String hrOrgUnitId = myjObject.getString("hrOrgUnitId");
                String personId = myjObject.getString("personId");
                String adminOrgUnitId = myjObject.getString("adminOrgUnitId");
                LinkedHashMap<String, String> hm = new LinkedHashMap<String, String>();
                hm.put("hrOrgUnitId", hrOrgUnitId);
                hm.put("personId", personId);
                hm.put("adminOrgUnitId", adminOrgUnitId);
                hm.put("backCalPeriod", backCalPeriod);
                hm.put("sumCalPeriod", sumPeriod);
                hm.put("key", hrOrgUnitId + personId + adminOrgUnitId);
                dataList.add(hm);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return dataList;
    }

    public static Set<String> getExistedSumRecordInfo(Context ctx, AtsSumBackCalVO backCalVO, List<LinkedHashMap<String, Object>> rowList, String keyTmpTableName) {
        ArrayList temExistList = new ArrayList();
        HashSet<String> existAttendRecord = new HashSet<String>();
        String backCalPeriod = backCalVO.getBackCalPeriod();
        String sumPeriod = backCalVO.getSumCalPeriod();
        try {
            String sql = AtsSumBackCalHelper.getDynaAttendSumExistsSql(sumPeriod, backCalPeriod, keyTmpTableName);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                String hrOrgUnitId = rowSet.getString("fhrorgunitid");
                String personId = rowSet.getString("FPROPOSERID");
                String adminOrgUnitId = rowSet.getString("FAdminORGUNITID");
                String positionId = rowSet.getString("fpositionID");
                String periodId = rowSet.getString("FSalaryPeriod");
                String salaryStatus = rowSet.getString("FSalaryStatus");
                String fid = rowSet.getString("fid");
                if (periodId != null) {
                    map.put("salaryPeriodId", periodId);
                }
                String key = hrOrgUnitId + personId + adminOrgUnitId;
                map.put("hrOrgUnitId", hrOrgUnitId);
                map.put("personId", personId);
                map.put("adminOrgUnitId", adminOrgUnitId);
                map.put("fid", fid);
                map.put("fpositionID", positionId);
                map.put("salaryStatus", salaryStatus);
                map.put("key", key);
                existAttendRecord.add(key);
                temExistList.add(map);
            }
            int size = rowList.size();
            int tempSize = temExistList.size();
            if (tempSize > 0) {
                block3: for (int i = 0; tempSize > i; ++i) {
                    LinkedHashMap tempexsitMap = (LinkedHashMap)temExistList.get(i);
                    String tempkey = (String)tempexsitMap.get("key");
                    for (int j = 0; size > j; ++j) {
                        Map exsitMap = rowList.get(j);
                        String key = (String)exsitMap.get("key");
                        if (!key.equals(tempkey)) continue;
                        rowList.set(j, tempexsitMap);
                        continue block3;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return existAttendRecord;
    }

    public static String getDynaAttendSumExistsSql(String sumCalPeriod, String backCalPeriod, String keyTmpTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select resultSum.FPROPOSERID,resultSum.FADMINORGUNITID");
        sb.append(" ,resultSum.FSalaryStatus,resultSum.fpositionID");
        sb.append(",resultSum.fhrorgunitid,resultSum.FSalaryPeriod,resultSum.fid,resultSum.FBACKCALTYPE,resultSum.FBackCalPERIOD,resultSum.FBACKCALTYPE  ");
        sb.append(" from T_HR_ATS_ATTENDANCESUMBACKCAL resultSum ");
        sb.append(" INNER JOIN " + keyTmpTableName + " ATS_TMP ON ATS_TMP.fhrorgunitid = resultSum.fhrorgunitid AND ATS_TMP.fproposerid = resultSum.fproposerid AND ATS_TMP.fadminorgunitid = resultSum.fadminorgunitid ");
        sb.append(" where resultSum.FSUMCALPERIOD ='" + sumCalPeriod + "'");
        sb.append(" where resultSum.FBackCalPERIOD ='" + backCalPeriod + "'");
        sb.append(" where resultSum.FBACKCALTYPE ='SUMCAL'");
        return sb.toString();
    }

    public static void setGridAttendResultSumInfo(Context ctx, String keyTmpTableName, AtsSumBackCalVO backCalVO, List<LinkedHashMap<String, Object>> rowList, Map<String, String> columnMap) {
        try {
            String beginDate = AtsDateUtils.dateShortToString(backCalVO.getStartDate());
            String endDate = AtsDateUtils.dateShortToString(backCalVO.getEndDate());
            String attendPeriodId = backCalVO.getBackCalPeriodId();
            String attendPeriodName = backCalVO.getBackCalPeriod();
            int sumSize = rowList.size();
            int decimalPlacesSystem = DecimalPlaceUtil.getDecimalPlaceSystem(ctx);
            IRowSet rowSet = AtsSumBackCalHelper.getAttendDetailDataGrid(ctx, keyTmpTableName, beginDate, endDate);
            for (int i = 0; i < sumSize; ++i) {
                Map rowListMap = rowList.get(i);
                String sumKey = (String)rowListMap.get("key");
                rowListMap.put("beginDate", beginDate);
                rowListMap.put("endDate", endDate);
                rowListMap.put("attendPeriodId", attendPeriodId);
                rowListMap.put("attendPeriodName", attendPeriodName);
                while (rowSet.next()) {
                    String positionId = rowSet.getString("fpositionID");
                    String currentKey = rowSet.getString("fatthrorgunitid") + rowSet.getString("fproposerid") + rowSet.getString("fadminorgunitid");
                    String resultId = rowSet.getString("FID");
                    try {
                        if (!currentKey.equals(sumKey)) continue;
                        rowListMap.put("fpositionID", positionId);
                        rowListMap.put("resultId", resultId);
                        AtsSumBackCalHelper.setAttendResultSumData(ctx, rowSet, rowListMap, columnMap, decimalPlacesSystem);
                    }
                    catch (Exception e) {
                        logger.error((Object)("PAGE: RESULTTOSUM call setGridAttendResultSumInfo error,gather/gather to salary prepare detail data error,sumKey:" + sumKey));
                        e.printStackTrace();
                    }
                }
                rowSet.beforeFirst();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IRowSet getAttendDetailDataGrid(Context ctx, String keyTmpTableName, String beginDate, String endDate) {
        IRowSet rowSet = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" select RESULT.* from T_HR_ATS_AttendanceResult RESULT   ");
        sb.append("  WHERE EXISTS (SELECT 1 FROM  " + keyTmpTableName + " ATS_TMP ");
        sb.append("  WHERE ATS_TMP.FHRORGUNITID = RESULT.FATTHRORGUNITID ");
        sb.append("  AND ATS_TMP.FPROPOSERID = RESULT.FPROPOSERID ");
        sb.append("  AND ATS_TMP.FADMINORGUNITID = RESULT.FADMINORGUNITID )");
        sb.append("  and RESULT.FATTENCEDATE >= {ts '" + beginDate + "' }");
        sb.append("  and RESULT.FATTENCEDATE <=  {ts '" + endDate + "' }");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            logger.error((Object)("PAGE: RESULTTOSUM call getAttendDetailDataGrid error:" + sb.toString()));
            e.printStackTrace();
        }
        return rowSet;
    }

    public static void setAttendResultSumData(Context ctx, IRowSet rowSet, Map<String, Object> rowListMap, Map<String, String> columnMap, int decimalPlacesSystem) throws SQLException {
        for (String key : columnMap.keySet()) {
            String val = columnMap.get(key);
            if (val.equals("Int")) {
                int value = 0;
                if (rowListMap.get(key) != null) {
                    value = (Integer)rowListMap.get(key);
                }
                int tempVal = rowSet.getInt(key);
                rowListMap.put(key, value + tempVal);
                continue;
            }
            if (!val.equals("Float")) continue;
            float valueF = 0.0f;
            if (rowListMap.get(key) != null) {
                valueF = ((Float)rowListMap.get(key)).floatValue();
            }
            float tempValF = rowSet.getFloat(key);
            float valueRound = BigDecimal.valueOf(valueF + tempValF).setScale(decimalPlacesSystem, RoundingMode.HALF_UP).floatValue();
            rowListMap.put(key, Float.valueOf(valueRound));
        }
    }

    public static int getCount(Context ctx, String sql) throws Exception {
        int totalCount = 0;
        try {
            String sqlt = "select count(1) " + sql.substring(sql.indexOf("FROM"), sql.indexOf("order"));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlt);
            totalCount = AtsSumBackCalHelper.getTotalCount(rowSet);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return totalCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getTotalCount(IRowSet rowSet) throws Exception {
        int totalCount = 0;
        try {
            while (rowSet.next()) {
                try {
                    totalCount = rowSet.getInt(1);
                }
                catch (SQLException e) {
                    throw new Exception(e);
                    return totalCount;
                }
            }
        }
        catch (SQLException e) {
            throw new Exception(e);
        }
    }

    public static String getAtsTempTableSql(Context ctx, int totalCount, int rows, int page, String tempTableName, String field) throws Exception {
        int dbType = AtsBaseUtils.getDbType(ctx);
        if (StringUtils.isEmpty((String)tempTableName)) {
            return null;
        }
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        int start = (page - 1) * rows;
        int top = start + length;
        String sqlt = "SELECT TOP " + top + " " + field + "  FROM " + tempTableName + " TEMP ORDER BY FPROPOSERID,FHRORGUNITID,FADMINORGUNITID ";
        PagingHelper pageHelper = new PagingHelper();
        try {
            sqlt = pageHelper.getPagingSqlNoOptmize(dbType, sqlt, start, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("call setAttencePanelTempTableSql() error sql: " + sqlt.toString()));
        }
        return sqlt;
    }
}

