/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.sum.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsDateCommonResEnum;
import com.kingdee.eas.hr.ats.AtsShiftCollection;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AttencePolicyCollection;
import com.kingdee.eas.hr.ats.AttencePolicyFactory;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceProjectCollection;
import com.kingdee.eas.hr.ats.AttendanceProjectFactory;
import com.kingdee.eas.hr.ats.AttendanceProjectInfo;
import com.kingdee.eas.hr.ats.HolidayPolicySetCollection;
import com.kingdee.eas.hr.ats.HolidayPolicySetFactory;
import com.kingdee.eas.hr.ats.HolidayPolicySetInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.WorkCalendarCollection;
import com.kingdee.eas.hr.ats.WorkCalendarFactory;
import com.kingdee.eas.hr.ats.WorkCalendarInfo;
import com.kingdee.eas.hr.ats.app.AtsSumTypeEnum;
import com.kingdee.eas.hr.ats.calculate.AtsCacheUtil;
import com.kingdee.eas.hr.ats.util.AtsDbUtil;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AtsSumSalaryUtil {
    private static Logger logger = Logger.getLogger(AtsSumSalaryUtil.class);

    public static StringBuilder filterNoneConfirmRecordSql(Context ctx, Map<String, String> filterItems) {
        StringBuilder tempTableSql = new StringBuilder();
        tempTableSql.append(" select result.fid \n");
        tempTableSql.append(" from T_HR_ATS_AttendanceResult result \n");
        tempTableSql.append(" inner join T_HR_ATS_AttendanceFileHIS attendanceHISFile on attendanceHISFile.fproposerId = result.fproposerId and attendanceHISFile.FEFFDT <= result.fAttenceDate and attendanceHISFile.FLEFFDT >= result.fAttenceDate ");
        tempTableSql.append(" inner join T_HR_ATS_AttencePolicy attendancePolicy on attendancePolicy.fid = attendanceHISFile.fAttencePolicyId ");
        tempTableSql.append(" where result.fattencedate >= {ts '" + filterItems.get("beginDate") + "'} ");
        tempTableSql.append(" and result.fattencedate <= {ts '" + filterItems.get("endDate") + "'} ");
        tempTableSql.append(" and attendancePolicy.FIsConfirm = 1 ");
        tempTableSql.append(" and result.fConfirmState = 0 ");
        String tempTableName = null;
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
            String tempSql = "select * into " + tempTableName + " from (" + tempTableSql.toString() + ") T ; ";
            DbUtil.execute((Context)ctx, (String)tempSql.toString());
            String dbType = ContextUtil.getDbType((Context)ctx);
            tempSql = !StringUtils.isEmpty((CharSequence)dbType) && (dbType.equalsIgnoreCase("Oracle") || dbType.startsWith("Oracle")) ? "CREATE  INDEX " + tempTableName + " ON " + tempTableName + " (FID ASC) ;" : "CREATE  INDEX IX" + tempTableName + " ON " + tempTableName + " (FID ASC) ;";
            DbUtil.execute((Context)ctx, (String)tempSql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuilder filter = new StringBuilder();
        filter.append(" and fid not in \n");
        filter.append(" ( select fid \n");
        filter.append(" from " + tempTableName + " tempt ) \n");
        return filter;
    }

    public static String getWeekName(Context ctx, int day) {
        String week = "";
        switch (day) {
            case 1: {
                week = MLUtile.getRes(AtsDateCommonResEnum.Sunday, ctx);
                break;
            }
            case 2: {
                week = MLUtile.getRes(AtsDateCommonResEnum.Monday, ctx);
                break;
            }
            case 3: {
                week = MLUtile.getRes(AtsDateCommonResEnum.Tuesday, ctx);
                break;
            }
            case 4: {
                week = MLUtile.getRes(AtsDateCommonResEnum.Wednesday, ctx);
                break;
            }
            case 5: {
                week = MLUtile.getRes(AtsDateCommonResEnum.Thursday, ctx);
                break;
            }
            case 6: {
                week = MLUtile.getRes(AtsDateCommonResEnum.Friday, ctx);
                break;
            }
            case 7: {
                week = MLUtile.getRes(AtsDateCommonResEnum.Saturday, ctx);
            }
        }
        return week;
    }

    public static void getRowListPersonOrAdminOrg(Context ctx, StringBuilder hrOrgUnit, StringBuilder person, StringBuilder OrgUnit, List<LinkedHashMap<String, Object>> dataList) {
        Map<String, String> hrOrgUnitMap = null;
        Map<String, PersonInfo> personMap = null;
        Map<String, String> orgUnitMap = null;
        if (person.length() > 0) {
            hrOrgUnit.deleteCharAt(hrOrgUnit.length() - 1);
            person.deleteCharAt(person.length() - 1);
            OrgUnit.deleteCharAt(OrgUnit.length() - 1);
            hrOrgUnitMap = AtsSumSalaryUtil.getHrOrgUnitMap(ctx, hrOrgUnit.toString());
            personMap = AtsSumSalaryUtil.getPersonMap(ctx, person.toString());
            orgUnitMap = AtsSumSalaryUtil.getAdminOrgUnitMap(ctx, OrgUnit.toString());
        }
        for (int i = 0; i < dataList.size(); ++i) {
            LinkedHashMap<String, Object> map = dataList.get(i);
            PersonInfo personInfo = personMap != null ? (PersonInfo)personMap.get(map.get("personId")) : null;
            map.put("orgName", orgUnitMap == null ? "" : orgUnitMap.get(map.get("adminOrgUnitId")));
            map.put("companyName", orgUnitMap == null ? "" : orgUnitMap.get(map.get("adminOrgUnitId") + "_" + "companyName"));
            map.put("departmentName", orgUnitMap == null ? "" : orgUnitMap.get(map.get("adminOrgUnitId") + "_" + "departmentName"));
            map.put("personNumber", personInfo != null ? personInfo.getNumber() : "");
            map.put("personName", personInfo != null ? personInfo.getName() : "");
            map.put("hrOrgName", hrOrgUnitMap == null ? "" : hrOrgUnitMap.get(map.get("hrOrgUnitId")));
        }
    }

    public static Map<String, String> getHrOrgUnitMap(Context ctx, String hrOrgUnit) {
        StringBuilder oqlb = new StringBuilder();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("name,");
        oqlb.append("displayName");
        oqlb.append(" where id in(" + hrOrgUnit + ")");
        HashMap<String, String> hrOrgUnitMap = new HashMap<String, String>();
        HROrgUnitCollection col = null;
        try {
            col = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection(oqlb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (col == null || col.size() == 0) {
            return hrOrgUnitMap;
        }
        for (int i = 0; i < col.size(); ++i) {
            HROrgUnitInfo hrOrgUnitInfo = col.get(i);
            hrOrgUnitMap.put(hrOrgUnitInfo.getId().toString(), hrOrgUnitInfo.getName());
        }
        return hrOrgUnitMap;
    }

    public static Map<String, String> getAdminOrgUnitMap(Context ctx, String adminOrgUnit) {
        StringBuilder oqlb = new StringBuilder();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("displayName");
        oqlb.append(" where id in(" + adminOrgUnit + ")");
        HashMap<String, String> orgUnitMap = new HashMap<String, String>();
        AdminOrgUnitCollection col = null;
        try {
            col = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(oqlb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (col == null || col.size() == 0) {
            return orgUnitMap;
        }
        for (int i = 0; i < col.size(); ++i) {
            AdminOrgUnitInfo adminOrgUnitInfo = col.get(i);
            orgUnitMap.put(adminOrgUnitInfo.getId().toString(), adminOrgUnitInfo.getDisplayName());
        }
        return orgUnitMap;
    }

    public static Map<String, PersonInfo> getPersonMap(Context ctx, String person) {
        HashMap<String, PersonInfo> personMap = new HashMap<String, PersonInfo>();
        StringBuilder oqlb = new StringBuilder();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("number,");
        oqlb.append("name");
        oqlb.append(" where id in(" + person + ")");
        PersonCollection col = null;
        try {
            col = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(oqlb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (col == null || col.size() == 0) {
            return personMap;
        }
        for (int i = 0; i < col.size(); ++i) {
            PersonInfo personInfo = col.get(i);
            personMap.put(personInfo.getId().toString(), personInfo);
        }
        return personMap;
    }

    public static Map<String, AtsShiftInfo> getAtsShiftInfos(Context ctx) {
        HashMap<String, AtsShiftInfo> atsShiftInfoMap = new HashMap<String, AtsShiftInfo>();
        AtsShiftCollection coll = (AtsShiftCollection)((Object)AtsCacheUtil.get("atsShift"));
        try {
            if (coll == null || coll.size() == 0) {
                String oql = " select *,items.*  order by items.segment ";
                coll = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftCollection(oql);
                AtsCacheUtil.put("atsShift", (Object)coll);
            }
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                String key = coll.get(i).getId().toString();
                atsShiftInfoMap.put(key, coll.get(i));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return atsShiftInfoMap;
    }

    public static Map<String, AttencePolicyInfo> getAttendancePolicyInfos(Context ctx) {
        HashMap<String, AttencePolicyInfo> policyInfoMap = new HashMap<String, AttencePolicyInfo>();
        AttencePolicyCollection coll = (AttencePolicyCollection)((Object)AtsCacheUtil.get("attencePolicy"));
        try {
            if (coll == null || coll.size() == 0) {
                coll = AttencePolicyFactory.getLocalInstance(ctx).getAttencePolicyCollection();
                AtsCacheUtil.put("attencePolicy", (Object)coll);
            }
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                String key = coll.get(i).getId().toString();
                policyInfoMap.put(key, coll.get(i));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return policyInfoMap;
    }

    public static Map<String, WorkCalendarInfo> getAllWorkCalendarInfo(Context ctx) {
        HashMap<String, WorkCalendarInfo> workCalendarMap = new HashMap<String, WorkCalendarInfo>();
        WorkCalendarCollection workCalendarCol = (WorkCalendarCollection)((Object)AtsCacheUtil.get("workCalendar"));
        try {
            if (workCalendarCol == null || workCalendarCol.size() == 0) {
                workCalendarCol = WorkCalendarFactory.getLocalInstance(ctx).getWorkCalendarCollection();
                AtsCacheUtil.put("workCalendar", (Object)workCalendarCol);
            }
            for (int i = 0; i < workCalendarCol.size(); ++i) {
                WorkCalendarInfo workCalendarInfo = workCalendarCol.get(i);
                workCalendarMap.put(workCalendarInfo.getId().toString(), workCalendarInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return workCalendarMap;
    }

    public static Map<String, AttendanceProjectInfo> getAttendanceProject(Context ctx) {
        HashMap<String, AttendanceProjectInfo> attendanceProjectMap = new HashMap<String, AttendanceProjectInfo>();
        AttendanceProjectCollection attendanceProjectCollection = (AttendanceProjectCollection)((Object)AtsCacheUtil.get("attendanceProject"));
        try {
            if (attendanceProjectCollection == null || attendanceProjectCollection.size() == 0) {
                attendanceProjectCollection = AttendanceProjectFactory.getLocalInstance(ctx).getAttendanceProjectCollection();
                AtsCacheUtil.put("attendanceProject", (Object)attendanceProjectCollection);
            }
            AttendanceProjectInfo attendanceProjectInfo = null;
            for (int i = 0; i < attendanceProjectCollection.size(); ++i) {
                attendanceProjectInfo = attendanceProjectCollection.get(i);
                attendanceProjectMap.put(attendanceProjectInfo.getColumnNO() + "", attendanceProjectInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return attendanceProjectMap;
    }

    public static Map<String, HolidayPolicySetInfo> getAllHolidayPolicySet(Context ctx) {
        HashMap<String, HolidayPolicySetInfo> map = new HashMap<String, HolidayPolicySetInfo>();
        HolidayPolicySetCollection holidayPolicySetCollection = (HolidayPolicySetCollection)((Object)AtsCacheUtil.get("holidayPolicySet"));
        try {
            if (holidayPolicySetCollection == null || holidayPolicySetCollection.size() == 0) {
                holidayPolicySetCollection = HolidayPolicySetFactory.getLocalInstance(ctx).getHolidayPolicySetCollection();
                AtsCacheUtil.put("holidayPolicySet", (Object)holidayPolicySetCollection);
            }
            HolidayPolicySetInfo holidayPolicySet = null;
            for (int i = 0; i < holidayPolicySetCollection.size(); ++i) {
                holidayPolicySet = holidayPolicySetCollection.get(i);
                map.put(holidayPolicySet.getId().toString(), holidayPolicySet);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static String[] getSumTranSalaryTemplateSQLArrByPerson() {
        String sumTemplateSql = " UPDATE T_HR_ATS_ATTENDANCERESULTSUM SET FSALARYSTATUS=?, FSALARYPERIOD=?,FATTENDANCEPERIODID=?, FLASTUPDATETIME=? ,FLASTUPDATEUSERID=? WHERE FID= ? AND FSALARYSTATUS <> ? ";
        String mdTemplateSql = " INSERT INTO T_HR_ATS_ATTENDANCERESUMMD  SELECT * FROM T_HR_ATS_ATTENDANCERESULTSUM  WHERE  FID = ? ";
        StringBuilder mdDetailTemplateSql = new StringBuilder();
        mdDetailTemplateSql.append(" INSERT INTO T_HR_ATS_ATTENDANCERESMD  SELECT * FROM T_HR_ATS_ATTENDANCERESULT ").append(" WHERE FPROPOSERID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        StringBuilder mdToSalaryTemplateSql = new StringBuilder();
        mdToSalaryTemplateSql.append(" INSERT INTO T_HR_ATS_AttResultItemToSalary  SELECT * FROM T_HR_ATS_ATTRESULTITEM ").append(" WHERE FPROPOSERID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        String[] sqlArr = new String[]{sumTemplateSql, mdTemplateSql, mdDetailTemplateSql.toString(), mdToSalaryTemplateSql.toString()};
        return sqlArr;
    }

    public static String[] getSumTranSalaryTemplateSQLArr() {
        String sumTemplateSql = " UPDATE T_HR_ATS_ATTENDANCERESULTSUM SET FSALARYSTATUS=?, FSALARYPERIOD=?,FATTENDANCEPERIODID=?, FLASTUPDATETIME=? ,FLASTUPDATEUSERID=? WHERE FID= ? AND FSALARYSTATUS <> ? ";
        String mdTemplateSql = " INSERT INTO T_HR_ATS_ATTENDANCERESUMMD  SELECT * FROM T_HR_ATS_ATTENDANCERESULTSUM  WHERE  FID = ? ";
        StringBuilder mdDetailTemplateSql = new StringBuilder();
        mdDetailTemplateSql.append(" INSERT INTO T_HR_ATS_ATTENDANCERESMD  SELECT * FROM T_HR_ATS_ATTENDANCERESULT ").append(" WHERE FATTHRORGUNITID =? AND FPROPOSERID = ? AND FADMINORGUNITID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        StringBuilder mdToSalaryTemplateSql = new StringBuilder();
        mdToSalaryTemplateSql.append(" INSERT INTO T_HR_ATS_AttResultItemToSalary  SELECT * FROM T_HR_ATS_ATTRESULTITEM ").append(" WHERE FATTHRORGUNITID =? AND FPROPOSERID = ? AND FADMINORGUNITID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        String[] sqlArr = new String[]{sumTemplateSql, mdTemplateSql, mdDetailTemplateSql.toString(), mdToSalaryTemplateSql.toString()};
        return sqlArr;
    }

    public static String[] getTranSalaryTemplateSQLArr() {
        String sumTemplateSql = " update  T_HR_ATS_AttendanceResultSum  set FSalaryStatus=?,FSalaryPeriod=?,FLastUpdateTime=?,FLastUpdateUserID=? where fid = ? ";
        String mdTemplateSql = " insert into T_HR_ATS_AttendanceReSumMd  select * from T_HR_ATS_AttendanceResultSum  where fid = ?";
        StringBuilder mdDetailTemplateSql = new StringBuilder();
        mdDetailTemplateSql.append(" INSERT INTO T_HR_ATS_ATTENDANCERESMD  SELECT * FROM T_HR_ATS_ATTENDANCERESULT ").append(" WHERE FATTHRORGUNITID =? AND FPROPOSERID = ? AND FADMINORGUNITID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        StringBuilder mdToSalaryTemplateSql = new StringBuilder();
        mdToSalaryTemplateSql.append(" INSERT INTO T_HR_ATS_AttResultItemToSalary  SELECT * FROM T_HR_ATS_ATTRESULTITEM ").append(" WHERE FATTHRORGUNITID =? AND FPROPOSERID = ? AND FADMINORGUNITID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        String[] sqlArr = new String[]{sumTemplateSql, mdTemplateSql, mdDetailTemplateSql.toString(), mdToSalaryTemplateSql.toString()};
        return sqlArr;
    }

    public static String[] getItemTranSalaryTemplateSQLArr() {
        String sumTemplateSql = " update  T_HR_ATS_ATTRESULTITEMSUM  set FSalaryStatus=?,FSalaryPeriod=?,FLastUpdateTime=?,FLastUpdateUserID=? where fid = ? ";
        String mdTemplateSql = " insert into T_HR_ATS_ATTRESULTITEMSUMMD  select * from  T_HR_ATS_ATTRESULTITEMSUM   where fid = ?";
        String[] sqlArr = new String[]{sumTemplateSql, mdTemplateSql};
        return sqlArr;
    }

    public static String[] getTranSalaryTemplateSQLArrByPerson() {
        String sumTemplateSql = " update  T_HR_ATS_AttendanceResultSum  set FSalaryStatus=?,FSalaryPeriod=?,FLastUpdateTime=?,FLastUpdateUserID=? where fid = ? ";
        String mdTemplateSql = " insert into T_HR_ATS_AttendanceReSumMd  select * from T_HR_ATS_AttendanceResultSum  where fid = ?";
        StringBuilder mdDetailTemplateSql = new StringBuilder();
        mdDetailTemplateSql.append(" INSERT INTO T_HR_ATS_ATTENDANCERESMD  SELECT * FROM T_HR_ATS_ATTENDANCERESULT ").append(" WHERE FPROPOSERID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        StringBuilder mdToSalaryTemplateSql = new StringBuilder();
        mdToSalaryTemplateSql.append(" INSERT INTO T_HR_ATS_AttResultItemToSalary  SELECT * FROM T_HR_ATS_ATTRESULTITEM ").append(" WHERE FPROPOSERID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        String[] sqlArr = new String[]{sumTemplateSql, mdTemplateSql, mdDetailTemplateSql.toString(), mdToSalaryTemplateSql.toString()};
        return sqlArr;
    }

    public static String[] getTranSalaryTemplateSQLArrByHRPerson() {
        String sumTemplateSql = " update  T_HR_ATS_AttendanceResultSum  set FSalaryStatus=?,FSalaryPeriod=?,FLastUpdateTime=?,FLastUpdateUserID=? where fid = ? ";
        String mdTemplateSql = " insert into T_HR_ATS_AttendanceReSumMd  select * from T_HR_ATS_AttendanceResultSum  where fid = ?";
        StringBuilder mdDetailTemplateSql = new StringBuilder();
        mdDetailTemplateSql.append(" INSERT INTO T_HR_ATS_ATTENDANCERESMD  SELECT * FROM T_HR_ATS_ATTENDANCERESULT ").append(" WHERE FATTHRORGUNITID =? AND FPROPOSERID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        StringBuilder mdToSalaryTemplateSql = new StringBuilder();
        mdToSalaryTemplateSql.append(" INSERT INTO T_HR_ATS_AttResultItemToSalary  SELECT * FROM T_HR_ATS_ATTRESULTITEM ").append(" WHERE FATTHRORGUNITID =? AND FPROPOSERID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        String[] sqlArr = new String[]{sumTemplateSql, mdTemplateSql, mdDetailTemplateSql.toString(), mdToSalaryTemplateSql.toString()};
        return sqlArr;
    }

    public static String[] getTranSalaryTemplateSQLArrByHRPersonAtt() {
        String sumTemplateSql = " update  T_HR_ATS_AttendanceResultSum  set FSalaryStatus=?,FSalaryPeriod=?,FLastUpdateTime=?,FLastUpdateUserID=? where fid = ? ";
        String mdTemplateSql = " insert into T_HR_ATS_AttendanceReSumMd  select * from T_HR_ATS_AttendanceResultSum  where fid = ?";
        StringBuilder mdDetailTemplateSql = new StringBuilder();
        mdDetailTemplateSql.append(" INSERT INTO T_HR_ATS_ATTENDANCERESMD  SELECT * FROM T_HR_ATS_ATTENDANCERESULT ").append(" WHERE FATTHRORGUNITID =? AND FPROPOSERID = ? AND FATTADMINORGUNITID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        StringBuilder mdToSalaryTemplateSql = new StringBuilder();
        mdToSalaryTemplateSql.append(" INSERT INTO T_HR_ATS_AttResultItemToSalary  SELECT * FROM T_HR_ATS_ATTRESULTITEM ").append(" WHERE FATTHRORGUNITID =? AND FPROPOSERID = ? AND FATTADMINORGUNITID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        String[] sqlArr = new String[]{sumTemplateSql, mdTemplateSql, mdDetailTemplateSql.toString(), mdToSalaryTemplateSql.toString()};
        return sqlArr;
    }

    public static String[] getSumTranSalaryTemplateSQLArrByHRPerson() {
        String sumTemplateSql = " UPDATE T_HR_ATS_ATTENDANCERESULTSUM SET FSALARYSTATUS=?, FSALARYPERIOD=?,FATTENDANCEPERIODID=?, FLASTUPDATETIME=? ,FLASTUPDATEUSERID=? WHERE FID= ? AND FSALARYSTATUS <> ? ";
        String mdTemplateSql = " INSERT INTO T_HR_ATS_ATTENDANCERESUMMD  SELECT * FROM T_HR_ATS_ATTENDANCERESULTSUM  WHERE  FID = ? ";
        StringBuilder mdDetailTemplateSql = new StringBuilder();
        mdDetailTemplateSql.append(" INSERT INTO T_HR_ATS_ATTENDANCERESMD  SELECT * FROM T_HR_ATS_ATTENDANCERESULT ").append(" WHERE FPROPOSERID = ? ").append(" AND FATTHrOrgUnitID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        StringBuilder mdToSalaryTemplateSql = new StringBuilder();
        mdToSalaryTemplateSql.append(" INSERT INTO T_HR_ATS_AttResultItemToSalary  SELECT * FROM T_HR_ATS_ATTRESULTITEM ").append(" WHERE FPROPOSERID = ? ").append(" AND FATTHrOrgUnitID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        String[] sqlArr = new String[]{sumTemplateSql, mdTemplateSql, mdDetailTemplateSql.toString(), mdToSalaryTemplateSql.toString()};
        return sqlArr;
    }

    public static String[] getSumTranSalaryTemplateSQLArrByHRPersonAtt() {
        String sumTemplateSql = " UPDATE T_HR_ATS_ATTENDANCERESULTSUM SET FSALARYSTATUS=?, FSALARYPERIOD=?,FATTENDANCEPERIODID=?, FLASTUPDATETIME=? ,FLASTUPDATEUSERID=? WHERE FID= ? AND FSALARYSTATUS <> ? ";
        String mdTemplateSql = " INSERT INTO T_HR_ATS_ATTENDANCERESUMMD  SELECT * FROM T_HR_ATS_ATTENDANCERESULTSUM  WHERE  FID = ? ";
        StringBuilder mdDetailTemplateSql = new StringBuilder();
        mdDetailTemplateSql.append(" INSERT INTO T_HR_ATS_ATTENDANCERESMD  SELECT * FROM T_HR_ATS_ATTENDANCERESULT ").append(" WHERE FATTHrOrgUnitID = ? ").append(" AND  FPROPOSERID= ? ").append(" AND FATTADMINORGUNITID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        StringBuilder mdToSalaryTemplateSql = new StringBuilder();
        mdToSalaryTemplateSql.append(" INSERT INTO T_HR_ATS_AttResultItemToSalary  SELECT * FROM T_HR_ATS_ATTRESULTITEM ").append(" WHERE  FATTHrOrgUnitID = ? ").append(" AND FPROPOSERID = ? ").append(" AND FATTADMINORGUNITID = ? ").append(" AND FATTENCEDATE >= ? AND FATTENCEDATE <= ? ");
        String[] sqlArr = new String[]{sumTemplateSql, mdTemplateSql, mdDetailTemplateSql.toString(), mdToSalaryTemplateSql.toString()};
        return sqlArr;
    }

    public static String[] getCancelSalaryTemplateSQLArr() {
        String updateSumTemplateSql = "update T_HR_ATS_AttendanceResultSum set FSalaryStatus=?,FSalaryPeriod=?,FLastUpdateTime=?,FLastUpdateUserID=? where fid =?";
        String deleteMDTemplateSql = " delete from T_HR_ATS_AttendanceReSumMd  where fid = ? ";
        StringBuilder deleteMDDetailTemplateSql = new StringBuilder();
        deleteMDDetailTemplateSql.append("  DELETE FROM T_HR_ATS_AttendanceResMd A  ").append(" WHERE EXISTS (SELECT 1 FROM T_HR_ATS_AttendanceResultSum T  ").append(" WHERE T.FID = ?  ").append(" AND A.FAtthrOrgUnitID = T.FhrOrgUnitID AND A.FPROPOSERID = T.FPROPOSERID AND A.FADMINORGUNITID = T.FADMINORGUNITID ) ").append(" and A.FAttenceDate >= ? ").append(" and A.FAttenceDate <= ? ");
        StringBuilder deleteMDToSalaryTemplateSql = new StringBuilder();
        deleteMDToSalaryTemplateSql.append("  DELETE FROM T_HR_ATS_AttResultItemToSalary A  ").append(" WHERE EXISTS (SELECT 1 FROM T_HR_ATS_AttendanceResultSum T  ").append(" WHERE T.FID = ?  ").append(" AND A.FAtthrOrgUnitID = T.FhrOrgUnitID AND A.FPROPOSERID = T.FPROPOSERID AND A.FADMINORGUNITID = T.FADMINORGUNITID ) ").append(" and A.FAttenceDate >= ? ").append(" and A.FAttenceDate <= ? ");
        String[] sqlArr = new String[]{updateSumTemplateSql, deleteMDTemplateSql, deleteMDDetailTemplateSql.toString(), deleteMDToSalaryTemplateSql.toString()};
        return sqlArr;
    }

    public static String[] getCancelSalaryTemplateSQLArrByPerson() {
        String updateSumTemplateSql = "update T_HR_ATS_AttendanceResultSum set FSalaryStatus=?,FSalaryPeriod=?,FLastUpdateTime=?,FLastUpdateUserID=? where fid =?";
        String deleteMDTemplateSql = " delete from T_HR_ATS_AttendanceReSumMd  where fid = ? ";
        StringBuilder deleteMDDetailTemplateSql = new StringBuilder();
        deleteMDDetailTemplateSql.append("  DELETE FROM T_HR_ATS_AttendanceResMd A  ").append(" WHERE EXISTS (SELECT 1 FROM T_HR_ATS_AttendanceResultSum T  ").append(" WHERE T.FID = ?  ").append(" AND A.FPROPOSERID = T.FPROPOSERID )").append(" and A.FAttenceDate >= ? ").append(" and A.FAttenceDate <= ?  ");
        StringBuilder deleteMDToSalaryTemplateSql = new StringBuilder();
        deleteMDToSalaryTemplateSql.append("  DELETE FROM T_HR_ATS_AttResultItemToSalary A  ").append(" WHERE EXISTS (SELECT 1 FROM T_HR_ATS_AttendanceResultSum T  ").append(" WHERE T.FID = ?  ").append(" AND A.FPROPOSERID = T.FPROPOSERID)  ").append(" and A.FAttenceDate >= ? ").append(" and A.FAttenceDate <= ? ");
        String[] sqlArr = new String[]{updateSumTemplateSql, deleteMDTemplateSql, deleteMDDetailTemplateSql.toString(), deleteMDToSalaryTemplateSql.toString()};
        return sqlArr;
    }

    public static String[] getCancelSalaryTemplateSQLArrByHRPerson() {
        String updateSumTemplateSql = "update T_HR_ATS_AttendanceResultSum set FSalaryStatus=?,FSalaryPeriod=?,FLastUpdateTime=?,FLastUpdateUserID=? where fid =?";
        String deleteMDTemplateSql = " delete from T_HR_ATS_AttendanceReSumMd  where fid = ? ";
        StringBuilder deleteMDDetailTemplateSql = new StringBuilder();
        deleteMDDetailTemplateSql.append("  DELETE FROM T_HR_ATS_AttendanceResMd A  ").append(" WHERE EXISTS (SELECT 1 FROM T_HR_ATS_AttendanceResultSum T  ").append(" WHERE T.FID = ?  ").append(" AND A.FAtthrOrgUnitID = T.FhrOrgUnitID AND A.FPROPOSERID = T.FPROPOSERID ) ").append(" and A.FAttenceDate >= ? ").append(" and A.FAttenceDate <= ? ");
        StringBuilder deleteMDToSalaryTemplateSql = new StringBuilder();
        deleteMDToSalaryTemplateSql.append("  DELETE FROM T_HR_ATS_AttResultItemToSalary A  ").append(" WHERE EXISTS (SELECT 1 FROM T_HR_ATS_AttendanceResultSum T  ").append(" WHERE T.FID = ?  ").append(" AND A.FAtthrOrgUnitID = T.FhrOrgUnitID AND A.FPROPOSERID = T.FPROPOSERID ) ").append(" and A.FAttenceDate >= ? ").append(" and A.FAttenceDate <= ? ");
        String[] sqlArr = new String[]{updateSumTemplateSql, deleteMDTemplateSql, deleteMDDetailTemplateSql.toString(), deleteMDToSalaryTemplateSql.toString()};
        return sqlArr;
    }

    public static String[] getCancelSalaryTemplateSQLArrByHRPersonAtt() {
        String updateSumTemplateSql = "update T_HR_ATS_AttendanceResultSum set FSalaryStatus=?,FSalaryPeriod=?,FLastUpdateTime=?,FLastUpdateUserID=? where fid =?";
        String deleteMDTemplateSql = " delete from T_HR_ATS_AttendanceReSumMd  where fid = ? ";
        StringBuilder deleteMDDetailTemplateSql = new StringBuilder();
        deleteMDDetailTemplateSql.append("  DELETE FROM T_HR_ATS_AttendanceResMd A  ").append(" WHERE EXISTS (SELECT 1 FROM T_HR_ATS_AttendanceResultSum T  ").append(" WHERE T.FID = ?  ").append(" AND A.FAtthrOrgUnitID = T.FhrOrgUnitID AND A.FPROPOSERID = T.FPROPOSERID AND A.FATTADMINORGUNITID = T.FADMINORGUNITID)  ").append(" and A.FAttenceDate >= ? ").append(" and A.FAttenceDate <= ? ");
        StringBuilder deleteMDToSalaryTemplateSql = new StringBuilder();
        deleteMDToSalaryTemplateSql.append("  DELETE FROM T_HR_ATS_AttResultItemToSalary A  ").append(" WHERE EXISTS (SELECT 1 FROM T_HR_ATS_AttendanceResultSum T  ").append(" WHERE T.FID = ?  ").append(" AND A.FAtthrOrgUnitID = T.FhrOrgUnitID AND A.FPROPOSERID = T.FPROPOSERID AND A.FATTADMINORGUNITID = T.FADMINORGUNITID)  ").append(" and A.FAttenceDate >= ? ").append(" and A.FAttenceDate <= ? ");
        String[] sqlArr = new String[]{updateSumTemplateSql, deleteMDTemplateSql, deleteMDDetailTemplateSql.toString(), deleteMDToSalaryTemplateSql.toString()};
        return sqlArr;
    }

    public static String[] getCancelItemSalaryTemplateSQLArrByHRPersonAtt() {
        String updateSumTemplateSql = "update T_HR_ATS_ATTRESULTITEMSUM set FSalaryStatus=?,FSalaryPeriod=?,FLastUpdateTime=?,FLastUpdateUserID=? where fid =?";
        String deleteMDTemplateSql = " delete from T_HR_ATS_ATTRESULTITEMSUMMD  where fid = ? ";
        String[] sqlArr = new String[]{updateSumTemplateSql, deleteMDTemplateSql};
        return sqlArr;
    }

    public static void initMsgMap(Map<String, Object> resultMap) {
        HashMap successMap = (HashMap)resultMap.get("SUCCESS_MAP");
        HashMap auditedMap = (HashMap)resultMap.get("AUDITED_MAP");
        HashMap hasSalaryMap = (HashMap)resultMap.get("HASSALARY_MAP");
        HashMap lockMap = (HashMap)resultMap.get("LOCK_MAP");
        HashSet sumIdSet = (HashSet)resultMap.get("SUMID_SET");
        ArrayList sumSalaryUpdateList = (ArrayList)resultMap.get("SUM_SALARY_UPDATE_PARAMS");
        ArrayList insertMdSqlList = (ArrayList)resultMap.get("SALARY_INSERT_PARAMS");
        ArrayList insertDetailMdSqlList = (ArrayList)resultMap.get("SALARY_DETAIL_INSERT_PARAMS");
        ArrayList insertItemDetailMdSqlList = (ArrayList)resultMap.get("ITEM_TO_SALARY_DETAIL_INSERT_PARAMS");
        if (successMap == null) {
            successMap = new HashMap();
            resultMap.put("SUCCESS_MAP", successMap);
        }
        if (auditedMap == null) {
            auditedMap = new HashMap();
            resultMap.put("AUDITED_MAP", auditedMap);
        }
        if (hasSalaryMap == null) {
            hasSalaryMap = new HashMap();
            resultMap.put("HASSALARY_MAP", hasSalaryMap);
        }
        if (lockMap == null) {
            lockMap = new HashMap();
            resultMap.put("LOCK_MAP", lockMap);
        }
        if (sumIdSet == null) {
            sumIdSet = new HashSet();
            resultMap.put("SUMID_SET", sumIdSet);
        }
        if (sumSalaryUpdateList == null) {
            sumSalaryUpdateList = new ArrayList();
            resultMap.put("SUM_SALARY_UPDATE_PARAMS", sumSalaryUpdateList);
        }
        if (insertMdSqlList == null) {
            insertMdSqlList = new ArrayList();
            resultMap.put("SALARY_INSERT_PARAMS", insertMdSqlList);
        }
        if (insertDetailMdSqlList == null) {
            insertDetailMdSqlList = new ArrayList();
            resultMap.put("SALARY_DETAIL_INSERT_PARAMS", insertDetailMdSqlList);
        }
        if (insertItemDetailMdSqlList == null) {
            insertItemDetailMdSqlList = new ArrayList();
            resultMap.put("ITEM_TO_SALARY_DETAIL_INSERT_PARAMS", insertItemDetailMdSqlList);
        }
    }

    public static void putMsgToResultMap(Map<String, Object> resultMap, Map<String, Object> batchMsgMap) {
        Map successMap = (Map)resultMap.get("SUCCESS_MAP");
        Map auditedMap = (Map)resultMap.get("AUDITED_MAP");
        Map hasSalaryMap = (Map)resultMap.get("HASSALARY_MAP");
        Map lockMap = (Map)resultMap.get("LOCK_MAP");
        Set sumIdSet = (Set)resultMap.get("SUMID_SET");
        List sumSalaryUpdateList = (List)resultMap.get("SUM_SALARY_UPDATE_PARAMS");
        List insertMdSqlList = (List)resultMap.get("SALARY_INSERT_PARAMS");
        List insertDetailMdSqlList = (List)resultMap.get("SALARY_DETAIL_INSERT_PARAMS");
        List insertItemDetailMdSqlList = (List)resultMap.get("ITEM_TO_SALARY_DETAIL_INSERT_PARAMS");
        if (batchMsgMap.get("LOCK_MAP") != null) {
            lockMap.putAll((Map)batchMsgMap.get("LOCK_MAP"));
        }
        if (batchMsgMap.get("SUCCESS_MAP") != null) {
            successMap.putAll((Map)batchMsgMap.get("SUCCESS_MAP"));
        }
        if (batchMsgMap.get("AUDITED_MAP") != null) {
            auditedMap.putAll((Map)batchMsgMap.get("AUDITED_MAP"));
        }
        if (batchMsgMap.get("HASSALARY_MAP") != null) {
            hasSalaryMap.putAll((Map)batchMsgMap.get("HASSALARY_MAP"));
        }
        if (batchMsgMap.get("SUMID_SET") != null) {
            sumIdSet.addAll((Set)batchMsgMap.get("SUMID_SET"));
        }
        if (batchMsgMap.get("SUM_SALARY_UPDATE_PARAMS") != null) {
            sumSalaryUpdateList.addAll((List)batchMsgMap.get("SUM_SALARY_UPDATE_PARAMS"));
        }
        if (batchMsgMap.get("SALARY_INSERT_PARAMS") != null) {
            insertMdSqlList.addAll((List)batchMsgMap.get("SALARY_INSERT_PARAMS"));
        }
        if (batchMsgMap.get("SALARY_DETAIL_INSERT_PARAMS") != null) {
            insertDetailMdSqlList.addAll((List)batchMsgMap.get("SALARY_DETAIL_INSERT_PARAMS"));
        }
        if (batchMsgMap.get("ITEM_TO_SALARY_DETAIL_INSERT_PARAMS") != null) {
            insertItemDetailMdSqlList.addAll((List)batchMsgMap.get("ITEM_TO_SALARY_DETAIL_INSERT_PARAMS"));
        }
    }

    public static void tranSalary(Context ctx, Map<String, Object> resultMap, String[] sumTranSalaryTempldateSQL) {
        List sumSalaryUpdateSqlParam = (List)resultMap.get("SUM_SALARY_UPDATE_PARAMS");
        List insertMdSqlParam = (List)resultMap.get("SALARY_INSERT_PARAMS");
        List insertDetailMdParam = (List)resultMap.get("SALARY_DETAIL_INSERT_PARAMS");
        List insertToSalaryDetailMdParam = (List)resultMap.get("ITEM_TO_SALARY_DETAIL_INSERT_PARAMS");
        int successCount = 0;
        String errorMsg = "";
        try {
            if (null != sumSalaryUpdateSqlParam && null != insertMdSqlParam && null != insertDetailMdParam && null != insertToSalaryDetailMdParam && sumSalaryUpdateSqlParam.size() == insertMdSqlParam.size() && insertDetailMdParam.size() == sumSalaryUpdateSqlParam.size() && insertToSalaryDetailMdParam.size() == sumSalaryUpdateSqlParam.size()) {
                Object[] paramsTemplateArr = new Object[]{sumSalaryUpdateSqlParam, insertMdSqlParam, insertDetailMdParam, insertToSalaryDetailMdParam};
                Object[] result = AtsDbUtil.executeBatch(ctx, sumSalaryUpdateSqlParam.size(), AtsDbUtil.getBatchCount(), sumTranSalaryTempldateSQL, paramsTemplateArr);
                successCount = (Integer)result[0];
                errorMsg = result[1].toString();
                if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
                    HashMap<String, String> lockMap = (HashMap<String, String>)resultMap.get("LOCK_MAP");
                    if (lockMap == null) {
                        lockMap = new HashMap<String, String>();
                    }
                    lockMap.put("error", errorMsg);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.error((Object)("ResultToSumSalary saveSalaryData success count: " + successCount));
    }

    public static Map<String, Object> checkSumType(Context ctx, int sumType, String sqlQuery, String tableName) {
        HashMap<String, Object> lockMessageMap = new HashMap<String, Object>();
        sqlQuery = sqlQuery.substring(0, sqlQuery.indexOf("order by")) + " and ATS_RESULT.FSUMTYPE <> " + sumType;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlQuery.toString());
            while (rowSet.next()) {
                String FID = rowSet.getString("FID");
                String personName = rowSet.getString("personName");
                String pNumber = rowSet.getString("personNumber");
                Integer dbsumType = rowSet.getInt("FSUMTYPE");
                if (!StringUtils.isEmpty((CharSequence)tableName) && tableName.equals("T_HR_ATS_AttendanceResultSum")) {
                    lockMessageMap.put(FID, MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.SumTypeUnMatch, ctx, personName, pNumber, AtsSumTypeEnum.getEnum(dbsumType).getAlias()));
                    continue;
                }
                lockMessageMap.put(FID, MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.CancelSalarySumTypeUnMatch, ctx, personName, pNumber, AtsSumTypeEnum.getEnum(dbsumType).getAlias()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lockMessageMap;
    }

    public static Map<String, Object> checkSumType(Context ctx, int sumType, List<String> salaryIdList, String tableName) {
        HashMap<String, Object> lockMessageMap = new HashMap<String, Object>();
        Object[] params = new Object[salaryIdList.size() + 1];
        StringBuilder where = new StringBuilder();
        for (int i = 0; i < salaryIdList.size(); ++i) {
            if (where.length() > 0) {
                where.append(",");
            }
            where.append("?");
            params[i] = salaryIdList.get(i);
        }
        params[salaryIdList.size()] = sumType;
        StringBuilder checkSql = new StringBuilder();
        checkSql.append("SELECT D.FID, P.FNAME").append(MLUtile.getMlFlag(ctx)).append(" personName,P.FNUMBER personNumber ,D.FSUMTYPE").append(" FROM " + tableName + " D INNER JOIN T_BD_PERSON P ON D.FPROPOSERID = P.FID WHERE D.FID IN (").append(where.toString()).append(") AND D.FSUMTYPE <> ? ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString(), (Object[])params);
            while (rowSet.next()) {
                String FID = rowSet.getString("FID");
                String personName = rowSet.getString("personName");
                String pNumber = rowSet.getString("personNumber");
                Integer dbsumType = rowSet.getInt("FSUMTYPE");
                if (!StringUtils.isEmpty((CharSequence)tableName) && tableName.equals("T_HR_ATS_AttendanceResultSum")) {
                    lockMessageMap.put(FID, MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.SumTypeUnMatch, ctx, personName, pNumber, AtsSumTypeEnum.getEnum(dbsumType).getAlias()));
                } else {
                    lockMessageMap.put(FID, MLUtile.getRes((ResourceEnum)AtsAttenceResEnum.CancelSalarySumTypeUnMatch, ctx, personName, pNumber, AtsSumTypeEnum.getEnum(dbsumType).getAlias()));
                }
                salaryIdList.remove(FID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lockMessageMap;
    }

    public static int getSystemParamIntValue(Context ctx, String keyId) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT FVALUE" + MLUtile.getMlFlag(ctx) + " VALUE FROM T_BAS_PARAMITEM ITEM ");
        sb.append(" INNER JOIN T_BAS_PARAM PARAM ON PARAM.FID = ITEM.FKEYID ");
        sb.append(" WHERE FKEYID = ? ");
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{keyId});
            if (row.next()) {
                return row.getInt("VALUE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }
}

