/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.punchcard;

import com.kingdee.bos.Context;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsBillResEnum;
import com.kingdee.eas.hr.ats.AtsCludHubResEnum;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsPunchCardResEnum;
import com.kingdee.eas.hr.ats.AtsTimeCommonResEnum;
import com.kingdee.eas.hr.ats.AttendanceLogFactory;
import com.kingdee.eas.hr.ats.AttendanceLogInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.atsTimer.AtsTimeTask;
import com.kingdee.eas.hr.ats.atsTimer.AtsTimer;
import com.kingdee.eas.hr.ats.syn.punchcard.PunchcardHttpExecutor;
import com.kingdee.eas.hr.ats.syn.synch.PunchCardSynEnv;
import com.kingdee.eas.hr.ats.syn.synch.SynHelper;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.AtsSqlUtile;
import com.kingdee.eas.hr.ats.util.common.BackJob.BackJobUtile;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.util.common.OneFieldProcessor;
import com.kingdee.eas.hr.ats.vo.common.AtsErrorMsg;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.TimerTask;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractPunchCardSynProcessor
extends AtsErrorMsg {
    private Logger logger = AtsLog.getPunchcardCloudLog();
    private AttendanceLogInfo attendanceLog = new AttendanceLogInfo();
    private int punnchcard_cloud_pageLength = 100;
    private boolean fetchDataDayByDay = true;
    private boolean fetchDataWithPersonPage = true;
    private int punnchcard_cloud_batch_person_size = 50;
    private Timestamp taskRunningTime;
    private Timestamp workDateFrom;
    private Timestamp workDateTo;
    private String personIds;
    private String syncUrl;
    private Exception globalException;
    private boolean noNetPhotoAsNormalCard;
    private PunchCardSynEnv punchCardSynEnv;
    private PunchcardHttpExecutor httpExecutor;
    private String openapikey;

    public AbstractPunchCardSynProcessor() {
        this.setNoNetPhotoAsNormalCard(Boolean.parseBoolean(ConfigAts.getPropertyFromConfig("punchcardRecord.syn.noNetPhotoAsNormalCard")));
    }

    public String synchronize() {
        this.setTaskRunningTime(new Timestamp(System.currentTimeMillis()));
        this.getAttendanceLog().setJobid(BackJobUtile.getJobId(this.ctx));
        this.getAttendanceLog().setCreateTime(this.getTaskRunningTime());
        this.setPunchCardSynEnv(this.createPunchCardSynEnv());
        this.logger.info((Object)("need syn time range : " + AtsDateUtils.timestampToString(this.getPunchCardSynEnv().getWorkDateFrom()) + "--" + AtsDateUtils.timestampToString(this.getPunchCardSynEnv().getWorkDateTo()) + "--" + this.ctx.get((Object)"synStyle")));
        this.logger.info((Object)("cur enabled interface" + this.getSyncUrl()));
        if (this.getPunchCardSynEnv().isClockInterface()) {
            this.setFetchDataWithPersonPage(false);
        }
        if (this.getPunchCardSynEnv().isNewListInterface()) {
            this.setFetchDataDayByDay(true);
        }
        this.doSynchronize(this.getPunchCardSynEnv());
        return this.generateSynInfo();
    }

    protected String generateSynInfo() {
        StringBuffer dataString = new StringBuffer("\r\n" + MLUtile.getRes((ResourceEnum)AtsTimeCommonResEnum.SyncTimeRange, this.ctx, "")).append(AtsDateUtils.timestampToString(this.getPunchCardSynEnv().getWorkDateFrom())).append("~").append(AtsDateUtils.timestampToString(this.getPunchCardSynEnv().getWorkDateTo())).append("\r\n").append(MLUtile.getRes(AtsTimeCommonResEnum.SyncEndTime, this.ctx)).append(" : ").append(AtsDateUtils.timestampToString(this.getTaskRunningTime())).append("\r\n").append(MLUtile.getRes(AtsTimeCommonResEnum.SyncStartTime, this.ctx)).append(" : ").append(AtsDateUtils.timestampToString(new Timestamp(System.currentTimeMillis()))).append("\r\n").append(MLUtile.getRes((ResourceEnum)AtsCludHubResEnum.item4, this.ctx, this.getPunchCardSynEnv().getCloudTotalSize())).append("\r\n").append(MLUtile.getRes((ResourceEnum)AtsBillResEnum.SyncConsumerMillis, this.ctx, System.currentTimeMillis() - this.getTaskRunningTime().getTime())).append("\r\n").append(MLUtile.getRes((ResourceEnum)AtsPunchCardResEnum.PunchAddDataRow, this.ctx, this.getPunchCardSynEnv().getPunchcardAddSize())).append(MLUtile.getRes((ResourceEnum)AtsBillResEnum.UpdateDataItem, this.ctx, " " + this.getPunchCardSynEnv().getPunchcardUpdateSize() + " ")).append(";").append("\r\n").append(MLUtile.getRes((ResourceEnum)AtsPunchCardResEnum.MobilePunchAddRow, this.ctx, this.getPunchCardSynEnv().getSignAddSize())).append(MLUtile.getRes((ResourceEnum)AtsBillResEnum.UpdateDataItem, this.ctx, " " + this.getPunchCardSynEnv().getSignUpdateSize() + " ")).append(";");
        if (!AtsCollectionUtile.isEmpty(this.getPunchCardSynEnv().getNotFoundPersonSet())) {
            dataString.append("\r\n----------------------------------------------------------");
            dataString.append("\r\n").append(MLUtile.getRes(AtsBillResEnum.NoEmployeeInSystem, this.ctx));
            dataString.append("\r\n").append(MLUtile.getRes(AtsBillResEnum.ReSyncPersonDetail, this.ctx)).append("\r\n");
            dataString.append(this.getPunchCardSynEnv().getNotFoundPersonSet());
        }
        return dataString.toString();
    }

    protected void doSynchronize(PunchCardSynEnv punchCardSynEnv) {
        if (!this.isFetchDataWithPersonPage() && StringUtils.isEmpty((String)punchCardSynEnv.getPersonIds())) {
            this.doSynchronizeByPage(punchCardSynEnv, null);
            return;
        }
        StringBuffer sql = new StringBuffer("select FPROPOSERID from t_hr_ats_attendancefile");
        if (StringUtils.isNotBlank((String)this.getPersonIds())) {
            sql.append(" where FPROPOSERID in ('").append(this.getPersonIds().replaceAll(",", "','")).append("')");
        }
        new OneFieldProcessor<Object>(sql.append(" order by FPROPOSERID").toString(), this.ctx){

            @Override
            protected void afterGetAllRow(Context ctx, List<Object> rows) {
                if (AbstractPunchCardSynProcessor.this.getGlobalException() != null) {
                    this.setSql(null);
                    return;
                }
                AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().setPersonIds(AtsCollectionUtile.join(rows));
                try {
                    AbstractPunchCardSynProcessor.this.initPunchcardSynEnv(AbstractPunchCardSynProcessor.this.getPunchCardSynEnv(), AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().getPersonIds(), true);
                }
                catch (Exception e) {
                    AbstractPunchCardSynProcessor.this.add(MLUtile.getRes((ResourceEnum)AtsCommonResEnum.InitFail, ctx, "punchCardSynEnv", ":" + e.getMessage()));
                    AbstractPunchCardSynProcessor.this.logger.error((Object)("punchCardSynEnv init error:" + e.getMessage()), (Throwable)e);
                    return;
                }
                if (StringUtils.isBlank((String)AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().getOpenIds())) {
                    AbstractPunchCardSynProcessor.this.add(MLUtile.getRes((ResourceEnum)AtsBillResEnum.NotFetchWithPersonOfNo, ctx, AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().getTotalPage(), "openid,personId", AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().getPersonIds()));
                    AbstractPunchCardSynProcessor.this.logger.info((Object)("total batch " + AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().getTotalPage() + " all person not find openid,personId is:" + AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().getPersonIds()));
                    return;
                }
                AbstractPunchCardSynProcessor.this.doSynchronizeByPage(AbstractPunchCardSynProcessor.this.getPunchCardSynEnv(), this.sql);
            }
        }.setUseTempTable(this.getPersonIds() == null || this.getPersonIds().split(",").length > 200).setLength(this.getPunnchcard_cloud_batch_person_size()).process();
    }

    protected void doSynchronizeByPage(PunchCardSynEnv punchCardSynEnv, String personPageSql) {
        boolean reInitPersonData = personPageSql == null;
        Timestamp curSynStartTimeStamp = (Timestamp)punchCardSynEnv.getWorkDateFrom().clone();
        while (curSynStartTimeStamp.before(punchCardSynEnv.getWorkDateTo())) {
            while (true) {
                if (this.getGlobalException() != null) {
                    return;
                }
                punchCardSynEnv.incTotalPage();
                this.logger.info((Object)("cur batch;total batch :" + punchCardSynEnv.getTotalPage() + ";batch in that day" + AtsDateUtils.dateShortToString(curSynStartTimeStamp) + ":" + punchCardSynEnv.getStart()));
                JSONArray outData = this.getOutData(punchCardSynEnv, curSynStartTimeStamp);
                this.updatePunchCardSynEnv(outData, punchCardSynEnv, reInitPersonData);
                this.saveData(punchCardSynEnv);
                if (reInitPersonData) {
                    punchCardSynEnv.setOpenIds(null);
                }
                if (outData == null || punchCardSynEnv.isNewListInterface() || outData.size() < punchCardSynEnv.getLimit() || punchCardSynEnv.getTotalPage() > 100000) break;
                punchCardSynEnv.setStart(punchCardSynEnv.getStart() + 1);
            }
            if (this.isFetchDataDayByDay()) {
                punchCardSynEnv.setStart(1);
                curSynStartTimeStamp.setTime(AtsCommonUtile.getDayStart(curSynStartTimeStamp).getTime());
                curSynStartTimeStamp.setTime(curSynStartTimeStamp.getTime() + 86400000L);
            } else {
                curSynStartTimeStamp = punchCardSynEnv.getWorkDateTo();
            }
            this.updateAttendanceLog(personPageSql);
        }
    }

    protected void updateAttendanceLog(String personPageSql) {
        AtsTimer.addTask((TimerTask)new AtsTimeTask<String>(this.ctx, personPageSql){

            @Override
            protected void process() throws Exception {
                long taskNeedTime = AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().getTaskNeedTime();
                long curUsedTime = System.currentTimeMillis() - AbstractPunchCardSynProcessor.this.getTaskRunningTime().getTime();
                if (taskNeedTime == 0L) {
                    long synTimeDiff = AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().getWorkDateTo().getTime() - AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().getWorkDateFrom().getTime();
                    synTimeDiff = synTimeDiff / 86400000L + (long)(synTimeDiff % 86400000L == 0L ? 0 : 1);
                    int personTotalPage = this.dataObj == null ? 0 : AtsSqlUtile.getTotalCount(this.ctx, (String)this.dataObj) / AbstractPunchCardSynProcessor.this.getPunnchcard_cloud_batch_person_size();
                    taskNeedTime = curUsedTime * synTimeDiff * (long)(personTotalPage == 0 ? 1 : personTotalPage);
                    AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().setTaskNeedTime(taskNeedTime);
                }
                if (curUsedTime > taskNeedTime) {
                    curUsedTime = taskNeedTime;
                }
                AbstractPunchCardSynProcessor.this.getAttendanceLog().setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                AbstractPunchCardSynProcessor.this.getAttendanceLog().setCostSumTime(BigDecimal.valueOf(taskNeedTime));
                AbstractPunchCardSynProcessor.this.getAttendanceLog().setCostTime(BigDecimal.valueOf(curUsedTime));
                AbstractPunchCardSynProcessor.this.getAttendanceLog().setRemainTime(BigDecimal.valueOf(taskNeedTime - curUsedTime));
                AbstractPunchCardSynProcessor.this.getAttendanceLog().setSumPerson(BigDecimal.valueOf(AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().getCloudTotalSize()));
                int successCount = AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().getPunchcardAddSize() + AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().getPunchcardUpdateSize() + AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().getSignAddSize() + AbstractPunchCardSynProcessor.this.getPunchCardSynEnv().getSignUpdateSize();
                AbstractPunchCardSynProcessor.this.getAttendanceLog().setSumDays(BigDecimal.valueOf(successCount));
                try {
                    AttendanceLogFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)AbstractPunchCardSynProcessor.this.getAttendanceLog());
                }
                catch (Exception e) {
                    AbstractPunchCardSynProcessor.this.logger.error((Object)("update syn logger error ,detail:" + e.getMessage()), (Throwable)e);
                }
            }
        }, 100L);
    }

    protected void saveData(PunchCardSynEnv punchCardSynEnv) {
        SynHelper.compareSignRcdColl(punchCardSynEnv);
        SynHelper.updateSignRecData(punchCardSynEnv);
        SynHelper.comparePunchcardColl(punchCardSynEnv);
        SynHelper.updatePunchcardData(punchCardSynEnv);
        if (punchCardSynEnv.getDiscardData().size() > 0 || punchCardSynEnv.getPersonNotExistData().size() > 0) {
            this.logger.info((Object)"give_up_data begin");
            if (punchCardSynEnv.getDiscardData().size() > 0) {
                this.logger.info((Object)("discardData:size=" + punchCardSynEnv.getDiscardData().size() + "\r\n" + punchCardSynEnv.getDiscardData().join("\r\n")));
            }
            if (punchCardSynEnv.getPersonNotExistData().size() > 0) {
                this.logger.info((Object)("personNotExistData:size=" + punchCardSynEnv.getPersonNotExistData().size() + "\r\n" + punchCardSynEnv.getPersonNotExistData().join("\r\n")));
            }
            this.logger.info((Object)"give_up_data end");
        }
        punchCardSynEnv.setDiscardCount(punchCardSynEnv.getDiscardCount() + punchCardSynEnv.getDiscardData().size());
        punchCardSynEnv.setPersonNotExistCount(punchCardSynEnv.getPersonNotExistCount() + punchCardSynEnv.getPersonNotExistData().size());
        punchCardSynEnv.getDiscardData().clear();
        punchCardSynEnv.getPersonNotExistData().clear();
    }

    protected abstract JSONArray getOutData(PunchCardSynEnv var1, Timestamp var2);

    protected PunchCardSynEnv createPunchCardSynEnv() {
        PunchCardSynEnv punchCardSynEnv = new PunchCardSynEnv();
        punchCardSynEnv.setLimit(this.getPunnchcard_cloud_pageLength());
        punchCardSynEnv.setCtx(this.ctx);
        punchCardSynEnv.setNotFoundPersonSet(new HashSet<String>());
        if (this.getWorkDateTo() == null) {
            this.setWorkDateTo(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getWorkDateFrom() == null) {
            this.setWorkDateFrom(new Timestamp(System.currentTimeMillis() - 86400000L));
        }
        punchCardSynEnv.setWorkDateTo(this.getWorkDateTo());
        punchCardSynEnv.setWorkDateFrom(this.getWorkDateFrom());
        return punchCardSynEnv;
    }

    protected abstract void updatePunchCardSynEnv(JSONArray var1, PunchCardSynEnv var2, boolean var3);

    protected abstract void initPunchcardSynEnv(PunchCardSynEnv var1, String var2, boolean var3) throws Exception;

    private boolean isUnhandle(JSONObject json) {
        JSONObject approveResult;
        if (json != null && json.containsKey((Object)"approveResult") && !json.getString("approveResult").equals("") && (approveResult = json.getJSONObject("approveResult")) != null && approveResult.containsKey((Object)"approveStatus")) {
            return "UNHANDLED".equalsIgnoreCase(approveResult.getString("approveStatus"));
        }
        return false;
    }

    public AttendanceLogInfo getAttendanceLog() {
        return this.attendanceLog;
    }

    public void setAttendanceLog(AttendanceLogInfo attendanceLog) {
        this.attendanceLog = attendanceLog;
    }

    public int getPunnchcard_cloud_pageLength() {
        return this.punnchcard_cloud_pageLength;
    }

    public void setPunnchcard_cloud_pageLength(int punnchcard_cloud_pageLength) {
        this.punnchcard_cloud_pageLength = punnchcard_cloud_pageLength;
    }

    public PunchCardSynEnv getPunchCardSynEnv() {
        return this.punchCardSynEnv;
    }

    public void setPunchCardSynEnv(PunchCardSynEnv punchCardSynEnv) {
        this.punchCardSynEnv = punchCardSynEnv;
    }

    public PunchcardHttpExecutor getHttpExecutor() {
        return this.httpExecutor;
    }

    public void setHttpExecutor(PunchcardHttpExecutor httpExecutor) {
        this.httpExecutor = httpExecutor;
    }

    public int getPunnchcard_cloud_batch_person_size() {
        return this.punnchcard_cloud_batch_person_size;
    }

    public void setPunnchcard_cloud_batch_person_size(int punnchcard_cloud_batch_person_size) {
        this.punnchcard_cloud_batch_person_size = punnchcard_cloud_batch_person_size;
    }

    public String getSyncUrl() {
        return this.syncUrl;
    }

    public void setSyncUrl(String syncUrl) {
        this.syncUrl = syncUrl;
    }

    public Timestamp getWorkDateFrom() {
        return this.workDateFrom;
    }

    public void setWorkDateFrom(Timestamp workDateFrom) {
        this.workDateFrom = workDateFrom;
    }

    public Timestamp getWorkDateTo() {
        return this.workDateTo;
    }

    public void setWorkDateTo(Timestamp workDateTo) {
        this.workDateTo = workDateTo;
    }

    public boolean isFetchDataDayByDay() {
        return this.fetchDataDayByDay;
    }

    public void setFetchDataDayByDay(boolean fetchDataDayByDay) {
        this.fetchDataDayByDay = fetchDataDayByDay;
    }

    public boolean isFetchDataWithPersonPage() {
        return this.fetchDataWithPersonPage;
    }

    public void setFetchDataWithPersonPage(boolean fetchDataWithPersonPage) {
        this.fetchDataWithPersonPage = fetchDataWithPersonPage;
    }

    public String getPersonIds() {
        return this.personIds;
    }

    public void setPersonIds(String personIds) {
        this.personIds = personIds;
    }

    public Timestamp getTaskRunningTime() {
        return this.taskRunningTime;
    }

    public void setTaskRunningTime(Timestamp taskRunningTime) {
        this.taskRunningTime = taskRunningTime;
    }

    public Exception getGlobalException() {
        return this.globalException;
    }

    public void setGlobalException(Exception globalException) {
        this.globalException = globalException;
    }

    public void setNoNetPhotoAsNormalCard(boolean noNetPhotoAsNormalCard) {
        this.noNetPhotoAsNormalCard = noNetPhotoAsNormalCard;
    }

    public boolean isNoNetPhotoAsNormalCard() {
        return this.noNetPhotoAsNormalCard;
    }

    public String getOpenapikey() {
        return this.openapikey;
    }

    public void setOpenapikey(String openapikey) {
        this.openapikey = openapikey;
    }
}

