/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.qyweixin;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.HttpSendUtil;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncHelper;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class WXSyncURLUtil {
    public static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.trdsync.wxsync.util.WXSyncURLUtil");
    public static Map tokenMap = null;
    public static final String DEFAULT_MCLOUD = "https://qyapi.weixin.qq.com";
    public static final String WX_TOKEN = "/cgi-bin/gettoken";
    public static final String WX_GET_CHECK_INDATA = "/cgi-bin/checkin/getcheckindata";
    private static final String WX_EIP = "wx_eip";
    private static final String WX_SECRET = "wx_secret";

    public static String getSyncUrl(Context ctx, String syncTypeUrl) throws BOSException {
        String token;
        Map config = new WXSyncHelper(ctx).getConfig();
        String mCloud = config.get("mCloud") == null ? DEFAULT_MCLOUD : (String)config.get("mCloud");
        String eip = (String)config.get("eip");
        String secret = (String)config.get("secret");
        String wxeip = ConfigAts.getPropertyFromConfig(WX_EIP);
        String wxsecret = ConfigAts.getPropertyFromConfig(WX_SECRET);
        if (StringUtils.isNotEmpty((CharSequence)wxeip) && StringUtils.isNotEmpty((CharSequence)wxsecret)) {
            eip = wxeip;
            secret = wxsecret;
        }
        if (com.kingdee.util.StringUtils.isEmpty((String)(token = WXSyncURLUtil.getToken(mCloud, eip, secret)))) {
            throw new BOSException("token is empty");
        }
        String syncUrl = mCloud + syncTypeUrl + "?access_token=" + token;
        return syncUrl;
    }

    private static String getToken(String headUrl, String corpid, String corpsecret) {
        if (tokenMap != null && tokenMap.get("token") != null) {
            long currentTimeMillis;
            long effectTime = (Long)tokenMap.get("effectime");
            if (effectTime <= (currentTimeMillis = System.currentTimeMillis())) {
                WXSyncURLUtil.sendToken(headUrl, corpid, corpsecret);
            }
        } else {
            tokenMap = new HashMap();
            WXSyncURLUtil.sendToken(headUrl, corpid, corpsecret);
        }
        return tokenMap.get("token").toString();
    }

    private static void sendToken(String headUrl, String corpid, String corpsecret) {
        HashMap<String, String> tokenParam = new HashMap<String, String>();
        tokenParam.put("corpid", corpid);
        tokenParam.put("corpsecret", corpsecret);
        try {
            JSONObject tokenResult = HttpSendUtil.startGet((String)(headUrl + WX_TOKEN), tokenParam);
            if (tokenResult.getInteger("errcode") != 0) {
                logger.error((Object)("fetch token fail:" + tokenResult.getString("errmsg")));
            } else {
                String token = tokenResult.getString("access_token");
                long effectime = System.currentTimeMillis() + (long)(tokenResult.getInteger("expires_in") * 1000);
                tokenMap.put("token", token);
                tokenMap.put("effectime", effectime);
            }
        }
        catch (Exception e) {
            logger.error((Object)("fetch token fail;" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static void clearTokenCache() {
        if (tokenMap != null) {
            tokenMap.clear();
        }
    }
}

