/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.syn.synch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.ats.AttendanceEquipmentFactory;
import com.kingdee.eas.hr.ats.AttendanceEquipmentInfo;
import com.kingdee.eas.hr.ats.PunchCardRecordFactory;
import com.kingdee.eas.hr.ats.syn.SynResultInfo;
import com.kingdee.eas.hr.ats.syn.SynchronizationContext;
import com.kingdee.eas.hr.ats.syn.fetch.PunchCardByWebSrvcGetOuterData;
import com.kingdee.eas.hr.ats.syn.synch.AbstractSynchronization;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PunchCardByWebSrvcSynchroniztion
extends AbstractSynchronization {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.ats.syn.synch.PunchCardByWebSrvcSynchroniztion");
    private final int extendDuration = 1440;

    @Override
    protected void synchronize(SynchronizationContext synContext, SynResultInfo resultInfo) throws EASBizException, BOSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void synchronize(SynchronizationContext synContext, SynResultInfo resultInfo, Map<String, Object> paramMap) throws EASBizException, BOSException {
        PunchCardByWebSrvcGetOuterData punchCardByWebSrvcGetOuterData = new PunchCardByWebSrvcGetOuterData();
        CoreBaseCollection attEquColl = this.GetAttendanceEquipmentNumber(synContext.getBosCtx());
        if (attEquColl == null || attEquColl.size() <= 0) {
            logger.error((Object)"The number of attendance Equipment is 0,their state is able;");
            throw new BOSException("The number of attendance Equipment is 0,their state is able;");
        }
        Map<String, String> EquAddressMap = this.getEquAddress(attEquColl);
        Map<String, String> map = this.getEquNoLastTransmitTime(attEquColl, synContext.getBosCtx());
        HashSet<String> validateSet = new HashSet<String>();
        for (AttendanceEquipmentInfo aei : attEquColl) {
            if (aei.getNumber() == null) continue;
            HashMap<String, Object> paramMap4get = new HashMap<String, Object>();
            paramMap4get.put("EquNO", aei.getNumber());
            paramMap4get.put("EquNoLastTransmitTime", map.get(aei.getNumber()));
            paramMap4get.put("EquAddress", EquAddressMap.get(aei.getNumber()));
            paramMap4get.put("number", paramMap.get("number"));
            CoreBaseCollection crdColl = (CoreBaseCollection)punchCardByWebSrvcGetOuterData.getOuterData(synContext, paramMap4get);
            if (crdColl != null && crdColl.size() > 0) {
                PunchCardRecordFactory.getLocalInstance(synContext.getBosCtx()).addnewBatchData(crdColl);
            }
            if (crdColl == null) continue;
            validateSet.add(aei.getNumber());
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            if (validateSet.size() > 0) {
                String sqlUpdate = "update T_HR_ATS_PunchCardRecordAssist set FLastTransmitTime = ? where FEquNo = ?  ";
                conn = EJBFactory.getConnection((Context)synContext.getBosCtx());
                pstmt = conn.prepareStatement(sqlUpdate);
                Iterator itr1 = validateSet.iterator();
                while (itr1.hasNext()) {
                    pstmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    pstmt.setString(2, (String)itr1.next());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(pstmt, conn);
        }
    }

    private CoreBaseCollection GetAttendanceEquipmentNumber(Context ctx) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("state"));
        evi.getSelector().add(new SelectorItemInfo("address"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        CoreBaseCollection coll = AttendanceEquipmentFactory.getLocalInstance(ctx).getCollection(evi);
        return coll;
    }

    private Map<String, String> getEquNoLastTransmitTime(CoreBaseCollection attEquColl, Context ctx) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (attEquColl.size() <= 0) {
            return map;
        }
        String[] equNoArr = new String[attEquColl.size()];
        for (int i = 0; i < attEquColl.size(); ++i) {
            equNoArr[i] = ((AttendanceEquipmentInfo)attEquColl.get(i)).getNumber();
        }
        String sql = "select FEquNo,FLastTransmitTime from  T_HR_ATS_PunchCardRecordAssist  WHERE FEquNo in ( " + AtsUtil.getStrFromStringArr(equNoArr) + " )";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String FEquNo = null;
            Timestamp lastDate = null;
            HashSet<String> setAready = new HashSet<String>();
            while (rowSet.next()) {
                FEquNo = rowSet.getString(1);
                lastDate = rowSet.getTimestamp(2);
                SimpleDateFormat form = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                map.put(FEquNo, form.format(lastDate));
                setAready.add(FEquNo);
            }
            String sql1 = "insert into T_HR_ATS_PunchCardRecordAssist values(?,?) ";
            pstmt = conn.prepareStatement(sql1);
            Set<String> setNew = AtsUtil.getSetFromStringArr(equNoArr);
            if (setAready.size() > 0) {
                setNew.removeAll(setAready);
            }
            for (String str : setNew) {
                map.put(str, "1990-01-01 00:00:00");
                pstmt.setString(1, str);
                pstmt.setDate(2, Date.valueOf("1990-01-01"));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException("SqlException : " + e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return map;
    }

    private Map<String, String> getEquAddress(CoreBaseCollection attEquColl) {
        HashMap<String, String> mapAddress = new HashMap<String, String>();
        for (int i = 0; i < attEquColl.size(); ++i) {
            AttendanceEquipmentInfo info = (AttendanceEquipmentInfo)attEquColl.get(i);
            mapAddress.put(info.getNumber(), info.getAddress());
        }
        return mapAddress;
    }
}

