/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsBillBizException;
import com.kingdee.eas.hr.ats.AtsTripBizException;
import com.kingdee.eas.hr.ats.AttenceGroupInfo;
import com.kingdee.eas.hr.ats.AttenceGroupItemCollection;
import com.kingdee.eas.hr.ats.AttenceGroupItemFactory;
import com.kingdee.eas.hr.ats.AttenceGroupItemInfo;
import com.kingdee.eas.hr.ats.AttendFileStateEnum;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.IAttendanceFileHIS;
import com.kingdee.eas.hr.ats.bizmanage.MessageConfirm.Constant.AtsMsgConfirmConstant;
import com.kingdee.eas.hr.ats.bizmanage.MessageConfirm.Util.AtsDealMsgConfirmTool;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.bizmanage.BizManageState;
import com.kingdee.shr.base.bizmanage.PersonBURelationCollection;
import com.kingdee.shr.base.bizmanage.PersonBURelationFactory;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.util.NumericException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AtsAttendanceFileUtils {
    private static Logger logger = Logger.getLogger(AtsAttendanceFileUtils.class);

    public static AttendanceFileInfo getAttendanceFile(Context ctx, String personID) {
        if (personID == null) {
            return null;
        }
        AttendanceFileInfo attendanceFileInfo = null;
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("effdt,");
        oqlb.append("atsShift.id,");
        oqlb.append("atsShift.number,");
        oqlb.append("atsShift.name,");
        oqlb.append("holidayPolicySet.id,");
        oqlb.append("holidayPolicySet.number,");
        oqlb.append("holidayPolicySet.name,");
        oqlb.append("attencePolicy.id,");
        oqlb.append("attencePolicy.number,");
        oqlb.append("attencePolicy.name,");
        oqlb.append("attencePolicy.isLeastTwoCards,");
        oqlb.append("attendanceNum,");
        oqlb.append("proposer.id,");
        oqlb.append("proposer.number,");
        oqlb.append("adminOrgUnit.id,");
        oqlb.append("position.id,");
        oqlb.append("hrOrgUnit.id");
        oqlb.append(" where proposer.id='");
        oqlb.append(personID);
        oqlb.append("'");
        oqlb.append(" and attendFileState='1' order by leffdt desc ");
        AttendanceFileCollection c = null;
        try {
            c = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(oqlb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"AtsAttendanceFileUtils.getAttendanceFile err", (Throwable)e);
        }
        if (c != null && c.size() > 0) {
            attendanceFileInfo = c.get(0);
        }
        return attendanceFileInfo;
    }

    public static Map getAttendanceFile(Context ctx, Set<String> personNumSet) {
        HashMap<String, AttendanceFileInfo> resultMap = new HashMap<String, AttendanceFileInfo>();
        try {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("proposer.id"));
            evi.getSelector().add(new SelectorItemInfo("proposer.number"));
            evi.getSelector().add(new SelectorItemInfo("proposer.name"));
            evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
            evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.number"));
            evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.name"));
            evi.getSelector().add(new SelectorItemInfo("position.id"));
            evi.getSelector().add(new SelectorItemInfo("position.number"));
            evi.getSelector().add(new SelectorItemInfo("position.name"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.id"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.number"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.name"));
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("proposer.number", personNumSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)"1", CompareType.EQUALS));
            evi.setFilter(fi);
            AttendanceFileCollection fileCollection = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(evi);
            if (fileCollection != null) {
                AttendanceFileInfo fileInfo = null;
                for (int i = 0; i < fileCollection.size(); ++i) {
                    fileInfo = fileCollection.get(i);
                    resultMap.put(fileInfo.getProposer().getNumber() + fileInfo.getProposer().getName(), fileInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public static Map getAttendanceFileWithHrRangeFilter(Context ctx, Set<String> personNumSet, String permItemId, String userId) {
        HashMap<String, AttendanceFileInfo> resultMap = new HashMap<String, AttendanceFileInfo>();
        try {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("proposer.id"));
            evi.getSelector().add(new SelectorItemInfo("proposer.number"));
            evi.getSelector().add(new SelectorItemInfo("proposer.name"));
            evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
            evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.number"));
            evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.name"));
            evi.getSelector().add(new SelectorItemInfo("position.id"));
            evi.getSelector().add(new SelectorItemInfo("position.number"));
            evi.getSelector().add(new SelectorItemInfo("position.name"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.id"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.number"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.name"));
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("proposer.number", personNumSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)"1", CompareType.EQUALS));
            Set hrOrgUnitIds = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)userId, (String)permItemId);
            fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitIds, CompareType.INCLUDE));
            evi.setFilter(fi);
            AttendanceFileCollection fileCollection = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(evi);
            if (fileCollection != null) {
                AttendanceFileInfo fileInfo = null;
                for (int i = 0; i < fileCollection.size(); ++i) {
                    fileInfo = fileCollection.get(i);
                    resultMap.put(fileInfo.getProposer().getNumber() + fileInfo.getProposer().getName(), fileInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public static Map getAttendanceFileWithHrOrgFilter(Context ctx, Set<String> personNumSet, String hrOrgUnitId) {
        HashMap<String, AttendanceFileInfo> resultMap = new HashMap<String, AttendanceFileInfo>();
        try {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("proposer.id"));
            evi.getSelector().add(new SelectorItemInfo("proposer.number"));
            evi.getSelector().add(new SelectorItemInfo("proposer.name"));
            evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
            evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.number"));
            evi.getSelector().add(new SelectorItemInfo("adminOrgUnit.name"));
            evi.getSelector().add(new SelectorItemInfo("position.id"));
            evi.getSelector().add(new SelectorItemInfo("position.number"));
            evi.getSelector().add(new SelectorItemInfo("position.name"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.id"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.number"));
            evi.getSelector().add(new SelectorItemInfo("hrOrgUnit.name"));
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("proposer.number", personNumSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)"1", CompareType.EQUALS));
            fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitId, CompareType.EQUALS));
            evi.setFilter(fi);
            AttendanceFileCollection fileCollection = AttendanceFileFactory.getLocalInstance(ctx).getAttendanceFileCollection(evi);
            if (fileCollection != null) {
                AttendanceFileInfo fileInfo = null;
                for (int i = 0; i < fileCollection.size(); ++i) {
                    fileInfo = fileCollection.get(i);
                    resultMap.put(fileInfo.getProposer().getNumber() + fileInfo.getProposer().getName(), fileInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public static Map getAttenceGroupInfo(Context ctx, Set<String> attenceNums) {
        HashMap<String, AttenceGroupInfo> resultMap = new HashMap<String, AttenceGroupInfo>();
        try {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("group.number"));
            evi.getSelector().add(new SelectorItemInfo("group.name"));
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("proposer.id"));
            evi.getSelector().add(new SelectorItemInfo("proposer.number"));
            evi.getSelector().add(new SelectorItemInfo("proposer.name"));
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("group.number", attenceNums, CompareType.INCLUDE));
            evi.setFilter(fi);
            AttenceGroupItemCollection attenceItemCollection = AttenceGroupItemFactory.getLocalInstance(ctx).getAttenceGroupItemCollection(evi);
            if (attenceItemCollection != null) {
                AttenceGroupItemInfo attenceItemInfo = null;
                for (int i = 0; i < attenceItemCollection.size(); ++i) {
                    attenceItemInfo = attenceItemCollection.get(i);
                    AttenceGroupInfo group = attenceItemInfo.getGroup();
                    if (resultMap.get(group.getNumber() + group.getName()) == null) {
                        group.getItems().add(attenceItemInfo);
                        resultMap.put(group.getNumber() + group.getName(), group);
                        continue;
                    }
                    AttenceGroupInfo groupItem = (AttenceGroupInfo)resultMap.get(group.getNumber() + group.getName());
                    groupItem.getItems().add(attenceItemInfo);
                    resultMap.put(group.getNumber() + group.getName(), group);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public static void delScheduleShiftBeforeEnterDate(Context ctx, Set<String> personNums) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.number", personNums, CompareType.INCLUDE));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        evi.getSelector().add(new SelectorItemInfo("leftDate"));
        evi.setFilter(fi);
        String delSql = null;
        try {
            PersonPositionCollection ppCollection = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(evi);
            if (ppCollection != null && !ppCollection.isEmpty()) {
                HashMap<String, java.util.Date> dataMap = new HashMap<String, java.util.Date>();
                HashMap enterMap = new HashMap();
                HashMap<String, java.util.Date> leftDateMap = new HashMap<String, java.util.Date>();
                HashMap enterAndLeftDateMap = new HashMap();
                PersonPositionInfo ppInfo = null;
                for (int i = 0; i < ppCollection.size(); ++i) {
                    ppInfo = ppCollection.get(i);
                    String personId = ppInfo.getPerson().getId().toString();
                    EmpLaborRelationInfo laborInfo = SHRBillUtil.getEmpLaborRelationInfo(personId, ctx);
                    java.util.Date date = (java.util.Date)dataMap.get(personId);
                    java.util.Date leftDateObject = (java.util.Date)leftDateMap.get(personId);
                    if (date != null) {
                        long dbDateNum;
                        java.util.Date dbEnterDate = null;
                        if (laborInfo != null) {
                            dbEnterDate = laborInfo.getEnterDate();
                        }
                        long l = dbDateNum = dbEnterDate == null ? 0L : dbEnterDate.getTime();
                        if (date.getTime() < dbDateNum) {
                            dataMap.put(personId, dbEnterDate);
                        }
                    } else if (laborInfo != null) {
                        dataMap.put(personId, laborInfo.getEnterDate());
                    }
                    if (ppInfo.getLeftDate() == null) continue;
                    if (leftDateObject != null) {
                        long dbLeftDateNum;
                        java.util.Date dbLeftDate = ppInfo.getLeftDate();
                        long l = dbLeftDateNum = dbLeftDate == null ? 0L : dbLeftDate.getTime();
                        if (date == null || date.getTime() >= dbLeftDateNum) continue;
                        leftDateMap.put(personId, dbLeftDate);
                        continue;
                    }
                    leftDateMap.put(personId, ppInfo.getLeftDate());
                }
                Set dataMapSet = dataMap.keySet();
                Iterator i = dataMapSet.iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    if (dataMap.get(key) == null) continue;
                    enterMap.put(key, dataMap.get(key));
                    if (leftDateMap.get(key) == null || ((java.util.Date)leftDateMap.get(key)).getTime() >= ((java.util.Date)dataMap.get(key)).getTime()) continue;
                    ArrayList arrayList = new ArrayList();
                    arrayList.add(dataMap.get(key));
                    arrayList.add(leftDateMap.get(key));
                    enterAndLeftDateMap.put(key, arrayList);
                    i.remove();
                }
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                if (!enterAndLeftDateMap.isEmpty()) {
                    delSql = "delete from t_hr_ats_scheduleshift where FProposerID = ? and FAttendDate < ? and FAttendDate > ? ";
                    for (Map.Entry entry : enterAndLeftDateMap.entrySet()) {
                        if (entry.getValue() == null) continue;
                        paramsList.add(new Object[]{entry.getKey(), new Date(((java.util.Date)((List)entry.getValue()).get(0)).getTime()), new Date(((java.util.Date)((List)entry.getValue()).get(1)).getTime())});
                    }
                    DbUtil.executeBatch((Context)ctx, (String)delSql, paramsList);
                }
                String personId = "";
                if (!enterMap.isEmpty()) {
                    paramsList.clear();
                    delSql = "delete from t_hr_ats_scheduleshift where FProposerID = ? and FAttendDate < ?";
                    for (Map.Entry entry : enterMap.entrySet()) {
                        if (entry.getValue() == null) continue;
                        personId = (String)entry.getKey();
                        if ((entry.getValue() == null || leftDateMap.get(personId) == null || ((java.util.Date)entry.getValue()).getTime() >= ((java.util.Date)leftDateMap.get(personId)).getTime()) && leftDateMap.get(personId) != null) continue;
                        paramsList.add(new Object[]{entry.getKey(), new Date(((java.util.Date)entry.getValue()).getTime())});
                    }
                    DbUtil.executeBatch((Context)ctx, (String)delSql, paramsList);
                }
                if (!leftDateMap.isEmpty()) {
                    paramsList.clear();
                    delSql = "delete from t_hr_ats_scheduleshift where FProposerID = ? and FAttendDate > ?";
                    for (Map.Entry entry : leftDateMap.entrySet()) {
                        if (entry.getValue() == null) continue;
                        personId = (String)entry.getKey();
                        if ((entry.getValue() == null || enterMap.get(personId) == null || ((java.util.Date)entry.getValue()).getTime() <= ((java.util.Date)enterMap.get(personId)).getTime()) && (entry.getValue() == null || enterMap.get(personId) != null)) continue;
                        paramsList.add(new Object[]{entry.getKey(), new Date(((java.util.Date)entry.getValue()).getTime())});
                    }
                    DbUtil.executeBatch((Context)ctx, (String)delSql, paramsList);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void deleteAttendanceFileCurrent(Context ctx, List<AttendanceFileInfo> attendanceFileInfoList) throws BOSException, EASBizException {
        if (attendanceFileInfoList != null && attendanceFileInfoList.size() > 0) {
            for (AttendanceFileInfo attendanceFileInfo : attendanceFileInfoList) {
                IAttendanceFileHIS iAttendanceFileHIS = AttendanceFileHISFactory.getLocalInstance(ctx);
                String hisSQL = "where proposer.id ='" + attendanceFileInfo.getProposer().getId().toString() + "' order by effdt desc,leffdt desc";
                AttendanceFileHISCollection hisColl = iAttendanceFileHIS.getAttendanceFileHISCollection(hisSQL);
                AttendanceFileFactory.getLocalInstance(ctx).delete("where id = '" + attendanceFileInfo.getId().toString() + "'");
                if (hisColl.size() > 1) {
                    PersonBURelationInfo personBURelationInfo;
                    PersonBURelationCollection coll;
                    AttendanceFileHISInfo attendanceFileHisCurrent = hisColl.get(0);
                    AttendanceFileHISFactory.getLocalInstance(ctx).delete("where id ='" + attendanceFileHisCurrent.getId().toString() + "'");
                    AttendanceFileHISInfo attendanceFileHisCurrentLast = hisColl.get(1);
                    attendanceFileHisCurrentLast.setLEFFDT(AtsDateUtils.stringToShortDate("2099-12-31"));
                    attendanceFileHisCurrentLast.setLastUpdateTime(AtsDealMsgConfirmTool.getNowTimestamp());
                    attendanceFileHisCurrentLast.setAttendFileState(AttendFileStateEnum.enable);
                    AttendanceFileHISFactory.getLocalInstance(ctx).save((CoreBaseInfo)attendanceFileHisCurrentLast);
                    AttendanceFileInfo resetFileInfo = new AttendanceFileInfo();
                    AtsAttendanceFileUtils.assembleAttendanceFileInfo(attendanceFileHisCurrentLast, resetFileInfo);
                    resetFileInfo.setId(null);
                    resetFileInfo.setNumber(null);
                    AttendanceFileFactory.getLocalInstance(ctx).addnew(resetFileInfo);
                    if (null == attendanceFileInfo.getManageRelation()) {
                        throw new BOSException(AtsMsgConfirmConstant.BURELACTION_ISEMPTY.getMessage());
                    }
                    String manageRelationId = CoreBaseUtile.getId(attendanceFileInfo.getManageRelation());
                    if (attendanceFileInfo.getHrOrgUnit().getId().toString().equals(resetFileInfo.getHrOrgUnit().getId().toString())) {
                        coll = PersonBURelationFactory.getLocalInstance((Context)ctx).getPersonBURelationCollection("where id = '" + manageRelationId + "'");
                        if (coll.size() <= 0 || (personBURelationInfo = coll.get(0)).isUseDefault() == resetFileInfo.isIsDefaultManage()) continue;
                        personBURelationInfo.setUseDefault(resetFileInfo.isIsDefaultManage());
                        PersonBURelationFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)personBURelationInfo);
                        continue;
                    }
                    PersonBURelationFactory.getLocalInstance((Context)ctx).delete("where id = '" + manageRelationId + "'");
                    coll = PersonBURelationFactory.getLocalInstance((Context)ctx).getPersonBURelationCollection("where id = '" + CoreBaseUtile.getId(resetFileInfo.getManageRelation()) + "'");
                    if (coll.size() <= 0) continue;
                    personBURelationInfo = coll.get(0);
                    personBURelationInfo.setState(BizManageState.Enable);
                    personBURelationInfo.setEndDate(null);
                    PersonBURelationFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)personBURelationInfo);
                    continue;
                }
                AttendanceFileHISFactory.getLocalInstance(ctx).delete("where id = '" + hisColl.get(0).getId().toString() + "'");
                if (null == attendanceFileInfo.getManageRelation()) continue;
                PersonBURelationFactory.getLocalInstance((Context)ctx).delete("where id = '" + attendanceFileInfo.getManageRelation().getId().toString() + "'");
            }
        }
    }

    public static void assembleAttendanceFileInfo(AttendanceFileHISInfo attendanceFileHISInfo, AttendanceFileInfo newFileInfo) {
        newFileInfo.setName(attendanceFileHISInfo.getName());
        newFileInfo.setProposer(attendanceFileHISInfo.getProposer());
        newFileInfo.setHrOrgUnit(attendanceFileHISInfo.getHrOrgUnit());
        newFileInfo.setManageRelation(attendanceFileHISInfo.getManageRelation());
        newFileInfo.setAdminOrgUnit(attendanceFileHISInfo.getAdminOrgUnit());
        newFileInfo.setPosition(attendanceFileHISInfo.getPosition());
        newFileInfo.setAttencePolicy(attendanceFileHISInfo.getAttencePolicy());
        newFileInfo.setCalendar(attendanceFileHISInfo.getCalendar());
        newFileInfo.setAtsShift(attendanceFileHISInfo.getAtsShift());
        newFileInfo.setAttendanceNum(attendanceFileHISInfo.getAttendanceNum());
        newFileInfo.setAttAdminOrgUnit(attendanceFileHISInfo.getAttAdminOrgUnit());
        newFileInfo.setAttPosition(attendanceFileHISInfo.getAttPosition());
        newFileInfo.setEFFDT(attendanceFileHISInfo.getEFFDT());
        newFileInfo.setLEFFDT(attendanceFileHISInfo.getLEFFDT());
        newFileInfo.setIsAttendance(attendanceFileHISInfo.getIsAttendance());
        newFileInfo.setIsAutoShift(attendanceFileHISInfo.getIsAutoShift());
        newFileInfo.setIsDefaultManage(attendanceFileHISInfo.isIsDefaultManage());
        newFileInfo.setAttendFileState(attendanceFileHISInfo.getAttendFileState());
    }

    public static AttendanceFileHISInfo getAttendanceFileHISInfoByAttenceDate(Context ctx, java.util.Date attenceDate, String proposerId) throws BOSException {
        String oqlfile = "select *,attencePolicy.otStart,proposer.* where proposer.id = '" + proposerId + "'";
        AttendanceFileHISCollection attendanceFileHISColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(oqlfile);
        for (int i = 0; i < attendanceFileHISColl.size(); ++i) {
            if (attenceDate.getTime() < attendanceFileHISColl.get(i).getEFFDT().getTime() || attenceDate.getTime() > attendanceFileHISColl.get(i).getLEFFDT().getTime()) continue;
            return attendanceFileHISColl.get(i);
        }
        return null;
    }

    public static AttendanceFileHISInfo getAttendanceFileHISInfoByAttenceDateAllPolicyMsg(Context ctx, java.util.Date attenceDate, String proposerId) throws BOSException {
        String oqlfile = "select *,attencePolicy.*,proposer.* where proposer.id = '" + proposerId + "'";
        AttendanceFileHISCollection attendanceFileHISColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(oqlfile);
        for (int i = 0; i < attendanceFileHISColl.size(); ++i) {
            if (attenceDate.getTime() < attendanceFileHISColl.get(i).getEFFDT().getTime() || attenceDate.getTime() > attendanceFileHISColl.get(i).getLEFFDT().getTime()) continue;
            return attendanceFileHISColl.get(i);
        }
        return null;
    }

    public static AttendanceFileHISInfo getAttendanceFileHISInfo(Context ctx, java.util.Date attenceDate, String proposerId) throws BOSException {
        String oqlfile = "select *,attencePolicy.*,proposer.* where proposer.id = '" + proposerId + "'";
        AttendanceFileHISCollection attendanceFileHISColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(oqlfile);
        for (int i = 0; i < attendanceFileHISColl.size(); ++i) {
            if (attenceDate.getTime() < attendanceFileHISColl.get(i).getEFFDT().getTime() || attenceDate.getTime() > attendanceFileHISColl.get(i).getLEFFDT().getTime()) continue;
            return attendanceFileHISColl.get(i);
        }
        return null;
    }

    public static AttendanceFileHISInfo getAttendanceFileHISInfoByAttenceDate(Context ctx, Timestamp beginDate, Timestamp endDate, String proposerId) throws BOSException {
        String oqlfile = "select *,attencePolicy.otStart,proposer.* where proposer.id = '" + proposerId + "' order by effdt desc";
        AttendanceFileHISCollection attendanceFileHISColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(oqlfile);
        AttendanceFileHISCollection intersectColl = new AttendanceFileHISCollection();
        for (int i = 0; i < attendanceFileHISColl.size(); ++i) {
            AttendanceFileHISInfo hisInfo = attendanceFileHISColl.get(i);
            java.util.Date effdt = hisInfo.getEFFDT();
            String leffdtStr = AtsDateUtils.dateShortToString(hisInfo.getLEFFDT());
            leffdtStr = leffdtStr + " 23:59:59";
            java.util.Date leffdt = AtsDateUtils.stringToLongDate(leffdtStr);
            if (endDate.getTime() <= effdt.getTime() || beginDate.getTime() >= leffdt.getTime()) continue;
            if (intersectColl.size() > 0) {
                if (!intersectColl.get(0).getHrOrgUnit().getId().toString().equals(attendanceFileHISColl.get(i).getHrOrgUnit().getId().toString())) {
                    throw new BOSException(new AtsBillBizException(AtsBillBizException.COMMITCROSSHRORG).getMessage());
                }
                intersectColl.add(attendanceFileHISColl.get(i));
                continue;
            }
            intersectColl.add(attendanceFileHISColl.get(i));
        }
        if (intersectColl.size() > 0) {
            return intersectColl.get(0);
        }
        return null;
    }

    public static AttendanceFileHISInfo getAttendanceFileHISInfoByAttenceDate(Context ctx, Timestamp beginDate, Timestamp endDate, String proposerId, String hrOrgUnitId) throws BOSException {
        String oqlfile = "select *,attencePolicy.otStart,proposer.*,hrOrgUnit.* where attendFileState='1' and proposer.id = '" + proposerId + "' order by effdt desc";
        AttendanceFileHISCollection attendanceFileHISColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection(oqlfile);
        AttendanceFileHISCollection intersectColl = new AttendanceFileHISCollection();
        AttendanceFileHISInfo currentFile = null;
        for (int i = 0; i < attendanceFileHISColl.size(); ++i) {
            AttendanceFileHISInfo hisInfo = attendanceFileHISColl.get(i);
            if (hisInfo.getHrOrgUnit().getId().toString().equals(hrOrgUnitId)) {
                if (currentFile == null) {
                    currentFile = hisInfo;
                } else if (AtsDateUtils.getPreDay(currentFile.getEFFDT(), 1).getTime() == hisInfo.getLEFFDT().getTime()) {
                    currentFile.setEFFDT(hisInfo.getEFFDT());
                }
            }
            java.util.Date effdt = hisInfo.getEFFDT();
            String leffdtStr = AtsDateUtils.dateShortToString(hisInfo.getLEFFDT());
            leffdtStr = leffdtStr + " 23:59:59";
            java.util.Date leffdt = AtsDateUtils.stringToLongDate(leffdtStr);
            if (endDate.getTime() <= effdt.getTime() || beginDate.getTime() >= leffdt.getTime()) continue;
            if (intersectColl.size() > 0) {
                if (intersectColl.get(0).getHrOrgUnit().getId().toString().equals(attendanceFileHISColl.get(i).getHrOrgUnit().getId().toString())) {
                    intersectColl.add(attendanceFileHISColl.get(i));
                    continue;
                }
                throw new BOSException(new AtsTripBizException(AtsTripBizException.TRIPTIMECROSSHRORG).getMessage());
            }
            intersectColl.add(attendanceFileHISColl.get(i));
        }
        if (intersectColl.size() > 0) {
            if (!intersectColl.get(0).getHrOrgUnit().getId().toString().equals(hrOrgUnitId) && currentFile != null) {
                throw new BOSException(MLUtile.getRes((NumericException)new AtsTripBizException(AtsTripBizException.NOMATCHHRORGORDATE), currentFile.getProposer().getName(), currentFile.getProposer().getNumber(), currentFile.getHrOrgUnit().getName(), AtsDateUtils.dateShortToString(currentFile.getEFFDT()), AtsDateUtils.dateShortToString(currentFile.getLEFFDT())));
            }
            return intersectColl.get(0);
        }
        return null;
    }
}

