/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.AtsOrdinalCommonResEnum;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AtsDateUtils {
    public static final String SPLIT = " ";
    public static final String UNDERLINE = "_";
    public static final String TIME_SUFFIX = "00:00:00";
    public static final String TIME_ENDSUFFIX = "23:00:00";
    public static final String TIME_CURRENDSUFFIX = "23:59:59";
    public static final String SYS_EFFDT = "1900-01-01";
    public static final String SYS_LEFFDT = "2099-12-31";
    public static final String TIME_COLON = ":";
    public static final String TIME_COLON_SUFF = ":00";
    public static final int A_DAY_TIME_MILLISECONDS = 86400000;
    static String regL = "(\\d{2}|\\d{4})(?:\\-)?([0]{1}\\d{1}|[1]{1}[0-2]{1})(?:\\-)?([0-2]{1}\\d{1}|[3]{1}[0-1]{1})(?:\\s)?([0-1]{1}\\d{1}|[2]{1}[0-3]{1})(?::)?([0-5]{1}\\d{1})(?::)?([0-5]{1}\\d{1})";

    public static String getDateFromLongString(String dateStr) {
        return dateStr.substring(0, 10);
    }

    public static String getTimeFromLongString(String dateStr) {
        return dateStr.substring(11, dateStr.length());
    }

    public static String getHourFromLongString(String dateStr) {
        return dateStr.substring(11, 13);
    }

    public static String getHourFromShiftString(String dateStr) {
        return dateStr.substring(0, 2);
    }

    public static String getHourMinFromString(String dateStr) {
        return dateStr.substring(11, 16);
    }

    public static String getTimeByHourDigital(double hour) {
        return AtsDateUtils.formatLongToTimeStr(hour);
    }

    public static String formatLongToTimeStr(double hourValue) {
        long ms = (long)(hourValue * 60.0 * 60.0 * 1000.0);
        int ss = 1000;
        int mi = ss * 60;
        int hh = mi * 60;
        int dd = hh * 24;
        long day = ms / (long)dd;
        long hour = (ms - day * (long)dd) / (long)hh;
        long minute = (ms - day * (long)dd - hour * (long)hh) / (long)mi;
        long second = (ms - day * (long)dd - hour * (long)hh - minute * (long)mi) / (long)ss;
        long milliSecond = ms - day * (long)dd - hour * (long)hh - minute * (long)mi - second * (long)ss;
        String strDay = day < 10L ? "0" + day : "" + day;
        String strHour = hour < 10L ? "0" + hour : "" + hour;
        String strMinute = minute < 10L ? "0" + minute : "" + minute;
        String strSecond = second < 10L ? "0" + second : "" + second;
        String strMilliSecond = milliSecond < 10L ? "0" + milliSecond : "" + milliSecond;
        strMilliSecond = milliSecond < 100L ? "0" + strMilliSecond : "" + strMilliSecond;
        return strHour + TIME_COLON + strMinute + TIME_COLON + strSecond;
    }

    public static Date getSeasonFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int fm = date.getMonth();
        if (fm < 3) {
            calendar.set(1, date.getYear() - 1);
            calendar.set(2, fm + 9);
        } else {
            calendar.set(2, fm - 3);
        }
        calendar.set(5, 1);
        return AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(calendar.getTime()));
    }

    public static Date getMonthFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(calendar.getTime()));
    }

    public static Date getMonthLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(calendar.getTime()));
    }

    public static Date getMonthsAgo(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -num);
        return AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(calendar.getTime()));
    }

    public static Date getMonthsNext(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, num);
        return AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(calendar.getTime()));
    }

    public static List getDateList(String startDate, int num) {
        if (num == 0) {
            return AtsDateUtils.getDateList(startDate, startDate);
        }
        if (num > 0) {
            return AtsDateUtils.getDateList(startDate, AtsDateUtils.getNextDay(startDate, num));
        }
        return AtsDateUtils.getDateList(AtsDateUtils.getNextDay(startDate, num), startDate);
    }

    public static String formatLongToTimeStr(long ms) {
        int ss = 1000;
        int mi = ss * 60;
        int hh = mi * 60;
        int dd = hh * 24;
        long day = ms / (long)dd;
        long hour = (ms - day * (long)dd) / (long)hh;
        long minute = (ms - day * (long)dd - hour * (long)hh) / (long)mi;
        long second = (ms - day * (long)dd - hour * (long)hh - minute * (long)mi) / (long)ss;
        long milliSecond = ms - day * (long)dd - hour * (long)hh - minute * (long)mi - second * (long)ss;
        String strDay = day < 10L ? "0" + day : "" + day;
        String strHour = hour < 10L ? "0" + hour : "" + hour;
        String strMinute = minute < 10L ? "0" + minute : "" + minute;
        String strSecond = second < 10L ? "0" + second : "" + second;
        String strMilliSecond = milliSecond < 10L ? "0" + milliSecond : "" + milliSecond;
        strMilliSecond = milliSecond < 100L ? "0" + strMilliSecond : "" + strMilliSecond;
        return strHour + TIME_COLON + strMinute + TIME_COLON + strSecond;
    }

    public static String timestampToString(Timestamp timestamp) {
        String tsStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (timestamp != null) {
            try {
                tsStr = sdf.format(timestamp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return tsStr;
    }

    public static String timestampToShortString(Timestamp timestamp) {
        String tsStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (timestamp != null) {
            try {
                tsStr = sdf.format(timestamp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return tsStr;
    }

    public static Timestamp stringToTimestamp(String tsStr) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            if ((tsStr.matches(regL) || tsStr.endsWith(".0")) && StringUtils.isNotBlank((String)tsStr)) {
                ts = Timestamp.valueOf(tsStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ts;
    }

    public static Timestamp stringShortToTimestamp(String tsStr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        format.setLenient(false);
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = new Timestamp(format.parse(tsStr).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return ts;
    }

    public static Date stringToLongDate(String str) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (StringUtils.isNotBlank((String)str)) {
                date = sdf.parse(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Boolean isValidLongDate(String str) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setLenient(false);
        try {
            if (StringUtils.isNotBlank((String)str)) {
                date = sdf.parse(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Boolean isValidShortDate(String str) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setLenient(false);
        try {
            if (StringUtils.isNotBlank((String)str)) {
                date = sdf.parse(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Date stringToShortDate(String str) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (StringUtils.isNotBlank((String)str)) {
                date = sdf.parse(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String dateLongToString(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    public static String dateShortToString(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    public static String dateShortToString(Date date, boolean flag) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    public static String getDateFromLongDate(Date date) {
        return AtsDateUtils.getDateFromLongString(AtsDateUtils.dateLongToString(date));
    }

    public static String dateShortFormatToString(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    public static String dateShortFormatToStr(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    public static Date dateShortFormatToDate(Date date) {
        Date value = null;
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            dateStr = sdf.format(date);
            value = sdf.parse(dateStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String dateLongFormatToString(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateStr;
    }

    public static Timestamp dateToTimestamp(Date date) {
        Timestamp ts = new Timestamp(date.getTime());
        return ts;
    }

    public static Date timestampToDate(Timestamp temTimestamp) {
        Date date = new Date();
        try {
            date = temTimestamp;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Timestamp getOneDayLastTime(Date date) {
        if (date == null) {
            return null;
        }
        return AtsDateUtils.dateToTimestamp(AtsDateUtils.getOneDayLastDate(date));
    }

    public static Date getOneDayLastDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Timestamp getSomeMinuteTimestamp(Timestamp value, int minute) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.add(12, minute);
        return new Timestamp(cal.getTime().getTime());
    }

    public static Date getNextDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        date = calendar.getTime();
        return date;
    }

    public static Date getNextDay(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        date = calendar.getTime();
        return date;
    }

    public static String getNextDay(String date) {
        Date freDate = AtsDateUtils.stringToShortDate(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(freDate);
        calendar.add(5, 1);
        Date afterdate = calendar.getTime();
        return AtsDateUtils.dateShortToString(afterdate);
    }

    public static String getNextDay(String date, int n) {
        Date freDate = AtsDateUtils.stringToShortDate(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(freDate);
        calendar.add(5, n);
        Date afterdate = calendar.getTime();
        return AtsDateUtils.dateShortToString(afterdate);
    }

    public static String getNextSomeDay(String date, int n) {
        Date freDate = AtsDateUtils.stringToShortDate(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(freDate);
        calendar.add(5, n);
        Date afterdate = calendar.getTime();
        return AtsDateUtils.dateShortToString(afterdate);
    }

    public static Date getPreDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        return date;
    }

    public static Date getPreDay(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -n);
        date = calendar.getTime();
        return date;
    }

    public static String getPreDay(String date, int n) {
        Date preDate = AtsDateUtils.stringToShortDate(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(preDate);
        calendar.add(5, -n);
        Date predate = calendar.getTime();
        return AtsDateUtils.dateShortToString(predate);
    }

    public static String getPreDay(String date) {
        Date preDate = AtsDateUtils.stringToShortDate(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(preDate);
        calendar.add(5, -1);
        Date predate = calendar.getTime();
        return AtsDateUtils.dateShortToString(predate);
    }

    public static String getPreAnyHour(String date, int n) {
        Date preDate = AtsDateUtils.stringToLongDate(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(preDate);
        calendar.add(11, -n);
        Date predate = calendar.getTime();
        return AtsDateUtils.dateLongToString(predate);
    }

    public static String getPreAnyHour(String date, double n) {
        Date preDate = AtsDateUtils.stringToLongDate(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(preDate);
        calendar.setTimeInMillis(calendar.getTimeInMillis() - BigDecimal.valueOf(n * 60.0 * 60.0 * 1000.0).setScale(2, 4).longValue());
        Date predate = calendar.getTime();
        return AtsDateUtils.dateLongToString(predate);
    }

    public static String getNextAnyHour(String date, int n) {
        Date preDate = AtsDateUtils.stringToLongDate(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(preDate);
        calendar.add(11, n);
        Date predate = calendar.getTime();
        return AtsDateUtils.dateLongToString(predate);
    }

    public static String getNextAnyHour(String date, double n) {
        Date preDate = AtsDateUtils.stringToLongDate(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(preDate);
        calendar.setTimeInMillis(calendar.getTimeInMillis() + BigDecimal.valueOf(n * 60.0 * 60.0 * 1000.0).setScale(2, 4).longValue());
        Date predate = calendar.getTime();
        return AtsDateUtils.dateLongToString(predate);
    }

    public static String getFullTime(String time) {
        if (StringUtils.isBlank((String)time)) {
            return "";
        }
        String resTime = time;
        String[] array = time.split(TIME_COLON);
        String pattern = "00";
        DecimalFormat df = new DecimalFormat(pattern);
        int array0 = Integer.parseInt(array[0]);
        String arrayFirst = df.format(array0);
        if (array.length == 3) {
            int arrayZero = Integer.parseInt(array[0]);
            String first = df.format(arrayZero);
            int arrayOne = Integer.parseInt(array[1]);
            String second = df.format(arrayOne);
            int arrayTwo = Integer.parseInt(array[2]);
            String three = df.format(arrayTwo);
            resTime = first + TIME_COLON + second + TIME_COLON + three;
        }
        if (array.length == 2) {
            int array1 = Integer.parseInt(array[1]);
            String arraySecond = df.format(array1);
            resTime = arrayFirst + TIME_COLON + arraySecond + TIME_COLON_SUFF;
        }
        if (array.length == 1) {
            resTime = arrayFirst + ":00:00";
        }
        return resTime;
    }

    public static double getTwoTimeDiffMinutes(String timeStart, String timeEnd) {
        double res = 0.0;
        if (StringUtils.isBlank((String)timeStart) || StringUtils.isBlank((String)timeEnd)) {
            res = 0.0;
        } else {
            timeStart = timeStart.subSequence(0, 16) + TIME_COLON_SUFF;
            timeEnd = timeEnd.subSequence(0, 16) + TIME_COLON_SUFF;
            Date beginDate = AtsDateUtils.stringToLongDate(timeStart);
            Date endDate = AtsDateUtils.stringToLongDate(timeEnd);
            long value = endDate.getTime() - beginDate.getTime();
            res = AtsDateUtils.longToMinute(value);
        }
        return res;
    }

    public static double getTwoTimeDiffMinutes(Date timeStart, Date timeEnd) {
        double res = 0.0;
        if (timeStart == null || timeEnd == null) {
            res = 0.0;
        } else {
            long value = timeEnd.getTime() - timeStart.getTime();
            res = AtsDateUtils.longToMinute(value);
        }
        return res;
    }

    public static double getTwoTimeDiffMinutes(Timestamp timeStart, Timestamp timeEnd) {
        double res = 0.0;
        if (timeStart == null || timeEnd == null) {
            res = 0.0;
        } else {
            long value = timeEnd.getTime() - timeStart.getTime();
            res = AtsDateUtils.longToMinute(value);
        }
        return res;
    }

    public static double getTwoTimeDiffMinutesabs(String timeStart, String timeEnd) {
        double res = 0.0;
        if (StringUtils.isBlank((String)timeStart) || StringUtils.isBlank((String)timeEnd)) {
            res = 0.0;
        } else {
            Date beginDate = AtsDateUtils.stringToLongDate(timeStart);
            Date endDate = AtsDateUtils.stringToLongDate(timeEnd);
            long value = endDate.getTime() - beginDate.getTime();
            res = AtsDateUtils.longToMinute(value);
            res = Math.abs(res);
        }
        return res;
    }

    public static double getTwoTimeDiffHours(String timeStart, String timeEnd) {
        double res = 0.0;
        if (StringUtils.isBlank((String)timeStart) || StringUtils.isBlank((String)timeEnd)) {
            res = 0.0;
        } else {
            Date beginDate = AtsDateUtils.stringToLongDate(timeStart);
            Date endDate = AtsDateUtils.stringToLongDate(timeEnd);
            long value = endDate.getTime() - beginDate.getTime();
            res = AtsDateUtils.longToHours(value);
        }
        return res;
    }

    public static double longToMinute(Long l) {
        double minute = AtsDateUtils.divide(l.doubleValue(), 1000.0, 10);
        minute = AtsDateUtils.divide(minute, 60.0, 10);
        minute = BigDecimal.valueOf(minute).setScale(2, 4).doubleValue();
        return minute;
    }

    public static double longToHours(Long l) {
        double minute = AtsDateUtils.divide(l.doubleValue(), 1000.0, 10);
        minute = AtsDateUtils.divide(minute, 60.0, 10);
        minute = AtsDateUtils.divide(minute, 60.0, 10);
        minute = BigDecimal.valueOf(minute).setScale(2, 4).doubleValue();
        return minute;
    }

    public static double longToMinute(Long l, int scale) {
        double minute = AtsDateUtils.divide(l.doubleValue(), 60000.0, scale, 4);
        return minute;
    }

    public static double longToHours(Long l, int scale) {
        double minute = AtsDateUtils.divide(l.doubleValue(), 3600000.0, scale, 4);
        return minute;
    }

    public static double divide(double v1, double v2, int scale) {
        return AtsDateUtils.divide(v1, v2, scale, 6);
    }

    public static double divide(double v1, double v2, int scale, int round_mode) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, round_mode).doubleValue();
    }

    public static BigDecimal divide(BigDecimal v1, BigDecimal v2, int scale) {
        return AtsDateUtils.divideBigdecimal(v1, v2, scale, 4);
    }

    public static BigDecimal divideBigdecimal(BigDecimal v1, BigDecimal v2, int scale, int round_mode) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = v1;
        BigDecimal b2 = v2;
        return b1.divide(b2, scale, round_mode);
    }

    public static BigDecimal getBigDecimal(Object value) {
        BigDecimal ret = null;
        if (value != null) {
            if (value instanceof BigDecimal) {
                ret = (BigDecimal)value;
            } else if (value instanceof String) {
                ret = new BigDecimal((String)value);
            } else if (value instanceof Integer) {
                ret = new BigDecimal((Integer)value);
            } else if (value instanceof Number) {
                ret = BigDecimal.valueOf(((Number)value).doubleValue());
            } else {
                throw new ClassCastException("Not possible to coerce [" + value + "] from class " + value.getClass() + " into a BigDecimal.");
            }
        }
        return ret;
    }

    public static BigDecimal getMaxValue(BigDecimal b1, BigDecimal b2) {
        BigDecimal maxDecimal = BigDecimal.valueOf(0L);
        maxDecimal = b1.doubleValue() > b2.doubleValue() ? b1 : b2;
        return maxDecimal;
    }

    public static Date dateAdd(Date date, int type, int add) {
        Calendar calendar = Calendar.getInstance();
        if (date == null) {
            date = new Date();
        }
        calendar.setTime(date);
        int oldYear = calendar.get(1);
        int oldMonth = calendar.get(2);
        int oldDay = calendar.get(5);
        Calendar sampleCalendar = Calendar.getInstance();
        if (1 == type) {
            calendar.add(1, add);
            calendar.set(5, calendar.getActualMaximum(5));
        } else if (2 == type) {
            calendar.add(2, add);
        } else if (3 == type) {
            calendar.add(5, add);
        } else if (10 == type) {
            calendar.add(10, add);
        } else if (12 == type) {
            calendar.add(12, add);
        } else if (13 == type) {
            calendar.add(13, add);
        }
        return calendar.getTime();
    }

    public static Date dateAdd(Date date, int type, int add, boolean flag) {
        Calendar calendar = Calendar.getInstance();
        if (date == null) {
            date = new Date();
        }
        calendar.setTime(date);
        int oldYear = calendar.get(1);
        int oldMonth = calendar.get(2);
        int oldDay = calendar.get(5);
        int maxOldDay = calendar.getActualMaximum(5);
        Calendar sampleCalendar = Calendar.getInstance();
        if (1 == type) {
            sampleCalendar.set(1, oldYear += add);
            sampleCalendar.set(5, 1);
            sampleCalendar.set(2, oldMonth);
            int maxNewDay = sampleCalendar.getActualMaximum(5);
            if (oldDay > maxNewDay) {
                oldDay = maxNewDay;
            }
        } else if (2 == type) {
            if ((oldMonth += add) > 11) {
                ++oldYear;
                oldMonth -= 12;
            }
            sampleCalendar.set(1, oldYear);
            sampleCalendar.set(5, 1);
            sampleCalendar.set(2, oldMonth);
            int maxNewDay = sampleCalendar.getActualMaximum(5);
            if (oldDay > maxNewDay || maxOldDay == oldDay) {
                oldDay = maxNewDay;
            }
        } else if (3 == type) {
            oldDay += add;
        }
        if (flag) {
            --oldDay;
        }
        if (oldYear >= 10000) {
            oldYear = 9999;
            oldMonth = 11;
            oldDay = 31;
        }
        calendar.set(oldYear, oldMonth, oldDay);
        return calendar.getTime();
    }

    public static Date getCurrentFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date == null) {
            date = new Date();
        }
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Map<String, Object> generateSDateAndEDateBySeason(int season, String year) {
        HashMap<String, Object> dateMap = new HashMap<String, Object>();
        String startDate = year + "-01-01";
        String endDate = year + "-03-31";
        switch (season) {
            case 2: {
                startDate = year + "-04-01";
                endDate = year + "-06-30";
                break;
            }
            case 3: {
                startDate = year + "-07-01";
                endDate = year + "-09-30";
                break;
            }
            case 4: {
                startDate = year + "-10-01";
                endDate = year + "-12-31";
            }
        }
        dateMap.put("startDate", AtsDateUtils.stringToShortDate(startDate));
        dateMap.put("endDate", AtsDateUtils.stringToShortDate(endDate));
        return dateMap;
    }

    public static int getSeason(Date date) {
        int season = 0;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                season = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                season = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                season = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                season = 4;
                break;
            }
        }
        return season;
    }

    public static int getCurrentYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date == null) {
            date = new Date();
        }
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static Date getCurrentYearFirst() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(2, 0);
        calendar.set(5, 1);
        return AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(calendar.getTime()));
    }

    public static Date getCurrentYearLast() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(2, 11);
        calendar.set(5, calendar.getActualMaximum(5));
        return AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(calendar.getTime()));
    }

    public static long getDaysBetweenTwoDate(String startDate, String endDate) {
        Date date2 = AtsDateUtils.stringToShortDate(endDate);
        Date date1 = AtsDateUtils.stringToShortDate(startDate);
        long days = 0L;
        try {
            long diff = date2.getTime() - date1.getTime();
            days = diff < 0L ? -1L : (diff == 0L ? 0L : diff / 86400000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return days;
    }

    public static long getDaysBetweenTwoDate(Date firstDate, Date secondDate) {
        firstDate = AtsDateUtils.dateShortFormatToDate(firstDate);
        secondDate = AtsDateUtils.dateShortFormatToDate(secondDate);
        if (firstDate == null || secondDate == null) {
            throw new RuntimeException("exist is null val");
        }
        return (firstDate.getTime() - secondDate.getTime()) / 86400000L;
    }

    public static List<String> getDateList(String startDate, String endDate) {
        ArrayList<String> list = new ArrayList<String>();
        long days = AtsDateUtils.getDaysBetweenTwoDate(startDate, endDate);
        if (days > 0L) {
            list.add(startDate);
        }
        if (days == 0L) {
            list.add(startDate);
        }
        int i = 1;
        while ((long)i <= days) {
            String day = AtsDateUtils.getNextSomeDay(startDate, i);
            list.add(day);
            ++i;
        }
        return list;
    }

    public static List getPersonAndDateList(List dateList, String personIds) {
        ArrayList<String> listres = new ArrayList<String>(1000);
        for (Object object : dateList) {
            String[] strArr;
            String date = (String)object;
            String[] stringArray = strArr = personIds.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string;
                String personId = string = stringArray[i];
                personId = personId.substring(1, personId.length() - 1);
                listres.add(personId + UNDERLINE + date);
            }
        }
        return listres;
    }

    public static List getPersonAndDateListCross(List dateList, String personIds) {
        String[] strArr;
        ArrayList<String> listres = new ArrayList<String>(1000);
        String[] stringArray = strArr = personIds.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String personId = string = stringArray[i];
            personId = personId.substring(1, personId.length() - 1);
            for (Object object : dateList) {
                String date = (String)object;
                listres.add(personId + UNDERLINE + date);
            }
        }
        return listres;
    }

    public static List getPersonAndDateListCross(String beginDate, String endDate, String personIds) {
        String[] strArr;
        List<String> dateList = AtsDateUtils.getDateList(beginDate, endDate);
        ArrayList<String> listres = new ArrayList<String>(1000);
        String[] stringArray = strArr = personIds.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String personId = string = stringArray[i];
            personId = personId.substring(1, personId.length() - 1);
            Iterator<String> iterator = dateList.iterator();
            while (iterator.hasNext()) {
                String object;
                String date = object = iterator.next();
                listres.add(personId + UNDERLINE + date);
            }
        }
        return listres;
    }

    public static String getWeekOfDate(Context ctx, Date date) {
        String[] weekDaysName = MLUtile.getRes(AtsOrdinalCommonResEnum.TitleOneToSeven, ctx).split(",");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int intWeek = calendar.get(7) - 1;
        return weekDaysName[intWeek].trim();
    }

    public static String getWeekOfDate(Context ctx, String dateStr) {
        return AtsDateUtils.getWeekOfDate(ctx, AtsDateUtils.stringToShortDate(dateStr));
    }

    public static void main(String[] args) throws ParseException {
        Date date = AtsDateUtils.stringToLongDate("2021-01-31 12:00:00");
        for (int index = -13; index <= 13; ++index) {
            Date next = AtsDateUtils.getMonthsNext(date, index);
            Date pre = AtsDateUtils.getMonthsAgo(date, -index);
            System.out.println("  2021-01-01 12:00:00 " + index + " # " + AtsDateUtils.dateLongToString(pre) + " # " + AtsDateUtils.dateLongToString(next));
        }
        System.out.println(AtsDateUtils.getSeasonLastDay(new Date()));
    }

    public static String tsDateStr(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        if (StringUtils.isEmpty((String)date)) {
            date = sdf.format(new Date());
        }
        if (date.contains("/")) {
            date = date.replace("/", "-");
        }
        return "{ts '" + date.trim().substring(0, 10) + " 00:00:00'}";
    }

    public static String tsDateStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        date = date != null ? date : new Date();
        return "{ts '" + sdf.format(date) + "'}";
    }

    public static String tsFullDateStr(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isEmpty((String)date)) {
            date = sdf.format(new Date());
        }
        if (date.contains("/")) {
            date = date.replace("/", "-");
        }
        return "{ts '" + date.trim().substring(0, 19) + "'}";
    }

    public static String tsFullDateStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        date = date != null ? date : new Date();
        return "{ts '" + sdf.format(date) + "'}";
    }

    public static Date getYearFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return AtsDateUtils.stringToShortDate(AtsDateUtils.dateShortToString(calendar.getTime()));
    }

    public static Date getNextYearsPreDay(Date date, int years, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, years);
        cal.add(5, day);
        Date lastDate = cal.getTime();
        return lastDate;
    }

    public static double getTwoTimeDiffSeconds(String timeStart, String timeEnd) {
        double res = 0.0;
        if (StringUtils.isBlank((String)timeStart) || StringUtils.isBlank((String)timeEnd)) {
            res = 0.0;
        } else {
            timeStart = timeStart.subSequence(0, 16) + TIME_COLON_SUFF;
            timeEnd = timeEnd.subSequence(0, 16) + TIME_COLON_SUFF;
            Date beginDate = AtsDateUtils.stringToLongDate(timeStart);
            Date endDate = AtsDateUtils.stringToLongDate(timeEnd);
            long value = endDate.getTime() - beginDate.getTime();
            res = AtsDateUtils.divide(value, 1000.0, 10);
        }
        return res;
    }

    public static Integer getTwoDateDiffMonth(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return null;
        }
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(startDate);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endDate);
        int startYear = startCalendar.get(1);
        int endYear = endCalendar.get(1);
        int startMonth = startCalendar.get(2);
        int endMonth = endCalendar.get(2);
        int monthNum = (endYear - startYear) * 12 + (endMonth - startMonth) + 1;
        return monthNum;
    }

    public static Integer getTwoDateDiffSeason(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return null;
        }
        int startSeason = AtsDateUtils.getSeason(startDate);
        int endSeason = AtsDateUtils.getSeason(endDate);
        return endSeason - startSeason;
    }

    public static Date getSeasonLastDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int season = AtsDateUtils.getSeason(date);
        Map<String, Object> data = AtsDateUtils.generateSDateAndEDateBySeason(season, String.valueOf(calendar.get(1)));
        return (Date)data.get("endDate");
    }

    public static String dateFilter(String str) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (StringUtils.isNotBlank((String)str)) {
                date = sdf.parse(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String res = AtsDateUtils.dateShortToString(date);
        return res;
    }

    public static Date getMonthLastDay(String endDate) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(endDate.substring(0, 4)));
        cal.set(2, Integer.parseInt(endDate.substring(5, 7)) - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        return cal.getTime();
    }

    public static boolean isValidShortDate(Object date) {
        boolean valid = true;
        if (date.equals("")) {
            valid = false;
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sdf.setLenient(false);
            try {
                if (date instanceof Date) {
                    sdf.format((Date)date);
                } else {
                    String temp = (String)date;
                    if (temp.indexOf("/") != -1) {
                        temp = temp.replaceAll("/", "-");
                    }
                    sdf.parse(temp);
                }
            }
            catch (Exception e) {
                valid = false;
                e.printStackTrace();
            }
        }
        return valid;
    }
}

