/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.hr.ats.DataTypeEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class AtsDbUtil {
    private static Logger logger = Logger.getLogger(AtsDbUtil.class);
    private static int BATCH_COUNT = 500;

    public static void addTableColumn(String tableName, String columnName, DataTypeEnum dataType, Context ctx) throws BOSException {
        String dataTypeStr = null;
        switch (dataType.getValue()) {
            case 2: {
                dataTypeStr = " NUMERIC(21,8) ";
                break;
            }
            case 3: {
                dataTypeStr = " nvarchar(100)";
                break;
            }
            case 4: {
                dataTypeStr = " INT ";
                break;
            }
            case 5: {
                dataTypeStr = " DateTime ";
                break;
            }
            default: {
                dataTypeStr = "  INT";
            }
        }
        StringBuffer ddl = new StringBuffer();
        ddl.append("IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE ");
        ddl.append(" KSQL_COL_TABNAME ='" + tableName + "' ");
        ddl.append(" AND KSQL_COL_NAME = '" + columnName + "')");
        ddl.append(" alter table " + tableName);
        ddl.append(" add " + columnName + " " + dataTypeStr);
        DbUtil.execute((Context)ctx, (String)ddl.toString());
    }

    public static void dropTableColumn(String tableName, String columnName, Context ctx) throws BOSException {
        StringBuffer del = new StringBuffer();
        del.append("IF EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE ");
        del.append(" KSQL_COL_TABNAME ='" + tableName + "' ");
        del.append(" AND KSQL_COL_NAME = '" + columnName + "')");
        del.append(" UPDATE " + tableName);
        del.append(" SET " + columnName + " = null");
        DbUtil.execute((Context)ctx, (String)del.toString());
        StringBuffer ddl = new StringBuffer();
        ddl.append("IF EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE ");
        ddl.append(" KSQL_COL_TABNAME ='" + tableName + "' ");
        ddl.append(" AND KSQL_COL_NAME = '" + columnName + "')");
        ddl.append(" alter table " + tableName);
        ddl.append(" drop column " + columnName);
        DbUtil.execute((Context)ctx, (String)ddl.toString());
    }

    public static Object[] executeBatch(Context ctx, int totalCount, int batchCount, String[] templateSQLArr, Object[] paramsTemplateArr) throws BOSException {
        long startTime = System.currentTimeMillis();
        Object[] result = new Object[]{0, ""};
        StringBuilder errorMsg = new StringBuilder();
        int successCount = 0;
        int page = 0;
        page = totalCount % batchCount == 0 ? totalCount / batchCount : totalCount / batchCount + 1;
        for (int i = 0; i < page; ++i) {
            logger.error((Object)("executebatchsql start ---------------page" + i));
            int startNum = i * batchCount;
            int endNum = i * batchCount + batchCount;
            if (i == page - 1) {
                startNum = i * batchCount;
                endNum = totalCount;
            }
            long startTimePage = System.currentTimeMillis();
            Object[] paramsList = new Object[templateSQLArr.length];
            for (int sqlIndex = 0; sqlIndex < templateSQLArr.length; ++sqlIndex) {
                paramsList[sqlIndex] = ((List)paramsTemplateArr[sqlIndex]).subList(startNum, endNum);
            }
            try {
                Object[] batchResult = AtsDbUtil.executeBatchAndReturn(ctx, templateSQLArr, paramsList);
                successCount += ((Integer)batchResult[0]).intValue();
                errorMsg.append(batchResult[1].toString());
            }
            catch (BOSException e1) {
                e1.printStackTrace();
                successCount += 0;
            }
            logger.error((Object)("executebatchsql page cost: " + (System.currentTimeMillis() - startTimePage)));
        }
        result[0] = successCount;
        result[1] = errorMsg;
        logger.error((Object)("executebatchsql all cost: " + (System.currentTimeMillis() - startTime)));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] executeBatchAndReturn(Context ctx, String[] sqlArr, Object[] paramsArr) throws BOSException {
        Object[] result = new Object[]{0, ""};
        Connection conn = null;
        PreparedStatement ps = null;
        List paramsList = null;
        String sql = null;
        StringBuffer errorMsg = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            conn.setAutoCommit(false);
            for (int sqlIndex = 0; sqlIndex < sqlArr.length; ++sqlIndex) {
                sql = sqlArr[sqlIndex];
                paramsList = (List)paramsArr[sqlIndex];
                ps = conn.prepareStatement(sql);
                Object[] params = null;
                for (int i = 0; i < paramsList.size(); ++i) {
                    params = (Object[])paramsList.get(i);
                    for (int j = 0; j < params.length; ++j) {
                        if (params[j] != null) {
                            ps.setObject(j + 1, params[j]);
                            continue;
                        }
                        ps.setNull(j + 1, 12);
                    }
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            conn.commit();
        }
        catch (Exception exc) {
            try {
                conn.rollback();
                StringBuffer sb = new StringBuffer();
                if (null != paramsList) {
                    int size = paramsList.size();
                    for (int i = 0; i < size; ++i) {
                        Object[] params;
                        if (i > 0) {
                            sb.append(";");
                        }
                        if (null == (params = (Object[])paramsList.get(i))) continue;
                        for (int k = 0; k < params.length; ++k) {
                            if (k > 0) {
                                sb.append(",");
                            }
                            sb.append(params[k]);
                        }
                    }
                }
                logger.error((Object)("executeBatchAndReturn errorSQL rollback: " + (null == sql ? "" : sql) + ",paramsList: " + sb.toString()));
                errorMsg.append("execute sql error: " + (null == sql ? "" : sql) + ",paramsList: " + sb.toString());
                paramsList = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)conn);
        }
        int successCount = 0;
        if (null != paramsList) {
            successCount = paramsList.size();
        }
        result[0] = successCount;
        result[1] = errorMsg;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(Context ctx, String sql) {
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        int successCount = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            successCount = statement.executeUpdate(sql);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
        }
        return successCount;
    }

    public static int getBatchCount() {
        return BATCH_COUNT;
    }
}

