/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public abstract class AtsManageLoggerUtil {
    public static final String PUNCHCARD_PATH = "shr_ats_punchcard_log";
    public static final String PUNCHCARD_FILE = "getkdcloudpunchcard";
    public static final Map<String, Logger> LOG_CACHE = new ConcurrentHashMap<String, Logger>(2);

    public static Logger getLogger(String filePath, String fileName) {
        Logger logger = LOG_CACHE.get(filePath);
        if (logger != null) {
            return logger;
        }
        logger = Logger.getLogger((String)filePath);
        LOG_CACHE.put(filePath, logger);
        logger.removeAllAppenders();
        logger.setLevel(Level.OFF);
        logger.setAdditivity(true);
        RollingFileAppender appender = new RollingFileAppender();
        PatternLayout layout = new PatternLayout();
        String conversionPattern = "%d{yyyy-MM-dd HH:mm:ss} [%5p] -%F(%L) -%m%n";
        layout.setConversionPattern(conversionPattern);
        appender.setLayout((Layout)layout);
        String sysPath = System.getProperty("EAS_HOME") + "/server/shr_ats_log/" + filePath;
        appender.setFile(sysPath + "/" + fileName + ".log");
        appender.setEncoding("UTF-8");
        appender.setAppend(true);
        appender.activateOptions();
        appender.setMaxBackupIndex(10);
        appender.setMaxFileSize("10MB");
        logger.addAppender((Appender)appender);
        return logger;
    }
}

