/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.IDecimalPlaceStrategy;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationSystem;
import com.kingdee.eas.hr.ats.log4j.AtsLogger;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.CardRuleResult;
import com.kingdee.eas.hr.ats.util.CardRuleResultInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CardRuleServer {
    AtsLogger logger = AtsLogger.getLogger();
    private IDecimalPlaceStrategy decimalPlacesSystem = new DecimalPlaceOperationSystem();
    boolean sqlOutOn = false;
    public String GMTDate = "1970-01-01";
    public String baseDate = "1990-01-01";
    public String basePreDate = "1989-12-31";
    public String baseNextDate = "1990-01-02";
    public String split = " ";
    public String timeInterval = "2";
    public String compareInterval = this.GMTDate + this.split + "00:02:00";
    public long timeIntervalMillisecond = new BigDecimal(this.timeInterval).longValue() * 60L * 1000L;
    public int segOneAssignType = 2;
    public int segOneAssignValue = 1;
    public int segTwoAssignType = 2;
    public int segTwoAssignValue = 4;
    public String firstOnTime = "09:00:00";
    public String firstOffTime = "12:00:00";
    public String secondOnTime = "13:00:00";
    public String secondOffTime = "17:00:00";
    public String thirdOnTime = "19:00:00";
    public String thirdOffTime = "22:00:00";
    public String firstOnworkTime = this.baseDate + this.split + this.firstOnTime;
    public String firstOffworkTime = this.baseDate + this.split + this.firstOffTime;
    public String secondOnworkTime = this.baseDate + this.split + this.secondOnTime;
    public String secondOffworkTime = this.baseDate + this.split + this.secondOffTime;
    public String thirdOnworkTime = this.baseDate + this.split + this.thirdOnTime;
    public String thirdOffworkTime = this.baseDate + this.split + this.thirdOffTime;

    public CardRuleServer() {
        if (this.decimalPlacesSystem == null) {
            this.decimalPlacesSystem = new DecimalPlaceOperationSystem();
        }
    }

    public List<CardRuleResultInfo> getPunchCardInfoTwo(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap) {
        String mixDate;
        CardRuleResultInfo info;
        if (shiftInfo != null) {
            this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOnTime");
            this.firstOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOffTime");
            this.secondOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("secondOnTime");
            this.secondOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("secondOffTime");
            this.firstOnworkTime = this.baseDate + this.split + this.firstOnTime;
            this.firstOffworkTime = this.baseDate + this.split + this.firstOffTime;
            this.secondOnworkTime = this.baseDate + this.split + this.secondOnTime;
            this.secondOffworkTime = this.baseDate + this.split + this.secondOffTime;
        }
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegFirAssignType() != null) {
                this.segOneAssignType = cardRuleInfo.getSegFirAssignType().getValue();
            }
            if (cardRuleInfo.getSegFirAssignSegment() != null) {
                this.segOneAssignValue = cardRuleInfo.getSegFirAssignSegment().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> getCardList = new ArrayList<CardRuleResultInfo>();
        int oneoffIsPunchCard = 1;
        int twoonIsPunchCard = 1;
        String preTime = "";
        String nextTime = "";
        if (shiftInfo != null && shiftInfo.getItems().size() == 2) {
            for (int i = 0; i < shiftInfo.getItems().size(); ++i) {
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) == 1) {
                    oneoffIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getNextIsPunchCard().getValue());
                }
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) != 2) continue;
                twoonIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getPreIsPunchCard().getValue());
            }
        }
        String shiftTime_Oneoff = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOffTime");
        String shiftTime_Twoon = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("secondOnTime");
        shiftTime_Oneoff = currentDate + this.split + shiftTime_Oneoff;
        shiftTime_Twoon = currentDate + this.split + shiftTime_Twoon;
        ArrayList segIntervalList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)list.get(i));
            String compareDate = this.baseDate + this.split + date_suffix;
            Date resDate = AtsDateUtils.stringToLongDate(compareDate);
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(this.firstOffworkTime);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(this.secondOnworkTime);
            if (resDate.getTime() < shiftFirstOffDate.getTime() || resDate.getTime() > shiftSecondOnDate.getTime()) continue;
            segIntervalList.add(list.get(i));
        }
        List segIntervalEffectiveList = this.getEffectivePunchData(segIntervalList);
        if (this.sqlOutOn) {
            this.logger.info("seg_2_effective_card_collection\uff1a" + segIntervalEffectiveList.size());
        }
        if (segIntervalEffectiveList.size() >= 2) {
            info = new CardRuleResultInfo();
            mixDate = this.getMinData(segIntervalEffectiveList);
            String maxDate = this.getMaxData(segIntervalEffectiveList);
            info.setOneOffWorkTime(mixDate);
            info.setTwoOnWorkTime(maxDate);
            getCardList.add(info);
        }
        if (segIntervalEffectiveList.size() == 1) {
            if (this.segOneAssignType == 1) {
                if (this.segOneAssignValue == 1) {
                    info = new CardRuleResultInfo();
                    mixDate = (String)segIntervalEffectiveList.get(0);
                    info.setOneOffWorkTime(mixDate);
                    getCardList.add(info);
                } else if (this.segOneAssignValue == 2) {
                    info = new CardRuleResultInfo();
                    mixDate = (String)segIntervalEffectiveList.get(0);
                    info.setTwoOnWorkTime(mixDate);
                    getCardList.add(info);
                }
            }
            if (this.segOneAssignType == 2) {
                CardRuleResultInfo info2;
                String interDatasString = (String)segIntervalEffectiveList.get(0);
                int res = this.getIntervalTimeWichNearly(this.firstOffworkTime, this.secondOnworkTime, interDatasString);
                if (res == 1) {
                    info2 = new CardRuleResultInfo();
                    info2.setOneOffWorkTime(interDatasString);
                    getCardList.add(info2);
                } else if (res == 2) {
                    info2 = new CardRuleResultInfo();
                    info2.setTwoOnWorkTime(interDatasString);
                    getCardList.add(info2);
                } else if (res == 3) {
                    info2 = new CardRuleResultInfo();
                    info2.setOneOffWorkTime(interDatasString);
                    getCardList.add(info2);
                }
            }
        }
        if (segIntervalEffectiveList.size() == 0) {
            // empty if block
        }
        boolean isFreeCardCal = this.isFreeCardCalForTwo(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap, segIntervalEffectiveList, getCardList, oneoffIsPunchCard, twoonIsPunchCard);
        if (oneoffIsPunchCard == 0 && twoonIsPunchCard == 1 && !isFreeCardCal) {
            if (getCardList.size() > 0) {
                ((CardRuleResultInfo)getCardList.get(0)).setOneOffWorkTime(shiftTime_Oneoff);
            }
            if (getCardList.size() == 0) {
                CardRuleResultInfo info3 = new CardRuleResultInfo();
                info3.setOneOffWorkTime(shiftTime_Oneoff);
                getCardList.add(info3);
            }
        }
        if (oneoffIsPunchCard == 1 && twoonIsPunchCard == 0 && !isFreeCardCal) {
            if (getCardList.size() > 0) {
                ((CardRuleResultInfo)getCardList.get(0)).setTwoOnWorkTime(shiftTime_Twoon);
            }
            if (getCardList.size() == 0) {
                CardRuleResultInfo info4 = new CardRuleResultInfo();
                info4.setTwoOnWorkTime(shiftTime_Twoon);
                getCardList.add(info4);
            }
        }
        if (oneoffIsPunchCard == 0 && twoonIsPunchCard == 0 && !isFreeCardCal) {
            if (getCardList.size() > 0) {
                ((CardRuleResultInfo)getCardList.get(0)).setOneOffWorkTime(shiftTime_Oneoff);
                ((CardRuleResultInfo)getCardList.get(0)).setTwoOnWorkTime(shiftTime_Twoon);
            }
            if (getCardList.size() == 0) {
                CardRuleResultInfo info5 = new CardRuleResultInfo();
                info5.setOneOffWorkTime(shiftTime_Oneoff);
                info5.setTwoOnWorkTime(shiftTime_Twoon);
                getCardList.add(info5);
            }
        }
        return getCardList;
    }

    public List getTwoShiftPunchCardData(List list, String onWorkTime, String offWorkTime) {
        ArrayList IntervalList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)list.get(i));
            String compareDate = this.baseDate + this.split + date_suffix;
            Date resDate = AtsDateUtils.stringToLongDate(compareDate);
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(onWorkTime);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(offWorkTime);
            if (resDate.getTime() <= shiftFirstOffDate.getTime() || resDate.getTime() >= shiftSecondOnDate.getTime()) continue;
            IntervalList.add(list.get(i));
        }
        return IntervalList;
    }

    public List getTwoShiftEffectivePunchCardData(List list, String onWorkTime, String offWorkTime) {
        ArrayList Interval_List = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)list.get(i));
            String compareDate = this.baseDate + this.split + date_suffix;
            Date resDate = AtsDateUtils.stringToLongDate(compareDate);
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(onWorkTime);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(offWorkTime);
            if (resDate.getTime() <= shiftFirstOffDate.getTime() || resDate.getTime() >= shiftSecondOnDate.getTime()) continue;
            Interval_List.add(list.get(i));
        }
        List IntervalEffective_List = this.getEffectivePunchData(Interval_List);
        return IntervalEffective_List;
    }

    public String getTwoShiftEffectivePunchCardMinData(List list, String onWorkTime, String offWorkTime) {
        ArrayList Interval_List = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)list.get(i));
            String compareDate = this.baseDate + this.split + date_suffix;
            Date resDate = AtsDateUtils.stringToLongDate(compareDate);
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(onWorkTime);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(offWorkTime);
            if (resDate.getTime() <= shiftFirstOffDate.getTime() || resDate.getTime() >= shiftSecondOnDate.getTime()) continue;
            Interval_List.add(list.get(i));
        }
        String minResultDate = "";
        List IntervalEffective_List = this.getEffectivePunchData(Interval_List);
        minResultDate = this.getMinData(IntervalEffective_List);
        return minResultDate;
    }

    public String getTwoShiftEffectivePunchCardMinDataContainShift(List list, String onWorkTime, String offWorkTime) {
        ArrayList Interval_List = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)list.get(i));
            String compareDate = this.baseDate + this.split + date_suffix;
            Date resDate = AtsDateUtils.stringToLongDate(compareDate);
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(onWorkTime);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(offWorkTime);
            if (resDate.getTime() < shiftFirstOffDate.getTime() || resDate.getTime() > shiftSecondOnDate.getTime()) continue;
            Interval_List.add(list.get(i));
        }
        String minResultDate = "";
        List IntervalEffective_List = this.getEffectivePunchData(Interval_List);
        minResultDate = this.getMinData(IntervalEffective_List);
        return minResultDate;
    }

    public String getTwoShiftEffectivePunchCardMaxData(List list, String onWorkTime, String offWorkTime) {
        ArrayList Interval_List = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)list.get(i));
            String compareDate = this.baseDate + this.split + date_suffix;
            Date resDate = AtsDateUtils.stringToLongDate(compareDate);
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(onWorkTime);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(offWorkTime);
            if (resDate.getTime() <= shiftFirstOffDate.getTime() || resDate.getTime() >= shiftSecondOnDate.getTime()) continue;
            Interval_List.add(list.get(i));
        }
        String maxResultDate = "";
        List IntervalEffective_List = this.getEffectivePunchData(Interval_List);
        maxResultDate = this.getMaxData(IntervalEffective_List);
        return maxResultDate;
    }

    public String getTwoShiftEffectivePunchCardMaxDataContainShift(List list, String onWorkTime, String offWorkTime) {
        ArrayList Interval_List = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)list.get(i));
            String compareDate = this.baseDate + this.split + date_suffix;
            Date resDate = AtsDateUtils.stringToLongDate(compareDate);
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(onWorkTime);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(offWorkTime);
            if (resDate.getTime() < shiftFirstOffDate.getTime() || resDate.getTime() > shiftSecondOnDate.getTime()) continue;
            Interval_List.add(list.get(i));
        }
        String maxResultDate = "";
        List IntervalEffective_List = this.getEffectivePunchData(Interval_List);
        maxResultDate = this.getMaxData(IntervalEffective_List);
        return maxResultDate;
    }

    public List getCurrentPunchCardDataOrNextPunchCardData(List list, Map<String, Object> map, String currentDate) {
        ArrayList middleList = new ArrayList();
        if (AtsDateUtils.stringShortToTimestamp(AtsDateUtils.getDateFromLongString((String)map.get("endTime"))).getTime() <= AtsDateUtils.stringShortToTimestamp(AtsDateUtils.getDateFromLongString((String)map.get("startTime"))).getTime()) {
            for (int i = 0; i < list.size(); ++i) {
                String comStrDate = AtsDateUtils.getDateFromLongString((String)list.get(i));
                if (AtsDateUtils.stringToShortDate(currentDate).getTime() != AtsDateUtils.stringToShortDate(comStrDate).getTime()) continue;
                middleList.add(list.get(i));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                middleList.add(list.get(i));
            }
        }
        return middleList;
    }

    public List<CardRuleResultInfo> getHeadCardDataInfoByOverTime(AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap, Map<Object, Object> globalMap) {
        String mixDate;
        if (shiftInfo != null) {
            this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 1).get("firstOnTime");
        }
        BigDecimal startBigDecimalOne = new BigDecimal("2.00");
        BigDecimal endBigDecimalOne = new BigDecimal("2.00");
        BigDecimal startBigDecimalTwo = new BigDecimal("3.00");
        BigDecimal endBigDecimalTwo = new BigDecimal("3.00");
        int headOneFetchCardType = 1;
        int headTwoFetchCardType = 1;
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegBefFirStartNum() != null) {
                startBigDecimalOne = cardRuleInfo.getSegBefFirStartNum();
            }
            if (cardRuleInfo.getSegBefFirEndNum() != null) {
                endBigDecimalOne = cardRuleInfo.getSegBefFirEndNum();
            }
            if (cardRuleInfo.getSegBefFirtakeCardType() != null) {
                headOneFetchCardType = cardRuleInfo.getSegBefFirtakeCardType().getValue();
            }
            if (cardRuleInfo.getSegBefSecStartNum() != null) {
                startBigDecimalTwo = cardRuleInfo.getSegBefSecStartNum();
            }
            if (cardRuleInfo.getSegBefSecEndNum() != null) {
                endBigDecimalTwo = cardRuleInfo.getSegBefSecEndNum();
            }
            if (cardRuleInfo.getSegBefSectakeCardType() != null) {
                headTwoFetchCardType = cardRuleInfo.getSegBefSectakeCardType().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> headCardListone = new ArrayList<CardRuleResultInfo>();
        ArrayList headList = new ArrayList();
        Timestamp startTime = (Timestamp)globalMap.get("startTime");
        Timestamp endTime = (Timestamp)globalMap.get("endTime");
        String beginTimestr = AtsDateUtils.getPreAnyHour(AtsDateUtils.timestampToString(startTime), startBigDecimalOne.intValue());
        String endTimestr = AtsDateUtils.getNextAnyHour(AtsDateUtils.timestampToString(startTime), endBigDecimalOne.intValue());
        List middleList = list;
        for (int i = 0; i < middleList.size(); ++i) {
            Timestamp compareTimestamp = AtsDateUtils.stringToTimestamp((String)middleList.get(i));
            if (AtsDateUtils.stringToTimestamp(beginTimestr).getTime() > compareTimestamp.getTime() || compareTimestamp.getTime() > AtsDateUtils.stringToTimestamp(endTimestr).getTime()) continue;
            headList.add(middleList.get(i));
        }
        List headEffectiveList = this.getEffectivePunchData(headList);
        CardRuleResultInfo info = new CardRuleResultInfo();
        if (headEffectiveList.size() > 0) {
            mixDate = null;
            String maxDate = null;
            if (headOneFetchCardType == 1) {
                mixDate = this.getMinData(headEffectiveList);
                maxDate = this.getMinData(headEffectiveList);
            } else if (headOneFetchCardType == 2) {
                mixDate = this.getMaxData(headEffectiveList);
                maxDate = this.getMaxData(headEffectiveList);
            }
            info.setOneOnWorkTimeEarliest(mixDate);
            info.setOneOnWorkTimeLatest(maxDate);
        }
        if (headEffectiveList.size() > 0) {
            if (headOneFetchCardType == 1) {
                mixDate = this.getMinData(headEffectiveList);
                info.setOneOnWorkTime(mixDate);
                headCardListone.add(info);
            }
            if (headOneFetchCardType == 2) {
                String maxDate = this.getMaxData(headEffectiveList);
                info.setOneOnWorkTime(maxDate);
                headCardListone.add(info);
            }
        }
        return headCardListone;
    }

    public List<CardRuleResultInfo> getTailCardDataInfoByOverTime(AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap, Map<Object, Object> globalMap) {
        if (shiftInfo != null) {
            this.firstOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 1).get("firstOffTime");
        }
        BigDecimal startBigDecimalOneTail = new BigDecimal("2.00");
        BigDecimal endBigDecimalOneTail = new BigDecimal("2.00");
        int tailOneFetchCardType = 2;
        int tailTwoFetchCardType = 2;
        BigDecimal startBigDecimalTwo = new BigDecimal("3.00");
        BigDecimal endBigDecimalTwo = new BigDecimal("3.00");
        int startSegmentNum = 1;
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getStartSegmentNum() != null) {
                startSegmentNum = cardRuleInfo.getStartSegmentNum().getValue();
            }
            if (cardRuleInfo.getSegAftFirStartNum() != null) {
                startBigDecimalOneTail = cardRuleInfo.getSegAftFirStartNum();
            }
            if (cardRuleInfo.getSegAftFirEndNum() != null) {
                endBigDecimalOneTail = cardRuleInfo.getSegAftFirEndNum();
            }
            if (cardRuleInfo.getSegAftFirtakeCardType() != null) {
                tailOneFetchCardType = cardRuleInfo.getSegAftFirtakeCardType().getValue();
            }
            if (cardRuleInfo.getSegAftSecStartNum() != null) {
                startBigDecimalTwo = cardRuleInfo.getSegAftSecStartNum();
            }
            if (cardRuleInfo.getSegAftSecEndNum() != null) {
                endBigDecimalTwo = cardRuleInfo.getSegAftSecEndNum();
            }
            if (cardRuleInfo.getSegAftSectakeCardType() != null) {
                tailTwoFetchCardType = cardRuleInfo.getSegAftSectakeCardType().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> tailCardList = new ArrayList<CardRuleResultInfo>();
        ArrayList tailList = new ArrayList();
        Timestamp startTime = (Timestamp)globalMap.get("startTime");
        Timestamp endTime = (Timestamp)globalMap.get("endTime");
        String beginTimestr = AtsDateUtils.getPreAnyHour(AtsDateUtils.timestampToString(endTime), startBigDecimalOneTail.intValue());
        String endTimestr = AtsDateUtils.getNextAnyHour(AtsDateUtils.timestampToString(endTime), endBigDecimalOneTail.intValue());
        if (list.size() > 0) {
            String string = AtsDateUtils.getDateFromLongString(this.getMinData(list));
        }
        List middleList = list;
        for (int i = 0; i < middleList.size(); ++i) {
            Timestamp compareTimestamp = AtsDateUtils.stringToTimestamp((String)middleList.get(i));
            if (AtsDateUtils.stringToTimestamp(beginTimestr).getTime() > compareTimestamp.getTime() || compareTimestamp.getTime() > AtsDateUtils.stringToTimestamp(endTimestr).getTime()) continue;
            tailList.add(middleList.get(i));
        }
        List tailEffectiveList = this.getEffectivePunchData(tailList);
        CardRuleResultInfo info = new CardRuleResultInfo();
        if (tailEffectiveList.size() > 0) {
            ArrayList overShiftList = new ArrayList();
            String mixDate = null;
            String maxDate = null;
            if (tailOneFetchCardType == 1) {
                mixDate = this.getMinData(tailEffectiveList);
                maxDate = this.getMinData(tailEffectiveList);
            } else if (tailOneFetchCardType == 2) {
                mixDate = this.getMaxData(tailEffectiveList);
                maxDate = this.getMaxData(tailEffectiveList);
            }
            if (startSegmentNum == 1) {
                info.setOneOffWorkTimeEarliest(mixDate);
                info.setOneOffWorkTimeLatest(maxDate);
            } else if (startSegmentNum == 2) {
                info.setTwoOffWorkTimeEarliest(mixDate);
                info.setTwoOffWorkTimeLatest(maxDate);
            } else if (startSegmentNum == 3) {
                info.setThreeOffWorkTimeEarliest(mixDate);
                info.setThreeOffWorkTimeLatest(maxDate);
            }
        }
        if (tailEffectiveList.size() > 0) {
            if (tailOneFetchCardType == 1) {
                String mixDate = this.getMinData(tailEffectiveList);
                if (startSegmentNum == 1) {
                    info.setOneOffWorkTime(mixDate);
                } else if (startSegmentNum == 2) {
                    info.setTwoOffWorkTime(mixDate);
                } else if (startSegmentNum == 3) {
                    info.setThreeOffWorkTime(mixDate);
                }
                tailCardList.add(info);
            }
            if (tailOneFetchCardType == 2) {
                String maxDate = this.getMaxData(tailEffectiveList);
                if (startSegmentNum == 1) {
                    info.setOneOffWorkTime(maxDate);
                } else if (startSegmentNum == 2) {
                    info.setTwoOffWorkTime(maxDate);
                } else if (startSegmentNum == 3) {
                    info.setThreeOffWorkTime(maxDate);
                }
                tailCardList.add(info);
            }
        }
        return tailCardList;
    }

    public List<CardRuleResultInfo> getHeadCardDataInfoOne(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap) {
        boolean isFreeCardCal;
        String mixDate;
        if (shiftInfo != null) {
            this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 1).get("firstOnTime");
        }
        BigDecimal startBigDecimalOne = new BigDecimal("2.00");
        BigDecimal endBigDecimalOne = new BigDecimal("2.00");
        BigDecimal startBigDecimalTwo = new BigDecimal("3.00");
        BigDecimal endBigDecimalTwo = new BigDecimal("3.00");
        int headOneFetchCardType = 1;
        int headTwoFetchCardType = 1;
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegBefFirStartNum() != null) {
                startBigDecimalOne = cardRuleInfo.getSegBefFirStartNum();
            }
            if (cardRuleInfo.getSegBefFirEndNum() != null) {
                endBigDecimalOne = cardRuleInfo.getSegBefFirEndNum();
            }
            if (cardRuleInfo.getSegBefFirtakeCardType() != null) {
                headOneFetchCardType = cardRuleInfo.getSegBefFirtakeCardType().getValue();
            }
            if (cardRuleInfo.getSegBefSecStartNum() != null) {
                startBigDecimalTwo = cardRuleInfo.getSegBefSecStartNum();
            }
            if (cardRuleInfo.getSegBefSecEndNum() != null) {
                endBigDecimalTwo = cardRuleInfo.getSegBefSecEndNum();
            }
            if (cardRuleInfo.getSegBefSectakeCardType() != null) {
                headTwoFetchCardType = cardRuleInfo.getSegBefSectakeCardType().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> headCardListone = new ArrayList<CardRuleResultInfo>();
        ArrayList headList = new ArrayList();
        BigDecimal oneOnTime = new BigDecimal(AtsDateUtils.getHourFromShiftString(this.firstOnTime));
        Map<String, Object> map = this.getSomeSectionTimeByHoursWithBaseDate(ctx, startBigDecimalOne, endBigDecimalOne, oneOnTime, this.baseDate);
        if (oneOnTime.subtract(startBigDecimalOne).doubleValue() <= 0.0) {
            String startDate_Str = this.baseDate + this.split + this.firstOnTime;
            String startDateStr = AtsDateUtils.getPreAnyHour(startDate_Str, startBigDecimalOne.intValue());
            map.put("startTime", startDateStr);
        }
        if (this.sqlOutOn) {
            this.logger.info("(seg_1_first_expand_start:" + map.get("startTime") + " seg_1_first_expand_start_end" + map.get("endTime"));
        }
        List middleList = this.getCurrentPunchCardDataOrNextPunchCardData(list, map, currentDate);
        for (int i = 0; i < middleList.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)middleList.get(i));
            String compdate = AtsDateUtils.getDateFromLongString((String)middleList.get(i));
            String compare_Date = this.baseDate + this.split + date_suffix;
            if (AtsDateUtils.stringToShortDate(compdate).getTime() > AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                compare_Date = this.baseNextDate + this.split + date_suffix;
            }
            if (AtsDateUtils.stringToShortDate(compdate).getTime() < AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                compare_Date = this.basePreDate + this.split + date_suffix;
            }
            Date compareDate = AtsDateUtils.stringToLongDate(compare_Date);
            Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("startTime"));
            Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("endTime"));
            if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
            headList.add(middleList.get(i));
        }
        List headEffectiveList = this.getEffectivePunchData(headList);
        if (this.sqlOutOn) {
            this.logger.info("seg_1_begin_first_effective_collection" + headEffectiveList.size());
            for (int i = 0; i < headEffectiveList.size(); ++i) {
                this.logger.info("seg_1_first_begin==" + headEffectiveList.get(i));
            }
        }
        CardRuleResultInfo info = new CardRuleResultInfo();
        if (headEffectiveList.size() > 0) {
            mixDate = this.getMinData(headEffectiveList);
            String maxDate = null;
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            if (scheduleShiftHasEntryTag == 1) {
                ArrayList lessShiftList = new ArrayList();
                for (int i = 0; i < headEffectiveList.size(); ++i) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)headEffectiveList.get(i));
                    Date compareValue = AtsDateUtils.stringToLongDate(this.baseDate + this.split + date_suffix);
                    Timestamp innerTimestamp = AtsDateUtils.stringShortToTimestamp(AtsDateUtils.getDateFromLongString((String)headEffectiveList.get(i)));
                    Timestamp currTimestamp = AtsDateUtils.stringShortToTimestamp(currentDate);
                    if (innerTimestamp.getTime() < currTimestamp.getTime()) {
                        compareValue = AtsDateUtils.stringToLongDate(this.basePreDate + this.split + date_suffix);
                    }
                    if (innerTimestamp.getTime() > currTimestamp.getTime()) {
                        compareValue = AtsDateUtils.stringToLongDate(this.baseNextDate + this.split + date_suffix);
                    }
                    Date shiftDateValue = AtsDateUtils.stringToLongDate(this.baseDate + this.split + this.firstOnTime);
                    if (compareValue.getTime() > shiftDateValue.getTime()) continue;
                    lessShiftList.add(headEffectiveList.get(i));
                }
                maxDate = this.getMaxData(lessShiftList);
            } else {
                maxDate = this.getMaxData(headEffectiveList);
            }
            info.setOneOnWorkTimeEarliest(mixDate);
            info.setOneOnWorkTimeLatest(maxDate);
        }
        if (headEffectiveList.size() > 0) {
            if (headOneFetchCardType == 1) {
                mixDate = this.getMinData(headEffectiveList);
                info.setOneOnWorkTime(mixDate);
                headCardListone.add(info);
            }
            if (headOneFetchCardType == 2) {
                String maxDate = this.getMaxData(headEffectiveList);
                info.setOneOnWorkTime(maxDate);
                headCardListone.add(info);
            }
        }
        ArrayList headTwoList = new ArrayList();
        if (headEffectiveList.size() == 0) {
            Map<String, Object> mapTwo = this.getSomeSectionTimeByHoursWithBaseDate(ctx, startBigDecimalTwo, endBigDecimalTwo, oneOnTime, this.baseDate);
            if (oneOnTime.subtract(startBigDecimalTwo).doubleValue() <= 0.0) {
                String startDate_Str = this.baseDate + this.split + this.firstOnTime;
                String startDateStr = AtsDateUtils.getPreAnyHour(startDate_Str, startBigDecimalTwo.intValue());
                mapTwo.put("startTime", startDateStr);
            }
            if (this.sqlOutOn) {
                this.logger.info("seg_1_second_expand_startTime\uff1a" + mapTwo.get("startTime") + " seg_1_second_expand_endTime:" + mapTwo.get("endTime"));
            }
            List middleListTwo = this.getCurrentPunchCardDataOrNextPunchCardData(list, mapTwo, currentDate);
            for (int i = 0; i < middleListTwo.size(); ++i) {
                String date_suffix = AtsDateUtils.getTimeFromLongString((String)middleListTwo.get(i));
                String compdate = AtsDateUtils.getDateFromLongString((String)middleListTwo.get(i));
                String compare_Date = this.baseDate + this.split + date_suffix;
                if (AtsDateUtils.stringToShortDate(compdate).getTime() > AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                    compare_Date = this.baseNextDate + this.split + date_suffix;
                }
                if (AtsDateUtils.stringToShortDate(compdate).getTime() < AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                    compare_Date = this.basePreDate + this.split + date_suffix;
                }
                Date compareDate = AtsDateUtils.stringToLongDate(compare_Date);
                Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)mapTwo.get("startTime"));
                Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)mapTwo.get("endTime"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                headTwoList.add(middleListTwo.get(i));
            }
            List headTwoEffectiveList = this.getEffectivePunchData(headTwoList);
            if (this.sqlOutOn) {
                this.logger.info("seg_1_begin_second_effective_collection\uff1a" + headTwoEffectiveList.size());
                for (int i = 0; i < headTwoEffectiveList.size(); ++i) {
                    this.logger.info("seg_1_second_begin==" + headTwoEffectiveList.get(i));
                }
            }
            if (headTwoEffectiveList.size() > 0) {
                String mixDate2 = this.getMinData(headTwoEffectiveList);
                String maxDate = this.getMaxData(headTwoEffectiveList);
                info.setOneOnWorkTimeEarliest(mixDate2);
                info.setOneOnWorkTimeLatest(maxDate);
            }
            if (headTwoEffectiveList.size() > 0) {
                if (headTwoFetchCardType == 1) {
                    String mixDate3 = this.getMinData(headTwoEffectiveList);
                    info.setOneOnWorkTime(mixDate3);
                    headCardListone.add(info);
                }
                if (headTwoFetchCardType == 2) {
                    String maxDate = this.getMaxData(headTwoEffectiveList);
                    info.setOneOnWorkTime(maxDate);
                    headCardListone.add(info);
                }
            }
        }
        int oneonIsPunchCard = 1;
        if (shiftInfo != null && shiftInfo.getItems().size() == 1) {
            for (int i = 0; i < shiftInfo.getItems().size(); ++i) {
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) != 1) continue;
                oneonIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getPreIsPunchCard().getValue());
            }
        }
        String shiftTime_Oneon = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 1).get("firstOnTime");
        shiftTime_Oneon = currentDate + this.split + shiftTime_Oneon;
        boolean bl = isFreeCardCal = cardRuleInfo.isIsFreeCardCal() && headEffectiveList.size() > 0;
        if (oneonIsPunchCard == 0 && !isFreeCardCal) {
            if (headCardListone.size() > 0) {
                ((CardRuleResultInfo)headCardListone.get(0)).setOneOnWorkTime(shiftTime_Oneon);
            }
            if (headCardListone.size() == 0) {
                CardRuleResultInfo infoinner = new CardRuleResultInfo();
                infoinner.setOneOnWorkTime(shiftTime_Oneon);
                headCardListone.add(infoinner);
            }
        }
        return headCardListone;
    }

    public List<CardRuleResultInfo> getTailCardDataInfoOne(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap) {
        boolean isFreeCardCal;
        Date oneFetchCardEndDate;
        Date oneFetchCardBeginDate;
        Date compareDate;
        int i;
        String compareDateString;
        ArrayList nextList;
        ArrayList currList;
        if (shiftInfo != null) {
            this.firstOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 1).get("firstOffTime");
        }
        BigDecimal startBigDecimalOneTail = new BigDecimal("2.00");
        BigDecimal endBigDecimalOneTail = new BigDecimal("2.00");
        int tailOneFetchCardType = 2;
        int tailTwoFetchCardType = 2;
        BigDecimal startBigDecimalTwo = new BigDecimal("3.00");
        BigDecimal endBigDecimalTwo = new BigDecimal("3.00");
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegAftFirStartNum() != null) {
                startBigDecimalOneTail = cardRuleInfo.getSegAftFirStartNum();
            }
            if (cardRuleInfo.getSegAftFirEndNum() != null) {
                endBigDecimalOneTail = cardRuleInfo.getSegAftFirEndNum();
            }
            if (cardRuleInfo.getSegAftFirtakeCardType() != null) {
                tailOneFetchCardType = cardRuleInfo.getSegAftFirtakeCardType().getValue();
            }
            if (cardRuleInfo.getSegAftSecStartNum() != null) {
                startBigDecimalTwo = cardRuleInfo.getSegAftSecStartNum();
            }
            if (cardRuleInfo.getSegAftSecEndNum() != null) {
                endBigDecimalTwo = cardRuleInfo.getSegAftSecEndNum();
            }
            if (cardRuleInfo.getSegAftSectakeCardType() != null) {
                tailTwoFetchCardType = cardRuleInfo.getSegAftSectakeCardType().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> tailCardList = new ArrayList<CardRuleResultInfo>();
        ArrayList tailList = new ArrayList();
        BigDecimal twoOffTime = new BigDecimal(AtsDateUtils.getHourFromShiftString(this.firstOffTime));
        Map<String, Object> map = this.getSomeSectionTimeByHoursWithBaseDate(ctx, startBigDecimalOneTail, endBigDecimalOneTail, twoOffTime, this.baseDate);
        if (this.sqlOutOn) {
            this.logger.info("seg_1_first_expand_start_start\uff1a" + map.get("startTime") + " seg_1_first_expand_start_end:" + map.get("endTime"));
        }
        if (twoOffTime.add(endBigDecimalOneTail).doubleValue() > 24.0) {
            currList = new ArrayList();
            nextList = new ArrayList();
            if (list.size() > 0) {
                String mindate = AtsDateUtils.getDateFromLongString(this.getMinData(list));
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    compareDateString = AtsDateUtils.getDateFromLongString((String)list.get(i2));
                    if (AtsDateUtils.stringToShortDate(compareDateString).getTime() == AtsDateUtils.stringToShortDate(mindate).getTime()) {
                        currList.add(list.get(i2));
                        continue;
                    }
                    nextList.add(list.get(i2));
                }
            }
            for (i = 0; i < currList.size(); ++i) {
                String date_suffix = AtsDateUtils.getTimeFromLongString((String)currList.get(i));
                String compdate = AtsDateUtils.getDateFromLongString((String)currList.get(i));
                compareDate = AtsDateUtils.stringToLongDate(this.baseDate + this.split + date_suffix);
                if (AtsDateUtils.stringToShortDate(compdate).getTime() > AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                    compareDate = AtsDateUtils.stringToLongDate(this.baseNextDate + this.split + date_suffix);
                }
                oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("startTime"));
                oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("endTime"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                tailList.add(currList.get(i));
            }
            for (i = 0; i < nextList.size(); ++i) {
                String date_suffix = AtsDateUtils.getTimeFromLongString((String)nextList.get(i));
                String compareBaseDate = this.baseDate;
                if (twoOffTime.add(endBigDecimalOneTail).doubleValue() > 24.0) {
                    compareBaseDate = AtsDateUtils.getNextDay(this.baseDate);
                }
                compareDate = AtsDateUtils.stringToLongDate(compareBaseDate + this.split + date_suffix);
                oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("startTime"));
                oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("endTime"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                tailList.add(nextList.get(i));
            }
        } else {
            currList = new ArrayList();
            nextList = new ArrayList();
            if (list.size() > 0) {
                String mindate = AtsDateUtils.getDateFromLongString(this.getMinData(list));
                for (int j = 0; j < list.size(); ++j) {
                    compareDateString = AtsDateUtils.getDateFromLongString((String)list.get(j));
                    if (AtsDateUtils.stringToShortDate(compareDateString).getTime() == AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                        currList.add(list.get(j));
                        continue;
                    }
                    if (AtsDateUtils.stringToShortDate(compareDateString).getTime() <= AtsDateUtils.stringToShortDate(currentDate).getTime()) continue;
                    nextList.add(list.get(j));
                }
            }
            for (i = 0; i < currList.size(); ++i) {
                String date_suffix = AtsDateUtils.getTimeFromLongString((String)currList.get(i));
                String compare_Date = this.baseDate + this.split + date_suffix;
                compareDate = AtsDateUtils.stringToLongDate(compare_Date);
                oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("startTime"));
                oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("endTime"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                tailList.add(currList.get(i));
            }
        }
        List tailEffectiveList = this.getEffectivePunchData(tailList);
        if (this.sqlOutOn) {
            this.logger.info("seg_1_end_effective_card_collection\uff1a" + tailEffectiveList.size());
            for (int i3 = 0; i3 < tailEffectiveList.size(); ++i3) {
                this.logger.info("seg_1_first_end==" + tailEffectiveList.get(i3));
            }
        }
        CardRuleResultInfo info = new CardRuleResultInfo();
        if (tailEffectiveList.size() > 0) {
            ArrayList overShiftList = new ArrayList();
            String mixDate = null;
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            if (scheduleShiftHasEntryTag == 1) {
                for (int i4 = 0; i4 < tailEffectiveList.size(); ++i4) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)tailEffectiveList.get(i4));
                    String calBaseDate = this.baseDate;
                    if (twoOffTime.add(endBigDecimalOneTail).doubleValue() > 24.0) {
                        calBaseDate = AtsDateUtils.getNextDay(this.baseDate);
                    }
                    Date compareValue = AtsDateUtils.stringToLongDate(calBaseDate + this.split + date_suffix);
                    Date shiftDateValue = AtsDateUtils.stringToLongDate(this.baseDate + this.split + this.firstOffTime);
                    if (compareValue.getTime() < shiftDateValue.getTime()) continue;
                    overShiftList.add(tailEffectiveList.get(i4));
                }
                mixDate = this.getMinData(overShiftList);
            } else {
                mixDate = this.getMinData(tailEffectiveList);
            }
            String maxDate = this.getMaxData(tailEffectiveList);
            info.setOneOffWorkTimeEarliest(mixDate);
            info.setOneOffWorkTimeLatest(maxDate);
        }
        if (tailEffectiveList.size() > 0) {
            if (tailOneFetchCardType == 1) {
                String mixDate = this.getMinData(tailEffectiveList);
                info.setOneOffWorkTime(mixDate);
                tailCardList.add(info);
            }
            if (tailOneFetchCardType == 2) {
                String maxDate = this.getMaxData(tailEffectiveList);
                info.setOneOffWorkTime(maxDate);
                tailCardList.add(info);
            }
        }
        ArrayList tailTwoList = new ArrayList();
        if (tailEffectiveList.size() == 0) {
            Date oneFetchCardEndDate2;
            Date oneFetchCardBeginDate2;
            Date compareDate2;
            int i5;
            ArrayList nextList2;
            ArrayList currList2;
            Map<String, Object> mapTwo = this.getSomeSectionTimeByHoursWithBaseDate(ctx, startBigDecimalTwo, endBigDecimalTwo, twoOffTime, this.baseDate);
            if (this.sqlOutOn) {
                this.logger.info("seg_2_first_expand_start_start\uff1a" + mapTwo.get("startTime") + " seg_2_first_expand_start_end:" + mapTwo.get("endTime"));
            }
            if (twoOffTime.add(endBigDecimalTwo).doubleValue() > 24.0) {
                currList2 = new ArrayList();
                nextList2 = new ArrayList();
                if (list.size() > 0) {
                    String mindate = AtsDateUtils.getDateFromLongString(this.getMinData(list));
                    for (int i6 = 0; i6 < list.size(); ++i6) {
                        String compareDateString2 = AtsDateUtils.getDateFromLongString((String)list.get(i6));
                        if (AtsDateUtils.stringToShortDate(compareDateString2).getTime() == AtsDateUtils.stringToShortDate(mindate).getTime()) {
                            currList2.add(list.get(i6));
                            continue;
                        }
                        nextList2.add(list.get(i6));
                    }
                }
                for (i5 = 0; i5 < currList2.size(); ++i5) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)currList2.get(i5));
                    Date compareDate3 = AtsDateUtils.stringToLongDate(this.baseDate + this.split + date_suffix);
                    Date oneFetchCardBeginDate3 = AtsDateUtils.stringToLongDate((String)mapTwo.get("startTime"));
                    Date oneFetchCardEndDate3 = AtsDateUtils.stringToLongDate((String)mapTwo.get("endTime"));
                    if (compareDate3.getTime() < oneFetchCardBeginDate3.getTime() || compareDate3.getTime() > oneFetchCardEndDate3.getTime()) continue;
                    tailTwoList.add(currList2.get(i5));
                }
                for (i5 = 0; i5 < nextList2.size(); ++i5) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)nextList2.get(i5));
                    String compareBaseDate = this.baseDate;
                    if (twoOffTime.add(endBigDecimalTwo).doubleValue() > 24.0) {
                        compareBaseDate = AtsDateUtils.getNextDay(this.baseDate);
                    }
                    compareDate2 = AtsDateUtils.stringToLongDate(compareBaseDate + this.split + date_suffix);
                    oneFetchCardBeginDate2 = AtsDateUtils.stringToLongDate((String)mapTwo.get("startTime"));
                    oneFetchCardEndDate2 = AtsDateUtils.stringToLongDate((String)mapTwo.get("endTime"));
                    if (compareDate2.getTime() < oneFetchCardBeginDate2.getTime() || compareDate2.getTime() > oneFetchCardEndDate2.getTime()) continue;
                    tailTwoList.add(nextList2.get(i5));
                }
            } else {
                currList2 = new ArrayList();
                nextList2 = new ArrayList();
                if (list.size() > 0) {
                    for (int j = 0; j < list.size(); ++j) {
                        String compareDateString3 = AtsDateUtils.getDateFromLongString((String)list.get(j));
                        if (AtsDateUtils.stringToShortDate(compareDateString3).getTime() == AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                            currList2.add(list.get(j));
                            continue;
                        }
                        if (AtsDateUtils.stringToShortDate(compareDateString3).getTime() <= AtsDateUtils.stringToShortDate(currentDate).getTime()) continue;
                        nextList2.add(list.get(j));
                    }
                }
                for (i5 = 0; i5 < currList2.size(); ++i5) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)currList2.get(i5));
                    String compare_Date = this.baseDate + this.split + date_suffix;
                    compareDate2 = AtsDateUtils.stringToLongDate(compare_Date);
                    oneFetchCardBeginDate2 = AtsDateUtils.stringToLongDate((String)mapTwo.get("startTime"));
                    oneFetchCardEndDate2 = AtsDateUtils.stringToLongDate((String)mapTwo.get("endTime"));
                    if (compareDate2.getTime() < oneFetchCardBeginDate2.getTime() || compareDate2.getTime() > oneFetchCardEndDate2.getTime()) continue;
                    tailTwoList.add(currList2.get(i5));
                }
            }
            List tailTwoEffectiveList = this.getEffectivePunchData(tailTwoList);
            if (this.sqlOutOn) {
                this.logger.info("seg_1_begin_second_effective_collection\uff1a" + tailTwoEffectiveList.size());
                for (int i7 = 0; i7 < tailTwoEffectiveList.size(); ++i7) {
                    this.logger.info("seg_1_first_begin\uff1a\uff1a" + tailTwoEffectiveList.get(i7));
                }
            }
            if (tailTwoEffectiveList.size() > 0) {
                String mixDate = this.getMinData(tailTwoEffectiveList);
                String maxDate = this.getMaxData(tailTwoEffectiveList);
                info.setOneOffWorkTimeEarliest(mixDate);
                info.setOneOffWorkTimeLatest(maxDate);
            }
            if (tailTwoEffectiveList.size() > 0) {
                if (tailTwoFetchCardType == 1) {
                    String mixDate = this.getMinData(tailTwoEffectiveList);
                    info.setOneOffWorkTime(mixDate);
                    tailCardList.add(info);
                }
                if (tailTwoFetchCardType == 2) {
                    String maxDate = this.getMaxData(tailTwoEffectiveList);
                    info.setOneOffWorkTime(maxDate);
                    tailCardList.add(info);
                }
            }
        }
        int oneoffIsPunchCard = 1;
        if (shiftInfo != null && shiftInfo.getItems().size() == 1) {
            for (int i8 = 0; i8 < shiftInfo.getItems().size(); ++i8) {
                if (Integer.parseInt(shiftInfo.getItems().get(i8).getSegment().getValue()) != 1) continue;
                oneoffIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i8).getNextIsPunchCard().getValue());
            }
        }
        String shiftTime_Oneoff = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 1).get("firstOffTime");
        shiftTime_Oneoff = currentDate + this.split + shiftTime_Oneoff;
        boolean bl = isFreeCardCal = cardRuleInfo.isIsFreeCardCal() && tailEffectiveList.size() > 0;
        if (oneoffIsPunchCard == 0 && !isFreeCardCal) {
            if (tailCardList.size() > 0) {
                ((CardRuleResultInfo)tailCardList.get(0)).setOneOffWorkTime(shiftTime_Oneoff);
            }
            if (tailCardList.size() == 0) {
                CardRuleResultInfo infoinner = new CardRuleResultInfo();
                infoinner.setOneOffWorkTime(shiftTime_Oneoff);
                tailCardList.add(infoinner);
            }
        }
        return tailCardList;
    }

    public List<CardRuleResultInfo> getHeadCardDataInfoTwo(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap) {
        boolean isFreeCardCal;
        String mixDate;
        if (shiftInfo != null) {
            this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOnTime");
        }
        BigDecimal startBigDecimalOne = new BigDecimal("2.00");
        BigDecimal endBigDecimalOne = new BigDecimal("2.00");
        BigDecimal startBigDecimalTwo = new BigDecimal("3.00");
        BigDecimal endBigDecimalTwo = new BigDecimal("3.00");
        int headOneFetchCardType = 1;
        int headTwoFetchCardType = 1;
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegBefFirStartNum() != null) {
                startBigDecimalOne = cardRuleInfo.getSegBefFirStartNum();
            }
            if (cardRuleInfo.getSegBefFirEndNum() != null) {
                endBigDecimalOne = cardRuleInfo.getSegBefFirEndNum();
            }
            if (cardRuleInfo.getSegBefFirtakeCardType() != null) {
                headOneFetchCardType = cardRuleInfo.getSegBefFirtakeCardType().getValue();
            }
            if (cardRuleInfo.getSegBefSecStartNum() != null) {
                startBigDecimalTwo = cardRuleInfo.getSegBefSecStartNum();
            }
            if (cardRuleInfo.getSegBefSecEndNum() != null) {
                endBigDecimalTwo = cardRuleInfo.getSegBefSecEndNum();
            }
            if (cardRuleInfo.getSegBefSectakeCardType() != null) {
                headTwoFetchCardType = cardRuleInfo.getSegBefSectakeCardType().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> headCardList = new ArrayList<CardRuleResultInfo>();
        ArrayList headList = new ArrayList();
        BigDecimal oneOnTime = new BigDecimal(AtsDateUtils.getHourFromShiftString(this.firstOnTime));
        Map<String, Object> map = this.getSomeSectionTimeByHoursWithBaseDate(ctx, startBigDecimalOne, endBigDecimalOne, oneOnTime, this.baseDate);
        if (oneOnTime.subtract(startBigDecimalOne).doubleValue() <= 0.0) {
            String startDate_Str = this.baseDate + this.split + this.firstOnTime;
            String startDateStr = AtsDateUtils.getPreAnyHour(startDate_Str, startBigDecimalOne.intValue());
            map.put("startTime", startDateStr);
        }
        if (this.sqlOutOn) {
            this.logger.info("seg_2_first_expand_start_start\uff1a" + map.get("startTime") + " seg_2_first_expand_start_end:" + map.get("endTime"));
        }
        List middleList = this.getCurrentPunchCardDataOrNextPunchCardData(list, map, currentDate);
        for (int i = 0; i < middleList.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)middleList.get(i));
            String compare_Date = this.baseDate + this.split + date_suffix;
            String compdate = AtsDateUtils.getDateFromLongString((String)middleList.get(i));
            if (AtsDateUtils.stringToShortDate(compdate).getTime() > AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                compare_Date = this.baseNextDate + this.split + date_suffix;
            }
            if (AtsDateUtils.stringToShortDate(compdate).getTime() < AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                compare_Date = this.basePreDate + this.split + date_suffix;
            }
            Date compareDate = AtsDateUtils.stringToLongDate(compare_Date);
            Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("startTime"));
            Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("endTime"));
            if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
            headList.add(middleList.get(i));
        }
        List headEffectiveList = this.getEffectivePunchData(headList);
        if (this.sqlOutOn) {
            this.logger.info("seg_2_first_begin\uff1a\uff1a" + headEffectiveList.size());
            for (int i = 0; i < headEffectiveList.size(); ++i) {
                this.logger.info("seg_2_first_begin\uff1a\uff1a==" + headEffectiveList.get(i));
            }
        }
        CardRuleResultInfo info = new CardRuleResultInfo();
        if (headEffectiveList.size() > 0) {
            mixDate = this.getMinData(headEffectiveList);
            String maxDate = null;
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            if (scheduleShiftHasEntryTag == 1) {
                ArrayList lessShiftList = new ArrayList();
                for (int i = 0; i < headEffectiveList.size(); ++i) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)headEffectiveList.get(i));
                    Date compareValue = AtsDateUtils.stringToLongDate(this.baseDate + this.split + date_suffix);
                    Timestamp innerTimestamp = AtsDateUtils.stringShortToTimestamp(AtsDateUtils.getDateFromLongString((String)headEffectiveList.get(i)));
                    Timestamp currTimestamp = AtsDateUtils.stringShortToTimestamp(currentDate);
                    if (innerTimestamp.getTime() < currTimestamp.getTime()) {
                        compareValue = AtsDateUtils.stringToLongDate(this.basePreDate + this.split + date_suffix);
                    }
                    if (innerTimestamp.getTime() > currTimestamp.getTime()) {
                        compareValue = AtsDateUtils.stringToLongDate(this.baseNextDate + this.split + date_suffix);
                    }
                    Date shiftDateValue = AtsDateUtils.stringToLongDate(this.baseDate + this.split + this.firstOnTime);
                    if (compareValue.getTime() > shiftDateValue.getTime()) continue;
                    lessShiftList.add(headEffectiveList.get(i));
                }
                maxDate = this.getMaxData(lessShiftList);
            } else {
                maxDate = this.getMaxData(headEffectiveList);
            }
            info.setOneOnWorkTimeEarliest(mixDate);
            info.setOneOnWorkTimeLatest(maxDate);
        }
        if (headEffectiveList.size() > 0) {
            if (headOneFetchCardType == 1) {
                mixDate = this.getMinData(headEffectiveList);
                info.setOneOnWorkTime(mixDate);
                headCardList.add(info);
            }
            if (headOneFetchCardType == 2) {
                String maxDate = this.getMaxData(headEffectiveList);
                info.setOneOnWorkTime(maxDate);
                headCardList.add(info);
            }
        }
        ArrayList headTwoList = new ArrayList();
        if (headEffectiveList.size() == 0) {
            Map<String, Object> mapTwo = this.getSomeSectionTimeByHoursWithBaseDate(ctx, startBigDecimalTwo, endBigDecimalTwo, oneOnTime, this.baseDate);
            if (oneOnTime.subtract(startBigDecimalTwo).doubleValue() <= 0.0) {
                String startDate_Str = this.baseDate + this.split + this.firstOnTime;
                String startDateStr = AtsDateUtils.getPreAnyHour(startDate_Str, startBigDecimalTwo.intValue());
                mapTwo.put("startTime", startDateStr);
            }
            if (this.sqlOutOn) {
                this.logger.info("seg_2_second_expand_start_start\uff1a" + mapTwo.get("startTime") + " seg_2_second_expand_start_end\uff1a" + mapTwo.get("endTime"));
            }
            List middleListTwo = this.getCurrentPunchCardDataOrNextPunchCardData(list, mapTwo, currentDate);
            for (int i = 0; i < middleListTwo.size(); ++i) {
                String date_suffix = AtsDateUtils.getTimeFromLongString((String)middleListTwo.get(i));
                String compdate = AtsDateUtils.getDateFromLongString((String)middleListTwo.get(i));
                String compare_Date = this.baseDate + this.split + date_suffix;
                if (AtsDateUtils.stringToShortDate(compdate).getTime() > AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                    compare_Date = this.baseNextDate + this.split + date_suffix;
                }
                if (AtsDateUtils.stringToShortDate(compdate).getTime() < AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                    compare_Date = this.basePreDate + this.split + date_suffix;
                }
                Date compareDate = AtsDateUtils.stringToLongDate(compare_Date);
                Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)mapTwo.get("startTime"));
                Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)mapTwo.get("endTime"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                headTwoList.add(middleListTwo.get(i));
            }
            List headTwoEffectiveList = this.getEffectivePunchData(headTwoList);
            if (this.sqlOutOn) {
                this.logger.info("seg_2_second_begin\uff1a" + headTwoEffectiveList.size());
                for (int i = 0; i < headTwoEffectiveList.size(); ++i) {
                    this.logger.info("seg_2_second_begin\uff1a==" + headTwoEffectiveList.get(i));
                }
            }
            if (headTwoEffectiveList.size() > 0) {
                String mixDate2 = this.getMinData(headTwoEffectiveList);
                String maxDate = this.getMaxData(headTwoEffectiveList);
                info.setTwoOnWorkTimeEarliest(mixDate2);
                info.setTwoOnWorkTimeLatest(maxDate);
            }
            if (headTwoEffectiveList.size() > 0) {
                if (headTwoFetchCardType == 1) {
                    String mixDate3 = this.getMinData(headTwoEffectiveList);
                    info.setOneOnWorkTime(mixDate3);
                    headCardList.add(info);
                }
                if (headTwoFetchCardType == 2) {
                    String maxDate = this.getMaxData(headTwoEffectiveList);
                    info.setOneOnWorkTime(maxDate);
                    headCardList.add(info);
                }
            }
        }
        int oneonIsPunchCard = 1;
        String preTime = "";
        String nextTime = "";
        if (shiftInfo != null && shiftInfo.getItems().size() == 2) {
            for (int i = 0; i < shiftInfo.getItems().size(); ++i) {
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) != 1) continue;
                oneonIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getPreIsPunchCard().getValue());
            }
        }
        String shiftTime_Oneon = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOnTime");
        shiftTime_Oneon = currentDate + this.split + shiftTime_Oneon;
        boolean bl = isFreeCardCal = cardRuleInfo.isIsFreeCardCal() && headEffectiveList.size() > 0;
        if (oneonIsPunchCard == 0 && !isFreeCardCal) {
            if (headCardList.size() > 0) {
                ((CardRuleResultInfo)headCardList.get(0)).setOneOnWorkTime(shiftTime_Oneon);
            }
            if (headCardList.size() == 0) {
                CardRuleResultInfo infoinner = new CardRuleResultInfo();
                infoinner.setOneOnWorkTime(shiftTime_Oneon);
                headCardList.add(infoinner);
            }
        }
        return headCardList;
    }

    public List<CardRuleResultInfo> getTailCardDataInfoTwo(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap) {
        boolean isFreeCardCal;
        Date compareDate;
        Date oneFetchCardEndDate;
        Date oneFetchCardBeginDate;
        int i;
        ArrayList nextList;
        ArrayList currList;
        if (shiftInfo != null) {
            this.secondOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("secondOffTime");
        }
        BigDecimal startBigDecimalOneTail = new BigDecimal("2.00");
        BigDecimal endBigDecimalOneTail = new BigDecimal("2.00");
        int tailOneFetchCardType = 2;
        int tailTwoFetchCardType = 2;
        BigDecimal startBigDecimalTwo = new BigDecimal("3.00");
        BigDecimal endBigDecimalTwo = new BigDecimal("3.00");
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegAftFirStartNum() != null) {
                startBigDecimalOneTail = cardRuleInfo.getSegAftFirStartNum();
            }
            if (cardRuleInfo.getSegAftFirEndNum() != null) {
                endBigDecimalOneTail = cardRuleInfo.getSegAftFirEndNum();
            }
            if (cardRuleInfo.getSegAftFirtakeCardType() != null) {
                tailOneFetchCardType = cardRuleInfo.getSegAftFirtakeCardType().getValue();
            }
            if (cardRuleInfo.getSegAftSecStartNum() != null) {
                startBigDecimalTwo = cardRuleInfo.getSegAftSecStartNum();
            }
            if (cardRuleInfo.getSegAftSecEndNum() != null) {
                endBigDecimalTwo = cardRuleInfo.getSegAftSecEndNum();
            }
            if (cardRuleInfo.getSegAftSectakeCardType() != null) {
                tailTwoFetchCardType = cardRuleInfo.getSegAftSectakeCardType().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> tailCardList = new ArrayList<CardRuleResultInfo>();
        ArrayList tailList = new ArrayList();
        BigDecimal twoOffTime = new BigDecimal(AtsDateUtils.getHourFromShiftString(this.secondOffTime));
        Map<String, Object> map = this.getSomeSectionTimeByHoursWithBaseDate(ctx, startBigDecimalOneTail, endBigDecimalOneTail, twoOffTime, this.baseDate);
        if (this.sqlOutOn) {
            this.logger.info("seg_2_end_first_expand_start_start\uff1a" + map.get("startTime") + " seg_2_end_first_expand_start_end\uff1a" + map.get("endTime"));
        }
        if (twoOffTime.add(endBigDecimalOneTail).doubleValue() > 24.0) {
            currList = new ArrayList();
            nextList = new ArrayList();
            if (list.size() > 0) {
                String mindate = AtsDateUtils.getDateFromLongString(this.getMinData(list));
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    String compareDateString = AtsDateUtils.getDateFromLongString((String)list.get(i2));
                    if (AtsDateUtils.stringToShortDate(compareDateString).getTime() == AtsDateUtils.stringToShortDate(mindate).getTime()) {
                        currList.add(list.get(i2));
                        continue;
                    }
                    nextList.add(list.get(i2));
                }
            }
            for (i = 0; i < currList.size(); ++i) {
                String date_suffix = AtsDateUtils.getTimeFromLongString((String)currList.get(i));
                Date compareDate2 = AtsDateUtils.stringToLongDate(this.baseDate + this.split + date_suffix);
                String compdate = AtsDateUtils.getDateFromLongString((String)currList.get(i));
                if (AtsDateUtils.stringToShortDate(compdate).getTime() > AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                    compareDate2 = AtsDateUtils.stringToLongDate(this.baseNextDate + this.split + date_suffix);
                }
                oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("startTime"));
                oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("endTime"));
                if (compareDate2.getTime() < oneFetchCardBeginDate.getTime() || compareDate2.getTime() > oneFetchCardEndDate.getTime()) continue;
                tailList.add(currList.get(i));
            }
            for (i = 0; i < nextList.size(); ++i) {
                String date_suffix = AtsDateUtils.getTimeFromLongString((String)nextList.get(i));
                String compareBaseDate = this.baseDate;
                if (twoOffTime.add(endBigDecimalOneTail).doubleValue() > 24.0) {
                    compareBaseDate = AtsDateUtils.getNextDay(this.baseDate);
                }
                compareDate = AtsDateUtils.stringToLongDate(compareBaseDate + this.split + date_suffix);
                oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("startTime"));
                oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("endTime"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                tailList.add(nextList.get(i));
            }
        } else {
            currList = new ArrayList();
            nextList = new ArrayList();
            if (list.size() > 0) {
                for (int j = 0; j < list.size(); ++j) {
                    String compareDateString = AtsDateUtils.getDateFromLongString((String)list.get(j));
                    if (AtsDateUtils.stringToShortDate(compareDateString).getTime() == AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                        currList.add(list.get(j));
                        continue;
                    }
                    if (AtsDateUtils.stringToShortDate(compareDateString).getTime() <= AtsDateUtils.stringToShortDate(currentDate).getTime()) continue;
                    nextList.add(list.get(j));
                }
            }
            for (i = 0; i < currList.size(); ++i) {
                String date_suffix = AtsDateUtils.getTimeFromLongString((String)currList.get(i));
                String compare_Date = this.baseDate + this.split + date_suffix;
                compareDate = AtsDateUtils.stringToLongDate(compare_Date);
                oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("startTime"));
                oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("endTime"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                tailList.add(currList.get(i));
            }
        }
        List tailEffectiveList = this.getEffectivePunchData(tailList);
        if (this.sqlOutOn) {
            this.logger.info("seg_2_end_first_effective_collection\uff1a" + tailEffectiveList.size());
            for (int i3 = 0; i3 < tailEffectiveList.size(); ++i3) {
                this.logger.info("seg_2_end_first_effective_collection==" + tailEffectiveList.get(i3));
            }
        }
        CardRuleResultInfo info = new CardRuleResultInfo();
        if (tailEffectiveList.size() > 0) {
            ArrayList overShiftList = new ArrayList();
            String mixDate = null;
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            if (scheduleShiftHasEntryTag == 1) {
                for (int i4 = 0; i4 < tailEffectiveList.size(); ++i4) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)tailEffectiveList.get(i4));
                    String calBaseDate = this.baseDate;
                    if (twoOffTime.add(endBigDecimalOneTail).doubleValue() > 24.0) {
                        calBaseDate = AtsDateUtils.getNextDay(this.baseDate);
                    }
                    Date compareValue = AtsDateUtils.stringToLongDate(calBaseDate + this.split + date_suffix);
                    Date shiftDateValue = AtsDateUtils.stringToLongDate(this.baseDate + this.split + this.secondOffTime);
                    if (compareValue.getTime() < shiftDateValue.getTime()) continue;
                    overShiftList.add(tailEffectiveList.get(i4));
                }
                mixDate = this.getMinData(overShiftList);
            } else {
                mixDate = this.getMinData(tailEffectiveList);
            }
            String maxDate = this.getMaxData(tailEffectiveList);
            info.setTwoOffWorkTimeEarliest(mixDate);
            info.setTwoOffWorkTimeLatest(maxDate);
        }
        if (tailEffectiveList.size() > 0) {
            if (tailOneFetchCardType == 1) {
                String mixDate = this.getMinData(tailEffectiveList);
                info.setTwoOffWorkTime(mixDate);
                tailCardList.add(info);
            }
            if (tailOneFetchCardType == 2) {
                String maxDate = this.getMaxData(tailEffectiveList);
                info.setTwoOffWorkTime(maxDate);
                tailCardList.add(info);
            }
        }
        ArrayList tailTwoList = new ArrayList();
        if (tailEffectiveList.size() == 0) {
            Date oneFetchCardEndDate2;
            Date oneFetchCardBeginDate2;
            Date compareDate3;
            int i5;
            ArrayList nextList2;
            ArrayList currList2;
            Map<String, Object> mapTwo = this.getSomeSectionTimeByHoursWithBaseDate(ctx, startBigDecimalTwo, endBigDecimalTwo, twoOffTime, this.baseDate);
            if (this.sqlOutOn) {
                this.logger.info("seg_2_second_end_expand_start_start" + mapTwo.get("startTime") + " seg_2_second_end_expand_start_end:" + mapTwo.get("endTime"));
            }
            if (twoOffTime.add(endBigDecimalTwo).doubleValue() > 24.0) {
                currList2 = new ArrayList();
                nextList2 = new ArrayList();
                if (list.size() > 0) {
                    String mindate = AtsDateUtils.getDateFromLongString(this.getMinData(list));
                    for (int i6 = 0; i6 < list.size(); ++i6) {
                        String compareDateString = AtsDateUtils.getDateFromLongString((String)list.get(i6));
                        if (AtsDateUtils.stringToShortDate(compareDateString).getTime() == AtsDateUtils.stringToShortDate(mindate).getTime()) {
                            currList2.add(list.get(i6));
                            continue;
                        }
                        nextList2.add(list.get(i6));
                    }
                }
                for (i5 = 0; i5 < currList2.size(); ++i5) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)currList2.get(i5));
                    Date compareDate4 = AtsDateUtils.stringToLongDate(this.baseDate + this.split + date_suffix);
                    Date oneFetchCardBeginDate3 = AtsDateUtils.stringToLongDate((String)mapTwo.get("startTime"));
                    Date oneFetchCardEndDate3 = AtsDateUtils.stringToLongDate((String)mapTwo.get("endTime"));
                    if (compareDate4.getTime() < oneFetchCardBeginDate3.getTime() || compareDate4.getTime() > oneFetchCardEndDate3.getTime()) continue;
                    tailTwoList.add(currList2.get(i5));
                }
                for (i5 = 0; i5 < nextList2.size(); ++i5) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)nextList2.get(i5));
                    String compareBaseDate = this.baseDate;
                    if (twoOffTime.add(endBigDecimalTwo).doubleValue() > 24.0) {
                        compareBaseDate = AtsDateUtils.getNextDay(this.baseDate);
                    }
                    compareDate3 = AtsDateUtils.stringToLongDate(compareBaseDate + this.split + date_suffix);
                    oneFetchCardBeginDate2 = AtsDateUtils.stringToLongDate((String)mapTwo.get("startTime"));
                    oneFetchCardEndDate2 = AtsDateUtils.stringToLongDate((String)mapTwo.get("endTime"));
                    if (compareDate3.getTime() < oneFetchCardBeginDate2.getTime() || compareDate3.getTime() > oneFetchCardEndDate2.getTime()) continue;
                    tailTwoList.add(nextList2.get(i5));
                }
            } else {
                currList2 = new ArrayList();
                nextList2 = new ArrayList();
                if (list.size() > 0) {
                    for (int j = 0; j < list.size(); ++j) {
                        String compareDateString = AtsDateUtils.getDateFromLongString((String)list.get(j));
                        if (AtsDateUtils.stringToShortDate(compareDateString).getTime() == AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                            currList2.add(list.get(j));
                            continue;
                        }
                        if (AtsDateUtils.stringToShortDate(compareDateString).getTime() <= AtsDateUtils.stringToShortDate(currentDate).getTime()) continue;
                        nextList2.add(list.get(j));
                    }
                }
                for (i5 = 0; i5 < currList2.size(); ++i5) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)currList2.get(i5));
                    String compare_Date = this.baseDate + this.split + date_suffix;
                    compareDate3 = AtsDateUtils.stringToLongDate(compare_Date);
                    oneFetchCardBeginDate2 = AtsDateUtils.stringToLongDate((String)mapTwo.get("startTime"));
                    oneFetchCardEndDate2 = AtsDateUtils.stringToLongDate((String)mapTwo.get("endTime"));
                    if (compareDate3.getTime() < oneFetchCardBeginDate2.getTime() || compareDate3.getTime() > oneFetchCardEndDate2.getTime()) continue;
                    tailTwoList.add(currList2.get(i5));
                }
            }
            List tailTwoEffectiveList = this.getEffectivePunchData(tailTwoList);
            if (this.sqlOutOn) {
                this.logger.info("seg_2_end_second_effective_collection\uff1a" + tailTwoEffectiveList.size());
                for (int i7 = 0; i7 < tailTwoEffectiveList.size(); ++i7) {
                    this.logger.info("seg_2_end_second_effective_collection\uff1a==" + tailTwoEffectiveList.get(i7));
                }
            }
            if (tailTwoEffectiveList.size() > 0) {
                String mixDate = this.getMinData(tailTwoEffectiveList);
                String maxDate = this.getMaxData(tailTwoEffectiveList);
                info.setTwoOffWorkTimeEarliest(mixDate);
                info.setTwoOffWorkTimeLatest(maxDate);
            }
            if (tailTwoEffectiveList.size() > 0) {
                if (tailTwoFetchCardType == 1) {
                    String mixDate = this.getMinData(tailTwoEffectiveList);
                    info.setTwoOffWorkTime(mixDate);
                    tailCardList.add(info);
                }
                if (tailTwoFetchCardType == 2) {
                    String maxDate = this.getMaxData(tailTwoEffectiveList);
                    info.setTwoOffWorkTime(maxDate);
                    tailCardList.add(info);
                }
            }
        }
        int twooffIsPunchCard = 1;
        String preTime = "";
        String nextTime = "";
        if (shiftInfo != null && shiftInfo.getItems().size() == 2) {
            for (int i8 = 0; i8 < shiftInfo.getItems().size(); ++i8) {
                if (Integer.parseInt(shiftInfo.getItems().get(i8).getSegment().getValue()) != 2) continue;
                twooffIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i8).getNextIsPunchCard().getValue());
            }
        }
        String shiftTime_Twooff = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("secondOffTime");
        shiftTime_Twooff = currentDate + this.split + shiftTime_Twooff;
        boolean bl = isFreeCardCal = cardRuleInfo.isIsFreeCardCal() && tailEffectiveList.size() > 0;
        if (twooffIsPunchCard == 0 && !isFreeCardCal) {
            if (tailCardList.size() > 0) {
                ((CardRuleResultInfo)tailCardList.get(0)).setTwoOffWorkTime(shiftTime_Twooff);
            }
            if (tailCardList.size() == 0) {
                CardRuleResultInfo infoinner = new CardRuleResultInfo();
                infoinner.setTwoOffWorkTime(shiftTime_Twooff);
                tailCardList.add(infoinner);
            }
        }
        return tailCardList;
    }

    public List<CardRuleResultInfo> getHeadCardDataInfoThree(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap) {
        boolean isFreeCardCal;
        String mixDate;
        if (shiftInfo != null) {
            this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("firstOnTime");
        }
        BigDecimal startBigDecimalOne = new BigDecimal("2.00");
        BigDecimal endBigDecimalOne = new BigDecimal("2.00");
        BigDecimal startBigDecimalTwo = new BigDecimal("3.00");
        BigDecimal endBigDecimalTwo = new BigDecimal("3.00");
        int headOneFetchCardType = 1;
        int headTwoFetchCardType = 1;
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegBefFirStartNum() != null) {
                startBigDecimalOne = cardRuleInfo.getSegBefFirStartNum();
            }
            if (cardRuleInfo.getSegBefFirEndNum() != null) {
                endBigDecimalOne = cardRuleInfo.getSegBefFirEndNum();
            }
            if (cardRuleInfo.getSegBefFirtakeCardType() != null) {
                headOneFetchCardType = cardRuleInfo.getSegBefFirtakeCardType().getValue();
            }
            if (cardRuleInfo.getSegBefSecStartNum() != null) {
                startBigDecimalTwo = cardRuleInfo.getSegBefSecStartNum();
            }
            if (cardRuleInfo.getSegBefSecEndNum() != null) {
                endBigDecimalTwo = cardRuleInfo.getSegBefSecEndNum();
            }
            if (cardRuleInfo.getSegBefSectakeCardType() != null) {
                headTwoFetchCardType = cardRuleInfo.getSegBefSectakeCardType().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> headCardList = new ArrayList<CardRuleResultInfo>();
        ArrayList headList = new ArrayList();
        BigDecimal oneOnTime = new BigDecimal(AtsDateUtils.getHourFromShiftString(this.firstOnTime));
        Map<String, Object> map = this.getSomeSectionTimeByHoursWithBaseDate(ctx, startBigDecimalOne, endBigDecimalOne, oneOnTime, this.baseDate);
        if (oneOnTime.subtract(startBigDecimalOne).doubleValue() <= 0.0) {
            String startDate_Str = this.baseDate + this.split + this.firstOnTime;
            String startDateStr = AtsDateUtils.getPreAnyHour(startDate_Str, startBigDecimalOne.intValue());
            map.put("startTime", startDateStr);
        }
        if (this.sqlOutOn) {
            this.logger.info("seg_3_begin_first_expand_start_start:" + map.get("startTime") + " seg_3_begin_first_expand_start_end:" + map.get("endTime"));
        }
        List middleList = this.getCurrentPunchCardDataOrNextPunchCardData(list, map, currentDate);
        for (int i = 0; i < middleList.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)middleList.get(i));
            String compdate = AtsDateUtils.getDateFromLongString((String)middleList.get(i));
            String compare_Date = this.baseDate + this.split + date_suffix;
            if (AtsDateUtils.stringToShortDate(compdate).getTime() > AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                compare_Date = this.baseNextDate + this.split + date_suffix;
            }
            if (AtsDateUtils.stringToShortDate(compdate).getTime() < AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                compare_Date = this.basePreDate + this.split + date_suffix;
            }
            Date compareDate = AtsDateUtils.stringToLongDate(compare_Date);
            Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("startTime"));
            Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("endTime"));
            if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
            headList.add(middleList.get(i));
        }
        List headEffectiveList = this.getEffectivePunchData(headList);
        if (this.sqlOutOn) {
            this.logger.info("seg_3_begin_first_effective_collection:" + headEffectiveList.size());
            for (int i = 0; i < headEffectiveList.size(); ++i) {
                this.logger.info("seg_1_begin_first_effective_collection:" + headEffectiveList.get(i));
            }
        }
        CardRuleResultInfo info = new CardRuleResultInfo();
        if (headEffectiveList.size() > 0) {
            mixDate = this.getMinData(headEffectiveList);
            String maxDate = null;
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            if (scheduleShiftHasEntryTag == 1) {
                ArrayList lessShiftList = new ArrayList();
                for (int i = 0; i < headEffectiveList.size(); ++i) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)headEffectiveList.get(i));
                    Date compareValue = AtsDateUtils.stringToLongDate(this.baseDate + this.split + date_suffix);
                    Timestamp innerTimestamp = AtsDateUtils.stringShortToTimestamp(AtsDateUtils.getDateFromLongString((String)headEffectiveList.get(i)));
                    Timestamp currTimestamp = AtsDateUtils.stringShortToTimestamp(currentDate);
                    if (innerTimestamp.getTime() < currTimestamp.getTime()) {
                        compareValue = AtsDateUtils.stringToLongDate(this.basePreDate + this.split + date_suffix);
                    }
                    if (innerTimestamp.getTime() > currTimestamp.getTime()) {
                        compareValue = AtsDateUtils.stringToLongDate(this.baseNextDate + this.split + date_suffix);
                    }
                    Date shiftDateValue = AtsDateUtils.stringToLongDate(this.baseDate + this.split + this.firstOnTime);
                    if (compareValue.getTime() > shiftDateValue.getTime()) continue;
                    lessShiftList.add(headEffectiveList.get(i));
                }
                maxDate = this.getMaxData(lessShiftList);
            } else {
                maxDate = this.getMaxData(headEffectiveList);
            }
            info.setOneOnWorkTimeEarliest(mixDate);
            info.setOneOnWorkTimeLatest(maxDate);
        }
        if (headEffectiveList.size() > 0) {
            if (headOneFetchCardType == 1) {
                mixDate = this.getMinData(headEffectiveList);
                info.setOneOnWorkTime(mixDate);
                headCardList.add(info);
            }
            if (headOneFetchCardType == 2) {
                String maxDate = this.getMaxData(headEffectiveList);
                info.setOneOnWorkTime(maxDate);
                headCardList.add(info);
            }
        }
        ArrayList headTwoList = new ArrayList();
        if (headEffectiveList.size() == 0) {
            Map<String, Object> mapTwo = this.getSomeSectionTimeByHoursWithBaseDate(ctx, startBigDecimalTwo, endBigDecimalTwo, oneOnTime, this.baseDate);
            if (oneOnTime.subtract(startBigDecimalTwo).doubleValue() <= 0.0) {
                String startDate_Str = this.baseDate + this.split + this.firstOnTime;
                String startDateStr = AtsDateUtils.getPreAnyHour(startDate_Str, startBigDecimalTwo.intValue());
                mapTwo.put("startTime", startDateStr);
            }
            if (this.sqlOutOn) {
                this.logger.info("seg_2_second_expand_start_start:" + mapTwo.get("startTime") + " seg_2_second_expand_start_end:" + mapTwo.get("endTime"));
            }
            List middleListTwo = this.getCurrentPunchCardDataOrNextPunchCardData(list, mapTwo, currentDate);
            for (int i = 0; i < middleListTwo.size(); ++i) {
                String date_suffix = AtsDateUtils.getTimeFromLongString((String)middleListTwo.get(i));
                String compdate = AtsDateUtils.getDateFromLongString((String)middleListTwo.get(i));
                String compare_Date = this.baseDate + this.split + date_suffix;
                if (AtsDateUtils.stringToShortDate(compdate).getTime() > AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                    compare_Date = this.baseNextDate + this.split + date_suffix;
                }
                if (AtsDateUtils.stringToShortDate(compdate).getTime() < AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                    compare_Date = this.basePreDate + this.split + date_suffix;
                }
                Date compareDate = AtsDateUtils.stringToLongDate(compare_Date);
                Date oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)mapTwo.get("startTime"));
                Date oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)mapTwo.get("endTime"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                headTwoList.add(middleListTwo.get(i));
            }
            List headTwoEffectiveList = this.getEffectivePunchData(headTwoList);
            if (this.sqlOutOn) {
                this.logger.info("seg_3_begin_second_effective_collection\uff1a" + headTwoEffectiveList.size());
                for (int i = 0; i < headTwoEffectiveList.size(); ++i) {
                    this.logger.info("seg_3_begin_second_effective_collection\uff1a==" + headTwoEffectiveList.get(i));
                }
            }
            if (headTwoEffectiveList.size() > 0) {
                String mixDate2 = this.getMinData(headTwoEffectiveList);
                String maxDate = this.getMaxData(headTwoEffectiveList);
                info.setThreeOnWorkTimeEarliest(mixDate2);
                info.setThreeOnWorkTimeLatest(maxDate);
            }
            if (headTwoEffectiveList.size() > 0) {
                if (headTwoFetchCardType == 1) {
                    String mixDate3 = this.getMinData(headTwoEffectiveList);
                    info.setOneOnWorkTime(mixDate3);
                    headCardList.add(info);
                }
                if (headTwoFetchCardType == 2) {
                    String maxDate = this.getMaxData(headTwoEffectiveList);
                    info.setOneOnWorkTime(maxDate);
                    headCardList.add(info);
                }
            }
        }
        int oneonIsPunchCard = 1;
        if (shiftInfo != null && shiftInfo.getItems().size() == 3) {
            for (int i = 0; i < shiftInfo.getItems().size(); ++i) {
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) != 1) continue;
                oneonIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getPreIsPunchCard().getValue());
            }
        }
        String shiftTime_Oneon = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("firstOnTime");
        shiftTime_Oneon = currentDate + this.split + shiftTime_Oneon;
        boolean bl = isFreeCardCal = cardRuleInfo.isIsFreeCardCal() && headEffectiveList.size() > 0;
        if (oneonIsPunchCard == 0 && !isFreeCardCal) {
            if (headCardList.size() > 0) {
                ((CardRuleResultInfo)headCardList.get(0)).setOneOnWorkTime(shiftTime_Oneon);
            }
            if (headCardList.size() == 0) {
                CardRuleResultInfo infoinner = new CardRuleResultInfo();
                infoinner.setOneOnWorkTime(shiftTime_Oneon);
                infoinner.setThreeSegmentTag(1);
                headCardList.add(infoinner);
            }
        }
        return headCardList;
    }

    public List<CardRuleResultInfo> getThreeSegmentTailCardDataInfo(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap) {
        boolean isFreeCardCal;
        Date oneFetchCardEndDate;
        Date oneFetchCardBeginDate;
        Date compareDate;
        int i;
        ArrayList nextList;
        ArrayList currList;
        if (shiftInfo != null) {
            this.thirdOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOffTime");
        }
        BigDecimal startBigDecimalOneTail = new BigDecimal("2.00");
        BigDecimal endBigDecimalOneTail = new BigDecimal("1.50");
        int tailOneFetchCardType = 2;
        int tailTwoFetchCardType = 2;
        BigDecimal startBigDecimalTwo = new BigDecimal("3.00");
        BigDecimal endBigDecimalTwo = new BigDecimal("1.90");
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegAftFirStartNum() != null) {
                startBigDecimalOneTail = cardRuleInfo.getSegAftFirStartNum();
            }
            if (cardRuleInfo.getSegAftFirEndNum() != null) {
                endBigDecimalOneTail = cardRuleInfo.getSegAftFirEndNum();
            }
            if (cardRuleInfo.getSegAftFirtakeCardType() != null) {
                tailOneFetchCardType = cardRuleInfo.getSegAftFirtakeCardType().getValue();
            }
            if (cardRuleInfo.getSegAftSecStartNum() != null) {
                startBigDecimalTwo = cardRuleInfo.getSegAftSecStartNum();
            }
            if (cardRuleInfo.getSegAftSecEndNum() != null) {
                endBigDecimalTwo = cardRuleInfo.getSegAftSecEndNum();
            }
            if (cardRuleInfo.getSegAftSectakeCardType() != null) {
                tailTwoFetchCardType = cardRuleInfo.getSegAftSectakeCardType().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> tailCardList = new ArrayList<CardRuleResultInfo>();
        ArrayList tailList = new ArrayList();
        BigDecimal threeOffTime = new BigDecimal(AtsDateUtils.getHourFromShiftString(this.thirdOffTime));
        Map<String, Object> map = this.getSomeSectionTimeByHoursWithBaseDate(ctx, startBigDecimalOneTail, endBigDecimalOneTail, threeOffTime, this.baseDate);
        if (this.sqlOutOn) {
            this.logger.info("seg_3_first_end_expand_start_start\uff1a" + map.get("startTime") + " seg_3_first_end_expand_start_end:" + map.get("endTime"));
        }
        if (threeOffTime.add(endBigDecimalOneTail).doubleValue() > 24.0) {
            currList = new ArrayList();
            nextList = new ArrayList();
            if (list.size() > 0) {
                String mindate = AtsDateUtils.getDateFromLongString(this.getMinData(list));
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    String compareDateString = AtsDateUtils.getDateFromLongString((String)list.get(i2));
                    if (AtsDateUtils.stringToShortDate(compareDateString).getTime() == AtsDateUtils.stringToShortDate(mindate).getTime()) {
                        currList.add(list.get(i2));
                        continue;
                    }
                    nextList.add(list.get(i2));
                }
            }
            for (i = 0; i < currList.size(); ++i) {
                String date_suffix = AtsDateUtils.getTimeFromLongString((String)currList.get(i));
                String compdate = AtsDateUtils.getDateFromLongString((String)currList.get(i));
                compareDate = AtsDateUtils.stringToLongDate(this.baseDate + this.split + date_suffix);
                if (AtsDateUtils.stringToShortDate(compdate).getTime() > AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                    compareDate = AtsDateUtils.stringToLongDate(this.baseNextDate + this.split + date_suffix);
                }
                oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("startTime"));
                oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("endTime"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                tailList.add(currList.get(i));
            }
            for (i = 0; i < nextList.size(); ++i) {
                String date_suffix = AtsDateUtils.getTimeFromLongString((String)nextList.get(i));
                String compareBaseDate = this.baseDate;
                if (threeOffTime.add(endBigDecimalOneTail).doubleValue() > 24.0) {
                    compareBaseDate = AtsDateUtils.getNextDay(this.baseDate);
                }
                compareDate = AtsDateUtils.stringToLongDate(compareBaseDate + this.split + date_suffix);
                oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("startTime"));
                oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("endTime"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                tailList.add(nextList.get(i));
            }
        } else {
            currList = new ArrayList();
            nextList = new ArrayList();
            if (list.size() > 0) {
                for (int j = 0; j < list.size(); ++j) {
                    String compareDateString = AtsDateUtils.getDateFromLongString((String)list.get(j));
                    if (AtsDateUtils.stringToShortDate(compareDateString).getTime() == AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                        currList.add(list.get(j));
                        continue;
                    }
                    if (AtsDateUtils.stringToShortDate(compareDateString).getTime() <= AtsDateUtils.stringToShortDate(currentDate).getTime()) continue;
                    nextList.add(list.get(j));
                }
            }
            for (i = 0; i < currList.size(); ++i) {
                String date_suffix = AtsDateUtils.getTimeFromLongString((String)currList.get(i));
                String compare_Date = this.baseDate + this.split + date_suffix;
                compareDate = AtsDateUtils.stringToLongDate(compare_Date);
                oneFetchCardBeginDate = AtsDateUtils.stringToLongDate((String)map.get("startTime"));
                oneFetchCardEndDate = AtsDateUtils.stringToLongDate((String)map.get("endTime"));
                if (compareDate.getTime() < oneFetchCardBeginDate.getTime() || compareDate.getTime() > oneFetchCardEndDate.getTime()) continue;
                tailList.add(currList.get(i));
            }
        }
        List tailEffectiveList = this.getEffectivePunchData(tailList);
        if (this.sqlOutOn) {
            this.logger.info("seg_3_end_first_effective_collection" + tailEffectiveList.size());
            for (int i3 = 0; i3 < tailEffectiveList.size(); ++i3) {
                this.logger.info("seg_3_end_first_effective_collection==" + tailEffectiveList.get(i3));
            }
        }
        CardRuleResultInfo info = new CardRuleResultInfo();
        if (tailEffectiveList.size() > 0) {
            ArrayList overShiftList = new ArrayList();
            String mixDate = null;
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            if (scheduleShiftHasEntryTag == 1) {
                for (int i4 = 0; i4 < tailEffectiveList.size(); ++i4) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)tailEffectiveList.get(i4));
                    String calBaseDate = this.baseDate;
                    if (threeOffTime.add(endBigDecimalOneTail).doubleValue() > 24.0) {
                        calBaseDate = AtsDateUtils.getNextDay(this.baseDate);
                    }
                    Date compareValue = AtsDateUtils.stringToLongDate(calBaseDate + this.split + date_suffix);
                    Date shiftDateValue = AtsDateUtils.stringToLongDate(this.baseDate + this.split + this.thirdOffTime);
                    if (compareValue.getTime() < shiftDateValue.getTime()) continue;
                    overShiftList.add(tailEffectiveList.get(i4));
                }
                mixDate = this.getMinData(overShiftList);
            } else {
                mixDate = this.getMinData(tailEffectiveList);
            }
            String maxDate = this.getMaxData(tailEffectiveList);
            info.setThreeOffWorkTimeEarliest(mixDate);
            info.setThreeOffWorkTimeLatest(maxDate);
        }
        if (tailEffectiveList.size() > 0) {
            if (tailOneFetchCardType == 1) {
                String mixDate = this.getMinData(tailEffectiveList);
                info.setThreeOffWorkTime(mixDate);
                tailCardList.add(info);
            }
            if (tailOneFetchCardType == 2) {
                String maxDate = this.getMaxData(tailEffectiveList);
                info.setThreeOffWorkTime(maxDate);
                tailCardList.add(info);
            }
        }
        ArrayList tailTwoList = new ArrayList();
        if (tailEffectiveList.size() == 0) {
            Date oneFetchCardEndDate2;
            Date oneFetchCardBeginDate2;
            Date compareDate2;
            int i5;
            ArrayList nextList2;
            ArrayList currList2;
            Map<String, Object> mapTwo = this.getSomeSectionTimeByHoursWithBaseDate(ctx, startBigDecimalTwo, endBigDecimalTwo, threeOffTime, this.baseDate);
            if (this.sqlOutOn) {
                this.logger.info("seg_3_end_second_expand_start_start\uff1a" + mapTwo.get("startTime") + " seg_3_end_second_expand_start_end:" + mapTwo.get("endTime"));
            }
            if (threeOffTime.add(endBigDecimalTwo).doubleValue() > 24.0) {
                currList2 = new ArrayList();
                nextList2 = new ArrayList();
                if (list.size() > 0) {
                    String mindate = AtsDateUtils.getDateFromLongString(this.getMinData(list));
                    for (int i6 = 0; i6 < list.size(); ++i6) {
                        String compareDateString = AtsDateUtils.getDateFromLongString((String)list.get(i6));
                        if (AtsDateUtils.stringToShortDate(compareDateString).getTime() == AtsDateUtils.stringToShortDate(mindate).getTime()) {
                            currList2.add(list.get(i6));
                            continue;
                        }
                        nextList2.add(list.get(i6));
                    }
                }
                for (i5 = 0; i5 < currList2.size(); ++i5) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)currList2.get(i5));
                    Date compareDate3 = AtsDateUtils.stringToLongDate(this.baseDate + this.split + date_suffix);
                    Date oneFetchCardBeginDate3 = AtsDateUtils.stringToLongDate((String)mapTwo.get("startTime"));
                    Date oneFetchCardEndDate3 = AtsDateUtils.stringToLongDate((String)mapTwo.get("endTime"));
                    if (compareDate3.getTime() < oneFetchCardBeginDate3.getTime() || compareDate3.getTime() > oneFetchCardEndDate3.getTime()) continue;
                    tailTwoList.add(currList2.get(i5));
                }
                for (i5 = 0; i5 < nextList2.size(); ++i5) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)nextList2.get(i5));
                    String compareBaseDate = this.baseDate;
                    if (threeOffTime.add(endBigDecimalTwo).doubleValue() > 24.0) {
                        compareBaseDate = AtsDateUtils.getNextDay(this.baseDate);
                    }
                    compareDate2 = AtsDateUtils.stringToLongDate(compareBaseDate + this.split + date_suffix);
                    oneFetchCardBeginDate2 = AtsDateUtils.stringToLongDate((String)mapTwo.get("startTime"));
                    oneFetchCardEndDate2 = AtsDateUtils.stringToLongDate((String)mapTwo.get("endTime"));
                    if (compareDate2.getTime() < oneFetchCardBeginDate2.getTime() || compareDate2.getTime() > oneFetchCardEndDate2.getTime()) continue;
                    tailTwoList.add(nextList2.get(i5));
                }
            } else {
                currList2 = new ArrayList();
                nextList2 = new ArrayList();
                if (list.size() > 0) {
                    for (int j = 0; j < list.size(); ++j) {
                        String compareDateString = AtsDateUtils.getDateFromLongString((String)list.get(j));
                        if (AtsDateUtils.stringToShortDate(compareDateString).getTime() == AtsDateUtils.stringToShortDate(currentDate).getTime()) {
                            currList2.add(list.get(j));
                            continue;
                        }
                        if (AtsDateUtils.stringToShortDate(compareDateString).getTime() <= AtsDateUtils.stringToShortDate(currentDate).getTime()) continue;
                        nextList2.add(list.get(j));
                    }
                }
                for (i5 = 0; i5 < currList2.size(); ++i5) {
                    String date_suffix = AtsDateUtils.getTimeFromLongString((String)currList2.get(i5));
                    String compare_Date = this.baseDate + this.split + date_suffix;
                    compareDate2 = AtsDateUtils.stringToLongDate(compare_Date);
                    oneFetchCardBeginDate2 = AtsDateUtils.stringToLongDate((String)mapTwo.get("startTime"));
                    oneFetchCardEndDate2 = AtsDateUtils.stringToLongDate((String)mapTwo.get("endTime"));
                    if (compareDate2.getTime() < oneFetchCardBeginDate2.getTime() || compareDate2.getTime() > oneFetchCardEndDate2.getTime()) continue;
                    tailTwoList.add(currList2.get(i5));
                }
            }
            List tailTwoEffectiveList = this.getEffectivePunchData(tailTwoList);
            if (this.sqlOutOn) {
                this.logger.info("seg_3_end_second_effective_collection\uff1a" + tailTwoEffectiveList.size());
                for (int i7 = 0; i7 < tailTwoEffectiveList.size(); ++i7) {
                    this.logger.info("seg_3_end_second_effective_collection\uff1a" + tailTwoEffectiveList.get(i7));
                }
            }
            if (tailTwoEffectiveList.size() > 0) {
                String mixDate = this.getMinData(tailTwoEffectiveList);
                String maxDate = this.getMaxData(tailTwoEffectiveList);
                info.setThreeOffWorkTimeEarliest(mixDate);
                info.setThreeOffWorkTimeLatest(maxDate);
            }
            if (tailTwoEffectiveList.size() > 0) {
                if (tailTwoFetchCardType == 1) {
                    String mixDate = this.getMinData(tailTwoEffectiveList);
                    info.setThreeOffWorkTime(mixDate);
                    tailCardList.add(info);
                }
                if (tailTwoFetchCardType == 2) {
                    String maxDate = this.getMaxData(tailTwoEffectiveList);
                    info.setThreeOffWorkTime(maxDate);
                    tailCardList.add(info);
                }
            }
        }
        int threeoffIsPunchCard = 1;
        if (shiftInfo != null && shiftInfo.getItems().size() == 3) {
            for (int i8 = 0; i8 < shiftInfo.getItems().size(); ++i8) {
                if (Integer.parseInt(shiftInfo.getItems().get(i8).getSegment().getValue()) != 3) continue;
                threeoffIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i8).getNextIsPunchCard().getValue());
            }
        }
        String shiftTime_Threeoff = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOffTime");
        shiftTime_Threeoff = currentDate + this.split + shiftTime_Threeoff;
        boolean bl = isFreeCardCal = cardRuleInfo.isIsFreeCardCal() && tailEffectiveList.size() > 0;
        if (threeoffIsPunchCard == 0 && !isFreeCardCal) {
            if (tailCardList.size() > 0) {
                ((CardRuleResultInfo)tailCardList.get(0)).setThreeOffWorkTime(shiftTime_Threeoff);
            }
            if (tailCardList.size() == 0) {
                CardRuleResultInfo infoinner = new CardRuleResultInfo();
                infoinner.setThreeOffWorkTime(shiftTime_Threeoff);
                infoinner.setThreeSegmentTag(1);
                tailCardList.add(infoinner);
            }
        }
        return tailCardList;
    }

    public List<CardRuleResultInfo> getThreeSegmentPunchCardDateInfo(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap) {
        CardRuleResultInfo pojoUse;
        CardRuleResultInfo two;
        String mixDate;
        String mixDate2;
        if (shiftInfo != null) {
            this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOnTime");
            this.firstOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("firstOffTime");
            this.secondOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("secondOnTime");
            this.secondOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("secondOffTime");
            this.thirdOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOnTime");
            this.thirdOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOffTime");
            this.firstOnworkTime = this.baseDate + this.split + this.firstOnTime;
            this.firstOffworkTime = this.baseDate + this.split + this.firstOffTime;
            this.secondOnworkTime = this.baseDate + this.split + this.secondOnTime;
            this.secondOffworkTime = this.baseDate + this.split + this.secondOffTime;
            this.thirdOnworkTime = this.baseDate + this.split + this.thirdOnTime;
            this.thirdOffworkTime = this.baseDate + this.split + this.thirdOffTime;
        }
        if (cardRuleInfo != null) {
            if (cardRuleInfo.getTimeInterval() != null) {
                this.timeInterval = cardRuleInfo.getTimeInterval().toString();
            }
            if (cardRuleInfo.getSegFirAssignType() != null) {
                this.segOneAssignType = cardRuleInfo.getSegFirAssignType().getValue();
            }
            if (cardRuleInfo.getSegFirAssignSegment() != null) {
                this.segOneAssignValue = cardRuleInfo.getSegFirAssignSegment().getValue();
            }
            if (cardRuleInfo.getSegSecAssignType() != null) {
                this.segTwoAssignType = cardRuleInfo.getSegSecAssignType().getValue();
            }
            if (cardRuleInfo.getSegSecAssignSegment() != null) {
                this.segTwoAssignValue = cardRuleInfo.getSegSecAssignSegment().getValue();
            }
        }
        ArrayList<CardRuleResultInfo> getCardList = new ArrayList<CardRuleResultInfo>();
        int oneoffIsPunchCard = 1;
        int twoonIsPunchCard = 1;
        int twooffIsPunchCard = 1;
        int threeonIsPunchCard = 1;
        String preTime = "";
        String nextTime = "";
        if (shiftInfo != null && shiftInfo.getItems().size() == 3) {
            for (int i = 0; i < shiftInfo.getItems().size(); ++i) {
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) == 1) {
                    oneoffIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getNextIsPunchCard().getValue());
                }
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) == 2) {
                    twoonIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getPreIsPunchCard().getValue());
                    twooffIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getNextIsPunchCard().getValue());
                }
                if (Integer.parseInt(shiftInfo.getItems().get(i).getSegment().getValue()) != 3) continue;
                threeonIsPunchCard = Integer.parseInt(shiftInfo.getItems().get(i).getPreIsPunchCard().getValue());
            }
        }
        String shiftTime_Oneoff = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("firstOffTime");
        String shiftTime_Twoon = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("secondOnTime");
        String shiftTime_Twooff = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("secondOffTime");
        String shiftTime_Threeon = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOnTime");
        shiftTime_Oneoff = currentDate + this.split + shiftTime_Oneoff;
        shiftTime_Twoon = currentDate + this.split + shiftTime_Twoon;
        shiftTime_Twooff = currentDate + this.split + shiftTime_Twooff;
        shiftTime_Threeon = currentDate + this.split + shiftTime_Threeon;
        ArrayList segIntervalList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)list.get(i));
            String compareDate = this.baseDate + this.split + date_suffix;
            Date resDate = AtsDateUtils.stringToLongDate(compareDate);
            Date shiftFirstOffDate = AtsDateUtils.stringToLongDate(this.firstOffworkTime);
            Date shiftSecondOnDate = AtsDateUtils.stringToLongDate(this.secondOnworkTime);
            if (resDate.getTime() < shiftFirstOffDate.getTime() || resDate.getTime() > shiftSecondOnDate.getTime()) continue;
            segIntervalList.add(list.get(i));
        }
        List segIntervalEffectiveList = this.getEffectivePunchData(segIntervalList);
        if (this.sqlOutOn) {
            this.logger.info("seg_3_shift_start:" + this.firstOffworkTime + " seg_3_shift_end" + this.secondOnworkTime);
            this.logger.info("seg_3_intersec_effective_collection\uff1a" + segIntervalEffectiveList.size());
            for (int i = 0; i < segIntervalEffectiveList.size(); ++i) {
                this.logger.info("seg_3_intersec_effective_collection\uff1a " + segIntervalEffectiveList.get(i));
            }
        }
        if (segIntervalEffectiveList.size() >= 2) {
            CardRuleResultInfo info = new CardRuleResultInfo();
            mixDate2 = this.getMinData(segIntervalEffectiveList);
            String maxDate = this.getMaxData(segIntervalEffectiveList);
            info.setOneOffWorkTime(mixDate2);
            info.setTwoOnWorkTime(maxDate);
            info.setThreeSegmentTag(1);
            getCardList.add(info);
        }
        if (segIntervalEffectiveList.size() == 1) {
            if (this.segOneAssignType == 1) {
                if (this.segOneAssignValue == 1) {
                    CardRuleResultInfo info = new CardRuleResultInfo();
                    mixDate2 = (String)segIntervalEffectiveList.get(0);
                    info.setOneOffWorkTime(mixDate2);
                    info.setThreeSegmentTag(1);
                    getCardList.add(info);
                } else if (this.segOneAssignValue == 2) {
                    CardRuleResultInfo info = new CardRuleResultInfo();
                    mixDate2 = (String)segIntervalEffectiveList.get(0);
                    info.setTwoOnWorkTime(mixDate2);
                    info.setThreeSegmentTag(1);
                    getCardList.add(info);
                }
            }
            if (this.segOneAssignType == 2) {
                CardRuleResultInfo info;
                String interDatasString = (String)segIntervalEffectiveList.get(0);
                int res = this.getIntervalTimeWichNearly(this.firstOffworkTime, this.secondOnworkTime, interDatasString);
                if (res == 1) {
                    info = new CardRuleResultInfo();
                    info.setOneOffWorkTime(interDatasString);
                    info.setThreeSegmentTag(1);
                    getCardList.add(info);
                } else if (res == 2) {
                    info = new CardRuleResultInfo();
                    info.setTwoOnWorkTime(interDatasString);
                    info.setThreeSegmentTag(1);
                    getCardList.add(info);
                } else if (res == 3) {
                    info = new CardRuleResultInfo();
                    info.setOneOffWorkTime(interDatasString);
                    info.setThreeSegmentTag(1);
                    getCardList.add(info);
                }
            }
        }
        if (segIntervalEffectiveList.size() == 0) {
            // empty if block
        }
        boolean isFreeCardCal = this.isFreeCardCalForThree1(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap, segIntervalEffectiveList, getCardList, oneoffIsPunchCard, twoonIsPunchCard);
        if (oneoffIsPunchCard == 0 && twoonIsPunchCard == 1 && !isFreeCardCal) {
            if (getCardList.size() > 0) {
                ((CardRuleResultInfo)getCardList.get(0)).setOneOffWorkTime(shiftTime_Oneoff);
            }
            if (getCardList.size() == 0) {
                CardRuleResultInfo info = new CardRuleResultInfo();
                info.setOneOffWorkTime(shiftTime_Oneoff);
                info.setThreeSegmentTag(1);
                getCardList.add(info);
            }
        }
        if (oneoffIsPunchCard == 1 && twoonIsPunchCard == 0 && !isFreeCardCal) {
            if (getCardList.size() > 0) {
                ((CardRuleResultInfo)getCardList.get(0)).setTwoOnWorkTime(shiftTime_Twoon);
            }
            if (getCardList.size() == 0) {
                CardRuleResultInfo info = new CardRuleResultInfo();
                info.setTwoOnWorkTime(shiftTime_Twoon);
                info.setThreeSegmentTag(1);
                getCardList.add(info);
            }
        }
        if (oneoffIsPunchCard == 0 && twoonIsPunchCard == 0 && !isFreeCardCal) {
            if (getCardList.size() > 0) {
                ((CardRuleResultInfo)getCardList.get(0)).setOneOffWorkTime(shiftTime_Oneoff);
                ((CardRuleResultInfo)getCardList.get(0)).setTwoOnWorkTime(shiftTime_Twoon);
            }
            if (getCardList.size() == 0) {
                CardRuleResultInfo info = new CardRuleResultInfo();
                info.setOneOffWorkTime(shiftTime_Oneoff);
                info.setTwoOnWorkTime(shiftTime_Twoon);
                info.setThreeSegmentTag(1);
                getCardList.add(info);
            }
        }
        ArrayList segSecondIntervalList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String date_suffix = AtsDateUtils.getTimeFromLongString((String)list.get(i));
            String compareDate = this.baseDate + this.split + date_suffix;
            Date resDate = AtsDateUtils.stringToLongDate(compareDate);
            Date shiftSecondOffDate = AtsDateUtils.stringToLongDate(this.secondOffworkTime);
            Date shiftThirdOnDate = AtsDateUtils.stringToLongDate(this.thirdOnworkTime);
            if (resDate.getTime() < shiftSecondOffDate.getTime() || resDate.getTime() > shiftThirdOnDate.getTime()) continue;
            segSecondIntervalList.add(list.get(i));
        }
        List segSecondIntervalEffectiveList = this.getEffectivePunchData(segSecondIntervalList);
        if (this.sqlOutOn) {
            this.logger.info("seg_3_intersec_2_shift_start\uff1a" + this.secondOffworkTime + " seg_3_intersec_2_shift_end\uff1a" + this.thirdOnworkTime);
            this.logger.info("seg_3_intersec_2_effective_collection\uff1a" + segSecondIntervalEffectiveList.size());
            this.logger.info(" -------------------------------- ");
            for (int i = 0; i < segSecondIntervalEffectiveList.size(); ++i) {
                this.logger.info("seg_3_intersec_2_effective_collection\uff1a" + segSecondIntervalEffectiveList.get(i));
            }
        }
        if (segSecondIntervalEffectiveList.size() >= 2) {
            CardRuleResultInfo info = new CardRuleResultInfo();
            mixDate = this.getMinData(segSecondIntervalEffectiveList);
            String maxDate = this.getMaxData(segSecondIntervalEffectiveList);
            info.setTwoOffWorkTime(mixDate);
            info.setThreeOnWorkTime(maxDate);
            info.setThreeSegmentTag(2);
            getCardList.add(info);
        }
        if (segSecondIntervalEffectiveList.size() == 1) {
            if (this.segTwoAssignType == 1) {
                if (this.segTwoAssignValue == 3) {
                    CardRuleResultInfo info = new CardRuleResultInfo();
                    mixDate = (String)segSecondIntervalEffectiveList.get(0);
                    info.setTwoOffWorkTime(mixDate);
                    info.setThreeSegmentTag(2);
                    getCardList.add(info);
                } else if (this.segTwoAssignValue == 4) {
                    CardRuleResultInfo info = new CardRuleResultInfo();
                    mixDate = (String)segSecondIntervalEffectiveList.get(0);
                    info.setThreeOnWorkTime(mixDate);
                    info.setThreeSegmentTag(2);
                    getCardList.add(info);
                }
            }
            if (this.segTwoAssignType == 2) {
                CardRuleResultInfo info;
                String interDatasString = (String)segSecondIntervalEffectiveList.get(0);
                int res = this.getIntervalTimeWichNearly(this.secondOffworkTime, this.thirdOnworkTime, interDatasString);
                if (res == 1) {
                    info = new CardRuleResultInfo();
                    info.setTwoOffWorkTime(interDatasString);
                    info.setThreeSegmentTag(2);
                    getCardList.add(info);
                } else if (res == 2) {
                    info = new CardRuleResultInfo();
                    info.setThreeOnWorkTime(interDatasString);
                    info.setThreeSegmentTag(2);
                    getCardList.add(info);
                } else if (res == 3) {
                    info = new CardRuleResultInfo();
                    info.setTwoOffWorkTime(interDatasString);
                    info.setThreeSegmentTag(2);
                    getCardList.add(info);
                }
            }
        }
        if (segSecondIntervalEffectiveList.size() == 0) {
            // empty if block
        }
        isFreeCardCal = this.isFreeCardCalForThree2(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap, segSecondIntervalEffectiveList, getCardList, twooffIsPunchCard, threeonIsPunchCard);
        if (twooffIsPunchCard == 0 && threeonIsPunchCard == 1 && !isFreeCardCal) {
            if (getCardList.size() > 1) {
                ((CardRuleResultInfo)getCardList.get(1)).setTwoOffWorkTime(shiftTime_Twooff);
            }
            if (getCardList.size() == 1) {
                if (((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 1) {
                    CardRuleResultInfo info = new CardRuleResultInfo();
                    info.setTwoOffWorkTime(shiftTime_Twooff);
                    info.setThreeSegmentTag(2);
                    getCardList.add(info);
                }
                if (((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 2) {
                    ((CardRuleResultInfo)getCardList.get(0)).setTwoOffWorkTime(shiftTime_Twooff);
                }
            }
            if (getCardList.size() == 0) {
                ArrayList<CardRuleResultInfo> tempList = new ArrayList<CardRuleResultInfo>();
                CardRuleResultInfo one = new CardRuleResultInfo();
                one.setThreeSegmentTag(1);
                two = new CardRuleResultInfo();
                two.setThreeSegmentTag(2);
                tempList.add(one);
                tempList.add(two);
                pojoUse = null;
                for (int m = 0; m < tempList.size(); ++m) {
                    if (((CardRuleResultInfo)tempList.get(m)).getThreeSegmentTag() != 2) continue;
                    pojoUse = (CardRuleResultInfo)tempList.get(m);
                }
                if (pojoUse != null) {
                    pojoUse.setTwoOffWorkTime(shiftTime_Twooff);
                }
                getCardList.add(one);
                getCardList.add(pojoUse);
            }
        }
        if (twooffIsPunchCard == 1 && threeonIsPunchCard == 0 && !isFreeCardCal) {
            if (getCardList.size() > 1) {
                ((CardRuleResultInfo)getCardList.get(1)).setThreeOnWorkTime(shiftTime_Threeon);
            }
            if (getCardList.size() == 1) {
                if (((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 1) {
                    CardRuleResultInfo info = new CardRuleResultInfo();
                    info.setThreeOnWorkTime(shiftTime_Threeon);
                    info.setThreeSegmentTag(2);
                    getCardList.add(info);
                }
                if (((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 2) {
                    ((CardRuleResultInfo)getCardList.get(0)).setThreeOnWorkTime(shiftTime_Threeon);
                }
            }
            if (getCardList.size() == 0) {
                ArrayList<CardRuleResultInfo> tempList = new ArrayList<CardRuleResultInfo>();
                CardRuleResultInfo one = new CardRuleResultInfo();
                one.setThreeSegmentTag(1);
                two = new CardRuleResultInfo();
                two.setThreeSegmentTag(2);
                tempList.add(one);
                tempList.add(two);
                pojoUse = null;
                for (int m = 0; m < tempList.size(); ++m) {
                    if (((CardRuleResultInfo)tempList.get(m)).getThreeSegmentTag() != 2) continue;
                    pojoUse = (CardRuleResultInfo)tempList.get(m);
                }
                if (pojoUse != null) {
                    pojoUse.setThreeOnWorkTime(shiftTime_Threeon);
                }
                getCardList.add(one);
                getCardList.add(pojoUse);
            }
        }
        if (twooffIsPunchCard == 0 && threeonIsPunchCard == 0 && !isFreeCardCal) {
            if (getCardList.size() > 1) {
                ((CardRuleResultInfo)getCardList.get(1)).setTwoOffWorkTime(shiftTime_Twooff);
                ((CardRuleResultInfo)getCardList.get(1)).setThreeOnWorkTime(shiftTime_Threeon);
            }
            if (getCardList.size() == 1) {
                if (((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 1) {
                    CardRuleResultInfo info = new CardRuleResultInfo();
                    info.setTwoOffWorkTime(shiftTime_Twooff);
                    info.setThreeOnWorkTime(shiftTime_Threeon);
                    info.setThreeSegmentTag(2);
                    getCardList.add(info);
                }
                if (((CardRuleResultInfo)getCardList.get(0)).getThreeSegmentTag() == 2) {
                    ((CardRuleResultInfo)getCardList.get(0)).setTwoOffWorkTime(shiftTime_Twooff);
                    ((CardRuleResultInfo)getCardList.get(0)).setThreeOnWorkTime(shiftTime_Threeon);
                }
            }
            if (getCardList.size() == 0) {
                ArrayList<CardRuleResultInfo> tempList = new ArrayList<CardRuleResultInfo>();
                CardRuleResultInfo one = new CardRuleResultInfo();
                one.setThreeSegmentTag(1);
                two = new CardRuleResultInfo();
                two.setThreeSegmentTag(2);
                tempList.add(one);
                tempList.add(two);
                pojoUse = null;
                for (int m = 0; m < tempList.size(); ++m) {
                    if (((CardRuleResultInfo)tempList.get(m)).getThreeSegmentTag() != 2) continue;
                    pojoUse = (CardRuleResultInfo)tempList.get(m);
                }
                if (pojoUse != null) {
                    pojoUse.setTwoOffWorkTime(shiftTime_Twooff);
                    pojoUse.setThreeOnWorkTime(shiftTime_Threeon);
                }
                getCardList.add(one);
                getCardList.add(pojoUse);
            }
        }
        return getCardList;
    }

    public Map<String, Object> getSomeSectionTimeByHoursWithBaseDate(Context ctx, BigDecimal startHour, BigDecimal endHour, BigDecimal shiftHour, String baseDate) {
        HashMap<String, Object> withBaseDateMap = new HashMap<String, Object>();
        Map<String, Object> noBaseDateMap = this.getSomeSectionTimeByHours(ctx, startHour, endHour, shiftHour);
        String srart = baseDate + this.split + (String)noBaseDateMap.get("startTime");
        String nextBaseDate = baseDate;
        if (shiftHour.add(endHour).doubleValue() > 24.0) {
            Date nextDate = AtsDateUtils.getNextDay(AtsDateUtils.stringToShortDate(baseDate));
            nextBaseDate = AtsDateUtils.dateShortToString(nextDate);
        } else {
            nextBaseDate = baseDate;
        }
        String end = nextBaseDate + this.split + (String)noBaseDateMap.get("endTime");
        withBaseDateMap.put("startTime", srart);
        withBaseDateMap.put("endTime", end);
        return withBaseDateMap;
    }

    public Map<String, Object> getSomeSectionTimeByHours(Context ctx, BigDecimal startHour, BigDecimal endHour, BigDecimal shiftHour) {
        Map mapTemp;
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        if (startHour.floatValue() >= 0.0f && endHour.floatValue() >= 0.0f) {
            mapTemp = this.getStartTimeEndTime(ctx, startHour, endHour, shiftHour);
            resMap.put("startTime", mapTemp.get("start_Time"));
            resMap.put("endTime", mapTemp.get("end_Time"));
        }
        if (startHour.floatValue() >= 0.0f && endHour.floatValue() < 0.0f) {
            mapTemp = this.getStartTimeEndTime(ctx, startHour, endHour, shiftHour);
            resMap.put("startTime", mapTemp.get("start_Time"));
            resMap.put("endTime", mapTemp.get("end_Time"));
        }
        if (startHour.floatValue() < 0.0f && endHour.floatValue() >= 0.0f) {
            mapTemp = this.getStartTimeEndTime(ctx, startHour, endHour, shiftHour);
            resMap.put("startTime", mapTemp.get("start_Time"));
            resMap.put("endTime", mapTemp.get("end_Time"));
        }
        if (startHour.floatValue() < 0.0f && endHour.floatValue() < 0.0f) {
            mapTemp = this.getStartTimeEndTime(ctx, startHour, endHour, shiftHour);
            resMap.put("startTime", mapTemp.get("start_Time"));
            resMap.put("endTime", mapTemp.get("end_Time"));
        }
        return resMap;
    }

    public Map getStartTimeEndTime(Context ctx, BigDecimal startHour, BigDecimal endHour, BigDecimal shiftHour) {
        HashMap<String, String> res_map = new HashMap<String, String>();
        BigDecimal start_value = shiftHour.subtract(startHour);
        if (start_value.doubleValue() < 0.0) {
            start_value = BigDecimal.valueOf(0L);
        }
        start_value = this.decimalPlacesSystem.precisionConvert(ctx, start_value, RoundingMode.HALF_UP);
        BigDecimal end_value = shiftHour.add(endHour);
        if (end_value.doubleValue() == 24.0) {
            end_value = BigDecimal.valueOf(23.9999);
        }
        String start_Time = AtsDateUtils.getTimeByHourDigital(start_value.doubleValue());
        String end_Time = AtsDateUtils.getTimeByHourDigital(end_value.doubleValue());
        res_map.put("start_Time", start_Time);
        res_map.put("end_Time", end_Time);
        return res_map;
    }

    public int getIntervalTimeWichNearly(String offTime, String onTime, String intervalTime) {
        long x2;
        int returnvalue = 0;
        Date offDate = AtsDateUtils.stringToLongDate(offTime);
        Date onDate = AtsDateUtils.stringToLongDate(onTime);
        String inter_suffix = AtsDateUtils.getTimeFromLongString(intervalTime);
        String interString = this.baseDate + this.split + inter_suffix;
        Date interDate = AtsDateUtils.stringToLongDate(interString);
        long x1 = interDate.getTime() - offDate.getTime();
        if (x1 < (x2 = onDate.getTime() - interDate.getTime())) {
            returnvalue = 1;
        } else if (x1 > x2) {
            returnvalue = 2;
        } else if (x1 == x2) {
            returnvalue = 3;
        }
        return returnvalue;
    }

    public String getMinData(List list) {
        if (list.size() > 0) {
            long min = AtsDateUtils.stringToLongDate((String)list.get(0)).getTime();
            Object minObject = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                long list_value = AtsDateUtils.stringToLongDate((String)list.get(i)).getTime();
                if (list_value >= min) continue;
                long temp = 0L;
                temp = min;
                min = list_value;
                minObject = list.get(i);
                list_value = temp;
            }
            return (String)minObject;
        }
        return null;
    }

    public String getMinDataShort(List list) {
        if (list.size() > 0) {
            long min = AtsDateUtils.stringToShortDate((String)list.get(0)).getTime();
            Object minObject = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                long list_value = AtsDateUtils.stringToShortDate((String)list.get(i)).getTime();
                if (list_value >= min) continue;
                long temp = 0L;
                temp = min;
                min = list_value;
                minObject = list.get(i);
                list_value = temp;
            }
            return (String)minObject;
        }
        return null;
    }

    public String getMaxData(List list) {
        if (list.size() > 0) {
            long min = AtsDateUtils.stringToLongDate((String)list.get(0)).getTime();
            Object maxObject = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                long list_value = AtsDateUtils.stringToLongDate((String)list.get(i)).getTime();
                if (list_value <= min) continue;
                long temp = 0L;
                temp = min;
                min = list_value;
                maxObject = list.get(i);
                list_value = temp;
            }
            return (String)maxObject;
        }
        return null;
    }

    public String getMaxDataShort(List list) {
        if (list.size() > 0) {
            long min = AtsDateUtils.stringToShortDate((String)list.get(0)).getTime();
            Object maxObject = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                long list_value = AtsDateUtils.stringToShortDate((String)list.get(i)).getTime();
                if (list_value <= min) continue;
                long temp = 0L;
                temp = min;
                min = list_value;
                maxObject = list.get(i);
                list_value = temp;
            }
            return (String)maxObject;
        }
        return null;
    }

    public List getEffectivePunchData(List segIntervalList) {
        ArrayList<String> resList = new ArrayList<String>();
        if (segIntervalList.size() > 0) {
            String minString = this.getMinData(segIntervalList);
            Date min_Date = AtsDateUtils.stringToLongDate(minString);
            resList.add(minString);
            for (int i = 0; i < segIntervalList.size(); ++i) {
                Date compare_Date = AtsDateUtils.stringToLongDate((String)segIntervalList.get(i));
                this.timeIntervalMillisecond = new BigDecimal(this.timeInterval).longValue() * 60L * 1000L;
                if (compare_Date.getTime() - min_Date.getTime() <= this.timeIntervalMillisecond) continue;
                resList.add((String)segIntervalList.get(i));
            }
        }
        return resList;
    }

    public List<CardRuleResultInfo> getPunchCardDataByCardRuleByOverTimeBill(AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap, Map<Object, Object> globalMap) {
        ArrayList<CardRuleResultInfo> resList = new ArrayList<CardRuleResultInfo>();
        CardRuleServer server = new CardRuleServer();
        List<CardRuleResultInfo> resHeadList = server.getHeadCardDataInfoByOverTime(shiftInfo, cardRuleInfo, list, currentDate, paraMap, globalMap);
        List<CardRuleResultInfo> resTailList = server.getTailCardDataInfoByOverTime(shiftInfo, cardRuleInfo, list, currentDate, paraMap, globalMap);
        CardRuleResultInfo info = new CardRuleResultInfo();
        if (resHeadList.size() > 0) {
            info.setOneOnWorkTime(resHeadList.get(0).getOneOnWorkTime());
            info.setOneOnWorkTimeEarliest(resHeadList.get(0).getOneOnWorkTimeEarliest());
            info.setOneOnWorkTimeLatest(resHeadList.get(0).getOneOnWorkTimeLatest());
        }
        if (resTailList.size() > 0) {
            info.setOneOffWorkTime(resTailList.get(0).getOneOffWorkTime());
            info.setOneOffWorkTimeEarliest(resTailList.get(0).getOneOffWorkTimeEarliest());
            info.setOneOffWorkTimeLatest(resTailList.get(0).getOneOffWorkTimeLatest());
            info.setTwoOffWorkTime(resTailList.get(0).getTwoOffWorkTime());
            info.setTwoOffWorkTimeEarliest(resTailList.get(0).getTwoOffWorkTimeEarliest());
            info.setTwoOffWorkTimeLatest(resTailList.get(0).getTwoOffWorkTimeLatest());
            info.setThreeOffWorkTime(resTailList.get(0).getThreeOffWorkTime());
            info.setThreeOffWorkTimeEarliest(resTailList.get(0).getThreeOffWorkTimeEarliest());
            info.setThreeOffWorkTimeLatest(resTailList.get(0).getThreeOffWorkTimeLatest());
        }
        resList.add(info);
        return resList;
    }

    public List<CardRuleResultInfo> getPunchCardDataByCardRule(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap) {
        String minDate;
        String maxDate;
        List<CardRuleResultInfo> resHeadList;
        int startSegmentShift = 1;
        if (cardRuleInfo != null) {
            startSegmentShift = cardRuleInfo.getStartSegmentNum().getValue();
        }
        CardRuleServer server = new CardRuleServer();
        ArrayList<CardRuleResultInfo> resList = new ArrayList<CardRuleResultInfo>();
        if (startSegmentShift == 1) {
            List<CardRuleResultInfo> resHeadList2 = server.getHeadCardDataInfoOne(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap);
            List<CardRuleResultInfo> resTailList = server.getTailCardDataInfoOne(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap);
            CardRuleResultInfo info = new CardRuleResultInfo();
            if (resHeadList2.size() > 0) {
                info.setOneOnWorkTime(resHeadList2.get(0).getOneOnWorkTime());
                info.setOneOnWorkTimeEarliest(resHeadList2.get(0).getOneOnWorkTimeEarliest());
                info.setOneOnWorkTimeLatest(resHeadList2.get(0).getOneOnWorkTimeLatest());
            }
            if (resTailList.size() > 0) {
                info.setOneOffWorkTime(resTailList.get(0).getOneOffWorkTime());
                info.setOneOffWorkTimeEarliest(resTailList.get(0).getOneOffWorkTimeEarliest());
                info.setOneOffWorkTimeLatest(resTailList.get(0).getOneOffWorkTimeLatest());
            }
            resList.add(info);
        }
        if (startSegmentShift == 2) {
            int compareValue;
            List<CardRuleResultInfo> resIntereList = server.getPunchCardInfoTwo(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap);
            resHeadList = server.getHeadCardDataInfoTwo(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap);
            List<CardRuleResultInfo> resTailList = server.getTailCardDataInfoTwo(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap);
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            CardRuleResultInfo info = new CardRuleResultInfo();
            if (resIntereList.size() > 0) {
                info.setOneOffWorkTime(resIntereList.get(0).getOneOffWorkTime());
                info.setTwoOnWorkTime(resIntereList.get(0).getTwoOnWorkTime());
            }
            if (resHeadList.size() > 0) {
                String oneOnTime_One = resHeadList.get(0).getOneOnWorkTime();
                compareValue = 1;
                if (scheduleShiftHasEntryTag == 1) {
                    compareValue = this.resListIsExistCurrentDate(oneOnTime_One, info);
                }
                if (compareValue == 1) {
                    info.setOneOnWorkTime(resHeadList.get(0).getOneOnWorkTime());
                }
                info.setOneOnWorkTimeEarliest(resHeadList.get(0).getOneOnWorkTimeEarliest());
                info.setOneOnWorkTimeLatest(resHeadList.get(0).getOneOnWorkTimeLatest());
            }
            if (resTailList.size() > 0) {
                String twoOffTime = resTailList.get(0).getTwoOffWorkTime();
                compareValue = 1;
                if (scheduleShiftHasEntryTag == 1) {
                    compareValue = this.resListIsExistCurrentDate(twoOffTime, info);
                }
                if (compareValue == 1) {
                    info.setTwoOffWorkTime(resTailList.get(0).getTwoOffWorkTime());
                }
                info.setTwoOffWorkTimeEarliest(resTailList.get(0).getTwoOffWorkTimeEarliest());
                info.setTwoOffWorkTimeLatest(resTailList.get(0).getTwoOffWorkTimeLatest());
            }
            resList.add(info);
            if (resList.size() > 0) {
                if (shiftInfo != null) {
                    this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOnTime");
                    this.firstOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOffTime");
                    this.secondOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("secondOnTime");
                    this.secondOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("secondOffTime");
                    this.firstOnworkTime = this.baseDate + this.split + this.firstOnTime;
                    this.firstOffworkTime = this.baseDate + this.split + this.firstOffTime;
                    this.secondOnworkTime = this.baseDate + this.split + this.secondOnTime;
                    this.secondOffworkTime = this.baseDate + this.split + this.secondOffTime;
                }
                if (cardRuleInfo != null) {
                    if (cardRuleInfo.getTimeInterval() != null) {
                        this.timeInterval = cardRuleInfo.getTimeInterval().toString();
                    }
                    if (cardRuleInfo.getSegFirAssignType() != null) {
                        this.segOneAssignType = cardRuleInfo.getSegFirAssignType().getValue();
                    }
                    if (cardRuleInfo.getSegFirAssignSegment() != null) {
                        this.segOneAssignValue = cardRuleInfo.getSegFirAssignSegment().getValue();
                    }
                }
                if (StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOffWorkTime())) {
                    maxDate = this.getTwoShiftEffectivePunchCardMaxData(list, this.firstOnworkTime, this.firstOffworkTime);
                    if (this.sqlOutOn) {
                        this.logger.info("seg_3_intersec_1_0_effective_fetch_1_2_max\uff1a" + maxDate);
                    }
                    if ((compareValue = this.resListIsExistCurrentData(maxDate, resList)) != 2) {
                        ((CardRuleResultInfo)resList.get(0)).setOneOffWorkTime(maxDate);
                    }
                }
                if (StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOnWorkTime())) {
                    minDate = this.getTwoShiftEffectivePunchCardMinData(list, this.secondOnworkTime, this.secondOffworkTime);
                    if (this.sqlOutOn) {
                        this.logger.info("seg_3_intersec_1_0_effective_fetch_3_4_min\uff1a" + minDate);
                    }
                    if ((compareValue = this.resListIsExistCurrentData(minDate, resList)) != 2) {
                        ((CardRuleResultInfo)resList.get(0)).setTwoOnWorkTime(minDate);
                    }
                }
            }
            if (resList != null && resList.size() > 0) {
                String t1;
                if (StringUtils.isNotBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOnWorkTime()) && StringUtils.isNotBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOnWorkTime()) && StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOffWorkTime()) && StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOffWorkTime())) {
                    ((CardRuleResultInfo)resList.get(0)).setOneOffWorkTime(((CardRuleResultInfo)resList.get(0)).getTwoOnWorkTime());
                    ((CardRuleResultInfo)resList.get(0)).setTwoOnWorkTime(null);
                }
                if (StringUtils.isNotBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOffWorkTime()) && StringUtils.isNotBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOffWorkTime()) && StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOnWorkTime()) && StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOnWorkTime())) {
                    ((CardRuleResultInfo)resList.get(0)).setTwoOnWorkTime(((CardRuleResultInfo)resList.get(0)).getOneOffWorkTime());
                    ((CardRuleResultInfo)resList.get(0)).setOneOffWorkTime(null);
                }
                if (StringUtils.isNotBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOnWorkTime()) && StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOnWorkTime()) && StringUtils.isNotBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOffWorkTime()) && StringUtils.isNotBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOffWorkTime())) {
                    String maxDate2;
                    t1 = AtsDateUtils.getTimeFromLongString(((CardRuleResultInfo)resList.get(0)).getOneOnWorkTime());
                    String t2 = AtsDateUtils.getTimeFromLongString(((CardRuleResultInfo)resList.get(0)).getOneOffWorkTime());
                    if (this.firstOnTime.compareTo(t1) > 0) {
                        t1 = this.firstOnTime;
                    }
                    if (StringUtils.isNotBlank((String)(maxDate2 = this.getTwoShiftEffectivePunchCardMaxData(list, this.baseDate + this.split + t1, this.baseDate + this.split + t2))) && this.firstOffTime.compareTo(t2) < 0) {
                        ((CardRuleResultInfo)resList.get(0)).setTwoOnWorkTime(((CardRuleResultInfo)resList.get(0)).getOneOffWorkTime());
                        ((CardRuleResultInfo)resList.get(0)).setOneOffWorkTime(maxDate2);
                    }
                }
                if (StringUtils.isNotBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOnWorkTime()) && StringUtils.isNotBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOnWorkTime()) && StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOffWorkTime()) && StringUtils.isNotBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOffWorkTime())) {
                    String minDate2;
                    t1 = AtsDateUtils.getTimeFromLongString(((CardRuleResultInfo)resList.get(0)).getTwoOnWorkTime());
                    String t2 = AtsDateUtils.getTimeFromLongString(((CardRuleResultInfo)resList.get(0)).getTwoOffWorkTime());
                    if (this.secondOffTime.compareTo(t2) < 0) {
                        t2 = this.secondOffTime;
                    }
                    if (StringUtils.isNotBlank((String)(minDate2 = this.getTwoShiftEffectivePunchCardMinData(list, this.baseDate + this.split + t1, this.baseDate + this.split + t2))) && this.secondOnTime.compareTo(t1) > 0) {
                        ((CardRuleResultInfo)resList.get(0)).setOneOffWorkTime(((CardRuleResultInfo)resList.get(0)).getTwoOnWorkTime());
                        ((CardRuleResultInfo)resList.get(0)).setTwoOnWorkTime(minDate2);
                    }
                }
            }
        }
        if (startSegmentShift == 3) {
            List<CardRuleResultInfo> resThreeSegmentIntereList = server.getThreeSegmentPunchCardDateInfo(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap);
            resHeadList = server.getHeadCardDataInfoThree(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap);
            List<CardRuleResultInfo> resThreeSegmentTailList = server.getThreeSegmentTailCardDataInfo(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap);
            CardRuleResultInfo info = new CardRuleResultInfo();
            if (resThreeSegmentIntereList.size() == 1) {
                info.setOneOffWorkTime(resThreeSegmentIntereList.get(0).getOneOffWorkTime());
                info.setTwoOnWorkTime(resThreeSegmentIntereList.get(0).getTwoOnWorkTime());
                info.setTwoOffWorkTime(resThreeSegmentIntereList.get(0).getTwoOffWorkTime());
                info.setThreeOnWorkTime(resThreeSegmentIntereList.get(0).getThreeOnWorkTime());
            }
            if (resThreeSegmentIntereList.size() == 0) {
                // empty if block
            }
            if (resThreeSegmentIntereList.size() == 2) {
                info.setOneOffWorkTime(resThreeSegmentIntereList.get(0).getOneOffWorkTime());
                info.setTwoOnWorkTime(resThreeSegmentIntereList.get(0).getTwoOnWorkTime());
                info.setTwoOffWorkTime(resThreeSegmentIntereList.get(1).getTwoOffWorkTime());
                info.setThreeOnWorkTime(resThreeSegmentIntereList.get(1).getThreeOnWorkTime());
            }
            int scheduleShiftHasEntryTag = Integer.parseInt(paraMap.get("scheduleShiftHasEntryTag"));
            if (resHeadList.size() > 0) {
                String oneOnTime = resHeadList.get(0).getOneOnWorkTime();
                int compareValue = 1;
                if (scheduleShiftHasEntryTag == 1) {
                    compareValue = this.resListIsExistCurrentDate(oneOnTime, info);
                }
                if (compareValue == 1) {
                    info.setOneOnWorkTime(resHeadList.get(0).getOneOnWorkTime());
                }
                info.setOneOnWorkTimeEarliest(resHeadList.get(0).getOneOnWorkTimeEarliest());
                info.setOneOnWorkTimeLatest(resHeadList.get(0).getOneOnWorkTimeLatest());
            }
            if (resThreeSegmentTailList.size() > 0) {
                String threeOffTime = resThreeSegmentTailList.get(0).getThreeOffWorkTime();
                int compareValue = 1;
                if (scheduleShiftHasEntryTag == 1) {
                    compareValue = this.resListIsExistCurrentDate(threeOffTime, info);
                }
                if (compareValue == 1) {
                    info.setThreeOffWorkTime(resThreeSegmentTailList.get(0).getThreeOffWorkTime());
                }
                info.setThreeOffWorkTimeEarliest(resThreeSegmentTailList.get(0).getThreeOffWorkTimeEarliest());
                info.setThreeOffWorkTimeLatest(resThreeSegmentTailList.get(0).getThreeOffWorkTimeLatest());
            }
            resList.add(info);
            if (resList.size() > 0) {
                if (shiftInfo != null) {
                    this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOnTime");
                    this.firstOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("firstOffTime");
                    this.secondOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("secondOnTime");
                    this.secondOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("secondOffTime");
                    this.thirdOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOnTime");
                    this.thirdOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOffTime");
                    this.firstOnworkTime = this.baseDate + this.split + this.firstOnTime;
                    this.firstOffworkTime = this.baseDate + this.split + this.firstOffTime;
                    this.secondOnworkTime = this.baseDate + this.split + this.secondOnTime;
                    this.secondOffworkTime = this.baseDate + this.split + this.secondOffTime;
                    this.thirdOnworkTime = this.baseDate + this.split + this.thirdOnTime;
                    this.thirdOffworkTime = this.baseDate + this.split + this.thirdOffTime;
                }
                if (cardRuleInfo != null) {
                    if (cardRuleInfo.getTimeInterval() != null) {
                        this.timeInterval = cardRuleInfo.getTimeInterval().toString();
                    }
                    if (cardRuleInfo.getSegFirAssignType() != null) {
                        this.segOneAssignType = cardRuleInfo.getSegFirAssignType().getValue();
                    }
                    if (cardRuleInfo.getSegFirAssignSegment() != null) {
                        this.segOneAssignValue = cardRuleInfo.getSegFirAssignSegment().getValue();
                    }
                    if (cardRuleInfo.getSegSecAssignType() != null) {
                        this.segTwoAssignType = cardRuleInfo.getSegSecAssignType().getValue();
                    }
                    if (cardRuleInfo.getSegSecAssignSegment() != null) {
                        this.segTwoAssignValue = cardRuleInfo.getSegSecAssignSegment().getValue();
                    }
                }
                if (StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getOneOffWorkTime())) {
                    int compareValue;
                    maxDate = this.getTwoShiftEffectivePunchCardMaxData(list, this.firstOnworkTime, this.firstOffworkTime);
                    if (this.sqlOutOn) {
                        this.logger.info("seg_3_intersec_1_1_2_0_effective_fetch_1_2_max\uff1a" + maxDate);
                    }
                    if ((compareValue = this.resListIsExistCurrentData(maxDate, resList)) != 2) {
                        ((CardRuleResultInfo)resList.get(0)).setOneOffWorkTime(maxDate);
                    }
                }
                if (StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOnWorkTime())) {
                    int compareValue;
                    minDate = this.getTwoShiftEffectivePunchCardMinData(list, this.secondOnworkTime, this.secondOffworkTime);
                    if (this.sqlOutOn) {
                        this.logger.info("seg_3_intersec_1_3_4_0_effective_fetch_1_2_max\uff1a" + minDate);
                    }
                    if ((compareValue = this.resListIsExistCurrentData(minDate, resList)) != 2) {
                        ((CardRuleResultInfo)resList.get(0)).setTwoOnWorkTime(minDate);
                    }
                }
                if (StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getTwoOffWorkTime())) {
                    int compareValue;
                    String maxDate_Two = this.getTwoShiftEffectivePunchCardMaxData(list, this.secondOnworkTime, this.secondOffworkTime);
                    if (this.sqlOutOn) {
                        this.logger.info("seg_3_intersec_2__0_effective_fetch_3_4_max\uff1a" + maxDate_Two);
                    }
                    if ((compareValue = this.resListIsExistCurrentData(maxDate_Two, resList)) != 2) {
                        ((CardRuleResultInfo)resList.get(0)).setTwoOffWorkTime(maxDate_Two);
                    }
                }
                if (StringUtils.isBlank((String)((CardRuleResultInfo)resList.get(0)).getThreeOnWorkTime())) {
                    int compareValue;
                    String minDate_Two = this.getTwoShiftEffectivePunchCardMinData(list, this.thirdOnworkTime, this.thirdOffworkTime);
                    if (this.sqlOutOn) {
                        this.logger.info("seg_3_intersec_2_0_effective_fetch_5_6_max\uff1a" + minDate_Two);
                    }
                    if ((compareValue = this.resListIsExistCurrentData(minDate_Two, resList)) != 2) {
                        ((CardRuleResultInfo)resList.get(0)).setThreeOnWorkTime(minDate_Two);
                    }
                }
            }
            this.amendAbsentForThree(shiftInfo, resList, list);
        }
        return resList;
    }

    public int resListIsExistCurrentData(String date, List<CardRuleResultInfo> infoList) {
        int res = 1;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < infoList.size(); ++i) {
            list.add(infoList.get(i).getOneOnWorkTime());
            list.add(infoList.get(i).getOneOffWorkTime());
            list.add(infoList.get(i).getTwoOnWorkTime());
            list.add(infoList.get(i).getTwoOffWorkTime());
            list.add(infoList.get(i).getThreeOnWorkTime());
            list.add(infoList.get(i).getThreeOffWorkTime());
        }
        if (list.contains(date)) {
            res = 2;
        }
        return res;
    }

    public int resListIsExistCurrentDate(String date, CardRuleResultInfo info) {
        int res = 1;
        ArrayList<String> list = new ArrayList<String>();
        list.add(info.getOneOnWorkTime());
        list.add(info.getOneOffWorkTime());
        list.add(info.getTwoOnWorkTime());
        list.add(info.getTwoOffWorkTime());
        list.add(info.getThreeOnWorkTime());
        list.add(info.getThreeOffWorkTime());
        if (list.contains(date)) {
            res = 2;
        }
        return res;
    }

    public static void main(String[] args) {
    }

    private boolean isFreeCardCalForTwo(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap, List segIntervalEffectiveList, List<CardRuleResultInfo> getCardList, int oneoffIsPunchCard, int twoonIsPunchCard) {
        CardRuleServer server = new CardRuleServer();
        boolean isFreeCardCal = cardRuleInfo.isIsFreeCardCal();
        if (!isFreeCardCal) {
            return false;
        }
        boolean isIntervalPunchCard = segIntervalEffectiveList.size() > 0;
        List<CardRuleResultInfo> resHeadList = server.getHeadCardDataInfoTwo(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap);
        String maxDate = this.getTwoShiftEffectivePunchCardMaxData(list, this.firstOnworkTime, this.firstOffworkTime);
        boolean isOnePunchCard = false;
        isOnePunchCard = resHeadList.size() > 0 ? maxDate != null && !maxDate.equals(resHeadList.get(0).getOneOnWorkTime()) : maxDate != null;
        List<CardRuleResultInfo> resTailList = server.getTailCardDataInfoTwo(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap);
        String minDate = this.getTwoShiftEffectivePunchCardMinData(list, this.secondOnworkTime, this.secondOffworkTime);
        boolean isTwoPunchCard = false;
        if (resTailList.size() > 0) {
            isTwoPunchCard = minDate != null && !minDate.equals(resTailList.get(0).getTwoOffWorkTime());
        } else {
            boolean bl = isTwoPunchCard = minDate != null;
        }
        if (oneoffIsPunchCard == 0 && twoonIsPunchCard == 1) {
            if (getCardList.size() > 0 && StringUtils.isEmpty((String)getCardList.get(0).getOneOffWorkTime()) && segIntervalEffectiveList.size() == 1) {
                isIntervalPunchCard = false;
            }
            return isFreeCardCal && (isIntervalPunchCard || isOnePunchCard);
        }
        if (oneoffIsPunchCard == 1 && twoonIsPunchCard == 0) {
            if (getCardList.size() > 0 && StringUtils.isEmpty((String)getCardList.get(0).getTwoOnWorkTime()) && segIntervalEffectiveList.size() == 1) {
                isIntervalPunchCard = false;
            }
            return isFreeCardCal && (isIntervalPunchCard || isTwoPunchCard);
        }
        if (oneoffIsPunchCard == 0 && twoonIsPunchCard == 0) {
            return isFreeCardCal && (isIntervalPunchCard || isOnePunchCard || isTwoPunchCard);
        }
        return false;
    }

    private boolean isFreeCardCalForThree1(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap, List segIntervalEffectiveList, List<CardRuleResultInfo> getCardList, int oneoffIsPunchCard, int twoonIsPunchCard) {
        CardRuleServer server = new CardRuleServer();
        boolean isFreeCardCal = cardRuleInfo.isIsFreeCardCal();
        if (!isFreeCardCal) {
            return false;
        }
        boolean isIntervalPunchCard = segIntervalEffectiveList.size() > 0;
        List<CardRuleResultInfo> resHeadList = server.getHeadCardDataInfoThree(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap);
        List<CardRuleResultInfo> resTailList = server.getThreeSegmentTailCardDataInfo(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap);
        String maxDate = this.getTwoShiftEffectivePunchCardMaxData(list, this.firstOnworkTime, this.firstOffworkTime);
        boolean isOnePunchCard = false;
        isOnePunchCard = resHeadList.size() > 0 ? maxDate != null && !maxDate.equals(resHeadList.get(0).getOneOnWorkTime()) : maxDate != null;
        String minDate = this.getTwoShiftEffectivePunchCardMinData(list, this.secondOnworkTime, this.secondOffworkTime);
        boolean isTwoPunchCard = minDate != null;
        boolean isBothPunchCard = false;
        String _maxDate = this.getTwoShiftEffectivePunchCardMaxData(list, this.firstOnworkTime, this.thirdOffworkTime);
        String _minDate = this.getTwoShiftEffectivePunchCardMinData(list, this.firstOnworkTime, this.thirdOffworkTime);
        if (resHeadList.size() > 0 && resTailList.size() > 0) {
            if (_maxDate != null && !_maxDate.equals(resTailList.get(0).getThreeOffWorkTime()) && !_maxDate.equals(resHeadList.get(0).getOneOnWorkTime())) {
                isBothPunchCard = true;
            }
            if (_minDate != null && !_minDate.equals(resTailList.get(0).getThreeOffWorkTime()) && !_minDate.equals(resHeadList.get(0).getOneOnWorkTime())) {
                isBothPunchCard = true;
            }
        } else if (resHeadList.size() > 0 && resTailList.size() == 0) {
            if (_maxDate != null && !_maxDate.equals(resHeadList.get(0).getOneOnWorkTime())) {
                isBothPunchCard = true;
            }
            if (_minDate != null && !_minDate.equals(resHeadList.get(0).getOneOnWorkTime())) {
                isBothPunchCard = true;
            }
        } else if (resHeadList.size() == 0 && resTailList.size() > 0) {
            if (_maxDate != null && !_maxDate.equals(resTailList.get(0).getThreeOffWorkTime())) {
                isBothPunchCard = true;
            }
            if (_minDate != null && !_minDate.equals(resTailList.get(0).getThreeOffWorkTime())) {
                isBothPunchCard = true;
            }
        } else {
            boolean bl = isBothPunchCard = _maxDate != null;
        }
        if (oneoffIsPunchCard == 0 && twoonIsPunchCard == 1) {
            if (getCardList.size() > 0 && StringUtils.isEmpty((String)getCardList.get(0).getOneOffWorkTime()) && segIntervalEffectiveList.size() == 1) {
                isIntervalPunchCard = false;
            }
            return isFreeCardCal && (isIntervalPunchCard || isOnePunchCard);
        }
        if (oneoffIsPunchCard == 1 && twoonIsPunchCard == 0) {
            if (getCardList.size() > 0 && StringUtils.isEmpty((String)getCardList.get(0).getTwoOnWorkTime()) && segIntervalEffectiveList.size() == 1) {
                isIntervalPunchCard = false;
            }
            return isFreeCardCal && (isIntervalPunchCard || isTwoPunchCard);
        }
        if (oneoffIsPunchCard == 0 && twoonIsPunchCard == 0) {
            return isFreeCardCal && (isIntervalPunchCard || isOnePunchCard || isTwoPunchCard);
        }
        return false;
    }

    private boolean isFreeCardCalForThree2(Context ctx, AtsShiftInfo shiftInfo, CardRuleInfo cardRuleInfo, List list, String currentDate, Map<String, String> paraMap, List segIntervalEffectiveList, List<CardRuleResultInfo> getCardList, int twooffIsPunchCard, int threeonIsPunchCard) {
        String oneOffWorkTime = "";
        String twoOnWorkTime = "";
        String twoOffWorkTime = "";
        String threeOnWorkTime = "";
        if (getCardList.size() > 1) {
            oneOffWorkTime = getCardList.get(0).getOneOffWorkTime();
            twoOnWorkTime = getCardList.get(0).getTwoOnWorkTime();
            twoOffWorkTime = getCardList.get(1).getTwoOffWorkTime();
            threeOnWorkTime = getCardList.get(1).getThreeOnWorkTime();
        }
        if (getCardList.size() == 1) {
            if (getCardList.get(0).getThreeSegmentTag() == 1) {
                oneOffWorkTime = getCardList.get(0).getOneOffWorkTime();
                twoOnWorkTime = getCardList.get(0).getTwoOnWorkTime();
            }
            if (getCardList.get(0).getThreeSegmentTag() == 2) {
                twoOffWorkTime = getCardList.get(0).getTwoOffWorkTime();
                threeOnWorkTime = getCardList.get(0).getThreeOnWorkTime();
            }
        }
        CardRuleServer server = new CardRuleServer();
        boolean isFreeCardCal = cardRuleInfo.isIsFreeCardCal();
        if (!isFreeCardCal) {
            return false;
        }
        boolean isIntervalPunchCard = segIntervalEffectiveList.size() > 0;
        String maxDate = this.getTwoShiftEffectivePunchCardMaxData(list, this.secondOnworkTime, this.secondOffworkTime);
        boolean isOnePunchCard = false;
        if (StringUtils.isEmpty((String)twoOnWorkTime)) {
            String minDateForTwoOnWorkTime = this.getTwoShiftEffectivePunchCardMinData(list, this.secondOnworkTime, this.secondOffworkTime);
            isOnePunchCard = maxDate != null && !maxDate.equals(minDateForTwoOnWorkTime);
        } else {
            isOnePunchCard = maxDate != null;
        }
        List<CardRuleResultInfo> resHeadList = server.getHeadCardDataInfoThree(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap);
        List<CardRuleResultInfo> resTailList = server.getThreeSegmentTailCardDataInfo(ctx, shiftInfo, cardRuleInfo, list, currentDate, paraMap);
        String minDate = this.getTwoShiftEffectivePunchCardMinData(list, this.thirdOnworkTime, this.thirdOffworkTime);
        boolean isTwoPunchCard = false;
        isTwoPunchCard = resTailList.size() > 0 ? minDate != null && !minDate.equals(resTailList.get(0).getThreeOffWorkTime()) : minDate != null;
        boolean isBothPunchCard = false;
        String _maxDate = this.getTwoShiftEffectivePunchCardMaxData(list, this.firstOnworkTime, this.thirdOffworkTime);
        String _minDate = this.getTwoShiftEffectivePunchCardMinData(list, this.firstOnworkTime, this.thirdOffworkTime);
        if (resHeadList.size() > 0 && resTailList.size() > 0) {
            if (_maxDate != null && !_maxDate.equals(resTailList.get(0).getThreeOffWorkTime()) && !_maxDate.equals(resHeadList.get(0).getOneOnWorkTime())) {
                isBothPunchCard = true;
            }
            if (_minDate != null && !_minDate.equals(resTailList.get(0).getThreeOffWorkTime()) && !_minDate.equals(resHeadList.get(0).getOneOnWorkTime())) {
                isBothPunchCard = true;
            }
        } else if (resHeadList.size() > 0 && resTailList.size() == 0) {
            if (_maxDate != null && !_maxDate.equals(resHeadList.get(0).getOneOnWorkTime())) {
                isBothPunchCard = true;
            }
            if (_minDate != null && !_minDate.equals(resHeadList.get(0).getOneOnWorkTime())) {
                isBothPunchCard = true;
            }
        } else if (resHeadList.size() == 0 && resTailList.size() > 0) {
            if (_maxDate != null && !_maxDate.equals(resTailList.get(0).getThreeOffWorkTime())) {
                isBothPunchCard = true;
            }
            if (_minDate != null && !_minDate.equals(resTailList.get(0).getThreeOffWorkTime())) {
                isBothPunchCard = true;
            }
        } else {
            boolean bl = isBothPunchCard = _maxDate != null;
        }
        if (twooffIsPunchCard == 0 && threeonIsPunchCard == 1) {
            if (StringUtils.isEmpty((String)twoOffWorkTime) && segIntervalEffectiveList.size() == 1) {
                isIntervalPunchCard = false;
            }
            return isFreeCardCal && (isIntervalPunchCard || isOnePunchCard);
        }
        if (twooffIsPunchCard == 1 && threeonIsPunchCard == 0) {
            if (StringUtils.isEmpty((String)threeOnWorkTime) && segIntervalEffectiveList.size() == 1) {
                isIntervalPunchCard = false;
            }
            return isFreeCardCal && (isIntervalPunchCard || isTwoPunchCard);
        }
        if (twooffIsPunchCard == 0 && threeonIsPunchCard == 0) {
            return isFreeCardCal && (isIntervalPunchCard || isOnePunchCard || isTwoPunchCard);
        }
        return false;
    }

    private void amendAbsentForThree(AtsShiftInfo shiftInfo, List<CardRuleResultInfo> resList, List list) {
        if (resList != null && resList.size() > 0) {
            String minDate;
            String maxDate;
            String t2;
            String t1;
            if (shiftInfo != null) {
                this.firstOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 2).get("firstOnTime");
                this.firstOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("firstOffTime");
                this.secondOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("secondOnTime");
                this.secondOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("secondOffTime");
                this.thirdOnTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOnTime");
                this.thirdOffTime = CardRuleResult.getShiftEndTimeAndStartTime(shiftInfo, 3).get("thirdOffTime");
                this.firstOnworkTime = this.baseDate + this.split + this.firstOnTime;
                this.firstOffworkTime = this.baseDate + this.split + this.firstOffTime;
                this.secondOnworkTime = this.baseDate + this.split + this.secondOnTime;
                this.secondOffworkTime = this.baseDate + this.split + this.secondOffTime;
                this.thirdOnworkTime = this.baseDate + this.split + this.thirdOnTime;
                this.thirdOffworkTime = this.baseDate + this.split + this.thirdOffTime;
            }
            if (StringUtils.isNotBlank((String)resList.get(0).getOneOnWorkTime()) && StringUtils.isNotBlank((String)resList.get(0).getOneOffWorkTime()) && StringUtils.isBlank((String)resList.get(0).getTwoOnWorkTime()) && StringUtils.isNotBlank((String)resList.get(0).getTwoOffWorkTime())) {
                t1 = AtsDateUtils.getTimeFromLongString(resList.get(0).getOneOnWorkTime());
                t2 = AtsDateUtils.getTimeFromLongString(resList.get(0).getOneOffWorkTime());
                if (this.firstOnTime.compareTo(t1) > 0) {
                    t1 = this.firstOnTime;
                }
                if (StringUtils.isNotBlank((String)(maxDate = this.getTwoShiftEffectivePunchCardMaxData(list, this.baseDate + this.split + t1, this.baseDate + this.split + t2))) && this.firstOffTime.compareTo(t2) < 0) {
                    resList.get(0).setTwoOnWorkTime(resList.get(0).getOneOffWorkTime());
                    resList.get(0).setOneOffWorkTime(maxDate);
                }
            }
            if (StringUtils.isNotBlank((String)resList.get(0).getOneOnWorkTime()) && StringUtils.isBlank((String)resList.get(0).getOneOffWorkTime()) && StringUtils.isNotBlank((String)resList.get(0).getTwoOnWorkTime()) && StringUtils.isNotBlank((String)resList.get(0).getTwoOffWorkTime())) {
                t1 = AtsDateUtils.getTimeFromLongString(resList.get(0).getTwoOnWorkTime());
                t2 = AtsDateUtils.getTimeFromLongString(resList.get(0).getTwoOffWorkTime());
                if (this.secondOffTime.compareTo(t2) < 0) {
                    t2 = this.secondOffTime;
                }
                if (StringUtils.isNotBlank((String)(minDate = this.getTwoShiftEffectivePunchCardMinData(list, this.baseDate + this.split + t1, this.baseDate + this.split + t2))) && this.secondOnTime.compareTo(t1) > 0) {
                    resList.get(0).setOneOffWorkTime(resList.get(0).getTwoOnWorkTime());
                    resList.get(0).setTwoOnWorkTime(minDate);
                }
            }
            if (StringUtils.isNotBlank((String)resList.get(0).getTwoOnWorkTime()) && StringUtils.isNotBlank((String)resList.get(0).getTwoOffWorkTime()) && StringUtils.isBlank((String)resList.get(0).getThreeOnWorkTime()) && StringUtils.isNotBlank((String)resList.get(0).getThreeOffWorkTime())) {
                t1 = AtsDateUtils.getTimeFromLongString(resList.get(0).getTwoOnWorkTime());
                t2 = AtsDateUtils.getTimeFromLongString(resList.get(0).getTwoOffWorkTime());
                if (this.secondOnTime.compareTo(t1) > 0) {
                    t1 = this.secondOnTime;
                }
                if (StringUtils.isNotBlank((String)(maxDate = this.getTwoShiftEffectivePunchCardMaxData(list, this.baseDate + this.split + t1, this.baseDate + this.split + t2))) && this.secondOffTime.compareTo(t2) < 0) {
                    resList.get(0).setThreeOnWorkTime(resList.get(0).getTwoOffWorkTime());
                    resList.get(0).setTwoOffWorkTime(maxDate);
                }
            }
            if (StringUtils.isNotBlank((String)resList.get(0).getTwoOnWorkTime()) && StringUtils.isBlank((String)resList.get(0).getTwoOffWorkTime()) && StringUtils.isNotBlank((String)resList.get(0).getThreeOnWorkTime()) && StringUtils.isNotBlank((String)resList.get(0).getThreeOffWorkTime())) {
                t1 = AtsDateUtils.getTimeFromLongString(resList.get(0).getThreeOnWorkTime());
                t2 = AtsDateUtils.getTimeFromLongString(resList.get(0).getThreeOffWorkTime());
                if (this.thirdOffTime.compareTo(t2) < 0) {
                    t2 = this.thirdOffTime;
                }
                if (StringUtils.isNotBlank((String)(minDate = this.getTwoShiftEffectivePunchCardMinData(list, this.baseDate + this.split + t1, this.baseDate + this.split + t2))) && this.thirdOnTime.compareTo(t1) > 0) {
                    resList.get(0).setTwoOffWorkTime(resList.get(0).getThreeOnWorkTime());
                    resList.get(0).setThreeOnWorkTime(minDate);
                }
            }
            if (StringUtils.isNotBlank((String)resList.get(0).getOneOnWorkTime()) && StringUtils.isNotBlank((String)resList.get(0).getOneOffWorkTime()) && StringUtils.isBlank((String)resList.get(0).getTwoOnWorkTime()) && StringUtils.isBlank((String)resList.get(0).getTwoOffWorkTime()) && StringUtils.isNotBlank((String)resList.get(0).getThreeOnWorkTime()) && StringUtils.isNotBlank((String)resList.get(0).getThreeOffWorkTime())) {
                String t1_1 = AtsDateUtils.getTimeFromLongString(resList.get(0).getOneOnWorkTime());
                String t1_2 = AtsDateUtils.getTimeFromLongString(resList.get(0).getOneOffWorkTime());
                String t2_1 = AtsDateUtils.getTimeFromLongString(resList.get(0).getThreeOnWorkTime());
                String t2_2 = AtsDateUtils.getTimeFromLongString(resList.get(0).getThreeOffWorkTime());
                if (this.firstOnTime.compareTo(t1_1) > 0) {
                    t1_1 = this.firstOnTime;
                }
                if (this.thirdOffTime.compareTo(t2_2) < 0) {
                    t2_2 = this.thirdOffTime;
                }
                String maxDate2 = this.getTwoShiftEffectivePunchCardMaxData(list, this.baseDate + this.split + t1_1, this.baseDate + this.split + t1_2);
                String minDate2 = this.getTwoShiftEffectivePunchCardMinData(list, this.baseDate + this.split + t2_1, this.baseDate + this.split + t2_2);
                if (StringUtils.isNotBlank((String)minDate2) && StringUtils.isNotBlank((String)maxDate2) && this.firstOffTime.compareTo(t1_2) < 0 && this.thirdOnTime.compareTo(t2_1) > 0) {
                    resList.get(0).setTwoOnWorkTime(resList.get(0).getOneOffWorkTime());
                    resList.get(0).setOneOffWorkTime(maxDate2);
                    resList.get(0).setTwoOffWorkTime(resList.get(0).getThreeOnWorkTime());
                    resList.get(0).setThreeOnWorkTime(minDate2);
                }
            }
        }
    }
}

