/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.eas.hr.ats.AtsOffsiteEntryInfo;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsShiftItemCollection;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AttencePolicyEntryCollection;
import com.kingdee.eas.hr.ats.AttencePolicyEntryInfo;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.AttendanceTypeEnum;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.calculate.time.model.TimeLabelModel;
import com.kingdee.eas.hr.ats.calculate.time.util.TimeRangeUnion;
import com.kingdee.eas.hr.ats.result.AttendanceDynamicResInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FetchCardUtil {
    public static final String ONE_PRETIME = "1,1";
    public static final String ONE_NEXTTIME = "1,2";
    public static final String TWO_PRETIME = "2,1";
    public static final String TWO_NEXTTIME = "2,2";
    public static final String THREE_PRETIME = "3,1";
    public static final String THREE_NEXTTIME = "3,2";
    public static final String ONE_PRERESTTIME = "1,1";
    public static final String ONE_NEXTRESTTIME = "1,2";
    public static final String TWO_PRERESTTIME = "2,1";
    public static final String TWO_NEXTRESTTIME = "2,2";
    public static final String THREE_PRERESTTIME = "3,1";
    public static final String THREE_NEXTRESTTIME = "3,2";

    public static Map<String, String> getShiftEarlyTimeAndLateTime(AtsShiftInfo shiftInfo) {
        HashMap<String, String> resMap = new HashMap<String, String>();
        String earlyTime = "00:00:00";
        String lateTime = "23:59:59";
        String earlyTimeDayType = "1";
        String lateTimeDayType = "1";
        if (shiftInfo != null) {
            AtsShiftItemCollection shiftItemColl = shiftInfo.getItems();
            for (int k = 0; k < shiftItemColl.size(); ++k) {
                int segmentValue = Integer.parseInt(shiftItemColl.get(k).getSegment().getValue());
                if (segmentValue == 1) {
                    earlyTime = shiftItemColl.get(k).getPreTime() + ":00";
                    earlyTimeDayType = String.valueOf(shiftItemColl.get(k).getPreTimeDayType().getValue());
                }
                if (segmentValue != shiftItemColl.size()) continue;
                lateTime = shiftItemColl.get(k).getNextTime() + ":00";
                lateTimeDayType = String.valueOf(shiftItemColl.get(k).getNextTimeDayType().getValue());
            }
        }
        resMap.put("earlyTime", earlyTime);
        resMap.put("lateTime", lateTime);
        resMap.put("earlyTimeDayType", earlyTimeDayType);
        resMap.put("lateTimeDayType", lateTimeDayType);
        return resMap;
    }

    public static String timeToDateByDayType(String time, String dayType, String attDate) {
        String date = "";
        long dayMs = 86400000L;
        Date tempDate = AtsDateUtils.stringToShortDate(attDate);
        if (dayType.equals("0")) {
            date = AtsDateUtils.dateShortToString(new Date(tempDate.getTime() - dayMs)) + " " + time;
        } else if (dayType.equals("1")) {
            date = attDate + " " + time;
        } else if (dayType.equals("2")) {
            date = AtsDateUtils.dateShortToString(new Date(tempDate.getTime() + dayMs)) + " " + time;
        }
        return date;
    }

    public static String hourExtend(String date, BigDecimal num) {
        long hourMs = 3600000L;
        Date dt = AtsDateUtils.stringToLongDate(date);
        String str = AtsDateUtils.dateLongToString(new Date(dt.getTime() + num.multiply(new BigDecimal(hourMs)).longValue()));
        return str;
    }

    public static String getShiftTime(AtsShiftInfo shiftInfo, String date, String seg) {
        String shiftTime = "";
        String[] temp = seg.split(",");
        int segment = 0;
        int preOrNext = 0;
        if (temp.length == 2) {
            segment = Integer.valueOf(temp[0]);
            preOrNext = Integer.valueOf(temp[1]);
        }
        if (shiftInfo != null) {
            AtsShiftItemCollection shiftItemColl = shiftInfo.getItems();
            for (int j = 0; j < shiftItemColl.size(); ++j) {
                String dayType;
                int segmentValue = Integer.parseInt(shiftItemColl.get(j).getSegment().getValue());
                if (segmentValue != segment) continue;
                if (preOrNext == 1) {
                    String preTime = AtsDateUtils.getFullTime(shiftItemColl.get(j).getPreTime());
                    dayType = String.valueOf(shiftItemColl.get(j).getPreTimeDayType().getValue());
                    shiftTime = FetchCardUtil.timeToDateByDayType(preTime, dayType, date);
                }
                if (preOrNext != 2) continue;
                String nextTime = AtsDateUtils.getFullTime(shiftItemColl.get(j).getNextTime());
                dayType = String.valueOf(shiftItemColl.get(j).getNextTimeDayType().getValue());
                shiftTime = FetchCardUtil.timeToDateByDayType(nextTime, dayType, date);
            }
        }
        return shiftTime;
    }

    public static String getShiftRestTime(AtsShiftInfo shiftInfo, String date, String seg) {
        String shiftTime = "";
        String[] temp = seg.split(",");
        int segment = 0;
        int preOrNext = 0;
        if (temp.length == 2) {
            segment = Integer.valueOf(temp[0]);
            preOrNext = Integer.valueOf(temp[1]);
        }
        if (shiftInfo != null) {
            AtsShiftItemCollection shiftItemColl = shiftInfo.getItems();
            for (int j = 0; j < shiftItemColl.size(); ++j) {
                String dayTypeNext;
                String dayTypePre;
                String preTime;
                int segmentValue = Integer.parseInt(shiftItemColl.get(j).getSegment().getValue());
                if (segmentValue != segment) continue;
                if (preOrNext == 1) {
                    String preRestTime = AtsDateUtils.getFullTime(shiftItemColl.get(j).getRestPreTime());
                    preTime = AtsDateUtils.getFullTime(shiftItemColl.get(j).getPreTime());
                    dayTypePre = String.valueOf(shiftItemColl.get(j).getPreTimeDayType().getValue());
                    dayTypeNext = String.valueOf(shiftItemColl.get(j).getNextTimeDayType().getValue());
                    shiftTime = preRestTime.compareTo(preTime) > 0 ? FetchCardUtil.timeToDateByDayType(preRestTime, dayTypePre, date) : FetchCardUtil.timeToDateByDayType(preRestTime, dayTypeNext, date);
                }
                if (preOrNext != 2) continue;
                String nextRestTime = AtsDateUtils.getFullTime(shiftItemColl.get(j).getRestNextTime());
                preTime = AtsDateUtils.getFullTime(shiftItemColl.get(j).getPreTime());
                dayTypePre = String.valueOf(shiftItemColl.get(j).getPreTimeDayType().getValue());
                dayTypeNext = String.valueOf(shiftItemColl.get(j).getNextTimeDayType().getValue());
                shiftTime = nextRestTime.compareTo(preTime) > 0 ? FetchCardUtil.timeToDateByDayType(nextRestTime, dayTypePre, date) : FetchCardUtil.timeToDateByDayType(nextRestTime, dayTypeNext, date);
            }
        }
        return shiftTime;
    }

    public static int nearestPoint(String offTime, String onTime, String intervalTime) {
        long x2;
        int returnvalue = 0;
        Date offDate = AtsDateUtils.stringToLongDate(offTime);
        Date onDate = AtsDateUtils.stringToLongDate(onTime);
        Date interDate = AtsDateUtils.stringToLongDate(intervalTime);
        long x1 = Math.abs(interDate.getTime() - offDate.getTime());
        if (x1 < (x2 = Math.abs(onDate.getTime() - interDate.getTime()))) {
            returnvalue = 1;
        } else if (x1 > x2) {
            returnvalue = 2;
        }
        return returnvalue;
    }

    public static Timestamp timestampAbortMinute(Timestamp timestamp) {
        String someTime = AtsDateUtils.timestampToString(timestamp);
        someTime = someTime.substring(0, 16) + ":00";
        return AtsDateUtils.stringToTimestamp(someTime);
    }

    public static String[] getOnOffShiftTime(Map globalMap, String personId, String date) {
        List scheduleShiftInfoList;
        Map scheduleShiftItemMap = (Map)globalMap.get("T_HR_ATS_ScheduleShift");
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        Map atsShiftInfoMap = (Map)globalMap.get("T_HR_ATS_Shift");
        String key = personId + "_" + date;
        ScheduleShiftInfo sheduleshiftinfo = null;
        AtsShiftInfo shiftInfo = null;
        if (null != scheduleShiftItemMap && scheduleShiftItemMap.size() > 0 && (scheduleShiftInfoList = (List)scheduleShiftItemMap.get(key)) != null && scheduleShiftInfoList.size() > 0) {
            sheduleshiftinfo = (ScheduleShiftInfo)scheduleShiftInfoList.get(0);
        }
        shiftInfo = FetchCardUtil.shiftInfoGet(key, sheduleshiftinfo, attendanceFileInfoMap, atsShiftInfoMap);
        return FetchCardUtil.getOnOffShiftTime(date, shiftInfo);
    }

    public static String[] getOnOffShiftTime(String date, AtsShiftInfo shiftInfo) {
        String oneOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "1,1");
        String oneOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "1,2");
        String twoOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "2,2");
        String threeOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "3,2");
        String shiftEarlyTime = "";
        String shiftEndTime = "";
        if (shiftInfo.getItems().size() == 1) {
            shiftEarlyTime = oneOnTimeSchedule;
            shiftEndTime = oneOffTimeSchedule;
        } else if (shiftInfo.getItems().size() == 2) {
            shiftEarlyTime = oneOnTimeSchedule;
            shiftEndTime = twoOffTimeSchedule;
        } else if (shiftInfo.getItems().size() == 3) {
            shiftEarlyTime = oneOnTimeSchedule;
            shiftEndTime = threeOffTimeSchedule;
        }
        return new String[]{shiftEarlyTime, shiftEndTime};
    }

    public static Timestamp[] getOneShiftRestTime(Map globalMap, String personId, String date) {
        AtsShiftInfo shiftInfo;
        Map scheduleShiftItemMap = (Map)globalMap.get("T_HR_ATS_ScheduleShift");
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        Map atsShiftInfoMap = (Map)globalMap.get("T_HR_ATS_Shift");
        String key = personId + "_" + date;
        ScheduleShiftInfo sheduleshiftinfo = null;
        List scheduleShiftInfoList = (List)scheduleShiftItemMap.get(key);
        if (scheduleShiftInfoList != null && scheduleShiftInfoList.size() > 0) {
            sheduleshiftinfo = (ScheduleShiftInfo)scheduleShiftInfoList.get(0);
        }
        if (null != (shiftInfo = FetchCardUtil.shiftInfoGet(key, sheduleshiftinfo, attendanceFileInfoMap, atsShiftInfoMap))) {
            String oneRestPreTimeSchedule = FetchCardUtil.getShiftRestTime(shiftInfo, date, "1,1");
            String oneRestNextTimeSchedule = FetchCardUtil.getShiftRestTime(shiftInfo, date, "1,2");
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)oneRestPreTimeSchedule) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)oneRestNextTimeSchedule)) {
                return new Timestamp[]{AtsDateUtils.stringToTimestamp(oneRestPreTimeSchedule), AtsDateUtils.stringToTimestamp(oneRestNextTimeSchedule)};
            }
        }
        return null;
    }

    public static AtsShiftInfo shiftInfoGet(Object key, ScheduleShiftInfo scheduleshiftinfo, Map<String, AttendanceFileInfo> attendanceFileInfoMap, Map<String, AtsShiftInfo> allShiftInfoMap) {
        String shiftId = "";
        if (null != scheduleshiftinfo && scheduleshiftinfo.getDefaultShift() != null) {
            shiftId = scheduleshiftinfo.getDefaultShift().getId().toString();
        } else {
            AtsShiftInfo defaultShiftInfo = attendanceFileInfoMap.get(key).getAtsShift();
            if (defaultShiftInfo != null) {
                shiftId = defaultShiftInfo.getId().toString();
            }
        }
        AtsShiftInfo shiftInfo = (AtsShiftInfo)allShiftInfoMap.get(shiftId).clone();
        if (shiftInfo != null) {
            AtsShiftItemCollection shiftColl = shiftInfo.getItems();
            ScheduleShiftItemCollection scheduleColl = new ScheduleShiftItemCollection();
            if (scheduleshiftinfo != null) {
                scheduleColl = scheduleshiftinfo.getItems();
                shiftInfo.setIsElastic(scheduleshiftinfo.isIsElastic());
                shiftInfo.setElasticType(scheduleshiftinfo.getElasticType());
                shiftInfo.setElasticDirection(scheduleshiftinfo.getElasticDirection());
                shiftInfo.setElasticValue(scheduleshiftinfo.getElasticValue());
                shiftInfo.setCardRule(scheduleshiftinfo.getCardRule());
                shiftInfo.setStandardHour(scheduleshiftinfo.getStandardHour());
                shiftInfo.put("dayType", (Object)scheduleshiftinfo.getDayType());
            }
            if (shiftColl.size() == scheduleColl.size()) {
                for (int j = 0; j < scheduleColl.size(); ++j) {
                    shiftColl.get(j).setPreTime(scheduleColl.get(j).getPreTime());
                    shiftColl.get(j).setNextTime(scheduleColl.get(j).getNextTime());
                    shiftColl.get(j).setPreIsPunchCard(scheduleColl.get(j).getPreIsPunchCard());
                    shiftColl.get(j).setNextIsPunchCard(scheduleColl.get(j).getNextIsPunchCard());
                    shiftColl.get(j).setPreTimeDayType(scheduleColl.get(j).getPreTimeDayType());
                    shiftColl.get(j).setNextTimeDayType(scheduleColl.get(j).getNextTimeDayType());
                    shiftColl.get(j).setSegment(scheduleColl.get(j).getSegment());
                    shiftColl.get(j).setPreFloatAdjusted(scheduleColl.get(j).getPreFloatAdjusted());
                    shiftColl.get(j).setNextFloatAdjusted(scheduleColl.get(j).getNextFloatAdjusted());
                    shiftColl.get(j).setRestPreTime(scheduleColl.get(j).getRestPreTime());
                    shiftColl.get(j).setRestNextTime(scheduleColl.get(j).getRestNextTime());
                    shiftColl.get(j).setSegmentInRest(scheduleColl.get(j).getSegmentInRest());
                    shiftColl.get(j).setAttendanceType(scheduleColl.get(j).getAttendanceType());
                }
            }
        }
        return shiftInfo;
    }

    public static String getScheduleShiftRestTime(ScheduleShiftInfo shiftInfo, String date, String seg) {
        String shiftTime = "";
        String[] temp = seg.split(",");
        int segment = 0;
        int preOrNext = 0;
        if (temp.length == 2) {
            segment = Integer.valueOf(temp[0]);
            preOrNext = Integer.valueOf(temp[1]);
        }
        if (shiftInfo != null) {
            ScheduleShiftItemCollection shiftItemColl = shiftInfo.getItems();
            for (int j = 0; j < shiftItemColl.size(); ++j) {
                String dayTypeNext;
                String dayTypePre;
                String preTime;
                int segmentValue = Integer.parseInt(shiftItemColl.get(j).getSegment().getValue());
                if (segmentValue != segment) continue;
                if (preOrNext == 1) {
                    String preRestTime = AtsDateUtils.getFullTime(shiftItemColl.get(j).getRestPreTime());
                    preTime = AtsDateUtils.getFullTime(shiftItemColl.get(j).getPreTime());
                    dayTypePre = String.valueOf(shiftItemColl.get(j).getPreTimeDayType().getValue());
                    dayTypeNext = String.valueOf(shiftItemColl.get(j).getNextTimeDayType().getValue());
                    shiftTime = preRestTime.compareTo(preTime) > 0 ? FetchCardUtil.timeToDateByDayType(preRestTime, dayTypePre, date) : FetchCardUtil.timeToDateByDayType(preRestTime, dayTypeNext, date);
                }
                if (preOrNext != 2) continue;
                String nextRestTime = AtsDateUtils.getFullTime(shiftItemColl.get(j).getRestNextTime());
                preTime = AtsDateUtils.getFullTime(shiftItemColl.get(j).getPreTime());
                dayTypePre = String.valueOf(shiftItemColl.get(j).getPreTimeDayType().getValue());
                dayTypeNext = String.valueOf(shiftItemColl.get(j).getNextTimeDayType().getValue());
                shiftTime = nextRestTime.compareTo(preTime) > 0 ? FetchCardUtil.timeToDateByDayType(nextRestTime, dayTypePre, date) : FetchCardUtil.timeToDateByDayType(nextRestTime, dayTypeNext, date);
            }
        }
        return shiftTime;
    }

    public static String[] getOnOffShiftSegTime(Map globalMap, String personId, String date) {
        Map scheduleShiftItemMap = (Map)globalMap.get("T_HR_ATS_ScheduleShift");
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        Map atsShiftInfoMap = (Map)globalMap.get("T_HR_ATS_Shift");
        String key = personId + "_" + date;
        ScheduleShiftInfo sheduleshiftinfo = null;
        AtsShiftInfo shiftInfo = null;
        List scheduleShiftInfoList = (List)scheduleShiftItemMap.get(key);
        if (scheduleShiftInfoList != null && scheduleShiftInfoList.size() > 0) {
            sheduleshiftinfo = (ScheduleShiftInfo)scheduleShiftInfoList.get(0);
        }
        shiftInfo = FetchCardUtil.shiftInfoGet(key, sheduleshiftinfo, attendanceFileInfoMap, atsShiftInfoMap);
        String oneOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "1,1");
        String oneOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "1,2");
        String twoOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "2,1");
        String twoOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "2,2");
        String threeOnTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "3,1");
        String threeOffTimeSchedule = FetchCardUtil.getShiftTime(shiftInfo, date, "3,2");
        return new String[]{oneOnTimeSchedule, oneOffTimeSchedule, twoOnTimeSchedule, twoOffTimeSchedule, threeOnTimeSchedule, threeOffTimeSchedule};
    }

    public static Timestamp[] getHeadAndTailOutShiftTime(Map param) {
        Map globalMap = (Map)param.get("globalMap");
        String personId = (String)param.get("personId");
        String date = (String)param.get("attenceDate");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)personId)) {
            personId = (String)param.get("T_HR_ATS_ATTENDANCERESULT_FPROPOSERID");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)date)) {
            date = (String)param.get("T_HR_ATS_ATTENDANCERESULT_FATTENCEDATE");
        }
        if (globalMap == null) {
            globalMap = (Map)param.get("globalMapKey");
        }
        return FetchCardUtil.getHeadAndTailOutShiftTime(globalMap, personId, date);
    }

    public static Timestamp[] getHeadAndTailOutShiftTime(Map globalMap, String personId, String date) {
        List scheduleShiftInfoList;
        String key = personId + "_" + date;
        Map scheduleShiftItemMap = (Map)globalMap.get("T_HR_ATS_ScheduleShift");
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        Map atsShiftInfoMap = (Map)globalMap.get("T_HR_ATS_Shift");
        Map cardRuleSingleInfoMap = (Map)globalMap.get("T_HR_ATS_CardRule");
        ScheduleShiftInfo sheduleshiftinfo = null;
        CardRuleInfo cardRuleInfo = null;
        if (null != scheduleShiftItemMap && scheduleShiftItemMap.size() > 0 && (scheduleShiftInfoList = (List)scheduleShiftItemMap.get(key)) != null && scheduleShiftInfoList.size() > 0) {
            sheduleshiftinfo = (ScheduleShiftInfo)scheduleShiftInfoList.get(0);
        }
        AtsShiftInfo shiftInfo = FetchCardUtil.shiftInfoGet(key, sheduleshiftinfo, attendanceFileInfoMap, atsShiftInfoMap);
        String[] onOffShiftTime = FetchCardUtil.getOnOffShiftTime(date, shiftInfo);
        String shiftOnWorkTime = onOffShiftTime[0];
        String shiftOffWorkTime = onOffShiftTime[1];
        if (null == shiftInfo.getCardRule() || shiftInfo.getCardRule().getId() == null) {
            return new Timestamp[]{AtsDateUtils.stringToTimestamp(shiftOnWorkTime), AtsDateUtils.stringToTimestamp(shiftOffWorkTime)};
        }
        String cardRuleId = shiftInfo.getCardRule().getId().toString();
        cardRuleInfo = (CardRuleInfo)cardRuleSingleInfoMap.get(cardRuleId);
        BigDecimal startNum = new BigDecimal("0.00");
        BigDecimal endNum = new BigDecimal("0.00");
        if (cardRuleInfo != null && cardRuleInfo != null) {
            startNum = cardRuleInfo.getStartNum();
            endNum = cardRuleInfo.getEndNum();
        }
        String startTime = FetchCardUtil.hourExtend(shiftOnWorkTime, startNum.multiply(new BigDecimal("-1")));
        String endTime = FetchCardUtil.hourExtend(shiftOffWorkTime, endNum);
        return new Timestamp[]{AtsDateUtils.stringToTimestamp(startTime), AtsDateUtils.stringToTimestamp(endTime)};
    }

    public static Timestamp[] getHeadAndTailOutDefaultTime(Map param, String personId, String attendDate) {
        Map globalMap = (Map)param.get("globalMap");
        if (globalMap == null) {
            globalMap = (Map)param.get("globalMapKey");
        }
        return FetchCardUtil.getHeadAndTailOutDefTime(globalMap, personId, attendDate);
    }

    public static Timestamp[] getHeadAndTailOutDefTime(Map globalMap, String personId, String attendDate) {
        Map scheduleShiftItemMap = (Map)globalMap.get("T_HR_ATS_ScheduleShift");
        Map attendanceFileInfoMap = (Map)globalMap.get("T_HR_ATS_AttendanceFile");
        Map atsShiftInfoMap = (Map)globalMap.get("T_HR_ATS_Shift");
        String key = personId + "_" + attendDate;
        ScheduleShiftInfo sheduleshiftinfo = null;
        AtsShiftInfo shiftInfo = null;
        List scheduleShiftInfoList = (List)scheduleShiftItemMap.get(key);
        if (scheduleShiftInfoList != null && scheduleShiftInfoList.size() > 0) {
            sheduleshiftinfo = (ScheduleShiftInfo)scheduleShiftInfoList.get(0);
        }
        shiftInfo = FetchCardUtil.shiftInfoGet(key, sheduleshiftinfo, attendanceFileInfoMap, atsShiftInfoMap);
        Map cardRuleSingleInfoMap = (Map)globalMap.get("T_HR_ATS_CardRule");
        String[] currentShiftTime = FetchCardUtil.getOnOffShiftTime(attendDate, shiftInfo);
        String cardRuleId = shiftInfo.getCardRule().getId().toString();
        CardRuleInfo cardRuleInfo = (CardRuleInfo)cardRuleSingleInfoMap.get(cardRuleId);
        BigDecimal startNum = new BigDecimal("0.00");
        BigDecimal endNum = new BigDecimal("0.00");
        if (cardRuleInfo != null && cardRuleInfo != null) {
            startNum = cardRuleInfo.getStartNum();
            endNum = cardRuleInfo.getEndNum();
        }
        String startTime = FetchCardUtil.hourExtend(currentShiftTime[0], startNum.multiply(new BigDecimal("-1")));
        String endTime = FetchCardUtil.hourExtend(currentShiftTime[1], endNum);
        return new Timestamp[]{AtsDateUtils.stringToTimestamp(startTime), AtsDateUtils.stringToTimestamp(endTime)};
    }

    public static Set<String> getCalOutShiftDate(List<AtsTripBillEntryInfo> tripBillList, String date, Timestamp[] headTailOutTime) {
        Timestamp headOutTime = headTailOutTime[0];
        Timestamp tailOutTime = headTailOutTime[1];
        AtsTripBillEntryInfo tripBillInfo = null;
        HashSet<String> calOutDate = new HashSet<String>();
        for (int i = 0; i < tripBillList.size(); ++i) {
            tripBillInfo = tripBillList.get(i);
            if (tripBillInfo.isIsAllDay()) continue;
            String startDate = AtsDateUtils.timestampToShortString(tripBillInfo.getRealTripStartTime());
            String endDate = AtsDateUtils.timestampToShortString(tripBillInfo.getRealTripEndTime());
            if (tripBillInfo.getRealTripStartTime().compareTo(headOutTime) < 0 && tripBillInfo.getRealTripEndTime().compareTo(tailOutTime) > 0) continue;
            if (tripBillInfo.getRealTripStartTime().compareTo(headOutTime) >= 0 && AtsDateUtils.stringToShortDate(startDate).compareTo(AtsDateUtils.stringToShortDate(date)) < 0) {
                calOutDate.add(AtsDateUtils.getNextDay(startDate));
            } else if (tripBillInfo.getRealTripStartTime().compareTo(tailOutTime) <= 0 && AtsDateUtils.stringToShortDate(startDate).compareTo(AtsDateUtils.stringToShortDate(date)) > 0) {
                calOutDate.add(AtsDateUtils.getPreDay(startDate));
            }
            calOutDate.add(AtsDateUtils.timestampToShortString(tripBillInfo.getRealTripStartTime()));
            if (tripBillInfo.getRealTripEndTime().compareTo(tailOutTime) <= 0 && AtsDateUtils.stringToShortDate(endDate).compareTo(AtsDateUtils.stringToShortDate(date)) > 0) {
                calOutDate.add(AtsDateUtils.getPreDay(endDate));
            } else if (tripBillInfo.getRealTripEndTime().compareTo(headOutTime) >= 0 && AtsDateUtils.stringToShortDate(endDate).compareTo(AtsDateUtils.stringToShortDate(date)) < 0) {
                calOutDate.add(AtsDateUtils.getNextDay(endDate));
            }
            calOutDate.add(AtsDateUtils.timestampToShortString(tripBillInfo.getRealTripEndTime()));
        }
        return calOutDate;
    }

    public static long intervalTimeCalOutShift(List<Timestamp> shiftList, List<Timestamp> billList, Timestamp[] headTailOutTime) {
        long intervalTime = 0L;
        if (shiftList.size() == 0 || billList.size() == 0 || shiftList.size() % 2 != 0 || billList.size() % 2 != 0) {
            return intervalTime;
        }
        if (shiftList.size() == 2 && billList.size() == 2) {
            Timestamp offShiftTime;
            Timestamp onShiftTime;
            Timestamp endTime;
            Timestamp beginTime = billList.get(0);
            long[] intervalTimes = FetchCardUtil.getTripBillIntersectTime(beginTime, endTime = billList.get(1), onShiftTime = shiftList.get(0), offShiftTime = shiftList.get(1), headTailOutTime);
            if (intervalTimes[0] > 0L) {
                intervalTime = intervalTimes[0];
            }
            if (intervalTimes[1] > 0L) {
                intervalTime += intervalTimes[1];
            }
            return intervalTime;
        }
        for (int i = 0; i < billList.size(); ++i) {
            ArrayList<Timestamp> tempBillList = new ArrayList<Timestamp>();
            tempBillList.add(billList.get(i));
            tempBillList.add(billList.get(++i));
            intervalTime += FetchCardUtil.intervalTimeCalOutShift(shiftList, tempBillList, headTailOutTime);
        }
        return intervalTime;
    }

    public static long[] getTripBillIntersectTime(Timestamp beginTime, Timestamp endTime, Timestamp onShiftTime, Timestamp offShiftTime, Timestamp[] headTailOutTime) {
        Timestamp headOutTime = beginTime;
        Timestamp tailOutTime = endTime;
        if (null != headTailOutTime) {
            headOutTime = headTailOutTime[0];
            tailOutTime = headTailOutTime[1];
        }
        long headIntervalTime = 0L;
        long tailIntervalTime = 0L;
        try {
            boolean calIntersectPre = true;
            boolean calIntersectNext = true;
            if (calIntersectPre) {
                if (beginTime.compareTo(onShiftTime) < 0 && endTime.compareTo(onShiftTime) > 0 && beginTime.compareTo(headOutTime) < 0) {
                    headIntervalTime = onShiftTime.getTime() - headOutTime.getTime();
                } else if (beginTime.compareTo(onShiftTime) < 0 && endTime.compareTo(onShiftTime) > 0 && beginTime.compareTo(headOutTime) >= 0) {
                    headIntervalTime = onShiftTime.getTime() - beginTime.getTime();
                } else if (endTime.compareTo(onShiftTime) <= 0 && beginTime.compareTo(headOutTime) < 0) {
                    headIntervalTime = endTime.getTime() - headOutTime.getTime();
                } else if (endTime.compareTo(onShiftTime) <= 0 && beginTime.compareTo(headOutTime) >= 0) {
                    headIntervalTime = endTime.getTime() - beginTime.getTime();
                }
            }
            if (calIntersectNext) {
                if (beginTime.compareTo(offShiftTime) < 0 && endTime.compareTo(offShiftTime) > 0 && endTime.compareTo(tailOutTime) > 0) {
                    tailIntervalTime = tailOutTime.getTime() - offShiftTime.getTime();
                } else if (beginTime.compareTo(offShiftTime) < 0 && endTime.compareTo(offShiftTime) > 0 && endTime.compareTo(tailOutTime) <= 0) {
                    tailIntervalTime = endTime.getTime() - offShiftTime.getTime();
                } else if (beginTime.compareTo(offShiftTime) >= 0 && endTime.compareTo(tailOutTime) > 0) {
                    tailIntervalTime = tailOutTime.getTime() - beginTime.getTime();
                } else if (beginTime.compareTo(offShiftTime) >= 0 && endTime.compareTo(tailOutTime) <= 0) {
                    tailIntervalTime = endTime.getTime() - beginTime.getTime();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new long[]{headIntervalTime, tailIntervalTime};
    }

    public static List<TimeLabelModel> getAtsOffsiteBillInfoFromGlobalMap(Map<Object, Object> globalMap, String attenceDate, String personId, AttencePolicyInfo policyInfo) {
        ArrayList<TimeLabelModel> timeLabelModels = new ArrayList<TimeLabelModel>();
        List<AtsOffsiteEntryInfo> offsiteEntryInfoList = FetchCardUtil.filterOffsiteBillByIsFreeCard(globalMap, policyInfo, personId, attenceDate);
        ArrayList offsiteTimeList = new ArrayList();
        if (offsiteEntryInfoList != null && !offsiteEntryInfoList.isEmpty()) {
            for (int j = 0; j < offsiteEntryInfoList.size(); ++j) {
                AtsOffsiteEntryInfo entryInfo = offsiteEntryInfoList.get(j);
                if (entryInfo.getRealDays().compareTo(BigDecimal.ZERO) <= 0) continue;
                timeLabelModels.add(new TimeLabelModel(entryInfo.getRealStartTime() == null ? entryInfo.getStartTime() : entryInfo.getRealStartTime(), entryInfo.getRealEndTime() == null ? entryInfo.getEndTime() : entryInfo.getRealEndTime()));
            }
        }
        return timeLabelModels;
    }

    public static List<AtsOffsiteEntryInfo> filterOffsiteBillByIsFreeCard(Map<Object, Object> globalMap, AttencePolicyInfo policyInfo, String personId, String attenceDate) {
        HashMap<String, AttencePolicyEntryInfo> policyEntryInfoMap = new HashMap<String, AttencePolicyEntryInfo>();
        AttencePolicyEntryCollection policyInfoEntries = policyInfo.getEntries();
        for (int i = 0; i < policyInfoEntries.size(); ++i) {
            policyEntryInfoMap.put(policyInfoEntries.get(i).getOffsiteType().getId().toString(), policyInfoEntries.get(i));
        }
        return FetchCardUtil.getOffsiteBillByFreeCard(globalMap, policyEntryInfoMap, personId, attenceDate);
    }

    public static List<AtsOffsiteEntryInfo> getOffsiteBillByFreeCard(Map<Object, Object> globalMap, Map<String, AttencePolicyEntryInfo> policyEntryInfoMap, String personId, String attenceDate) {
        ArrayList<AtsOffsiteEntryInfo> offsiteEntryInfoList = new ArrayList<AtsOffsiteEntryInfo>();
        Map allOffsiteEntryInfoList = (Map)globalMap.get("T_ATS_AtsOffsite");
        ArrayList<String> keylist = new ArrayList<String>();
        String preDateKey = personId + "_" + AtsDateUtils.getPreDay(attenceDate, 1);
        String toDayKey = personId + "_" + attenceDate;
        String afterDayKey = personId + "_" + AtsDateUtils.getNextDay(attenceDate, 1);
        keylist.add(preDateKey);
        keylist.add(toDayKey);
        keylist.add(afterDayKey);
        HashMap leaveKeyMap = new HashMap();
        for (int m = 0; m < keylist.size(); ++m) {
            String key = (String)keylist.get(m);
            List entryInfoList = (List)allOffsiteEntryInfoList.get(key);
            if (null == entryInfoList || entryInfoList.size() <= 0) continue;
            for (int i = 0; i < entryInfoList.size(); ++i) {
                String teleOfficeTypeId = ((AtsOffsiteEntryInfo)entryInfoList.get(i)).getTeleOfficeType().getId().toString();
                if (null == policyEntryInfoMap.get(teleOfficeTypeId) || !policyEntryInfoMap.get(teleOfficeTypeId).isIsFreeCard()) continue;
                offsiteEntryInfoList.add((AtsOffsiteEntryInfo)entryInfoList.get(i));
            }
        }
        return offsiteEntryInfoList;
    }

    public static List<TimeLabelModel> mergeBillTimeList(List<Map<String, Timestamp>> tripTimeList, List<Map<String, Timestamp>> leaveTimeList, List<TimeLabelModel> offsiteTimeList) {
        int i;
        ArrayList<TimeLabelModel> timeIntervalModels = new ArrayList<TimeLabelModel>();
        for (i = 0; i < tripTimeList.size(); ++i) {
            timeIntervalModels.add(new TimeLabelModel(tripTimeList.get(i).get("beginTime"), tripTimeList.get(i).get("endTime")));
        }
        for (i = 0; i < leaveTimeList.size(); ++i) {
            timeIntervalModels.add(new TimeLabelModel(leaveTimeList.get(i).get("beginTime"), leaveTimeList.get(i).get("endTime")));
        }
        timeIntervalModels.addAll(offsiteTimeList);
        TimeRangeUnion.union(timeIntervalModels);
        return timeIntervalModels;
    }

    public static void fillBillFreeCard(List<TimeLabelModel> timeLabelModelList, AttendanceDynamicResInfo result, List<Map<String, Object>> shiftList, ScheduleShiftInfo scheduleShiftInfo) {
        if (null != timeLabelModelList && !timeLabelModelList.isEmpty() && scheduleShiftInfo != null) {
            String[] atrr = new String[]{result.getOneOnTime(), result.getOneOffTime(), result.getTwoOnTime(), result.getTwoOffTime(), result.getThreeOnTime(), result.getThreeOffTime()};
            String[] atrTemp = new String[]{"", "", "", "", "", ""};
            block0: for (int k = 0; k < timeLabelModelList.size(); ++k) {
                TimeLabelModel timeLabelModel = timeLabelModelList.get(k);
                Timestamp billBeginTime = timeLabelModel.getBeginTime();
                Timestamp billEndTime = timeLabelModel.getEndTime();
                int i = 0;
                int j = 0;
                while (i < shiftList.size()) {
                    Map<String, Object> map = shiftList.get(i);
                    String segbegStr = (String)map.get("beginTime");
                    String segEndStr = (String)map.get("endTime");
                    Timestamp segBegElasTime = null;
                    Timestamp segEndElasTime = null;
                    if (null != scheduleShiftInfo.getElasticType() && scheduleShiftInfo.isIsElastic() && scheduleShiftInfo.getElasticType().getValue() == 1) {
                        BigDecimal elasticValue = scheduleShiftInfo.getElasticValue();
                        segBegElasTime = AtsDateUtils.stringToTimestamp(FetchCardUtil.hourExtend(segbegStr, elasticValue));
                        segEndElasTime = AtsDateUtils.stringToTimestamp(FetchCardUtil.hourExtend(segEndStr, elasticValue));
                    }
                    Timestamp segBegTime = AtsDateUtils.stringToTimestamp(segbegStr);
                    Timestamp segEndTime = AtsDateUtils.stringToTimestamp(segEndStr);
                    AttendanceTypeEnum attendanceType = (AttendanceTypeEnum)((Object)map.get("attendanceType"));
                    if (null != attendanceType && (attendanceType.getValue() == "2" || attendanceType.getValue() == "4")) continue block0;
                    String billEndTimeStr = AtsDateUtils.timestampToString(billEndTime);
                    String billBeginTimeStr = AtsDateUtils.timestampToString(billBeginTime);
                    if (billBeginTime.getTime() > segBegTime.getTime() || billEndTime.getTime() < segEndTime.getTime()) {
                        if (segBegTime.getTime() <= billEndTime.getTime() && segEndTime.getTime() >= billEndTime.getTime() && billBeginTime.getTime() <= segBegTime.getTime() && billEndTime.getTime() < segEndTime.getTime() || null != segBegElasTime && null != segEndElasTime && segBegElasTime.getTime() <= billEndTime.getTime() && segEndElasTime.getTime() >= billEndTime.getTime() && billBeginTime.getTime() <= segBegElasTime.getTime()) {
                            if (StringUtils.isEmpty((String)atrr[j])) {
                                atrTemp[j] = billEndTimeStr;
                            } else if (atrr[j].compareTo(billEndTimeStr) > 0) {
                                atrTemp[j] = billEndTimeStr;
                                if (StringUtils.isEmpty((String)atrr[j + 1])) {
                                    atrTemp[j + 1] = atrr[j];
                                }
                            }
                        } else if (segBegTime.getTime() <= billBeginTime.getTime() && segEndTime.getTime() >= billBeginTime.getTime() && segEndTime.getTime() <= billEndTime.getTime() && segBegTime.getTime() < billBeginTime.getTime() || null != segBegElasTime && null != segEndElasTime && segBegElasTime.getTime() <= billBeginTime.getTime() && segEndElasTime.getTime() >= billBeginTime.getTime() && segEndElasTime.getTime() <= billEndTime.getTime()) {
                            if (StringUtils.isEmpty((String)atrr[j + 1])) {
                                atrTemp[j + 1] = billBeginTimeStr;
                            } else if (atrr[j + 1].compareTo(billBeginTimeStr) < 0) {
                                atrTemp[j + 1] = billBeginTimeStr;
                                if (StringUtils.isEmpty((String)atrr[j])) {
                                    atrTemp[j] = atrr[j + 1];
                                }
                            }
                        }
                    }
                    ++i;
                    j += 2;
                }
            }
            boolean isChange = false;
            for (int k = 0; k < atrTemp.length; k += 2) {
                if (!StringUtils.isEmpty((String)atrTemp[k]) && !StringUtils.isEmpty((String)atrTemp[k + 1])) {
                    isChange = true;
                    atrr[k] = atrTemp[k];
                    atrr[k + 1] = atrTemp[k + 1];
                    continue;
                }
                if (!StringUtils.isEmpty((String)atrTemp[k])) {
                    isChange = true;
                    atrr[k] = atrTemp[k];
                    continue;
                }
                if (StringUtils.isEmpty((String)atrTemp[k + 1])) continue;
                isChange = true;
                atrr[k + 1] = atrTemp[k + 1];
            }
            if (isChange) {
                result.setOneOnTime(atrr[0]);
                result.setOneOffTime(atrr[1]);
                result.setTwoOnTime(atrr[2]);
                result.setTwoOffTime(atrr[3]);
                result.setThreeOnTime(atrr[4]);
                result.setThreeOffTime(atrr[5]);
            }
        }
    }
}

