/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AttendLogType;
import com.kingdee.eas.hr.ats.AttendanceLogCollection;
import com.kingdee.eas.hr.ats.AttendanceLogEntryFactory;
import com.kingdee.eas.hr.ats.AttendanceLogEntryInfo;
import com.kingdee.eas.hr.ats.AttendanceLogFactory;
import com.kingdee.eas.hr.ats.AttendanceLogInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class LoggerAtsGenerateHolidayLimit {
    public static final String JOBINSTID = "jobInstId";
    private static LoggerAtsGenerateHolidayLimit atsJobInst = null;

    private LoggerAtsGenerateHolidayLimit() {
    }

    public static void operatorAttendanceLogInfo(final Context ctx, final AttendanceLogCollection logCollection) {
        if (atsJobInst == null) {
            atsJobInst = new LoggerAtsGenerateHolidayLimit();
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    atsJobInst.insertAttendLogInfo(ctx, logCollection);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    private void insertAttendLogInfo(Context ctx, AttendanceLogCollection logCollection) {
        String jobInstId = (String)ctx.get((Object)JOBINSTID);
        if (logCollection.size() == 0) {
            return;
        }
        CoreBaseCollection coreInsertColl = new CoreBaseCollection();
        CoreBaseCollection coreUpdateColl = new CoreBaseCollection();
        try {
            int size = logCollection.size();
            for (int i = 0; i < size; ++i) {
                AttendanceLogInfo loginfo = logCollection.get(i);
                Date attendDate = loginfo.getEntries().get(0).getAttendDate();
                String personid = loginfo.getEntries().get(0).getPerson().getId().toString();
                String attenddate = AtsDateUtils.dateShortToString(attendDate);
                AttendanceLogInfo info = loginfo;
                boolean isexist = AttendanceLogEntryFactory.getLocalInstance(ctx).exists(" where person ='" + personid + "' and attendDate='" + attenddate + "' ");
                if (isexist) {
                    coreUpdateColl.add((CoreBaseInfo)info);
                    continue;
                }
                coreInsertColl.add((CoreBaseInfo)info);
            }
            AttendanceLogFactory.getLocalInstance(ctx).updateBatchData(coreUpdateColl);
            AttendanceLogFactory.getLocalInstance(ctx).addnewBatchData(coreInsertColl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateAttendanceLogStatusInfo(final Context ctx, final AttendanceLogInfo logInfo) {
        if (atsJobInst == null) {
            atsJobInst = new LoggerAtsGenerateHolidayLimit();
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    atsJobInst.updateAttendLogInfo(ctx, logInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    private void updateAttendLogInfo(Context ctx, AttendanceLogInfo logInfo) {
        String jobInstId = (String)ctx.get((Object)JOBINSTID);
        try {
            if (StringUtils.isNotBlank((String)jobInstId)) {
                String updateSql = "update T_HR_ATS_AttendanceLog set FCalStatus = '2' where FJobid = ?";
                Object[] params = new Object[]{jobInstId};
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])params);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void updateAttendanceLogCostTimeInfo(final Context ctx, final Map<String, Object> paraMap) {
        if (atsJobInst == null) {
            atsJobInst = new LoggerAtsGenerateHolidayLimit();
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    atsJobInst.updateAttendLogCostTimeInfo(ctx, paraMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    private void updateAttendLogCostTimeInfo(Context ctx, Map<String, Object> paraMap) {
        String jobInstId = (String)ctx.get((Object)JOBINSTID);
        int calPersonSize = 0;
        long costTime = 0L;
        long costSumTime = 0L;
        long remainTime = 0L;
        if (paraMap.get("calPersonSize") != null) {
            calPersonSize = (Integer)paraMap.get("calPersonSize");
        }
        if (paraMap.get("costSumTime") != null) {
            costSumTime = (Long)paraMap.get("costSumTime");
        }
        if (paraMap.get("costTime") != null) {
            costTime = (Long)paraMap.get("costTime");
        }
        if (paraMap.get("remainTime") != null) {
            remainTime = (Long)paraMap.get("remainTime");
        }
        try {
            if (StringUtils.isNotBlank((String)jobInstId)) {
                String updateSql = "update T_HR_ATS_AttendanceLog set FCalPersonSize = '" + calPersonSize + "'  ,FCostSumTime='" + costSumTime + "' ,FCostTime='" + costTime + "', FRemainTime='" + remainTime + "'  where FJobid = '" + jobInstId + "' ";
                Object[] params = new Object[]{jobInstId};
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static AttendanceLogInfo setAttendanceLogInfo(Map<String, Object> paraMap) {
        AttendanceLogInfo logInfo = new AttendanceLogInfo();
        String jobid = null;
        if (paraMap.get("jobid") != null) {
            jobid = (String)paraMap.get("jobid");
        }
        int sumPerson = 0;
        if (paraMap.get("sumPerson") != null) {
            sumPerson = (Integer)paraMap.get("sumPerson");
        }
        int sumDays = 0;
        if (paraMap.get("sumDays") != null) {
            sumDays = (Integer)paraMap.get("sumDays");
        }
        int sucessTimes = 0;
        if (paraMap.get("sucessTimes") != null) {
            sucessTimes = (Integer)paraMap.get("sucessTimes");
        }
        int failTimes = 0;
        if (paraMap.get("failTimes") != null) {
            failTimes = (Integer)paraMap.get("failTimes");
        }
        Date attendDate = new Date();
        if (paraMap.get("attendDate") != null) {
            attendDate = (Date)paraMap.get("attendDate");
        }
        String excepNumber = null;
        if (paraMap.get("excepNumber") != null) {
            excepNumber = (String)paraMap.get("excepNumber");
        }
        String excepMsg = null;
        if (paraMap.get("excepMsg") != null) {
            excepMsg = (String)paraMap.get("excepMsg");
        }
        String personid = null;
        if (paraMap.get("personid") != null) {
            personid = (String)paraMap.get("personid");
        }
        int calPersonSize = 0;
        if (paraMap.get("calPersonSize") != null) {
            calPersonSize = (Integer)paraMap.get("calPersonSize");
        }
        long costSumTime = 0L;
        if (paraMap.get("costSumTime") != null) {
            costSumTime = (Long)paraMap.get("costSumTime");
        }
        long costTime = 0L;
        if (paraMap.get("costTime") != null) {
            costTime = (Long)paraMap.get("costTime");
        }
        long remainTime = 0L;
        if (paraMap.get("remainTime") != null) {
            remainTime = (Long)paraMap.get("remainTime");
        }
        logInfo.setJobid(jobid);
        logInfo.setSumPerson(BigDecimal.valueOf(sumPerson));
        logInfo.setSumDays(BigDecimal.valueOf(sumDays));
        logInfo.setCalPersonSize(BigDecimal.valueOf(calPersonSize));
        logInfo.setCostSumTime(BigDecimal.valueOf(costSumTime));
        logInfo.setCostTime(BigDecimal.valueOf(costTime));
        logInfo.setRemainTime(BigDecimal.valueOf(remainTime));
        logInfo.setSucessTimes(BigDecimal.valueOf(sucessTimes));
        logInfo.setFailTimes(BigDecimal.valueOf(failTimes));
        logInfo.setLogType(AttendLogType.attendManage);
        AttendanceLogEntryInfo entryInfo = new AttendanceLogEntryInfo();
        entryInfo.setAttendDate(attendDate);
        entryInfo.setExcepNumber(excepNumber);
        entryInfo.setExcepMsg(excepMsg);
        PersonInfo pinfo = new PersonInfo();
        if (personid != null) {
            pinfo.setId(BOSUuid.read((String)personid));
        }
        entryInfo.setPerson(pinfo);
        logInfo.getEntries().add(entryInfo);
        return logInfo;
    }

    public static void collectionExceptionInfo(final Context ctx, final String exceptionInfo) {
        if (atsJobInst == null) {
            atsJobInst = new LoggerAtsGenerateHolidayLimit();
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    atsJobInst.insertExceptionInfo(ctx, exceptionInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertExceptionInfo(Context ctx, String exceptionInfo) {
        String jobInstId = (String)ctx.get((Object)JOBINSTID);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)exceptionInfo)) {
            return;
        }
        try {
            StringBuffer addExceptionInfo = new StringBuffer();
            String querySql = "select flocalExplain from T_JOB_INST where fjobInstId = ?";
            Object[] params = new Object[]{jobInstId};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])params);
            if (rowSet != null) {
                while (rowSet.next()) {
                    addExceptionInfo.append(rowSet.getString("flocalExplain") + exceptionInfo);
                }
            }
            String updateSql = "update T_JOB_INST set flocalExplain = ? where fjobInstId = ?";
            params = new Object[]{addExceptionInfo, jobInstId};
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])params);
        }
        catch (SQLException e) {
            Logger.error((Throwable)e, (String)(MLUtile.getRes(AtsCommonResEnum.SaveError, ctx) + "\uff01"));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

