/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.Precision;

import com.kingdee.eas.hr.ats.GetValueMtdEnum;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.util.Precision.PrecisionHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class LeaveBillPrecisionHelper
extends PrecisionHelper {
    private HolidayPolicyInfo holidayPolicyInfo;

    @Override
    protected void innerInitPrecision() {
        super.innerInitPrecision();
        this.initPrecisionByHPolicy();
    }

    private void initPrecisionByHPolicy() {
        if (this.holidayPolicyInfo == null || !this.holidayPolicyInfo.isEnableLeaveLength()) {
            return;
        }
        GetValueMtdEnum division = this.holidayPolicyInfo.getMinLeaveLengthVMtd();
        if (division == GetValueMtdEnum.floor) {
            this.setRoundingMode(RoundingMode.FLOOR);
        } else if (division == GetValueMtdEnum.ceil) {
            this.setRoundingMode(RoundingMode.CEILING);
        }
        BigDecimal minLen = this.holidayPolicyInfo.getMinLeaveLength();
        if (minLen != null) {
            this.setPrecision(this.holidayPolicyInfo.getMinLeaveLength().scale());
        }
    }

    protected boolean useSystemPrecision() {
        return this.holidayPolicyInfo == null || !this.holidayPolicyInfo.isEnableLeaveLength() || this.holidayPolicyInfo.getMinLeaveLengthVMtd() == GetValueMtdEnum.actualValue || this.holidayPolicyInfo.getMinLeaveLength() == null || this.holidayPolicyInfo.getMinLeaveLength().doubleValue() == 0.0;
    }

    @Override
    public BigDecimal precisionProcess(Object number, int precision, RoundingMode roundingMode) {
        if (this.useSystemPrecision()) {
            return super.precisionProcess(number, precision, roundingMode);
        }
        BigDecimal decimal = new BigDecimal(String.valueOf(number));
        BigDecimal initialVal = this.holidayPolicyInfo.getInitialValue();
        BigDecimal bigDecimal = initialVal = initialVal.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : initialVal;
        if (decimal.compareTo(initialVal) < 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal minLen = this.holidayPolicyInfo.getMinLeaveLength();
        return decimal.divide(minLen, 0, this.getRoundingMode()).multiply(minLen);
    }

    public HolidayPolicyInfo getHolidayPolicyInfo() {
        return this.holidayPolicyInfo;
    }

    public LeaveBillPrecisionHelper setHolidayPolicyInfo(HolidayPolicyInfo holidayPolicyInfo) {
        this.holidayPolicyInfo = holidayPolicyInfo;
        return this;
    }
}

