/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.eas.hr.ats.SchlShiftSrcTypeEnum;
import com.kingdee.eas.hr.ats.thread.ExecutorService.TaskPool;
import com.kingdee.eas.hr.ats.thread.executor.TaskExecutorBase;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.ConfigAts;
import com.kingdee.eas.hr.ats.util.common.DbUtile;
import com.kingdee.eas.hr.ats.util.common.tempTableUtile;
import com.kingdee.eas.hr.ats.vo.common.AtsCtx;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.hr.ats.vo.common.RangeDate;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;

public class ScheduleSaveHelper
extends AtsCtx {
    private String tempTable;
    private int batchCount = 498;
    private Boolean deleteRepeatSchedule;
    private String personField = "person.fnumber";
    private SchlShiftSrcTypeEnum defaultScheduleSrcType;
    private Set<String> schedulePersonNumbers = new HashSet<String>();
    private RangeDate scheduleDateRange = new RangeDate();
    private List<Future> snapShotTasks = new ArrayList<Future>();

    public void doDelete() {
        if (AtsCollectionUtile.isEmpty(this.snapShotTasks) && StringUtils.isBlank((CharSequence)this.tempTable)) {
            return;
        }
        TaskExecutorBase<Object> executor = new TaskExecutorBase<Object>(){

            @Override
            protected Object executeInner() throws Exception {
                ScheduleSaveHelper.this.waitSnapTaskComplete();
                try {
                    int totalRepeadCnt;
                    IRowSet rowSet = DbUtile.executeQuery(this.ctx, " select count(*) from " + ScheduleSaveHelper.this.tempTable);
                    int n = totalRepeadCnt = rowSet.next() ? rowSet.getInt(1) : 0;
                    if (totalRepeadCnt > ScheduleSaveHelper.this.batchCount) {
                        ScheduleSaveHelper.this.deleteRepeatDataBybatch(totalRepeadCnt);
                    } else if (totalRepeadCnt > 0) {
                        ScheduleSaveHelper.this.deleteAllRepeatData();
                    }
                }
                finally {
                    tempTableUtile.dropTable(this.ctx, ScheduleSaveHelper.this.tempTable, true);
                }
                return null;
            }
        };
        TaskPool.execute((Runnable)((Object)executor.setCtx(this.ctx)));
    }

    protected void deleteRepeatDataBybatch(int totalRepeadCnt) throws BOSException {
        int lastPageCnt = totalRepeadCnt % this.batchCount;
        int totalPage = lastPageCnt == 0 ? totalRepeadCnt / this.batchCount : totalRepeadCnt / this.batchCount + 1;
        lastPageCnt = lastPageCnt == 0 ? this.batchCount : lastPageCnt;
        String selSql = MessageFormat.format("select fid from {0} order by fid", this.tempTable);
        String delSql = "/*dialect*/delete from {0} where {1} in (select fid from ({2}) t0)";
        PagingHelper pagingHelper = new PagingHelper();
        for (int i = 0; i < totalPage; ++i) {
            String pageSql = pagingHelper.getPagingSqlNoOptmize(this.ctx, selSql, i * this.batchCount, i == totalPage - 1 ? lastPageCnt : this.batchCount);
            DbUtile.execute(this.ctx, MessageFormat.format(delSql, "t_hr_ats_scheduleshift", "fid", pageSql));
            DbUtile.execute(this.ctx, MessageFormat.format(delSql, "t_hr_ats_scheduleshiftItem", "fgroupId", pageSql));
        }
    }

    protected void deleteAllRepeatData() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from t_hr_ats_scheduleshift t0");
        sql.append(" where exists (select 1 from ").append(this.tempTable).append(" t1 where t0.fid=t1.fid)");
        DbUtile.execute(this.ctx, sql.toString());
        sql.setLength(0);
        sql.append(" delete from t_hr_ats_scheduleshiftItem t0");
        sql.append(" where exists (select 1 from ").append(this.tempTable).append(" t1 where t0.fgroupId=t1.fid)");
        DbUtile.execute(this.ctx, sql.toString());
    }

    protected void waitSnapTaskComplete() {
        for (Future task : this.snapShotTasks) {
            try {
                task.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ScheduleSaveHelper snapShotRepeatSchedule() {
        if (!this.isDeleteRepeatSchedule().booleanValue() || AtsCollectionUtile.isEmpty(this.schedulePersonNumbers) || this.scheduleDateRange == null || !this.scheduleDateRange.isValid()) {
            return null;
        }
        Date startDate = Date.getDate(this.scheduleDateRange.getLowBound());
        Date endDate = Date.getDate(this.scheduleDateRange.getUpBound());
        final StringBuffer sql = new StringBuffer();
        sql.append(" select outerTable.fid fid from t_hr_ats_scheduleshift outerTable");
        if (StringUtils.isNotBlank((CharSequence)this.personField)) {
            sql.append(" join t_bd_person person on person.fid=outerTable.fproposerid");
        }
        sql.append(" where outerTable.fattendDate >={ts '").append(startDate).append("'}");
        sql.append(" and outerTable.fattendDate <= {ts '").append(endDate).append("'}");
        sql.append(" and ").append(this.personField).append(" in ");
        sql.append(AtsCollectionUtile.joinForSqlWithBrackets(this.getSchedulePersonNumbers()));
        sql.append(" and outerTable.fid < (");
        sql.append(" select max(innerTable.fid) from t_hr_ats_scheduleshift innerTable");
        sql.append(" where outerTable.fattenddate=innerTable.fattenddate and outerTable.fproposerid=innerTable.fproposerid");
        sql.append(" )");
        this.scheduleDateRange = null;
        this.schedulePersonNumbers.clear();
        this.snapShotTasks.add(TaskPool.submit(new TaskExecutorBase<Object>(){

            @Override
            protected Object executeInner() throws Exception {
                if (StringUtils.isNotBlank((CharSequence)ScheduleSaveHelper.this.tempTable)) {
                    DbUtile.execute(this.ctx, new StringBuffer("insert into ").append(ScheduleSaveHelper.this.tempTable).append(sql).toString());
                } else {
                    ScheduleSaveHelper.this.tempTable = tempTableUtile.createTableWithFirstIndex(this.ctx, sql.toString());
                }
                return null;
            }
        }.setCtx(this.ctx)));
        return this;
    }

    public static boolean isDeleteRepeatSchedule(Object scheduleSrcType) {
        if (scheduleSrcType == null) {
            return true;
        }
        String typeConfig = ConfigAts.getPropertyFromConfig("schedule.deleteRepeatScheduleSrcTypes");
        if (StringUtils.isBlank((CharSequence)typeConfig)) {
            return true;
        }
        if (scheduleSrcType instanceof SchlShiftSrcTypeEnum) {
            scheduleSrcType = ((SchlShiftSrcTypeEnum)((Object)scheduleSrcType)).getValue();
        }
        return Arrays.asList(StringUtils.split((String)typeConfig)).contains(String.valueOf(scheduleSrcType));
    }

    public Boolean isDeleteRepeatSchedule() {
        if (this.deleteRepeatSchedule == null) {
            this.deleteRepeatSchedule = ScheduleSaveHelper.isDeleteRepeatSchedule((Object)this.defaultScheduleSrcType);
        }
        return (boolean)this.deleteRepeatSchedule;
    }

    public ScheduleSaveHelper setDeleteRepeatSchedule(Boolean deleteRepeatSchedule) {
        this.deleteRepeatSchedule = deleteRepeatSchedule;
        return this;
    }

    public Set<String> getSchedulePersonNumbers() {
        return this.schedulePersonNumbers;
    }

    public RangeDate getScheduleDateRange() {
        return this.scheduleDateRange;
    }

    public ScheduleSaveHelper setTempTable(String tempTable) {
        this.tempTable = tempTable;
        return this;
    }

    public ScheduleSaveHelper setSchedulePersonNumbers(Set<String> schedulePersonNumbers) {
        this.schedulePersonNumbers = schedulePersonNumbers;
        return this;
    }

    public ScheduleSaveHelper setScheduleDateRange(RangeDate scheduleDateRange) {
        this.scheduleDateRange = scheduleDateRange;
        return this;
    }

    public ScheduleSaveHelper setSnapShotTasks(List<Future> snapShotTasks) {
        this.snapShotTasks = snapShotTasks;
        return this;
    }

    public SchlShiftSrcTypeEnum getDefaultScheduleSrcType() {
        return this.defaultScheduleSrcType;
    }

    public ScheduleSaveHelper setDefaultScheduleSrcType(SchlShiftSrcTypeEnum defaultScheduleSrcType) {
        this.defaultScheduleSrcType = defaultScheduleSrcType;
        return this;
    }

    public String getTempTable() {
        return this.tempTable;
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    public ScheduleSaveHelper setBatchCount(int batchCount) {
        this.batchCount = batchCount;
        return this;
    }

    public Boolean getDeleteRepeatSchedule() {
        return this.deleteRepeatSchedule;
    }

    public String getPersonField() {
        return this.personField;
    }

    public ScheduleSaveHelper setPersonField(String personField) {
        this.personField = personField;
        return this;
    }

    public List<Future> getSnapShotTasks() {
        return this.snapShotTasks;
    }
}

