/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AbstractHolidayPolicyInfo;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisCollection;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisFactory;
import com.kingdee.eas.hr.ats.AtsHolidayFileHisInfo;
import com.kingdee.eas.hr.ats.AtsTakeWorkingFactory;
import com.kingdee.eas.hr.ats.AtsTakeWorkingInfo;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayLimitTransferCollection;
import com.kingdee.eas.hr.ats.HolidayLimitTransferFactory;
import com.kingdee.eas.hr.ats.HolidayLimitTransferInfo;
import com.kingdee.eas.hr.ats.HolidayLimitTransferStatus;
import com.kingdee.eas.hr.ats.HolidayPolicyCollection;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayRuleFactory;
import com.kingdee.eas.hr.ats.HolidayRuleInfo;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.hr.ats.LimitRuleEntryFactory;
import com.kingdee.eas.hr.ats.LimitRuleEntryInfo;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.OperTypeEnum;
import com.kingdee.eas.hr.ats.dataLog.control.LogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.control.impl.AtsLimitLogControlCenter;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogUtil;
import com.kingdee.eas.hr.ats.decimalPlace.strategy.impl.DecimalPlaceOperationSystem;
import com.kingdee.eas.hr.ats.holidayLimit.generate.manager.GenHolidayLimitManager;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class TranLimitUtil {
    private Logger logger = Logger.getLogger(TranLimitUtil.class);

    public void TranLimit(Context ctx, HolidayLimitCollection coll, String personId) {
        AtsHolidayFileHisCollection fileHisCollection = null;
        try {
            fileHisCollection = AtsHolidayFileHisFactory.getLocalInstance(ctx).getAtsHolidayFileHisCollection("where proposer.id='" + personId + "' and attendFileState='1' order by effdt desc");
            if (fileHisCollection.size() > 0) {
                AtsHolidayFileHisInfo info = fileHisCollection.get(0);
                for (int i = 0; i < coll.size(); ++i) {
                    String tranConditionsOld;
                    HolidayLimitInfo holidayLimitInfo = coll.get(i);
                    HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo((IObjectPK)new ObjectUuidPK(holidayLimitInfo.getHolidayPolicy().getId().toString()));
                    LimitRuleEntryInfo limitRuleEntryInfoNew = this.isTranStratger(ctx, info, holidayPolicyInfo.getHolidayType().getId().toString());
                    LimitRuleEntryInfo limitRuleEntryInfoOld = this.isTranStratger(ctx, fileHisCollection.get(1), holidayPolicyInfo.getHolidayType().getId().toString());
                    if (null == limitRuleEntryInfoOld) continue;
                    String string = tranConditionsOld = limitRuleEntryInfoOld.getTranConditions() == null ? "2" : limitRuleEntryInfoOld.getTranConditions().getValue();
                    if (tranConditionsOld.equals("2") || tranConditionsOld.equals("0") && holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) == 0 || tranConditionsOld.equals("1") && holidayLimitInfo.getRemainLimit().compareTo(BigDecimal.ZERO) < 0) continue;
                    String flagNew = limitRuleEntryInfoNew.getTranStratger() == null ? "2" : limitRuleEntryInfoNew.getTranStratger().getValue();
                    String tranConditionsNew = limitRuleEntryInfoNew.getTranConditions() == null ? "2" : limitRuleEntryInfoNew.getTranConditions().getValue();
                    BigDecimal tranUnitNew = limitRuleEntryInfoNew.getTranUnit() == null ? BigDecimal.valueOf(8L) : limitRuleEntryInfoNew.getTranUnit();
                    HolidayLimitCollection limitColl = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where proposer.id= '" + personId + "' and hrOrgUnit.id= '" + info.getHrOrgUnit().getId() + "' and holidayPolicy.holidayType.id='" + holidayPolicyInfo.getHolidayType().getId().toString() + "' order by effectDate ASC");
                    BigDecimal currentTransferLimitVal = holidayLimitInfo.getRemainLimit();
                    String id = this.insertHolidayLimitTransInfer(ctx, holidayLimitInfo, info, fileHisCollection.get(1));
                    if (tranConditionsNew.equals("2") || tranConditionsNew.equals("0") && currentTransferLimitVal.compareTo(BigDecimal.ZERO) == 0 || tranConditionsNew.equals("1") && currentTransferLimitVal.compareTo(BigDecimal.ZERO) < 0) continue;
                    if (flagNew.equals("0")) {
                        if (limitColl.size() <= 0) continue;
                        this.insertHolidayLimitTransOutfer(ctx, limitColl.get(0), info, currentTransferLimitVal, id, tranUnitNew);
                        continue;
                    }
                    if (!flagNew.equals("1")) continue;
                    holidayLimitInfo.setAdminOrgUnit(info.getAdminOrgUnit());
                    holidayLimitInfo.setHrOrgUnit(info.getHrOrgUnit());
                    holidayLimitInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                    holidayLimitInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                    String holidayTypeId = holidayPolicyInfo.getHolidayType().getId().toString();
                    String startTime = HRTimeWebUtils.dateLongToString(holidayLimitInfo.getCycleBeginDate());
                    String endTime = HRTimeWebUtils.dateLongToString(holidayLimitInfo.getCycleEndDate());
                    String hrOrgUnitId = info.getHrOrgUnit().getId().toString();
                    HolidayTypeUnitEnum holidayTypeUnitEnum = this.getHolidayLimitUnit(ctx, info, holidayTypeId);
                    HolidayLimitCollection holidayLimitColl = HolidayLimitFactory.getLocalInstance(ctx).getHolidayLimitCollection(" where  proposer='" + personId + "' and  holidayPolicy.holidayType='" + holidayTypeId + "' and cycleBeginDate <= '" + endTime + "' and cycleEndDate >= '" + startTime + "' and hrOrgUnit.id='" + hrOrgUnitId + "'");
                    if (holidayLimitColl.size() > 0) {
                        holidayLimitInfo = holidayLimitColl.get(0);
                        holidayLimitInfo.setHolidayUnit(holidayTypeUnitEnum);
                    } else {
                        holidayLimitInfo.setHolidayUnit(holidayTypeUnitEnum);
                        holidayLimitInfo.setStandardLimit(BigDecimal.ZERO);
                        holidayLimitInfo.setAddOrSubLimit(BigDecimal.ZERO);
                        holidayLimitInfo.setFreezeLimit(BigDecimal.ZERO);
                        holidayLimitInfo.setUsedLimit(BigDecimal.ZERO);
                        holidayLimitInfo.setRealLimit(BigDecimal.ZERO);
                        holidayLimitInfo.setId(BOSUuid.create((String)"A804F41D"));
                        holidayLimitInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                        holidayLimitInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                    }
                    this.insertHolidayLimitTransOutfer(ctx, holidayLimitInfo, info, currentTransferLimitVal, id, tranUnitNew);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String insertHolidayLimitTransInfer(Context ctx, HolidayLimitInfo holidayLimitInfo, AtsHolidayFileHisInfo atsHolidayFileHis, AtsHolidayFileHisInfo oldFileInfo) {
        BigDecimal standardLimit = holidayLimitInfo.getStandardLimit();
        BigDecimal realLimit = holidayLimitInfo.getRealLimit();
        BigDecimal usedLimit = holidayLimitInfo.getUsedLimit();
        BigDecimal freezeLimit = holidayLimitInfo.getFreezeLimit();
        BigDecimal preOverdraftLimit = holidayLimitInfo.getPreOverdraftLimit();
        BigDecimal remainLimit = holidayLimitInfo.getRemainLimit();
        BigDecimal addorSublimit = holidayLimitInfo.getAddOrSubLimit();
        BigDecimal realLimitCounted = BigDecimal.valueOf(0L);
        BigDecimal remainLimitCounted = BigDecimal.valueOf(0L);
        HolidayLimitTransferInfo holidayLimitTransferInfo = new HolidayLimitTransferInfo();
        Object id = null;
        try {
            holidayLimitTransferInfo.setAdminOrgUnit(holidayLimitInfo.getAdminOrgUnit());
            holidayLimitTransferInfo.setHrOrgUnit(holidayLimitInfo.getHrOrgUnit());
            holidayLimitTransferInfo.setPreHrOrgUnit(holidayLimitInfo.getHrOrgUnit());
            holidayLimitTransferInfo.setCurrentHrOrgUnit(atsHolidayFileHis.getHrOrgUnit());
            holidayLimitTransferInfo.setProposer(holidayLimitInfo.getProposer());
            addorSublimit = holidayLimitInfo.getAddOrSubLimit();
            holidayLimitTransferInfo.setPreTransferLimit(remainLimit);
            addorSublimit = addorSublimit.subtract(remainLimit);
            realLimitCounted = standardLimit.add(addorSublimit);
            remainLimitCounted = realLimitCounted.subtract(usedLimit).subtract(freezeLimit).subtract(preOverdraftLimit);
            holidayLimitInfo.setAddOrSubLimit(addorSublimit);
            holidayLimitInfo.setRealLimit(realLimitCounted);
            holidayLimitInfo.setRemainLimit(remainLimitCounted);
            HolidayLimitFactory.getLocalInstance(ctx).save((CoreBaseInfo)holidayLimitInfo);
            holidayLimitTransferInfo.setPreHolidayLimitUnit(holidayLimitInfo.getHolidayUnit());
            holidayLimitTransferInfo.setPreHolidayLimit(holidayLimitInfo);
            holidayLimitTransferInfo.setTransferStatus(HolidayLimitTransferStatus.out);
            HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo((IObjectPK)new ObjectUuidPK(holidayLimitInfo.getHolidayPolicy().getId().toString()));
            holidayLimitTransferInfo = this.setHolidayRuleTransferInfo(ctx, holidayLimitTransferInfo, oldFileInfo, holidayPolicyInfo.getHolidayType().getId().toString());
            id = HolidayLimitTransferFactory.getLocalInstance(ctx).save((CoreBaseInfo)holidayLimitTransferInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return id.toString();
    }

    public void insertHolidayLimitTransOutfer(Context ctx, HolidayLimitInfo holidayLimitInfo, AtsHolidayFileHisInfo atsHolidayFileHis, BigDecimal currentTransferLimitVal, String id, BigDecimal tranUnit) {
        boolean tempCurrentTransferLimitVal = false;
        BigDecimal standardLimit = BigDecimal.valueOf(0L);
        BigDecimal realLimit = BigDecimal.valueOf(0L);
        BigDecimal usedLimit = BigDecimal.valueOf(0L);
        BigDecimal freezeLimit = BigDecimal.valueOf(0L);
        BigDecimal preOverdraftLimit = BigDecimal.valueOf(0L);
        BigDecimal remainLimit = BigDecimal.valueOf(0L);
        BigDecimal addorSublimit = BigDecimal.valueOf(0L);
        BigDecimal realLimitCounted = BigDecimal.valueOf(0L);
        BigDecimal remainLimitCounted = BigDecimal.valueOf(0L);
        HolidayLimitTransferInfo holidayLimitTransferInfo = null;
        try {
            holidayLimitTransferInfo = HolidayLimitTransferFactory.getLocalInstance(ctx).getHolidayLimitTransferInfo(" select preHolidayLimit.*,currentHolidayLimit.*, * where id ='" + id + "'");
            holidayLimitTransferInfo.setHrOrgUnit(atsHolidayFileHis.getHrOrgUnit());
            standardLimit = holidayLimitInfo.getStandardLimit();
            realLimit = holidayLimitInfo.getRealLimit();
            usedLimit = holidayLimitInfo.getUsedLimit();
            freezeLimit = holidayLimitInfo.getFreezeLimit();
            preOverdraftLimit = holidayLimitInfo.getPreOverdraftLimit();
            remainLimit = holidayLimitInfo.getRemainLimit();
            addorSublimit = holidayLimitInfo.getAddOrSubLimit();
            currentTransferLimitVal = this.getRemainLimit(ctx, currentTransferLimitVal, holidayLimitTransferInfo.getPreHolidayLimitUnit().getValue(), holidayLimitInfo.getHolidayUnit().getValue(), tranUnit);
            holidayLimitTransferInfo.setCurrentTransferLimit(currentTransferLimitVal);
            holidayLimitTransferInfo.setTransferStatus(HolidayLimitTransferStatus.in);
            holidayLimitTransferInfo.setCurrentHolidayLimitUnit(holidayLimitInfo.getHolidayUnit());
            addorSublimit = addorSublimit.add(currentTransferLimitVal);
            realLimitCounted = standardLimit.add(addorSublimit);
            remainLimitCounted = realLimitCounted.subtract(usedLimit).subtract(freezeLimit).subtract(preOverdraftLimit);
            holidayLimitInfo.setAddOrSubLimit(addorSublimit);
            holidayLimitInfo.setRealLimit(realLimitCounted);
            holidayLimitInfo.setRemainLimit(remainLimitCounted);
            HolidayLimitFactory.getLocalInstance(ctx).save((CoreBaseInfo)holidayLimitInfo);
            holidayLimitTransferInfo.setCurrentHolidayLimit(holidayLimitInfo);
            HolidayPolicyInfo holidayPolicyInfo = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyInfo((IObjectPK)new ObjectUuidPK(holidayLimitInfo.getHolidayPolicy().getId().toString()));
            holidayLimitTransferInfo = this.setHolidayRuleTransferInfo(ctx, holidayLimitTransferInfo, atsHolidayFileHis, holidayPolicyInfo.getHolidayType().getId().toString());
            HolidayLimitTransferFactory.getLocalInstance(ctx).save((CoreBaseInfo)holidayLimitTransferInfo);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
    }

    public LimitRuleEntryInfo isTranStratger(Context ctx, AtsHolidayFileHisInfo atsHolidayFileHis, String holidayTypeId) {
        HolidayPolicyCollection collection = null;
        AbstractHolidayPolicyInfo holidayPolicyInfo = null;
        try {
            String holidayPolicySetId = atsHolidayFileHis.getHolidayPolicySet().getId().toString();
            collection = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection(" where holidayPolicySet.id='" + holidayPolicySetId + "'");
            for (int i = 0; i < collection.size(); ++i) {
                String typeId = collection.get(i).getHolidayType().getId().toString();
                if (!holidayTypeId.equals(typeId)) continue;
                holidayPolicyInfo = collection.get(i);
                break;
            }
            if (null != holidayPolicyInfo) {
                if (holidayPolicyInfo.isIsCtrlLimit()) {
                    if (holidayTypeId.equals("+ZM5jTmrS0KHCjDSYGcFLf0tUpg=")) {
                        String takeWorkId = holidayPolicyInfo.getTakeWorkingRule().getId().toString();
                        AtsTakeWorkingInfo atsTakeWorkingInfo = AtsTakeWorkingFactory.getLocalInstance(ctx).getAtsTakeWorkingInfo("select limitRule.id where id ='" + takeWorkId + "'");
                        LimitRuleEntryInfo limitRuleEntryInfo = LimitRuleEntryFactory.getLocalInstance(ctx).getLimitRuleEntryInfo((IObjectPK)new ObjectUuidPK(atsTakeWorkingInfo.getLimitRule().getId().toString()));
                        return limitRuleEntryInfo;
                    }
                    String holidayid = holidayPolicyInfo.getHolidayRule().getId().toString();
                    HolidayRuleInfo holidayRuleInfo = HolidayRuleFactory.getLocalInstance(ctx).getHolidayRuleInfo("select limitRule.id where id ='" + holidayid + "'");
                    LimitRuleEntryInfo limitRuleEntryInfo = LimitRuleEntryFactory.getLocalInstance(ctx).getLimitRuleEntryInfo((IObjectPK)new ObjectUuidPK(holidayRuleInfo.getLimitRule().getId().toString()));
                    return limitRuleEntryInfo;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public HolidayTypeUnitEnum getHolidayLimitUnit(Context ctx, AtsHolidayFileHisInfo atsHolidayFileHis, String holidayTypeId) {
        HolidayPolicyCollection collection = null;
        AbstractHolidayPolicyInfo holidayPolicyInfo = null;
        try {
            String holidayPolicySetId = atsHolidayFileHis.getHolidayPolicySet().getId().toString();
            collection = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection(" where holidayPolicySet.id='" + holidayPolicySetId + "'");
            for (int i = 0; i < collection.size(); ++i) {
                String typeId = collection.get(i).getHolidayType().getId().toString();
                if (!holidayTypeId.equals(typeId)) continue;
                holidayPolicyInfo = collection.get(i);
                break;
            }
            if (null != holidayPolicyInfo) {
                return holidayPolicyInfo.getUnit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public HolidayLimitTransferInfo setHolidayRuleTransferInfo(Context ctx, HolidayLimitTransferInfo holidayLimitTransferInfo, AtsHolidayFileHisInfo info, String holidayTypeId) {
        String holidayPolicySetId = info.getHolidayPolicySet().getId().toString();
        HolidayPolicyCollection collection = null;
        AbstractHolidayPolicyInfo holidayPolicyInfo = null;
        try {
            collection = HolidayPolicyFactory.getLocalInstance(ctx).getHolidayPolicyCollection(" where holidayPolicySet.id='" + holidayPolicySetId + "'");
            for (int i = 0; i < collection.size(); ++i) {
                String typeId = collection.get(i).getHolidayType().getId().toString();
                if (!holidayTypeId.equals(typeId)) continue;
                holidayPolicyInfo = collection.get(i);
                break;
            }
            if (null != holidayPolicyInfo && holidayPolicyInfo.isIsCtrlLimit()) {
                if (holidayTypeId.equals("+ZM5jTmrS0KHCjDSYGcFLf0tUpg=")) {
                    String takeWorkId = holidayPolicyInfo.getTakeWorkingRule().getId().toString();
                    AtsTakeWorkingInfo atsTakeWorkingInfo = AtsTakeWorkingFactory.getLocalInstance(ctx).getAtsTakeWorkingInfo("select limitRule.tranConditions where id ='" + takeWorkId + "'");
                    String limitRuleId = atsTakeWorkingInfo.getLimitRule().getId().toString();
                    LimitRuleEntryInfo limitRuleEntryInfo = LimitRuleEntryFactory.getLocalInstance(ctx).getLimitRuleEntryInfo((IObjectPK)new ObjectUuidPK(limitRuleId));
                    holidayLimitTransferInfo.setTranConditions(limitRuleEntryInfo.getTranConditions());
                    holidayLimitTransferInfo.setTranStratger(limitRuleEntryInfo.getTranStratger());
                    holidayLimitTransferInfo.setTranUnit(limitRuleEntryInfo.getTranUnit());
                } else {
                    String holidayid = holidayPolicyInfo.getHolidayRule().getId().toString();
                    HolidayRuleInfo holidayRuleInfo = HolidayRuleFactory.getLocalInstance(ctx).getHolidayRuleInfo("select limitRule.tranConditions where id ='" + holidayid + "'");
                    String limitRuleId = holidayRuleInfo.getLimitRule().getId().toString();
                    LimitRuleEntryInfo limitRuleEntryInfo = LimitRuleEntryFactory.getLocalInstance(ctx).getLimitRuleEntryInfo((IObjectPK)new ObjectUuidPK(limitRuleId));
                    holidayLimitTransferInfo.setTranConditions(limitRuleEntryInfo.getTranConditions());
                    holidayLimitTransferInfo.setTranStratger(limitRuleEntryInfo.getTranStratger());
                    holidayLimitTransferInfo.setTranUnit(limitRuleEntryInfo.getTranUnit());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return holidayLimitTransferInfo;
    }

    public BigDecimal getRemainLimit(Context ctx, BigDecimal currLimit, int oldUnit, int newUnit, BigDecimal tranUnit) {
        if (oldUnit != newUnit) {
            currLimit = oldUnit == 1 ? currLimit.multiply(tranUnit) : new DecimalPlaceOperationSystem().precisionConvert(ctx, currLimit.divide(tranUnit, 8, RoundingMode.HALF_UP), RoundingMode.HALF_UP);
        }
        return currLimit;
    }

    public void cancelTransferIn(Context ctx, String[] tranId) {
        HolidayLimitInfo currentTransferLimitInfo = null;
        BigDecimal standardLimit = BigDecimal.valueOf(0L);
        BigDecimal usedLimit = BigDecimal.valueOf(0L);
        BigDecimal freezeLimit = BigDecimal.valueOf(0L);
        BigDecimal preOverdraftLimit = BigDecimal.valueOf(0L);
        BigDecimal addorSublimit = BigDecimal.valueOf(0L);
        BigDecimal realLimitCounted = BigDecimal.valueOf(0L);
        BigDecimal remainLimitCounted = BigDecimal.valueOf(0L);
        HolidayLimitTransferInfo holidayLimitTransferInfo = null;
        BigDecimal currentTransferLimit = BigDecimal.valueOf(0L);
        CoreBaseCollection oldLimitCol = new CoreBaseCollection();
        CoreBaseCollection newLimitCol = new CoreBaseCollection();
        int n = tranId.length;
        for (int i = 0; i < n; ++i) {
            try {
                holidayLimitTransferInfo = HolidayLimitTransferFactory.getLocalInstance(ctx).getHolidayLimitTransferInfo(" select preHolidayLimit.*,currentHolidayLimit.*, *, preHrOrgUnit.*, currentHrOrgUnit.*  where id ='" + tranId[i] + "'");
                currentTransferLimitInfo = holidayLimitTransferInfo.getCurrentHolidayLimit();
                if (currentTransferLimitInfo != null) {
                    oldLimitCol.add((CoreBaseInfo)((HolidayLimitInfo)holidayLimitTransferInfo.clone()));
                    oldLimitCol.add((CoreBaseInfo)((HolidayLimitInfo)currentTransferLimitInfo.clone()));
                    currentTransferLimit = holidayLimitTransferInfo.getCurrentTransferLimit();
                    standardLimit = currentTransferLimitInfo.getStandardLimit();
                    usedLimit = currentTransferLimitInfo.getUsedLimit();
                    freezeLimit = currentTransferLimitInfo.getFreezeLimit();
                    preOverdraftLimit = currentTransferLimitInfo.getPreOverdraftLimit();
                    addorSublimit = currentTransferLimitInfo.getAddOrSubLimit();
                    addorSublimit = addorSublimit.subtract(currentTransferLimit);
                    realLimitCounted = standardLimit.add(addorSublimit);
                    remainLimitCounted = realLimitCounted.subtract(usedLimit).subtract(freezeLimit).subtract(preOverdraftLimit);
                    currentTransferLimitInfo.setAddOrSubLimit(addorSublimit);
                    currentTransferLimitInfo.setRealLimit(realLimitCounted);
                    currentTransferLimitInfo.setRemainLimit(remainLimitCounted);
                    GenHolidayLimitManager genHolidayLimitManager = new GenHolidayLimitManager();
                    genHolidayLimitManager.addShiftTotalRemainLimit(currentTransferLimitInfo, (boolean)Boolean.FALSE, ctx);
                    HolidayLimitFactory.getLocalInstance(ctx).save((CoreBaseInfo)currentTransferLimitInfo);
                    holidayLimitTransferInfo.setTransferStatus(HolidayLimitTransferStatus.out);
                    holidayLimitTransferInfo.setCurrentHolidayLimit(new HolidayLimitInfo());
                    HolidayLimitTransferFactory.getLocalInstance(ctx).save((CoreBaseInfo)holidayLimitTransferInfo);
                    newLimitCol.add((CoreBaseInfo)holidayLimitTransferInfo);
                    newLimitCol.add((CoreBaseInfo)currentTransferLimitInfo);
                }
                DataLogUtil.addLogObserverToCenter(ctx, (LogControlCenter)AtsLimitLogControlCenter.getInstance(), oldLimitCol, OperTypeEnum.holidayLimit, OperActionEnum.cancelTransferLimitIn, false);
                DataLogUtil.addLogObserverToCenter(ctx, (LogControlCenter)AtsLimitLogControlCenter.getInstance(), newLimitCol, OperTypeEnum.holidayLimit, OperActionEnum.cancelTransferLimitIn, true);
                continue;
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
                continue;
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void cancelTransferOut(Context ctx, String[] tranId) {
        HolidayLimitInfo preHolidayLimitInfo = null;
        BigDecimal standardLimit = BigDecimal.valueOf(0L);
        BigDecimal usedLimit = BigDecimal.valueOf(0L);
        BigDecimal freezeLimit = BigDecimal.valueOf(0L);
        BigDecimal preOverdraftLimit = BigDecimal.valueOf(0L);
        BigDecimal addorSublimit = BigDecimal.valueOf(0L);
        BigDecimal realLimitCounted = BigDecimal.valueOf(0L);
        BigDecimal remainLimitCounted = BigDecimal.valueOf(0L);
        HolidayLimitTransferInfo holidayLimitTransferInfo = null;
        BigDecimal preTransferLimit = BigDecimal.valueOf(0L);
        CoreBaseCollection oldLimitCol = new CoreBaseCollection();
        CoreBaseCollection newLimitCol = new CoreBaseCollection();
        int n = tranId.length;
        for (int i = 0; i < n; ++i) {
            try {
                holidayLimitTransferInfo = HolidayLimitTransferFactory.getLocalInstance(ctx).getHolidayLimitTransferInfo(" select preHolidayLimit.*,currentHolidayLimit.*, *, where id ='" + tranId[i] + "'");
                preHolidayLimitInfo = holidayLimitTransferInfo.getPreHolidayLimit();
                if (preHolidayLimitInfo != null) {
                    oldLimitCol.add((CoreBaseInfo)((HolidayLimitInfo)preHolidayLimitInfo.clone()));
                    preTransferLimit = holidayLimitTransferInfo.getPreTransferLimit();
                    standardLimit = preHolidayLimitInfo.getStandardLimit();
                    usedLimit = preHolidayLimitInfo.getUsedLimit();
                    freezeLimit = preHolidayLimitInfo.getFreezeLimit();
                    preOverdraftLimit = preHolidayLimitInfo.getPreOverdraftLimit();
                    addorSublimit = preHolidayLimitInfo.getAddOrSubLimit();
                    addorSublimit = addorSublimit.add(preTransferLimit);
                    realLimitCounted = standardLimit.add(addorSublimit);
                    remainLimitCounted = realLimitCounted.subtract(usedLimit).subtract(freezeLimit).subtract(preOverdraftLimit);
                    preHolidayLimitInfo.setAddOrSubLimit(addorSublimit);
                    preHolidayLimitInfo.setRealLimit(realLimitCounted);
                    preHolidayLimitInfo.setRemainLimit(remainLimitCounted);
                    HolidayLimitFactory.getLocalInstance(ctx).save((CoreBaseInfo)preHolidayLimitInfo);
                    HolidayLimitTransferFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(tranId[i]));
                    newLimitCol.add((CoreBaseInfo)preHolidayLimitInfo);
                    newLimitCol.add((CoreBaseInfo)holidayLimitTransferInfo);
                }
                DataLogUtil.addLogObserverToCenter(ctx, (LogControlCenter)AtsLimitLogControlCenter.getInstance(), oldLimitCol, OperTypeEnum.holidayLimit, OperActionEnum.cancelTransferLimitOut, false);
                DataLogUtil.addLogObserverToCenter(ctx, (LogControlCenter)AtsLimitLogControlCenter.getInstance(), newLimitCol, OperTypeEnum.holidayLimit, OperActionEnum.cancelTransferLimitOut, true);
                continue;
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
                continue;
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void cancelTranLimit(Context ctx, String personId, String hrOrgId, String changeDate) {
        try {
            HolidayLimitTransferCollection collection = HolidayLimitTransferFactory.getLocalInstance(ctx).getHolidayLimitTransferCollection("where Proposer.id='" + personId + "' and currentHrOrgUnit ='" + hrOrgId + "' and createTime >='" + changeDate + "'");
            if (collection.size() > 0) {
                int size = collection.size();
                String[] ids = new String[size];
                for (int i = 0; i < size; ++i) {
                    ids[i] = collection.get(i).getId().toString();
                }
                this.cancelTransferIn(ctx, ids);
                this.cancelTransferOut(ctx, ids);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"cancelTranLimit error~");
            e.printStackTrace();
        }
    }
}

