/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.util.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.DirectSenderAgent;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.util.Locale;
import java.util.Map;

public class MsgSendHelper {
    private static final Map<String, Object> defaultMap = AtsCollectionUtile.newMap("isSendCommon", Boolean.TRUE, "type", 0, "bizType", 20, "priority", 20, "sourceStatus", 0);
    private Context ctx;

    public Message getMessage() {
        return MessageFactory.newMessage();
    }

    public Message getMessage(IObjectValue objectValue, String msfField, String receiverUserId) {
        return this.getMessage(objectValue, msfField, msfField, receiverUserId);
    }

    public Message getMessage(IObjectValue objectValue, String titleField, String bodyField, String receiverUserId) {
        Message message = this.getMessage();
        if (objectValue == null) {
            return message;
        }
        bodyField = bodyField == null ? titleField : bodyField;
        boolean queryMsg = objectValue.get(titleField, LocaleUtils.locale_l2) == null;
        boolean bl = queryMsg = queryMsg || objectValue.get(bodyField, LocaleUtils.locale_l2) == null;
        if (queryMsg && CoreBaseUtile.getId(objectValue) != null) {
            try {
                EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{titleField, bodyField});
                AtsViewUtile.getViewByFilter("id", (Object)CoreBaseUtile.getId(objectValue), evi);
                objectValue = AtsEntityUtile.getBizInterface(this.ctx, (CoreBaseInfo)objectValue).getValue(evi.toString());
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        for (Locale locale : new Locale[]{LocaleUtils.locale_l1, LocaleUtils.locale_l2, LocaleUtils.locale_l3}) {
            message.setLocaleStringHeader("title", (String)objectValue.get(titleField, locale), locale);
            message.setLocaleStringHeader("body", (String)objectValue.get(bodyField, locale), locale);
        }
        message.setStringHeader("receiver", receiverUserId);
        return message;
    }

    public void send(Message message) {
        this.beforeSend(message);
        DirectSenderAgent.getSenderAgent().sendMessage(message);
    }

    protected void beforeSend(Message message) {
        for (String name : new String[]{"sender", "initiatorName"}) {
            if (message.getLocaleStringHeader(name, LocaleUtils.locale_l2) != null) continue;
            for (Locale locale : new Locale[]{LocaleUtils.locale_l1, LocaleUtils.locale_l2, LocaleUtils.locale_l3}) {
                message.setLocaleStringHeader(name, SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"sys_auto_send", (Locale)locale), locale);
            }
        }
        for (String name : defaultMap.keySet()) {
            if (defaultMap.containsKey(name)) continue;
            message.setObjectHeader(name, defaultMap.get(name));
        }
        String userId = this.ctx.getCaller().toString();
        if (message.getHeaderValue("receiver") == null) {
            message.setStringHeader("receiver", userId);
        }
        if (message.getHeaderValue("senderId") == null) {
            message.setStringHeader("senderId", userId);
        }
        message.setStringHeader("solution", this.ctx.getSolution());
        message.setStringHeader("databaseCenter", this.ctx.getAIS());
    }
}

