/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.ats.AdjustTypeEnum;
import com.kingdee.eas.hr.ats.AtsAffairEntryBaseInfo;
import com.kingdee.eas.hr.ats.AtsScheduleShiftEntryInfo;
import com.kingdee.eas.hr.ats.AtsScheduleShiftInfo;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.validator.BillValidator;
import com.kingdee.eas.hr.ats.validator.PlateformType;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Set;

public class AtsScheshiftValidator
extends BillValidator<AtsScheduleShiftInfo> {
    @Override
    protected String validateEntryDAC(String field, AtsAffairEntryBaseInfo entryBillInfo, AtsScheduleShiftInfo billInfo) throws Exception {
        boolean outManage;
        if (PlateformType.isSelf(this.getValidateCtx().getPlateformType())) {
            return this.isCurrentPerson(entryBillInfo) ? null : MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NOT_SELF", this.getValidateCtx().getBosCtx());
        }
        boolean bl = outManage = PlateformType.isPro(this.getValidateCtx().getPlateformType()) && !this.isDefaultManage(entryBillInfo);
        if (outManage) {
            return null;
        }
        Set<String> adminOrgRange = this.getValidateCtx().getAdminOrgRange();
        AdminOrgUnitInfo adminInfo = entryBillInfo.getAdminOrgUnit();
        if (adminInfo != null && adminOrgRange.contains(adminInfo.getString("id"))) {
            return null;
        }
        adminInfo = entryBillInfo.getAttAdminOrgUnit();
        if (adminInfo != null && adminOrgRange.contains(adminInfo.getString("id"))) {
            return null;
        }
        return MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "NO_BILL_PERM_ADMIN", this.getValidateCtx().getBosCtx());
    }

    protected boolean isCurrentPerson(AtsAffairEntryBaseInfo entryBillInfo) throws Exception {
        AtsScheduleShiftEntryInfo entryInfo = (AtsScheduleShiftEntryInfo)entryBillInfo;
        if (entryInfo.getAdjustType().equals((Object)AdjustTypeEnum.adjustWithOther)) {
            return true;
        }
        UserInfo curUserInfo = ContextUtil.getCurrentUserInfo((Context)this.getValidateCtx().getBosCtx());
        String currentPersonId = this.getPersonIdByUser(curUserInfo);
        String comparePersonId = this.getPersonIdByUser(entryBillInfo.getPerson());
        return comparePersonId != null && comparePersonId.equals(currentPersonId);
    }
}

