/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsAffairBaseInfo;
import com.kingdee.eas.hr.ats.AtsAffairEntryBaseInfo;
import com.kingdee.eas.hr.ats.AtsAttenceResEnum;
import com.kingdee.eas.hr.ats.AtsBillBizException;
import com.kingdee.eas.hr.ats.AtsBillResEnum;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsFileBizException;
import com.kingdee.eas.hr.ats.AtsOrdinalCommonResEnum;
import com.kingdee.eas.hr.ats.AtsShiftFactory;
import com.kingdee.eas.hr.ats.AtsShiftInfo;
import com.kingdee.eas.hr.ats.AtsStaticResourceBizException;
import com.kingdee.eas.hr.ats.AtsTripBillCollection;
import com.kingdee.eas.hr.ats.AtsTripBillEntryCollection;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsTripBillFactory;
import com.kingdee.eas.hr.ats.AtsTripBillInfo;
import com.kingdee.eas.hr.ats.AtsTripBillResEnum;
import com.kingdee.eas.hr.ats.AttencePolicyCycleTypeEnum;
import com.kingdee.eas.hr.ats.AttencePolicyFactory;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.BillSourceTypeEnum;
import com.kingdee.eas.hr.ats.CardRuleFactory;
import com.kingdee.eas.hr.ats.CardRuleInfo;
import com.kingdee.eas.hr.ats.ControlTypeEnum;
import com.kingdee.eas.hr.ats.FillAmountUnitEnum;
import com.kingdee.eas.hr.ats.IAtsTripBill;
import com.kingdee.eas.hr.ats.IsAttendanceEnum;
import com.kingdee.eas.hr.ats.OperActionEnum;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.TripbillCancelEnum;
import com.kingdee.eas.hr.ats.biz.util.AtsLeaveBillUtil;
import com.kingdee.eas.hr.ats.dataLog.util.DataLogsRecordUtil;
import com.kingdee.eas.hr.ats.lightapp.util.AtsWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.AttencePolicyFillUtil;
import com.kingdee.eas.hr.ats.lightapp.util.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.lightapp.util.SHRBillUtil;
import com.kingdee.eas.hr.ats.util.AtsAttendanceFileUtils;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.hr.ats.util.FetchCardUtil;
import com.kingdee.eas.hr.ats.util.common.AtsBillAssist;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.CoreBaseUtile;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.util.common.ParamUtile;
import com.kingdee.eas.hr.ats.util.common.TimeZoneUtile;
import com.kingdee.eas.hr.ats.validator.BillHelper;
import com.kingdee.eas.hr.ats.validator.DateInterVal;
import com.kingdee.eas.hr.ats.validator.ValidateCtx;
import com.kingdee.eas.hr.ats.validator.ValidateUtile;
import com.kingdee.eas.hr.ats.vo.common.Date;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.timezone.TimeZoneUtil;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TripBillHelper
extends BillHelper {
    public TripBillHelper(Context ctx) {
        super(ctx);
    }

    public TripBillHelper() {
    }

    public void getDateOverlappingData(AtsTripBillInfo tripBillInfo) throws BOSException, SQLException, EASBizException {
        Context ctx = this.getCtx();
        String billId = CoreBaseUtile.getId(tripBillInfo);
        if (tripBillInfo == null || AtsCollectionUtile.isEmpty((IObjectCollection)tripBillInfo.getEntries())) {
            return;
        }
        StringBuffer selectSql = new StringBuffer();
        ArrayList<Object> sqlParam = new ArrayList<Object>(4);
        String unionAllFlag = " union all ";
        for (int i = 0; i < tripBillInfo.getEntries().size(); ++i) {
            AtsTripBillEntryInfo entryBillInfo = tripBillInfo.getEntries().get(i);
            String personId = CoreBaseUtile.getId(entryBillInfo.getPerson());
            Date beginTime = Date.getTime(entryBillInfo.getRealTripStartTime());
            Date endTime = Date.getTime(entryBillInfo.getRealTripEndTime());
            sqlParam.addAll(Arrays.asList(personId, endTime, beginTime));
            selectSql.append(" select '").append(beginTime.toDateTimeStr()).append("' beginTime,");
            selectSql.append('\'').append(endTime.toDateTimeStr()).append("' endTime,");
            selectSql.append(entryBillInfo.isIsAllDay() ? 1 : 0).append(" isAllDay,bill.fnumber,entry.FRealTripStartTime,entry.FRealTripEndTime,entry.fpersonid,entry.fisAllDay");
            selectSql.append(" from T_HR_ATS_TripBill  bill left join T_HR_ATS_TripBillEntry entry on  bill.fid = entry.fbillid ");
            selectSql.append(" where entry.fpersonid=? and bill.fbillstate not in( 0,4) and entry.FRealTripStartTime<? and entry.FRealTripEndTime>? and entry.FRealTripStartTime <> entry.FRealTripEndTime ");
            if (BOSUuid.isValid((String)billId, (boolean)true)) {
                selectSql.append("and bill.fid !=?");
                sqlParam.add(billId);
            }
            selectSql.append(unionAllFlag);
        }
        selectSql.setLength(selectSql.length() - unionAllFlag.length());
        selectSql.append(") temp");
        selectSql.insert(0, "select top 1 * from (");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString(), (Object[])sqlParam.toArray());
        while (row.next()) {
            java.util.Date dbEndTime;
            java.util.Date beginTime = HRTimeWebUtils.timestampToDate(row.getTimestamp("beginTime"));
            java.util.Date endTime = HRTimeWebUtils.timestampToDate(row.getTimestamp("endTime"));
            String personId = row.getString("fpersonid");
            boolean isAllDay = row.getBoolean("isAllDay");
            boolean dbIsAllDay = row.getBoolean("FIsAllDay");
            java.util.Date dbBeginTime = HRTimeWebUtils.timestampToDate(row.getTimestamp("FRealTripStartTime"));
            if (TripBillHelper.isOutOfAllDay(ctx, beginTime, endTime, dbBeginTime, dbEndTime = HRTimeWebUtils.timestampToDate(row.getTimestamp("FRealTripEndTime")), dbIsAllDay, personId) || TripBillHelper.isOutOfAllDay(ctx, dbBeginTime, dbEndTime, beginTime, endTime, isAllDay, personId)) continue;
            String personid = row.getString("fpersonid");
            PersonPositionInfo positionInfo = SHRBillUtil.getAdminOrgUnit(personid, ctx);
            String msg = MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "TRIP_OVER", this.getCtx(), row.getString("FNumber"), positionInfo != null && positionInfo.getPerson() != null ? positionInfo.getPerson().getName() : "", HRTimeWebUtils.dateLongToString(dbBeginTime), HRTimeWebUtils.dateLongToString(dbEndTime));
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{msg});
        }
    }

    public String doDateInterleaveVerify(AtsTripBillEntryCollection tripEntryColl) {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)tripEntryColl)) {
            return null;
        }
        int size = tripEntryColl.size();
        String[] rowNum = new String[size];
        String[] personID = new String[size];
        String[] tripStartTime = new String[size];
        String[] tripEndTime = new String[size];
        for (int i = 0; i < size; ++i) {
            rowNum[i] = String.valueOf(i + 1);
            personID[i] = CoreBaseUtile.getId(tripEntryColl.get(i).getPerson());
            tripStartTime[i] = HRTimeWebUtils.timestampToString(AtsBillAssist.getRealBeginTime((CoreBaseInfo)tripEntryColl.get(i)));
            tripEndTime[i] = HRTimeWebUtils.timestampToString(AtsBillAssist.getRealEndTime((CoreBaseInfo)tripEntryColl.get(i)));
        }
        return this.doDateInterleaveVerify(rowNum, personID, tripStartTime, tripEndTime);
    }

    public String doDateInterleaveVerify(String[] rowNum, String[] personID, String[] tripStartTime, String[] tripEndTime) {
        int len = personID.length;
        HashMap<String, String> dateMap = new HashMap<String, String>();
        StringBuffer errorSb = new StringBuffer("");
        for (int i = 0; i < len; ++i) {
            if (dateMap.containsKey(personID[i])) {
                String tempData = (String)dateMap.get(personID[i]);
                String interleaveList = this.dateInterleaveVerifyCore(i, tempData, tripStartTime, tripEndTime);
                if (!interleaveList.equals("")) {
                    String[] interleaveListArray = interleaveList.split(",");
                    StringBuffer tmpsb = new StringBuffer("");
                    for (int j = 0; j < interleaveListArray.length; ++j) {
                        if (interleaveListArray[j].equals("")) continue;
                        tmpsb.append(rowNum[Integer.parseInt(interleaveListArray[j])]).append(" ");
                    }
                    errorSb.append(MLUtile.getRes((ResourceEnum)AtsOrdinalCommonResEnum.ConflictTripTimeRow, this.getCtx(), rowNum[i], tmpsb.toString()));
                }
                dateMap.put(personID[i], (String)dateMap.get(personID[i]) + "," + i);
                continue;
            }
            dateMap.put(personID[i], String.valueOf(i));
        }
        return errorSb.toString();
    }

    public String dateInterleaveVerifyCore(int rowNum, String arrayNum, String[] tripStartTime, String[] tripEndTime) {
        String interleaveList = "";
        String[] arrayNums = arrayNum.split(",");
        Timestamp startTimeStA = HRTimeWebUtils.stringToTimestamp(tripStartTime[rowNum].substring(0, 16) + ":00");
        Timestamp endTimeStA = HRTimeWebUtils.stringToTimestamp(tripEndTime[rowNum].substring(0, 16) + ":00");
        for (int i = 0; i < arrayNums.length; ++i) {
            Timestamp endTimeStB;
            int tempArrayNum = Integer.parseInt(arrayNums[i]);
            Timestamp startTimeStB = HRTimeWebUtils.stringToTimestamp(tripStartTime[tempArrayNum].substring(0, 16) + ":00");
            if (!this.isInterleaving(startTimeStA, endTimeStA, startTimeStB, endTimeStB = HRTimeWebUtils.stringToTimestamp(tripEndTime[tempArrayNum].substring(0, 16) + ":00"))) continue;
            interleaveList = interleaveList + tempArrayNum + ",";
        }
        return interleaveList;
    }

    private boolean isInterleaving(Timestamp startTimeA, Timestamp endTimeA, Timestamp startTimeB, Timestamp endTimeB) {
        return startTimeA.before(endTimeB) && startTimeB.before(endTimeA);
    }

    public static boolean isOutOfAllDay(Context ctx, java.util.Date beginTime1, java.util.Date endTime1, java.util.Date beginTime2, java.util.Date endTime2, boolean isAllDay, String personId) throws EASBizException, BOSException {
        AttendanceFileHISInfo fileHisInfo;
        if (!isAllDay) {
            return false;
        }
        List dateList = HRTimeWebUtils.getLeaveBeforeAndAfterDateColl(beginTime2, endTime2);
        if (dateList.size() >= 3) {
            dateList.remove(dateList.size() - 1);
            dateList.remove(0);
        }
        if ((fileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo(ctx, AtsDateUtils.dateToTimestamp(beginTime2), AtsDateUtils.dateToTimestamp(beginTime2), personId, null)) == null) {
            return false;
        }
        IsAttendanceEnum isAttendance = fileHisInfo.getIsAttendance();
        AtsShiftInfo atsShift = fileHisInfo.getAtsShift();
        if (isAttendance.getValue().equalsIgnoreCase("0")) {
            if (atsShift == null) {
                return false;
            }
            for (int indext = 0; indext < dateList.size(); ++indext) {
                if (!TripBillHelper.hasIntersectionByAtsShiftInfo(ctx, atsShift, AtsDateUtils.dateShortToString((java.util.Date)dateList.get(indext)), beginTime1, endTime1)) continue;
                return false;
            }
            return true;
        }
        ScheduleShiftInfo scheduleShiftInfo = null;
        for (int indext = 0; indext < dateList.size(); ++indext) {
            scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority(ctx, personId, AtsDateUtils.dateShortToString((java.util.Date)dateList.get(indext)));
            if (!(scheduleShiftInfo == null || scheduleShiftInfo.getItems() == null || scheduleShiftInfo.getItems().size() == 0 ? atsShift != null && TripBillHelper.hasIntersectionByAtsShiftInfo(ctx, atsShift, AtsDateUtils.dateShortToString((java.util.Date)dateList.get(indext)), beginTime1, endTime1) : TripBillHelper.hasIntersectionByScheduleShiftInfo(scheduleShiftInfo, beginTime1, endTime1))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasIntersectionByAtsShiftInfo(Context ctx, AtsShiftInfo atsShift, String date, java.util.Date beginTime1, java.util.Date endTime1) throws BOSException, EASBizException {
        AtsShiftInfo info = AtsShiftFactory.getLocalInstance(ctx).getAtsShiftInfo("where id = '" + atsShift.getId().toString() + "'");
        if (info == null || info.getItems() == null || info.getItems().size() == 0) {
            return false;
        }
        DateInterVal startAndEndTimeBy = TripBillHelper.getStartAndEndTimeByAtsShiftInfo(info, date);
        return TripBillHelper.hasIntersection(beginTime1, endTime1, startAndEndTimeBy.getBeginDate(), startAndEndTimeBy.getEndDate());
    }

    public static boolean hasIntersection(java.util.Date beginTime, java.util.Date lateTime, java.util.Date startTime, java.util.Date endTime) {
        if (startTime == null || endTime == null || startTime.getTime() >= endTime.getTime()) {
            return false;
        }
        if (beginTime == null || lateTime == null || beginTime.getTime() >= lateTime.getTime()) {
            return false;
        }
        return beginTime.getTime() < endTime.getTime() && startTime.getTime() < lateTime.getTime();
    }

    private static boolean hasIntersectionByScheduleShiftInfo(ScheduleShiftInfo info, java.util.Date beginTime1, java.util.Date endTime1) throws BOSException, EASBizException {
        DateInterVal startAndEndTimeByScheduleShiftInfo = TripBillHelper.getStartAndEndTimeByScheduleShiftInfo(info);
        return TripBillHelper.hasIntersection(beginTime1, endTime1, startAndEndTimeByScheduleShiftInfo.getBeginDate(), startAndEndTimeByScheduleShiftInfo.getEndDate());
    }

    private static DateInterVal getStartAndEndTimeByAtsShiftInfo(AtsShiftInfo info, String date) {
        Map<String, String> map = FetchCardUtil.getShiftEarlyTimeAndLateTime(info);
        String earlyDate = FetchCardUtil.timeToDateByDayType(map.get("earlyTime"), map.get("earlyTimeDayType"), date);
        String lateDate = FetchCardUtil.timeToDateByDayType(map.get("lateTime"), map.get("lateTimeDayType"), date);
        DateInterVal dateInterVal = new DateInterVal();
        dateInterVal.setBeginDate(AtsDateUtils.stringToLongDate(earlyDate));
        dateInterVal.setEndDate(AtsDateUtils.stringToLongDate(lateDate));
        return dateInterVal;
    }

    private static DateInterVal getStartAndEndTimeByScheduleShiftInfo(ScheduleShiftInfo info) {
        Timestamp preTime = null;
        Timestamp nextTime = null;
        for (int sta = 0; sta < info.getItems().size(); ++sta) {
            int segmentValue = Integer.parseInt(info.getItems().get(sta).getSegment().getValue());
            if (segmentValue == 1) {
                preTime = info.getItems().get(sta).getPreDateTime();
            }
            if (segmentValue != info.getItems().size()) continue;
            nextTime = info.getItems().get(sta).getNextDateTime();
        }
        DateInterVal dateInterVal = new DateInterVal();
        dateInterVal.setBeginDate(preTime);
        dateInterVal.setEndDate(nextTime);
        return dateInterVal;
    }

    public String validateIsFillTrip(Context ctx, AtsTripBillInfo tripBillInfo) throws EASBizException, BOSException {
        String errorString = "";
        String extraString = "";
        String buffer = "";
        ArrayList<Integer> rows = new ArrayList<Integer>();
        if (tripBillInfo == null) {
            errorString = MLUtile.getRes(AtsBillResEnum.NullBillInfo, ctx);
            return errorString;
        }
        AtsTripBillEntryCollection tripBillEntryCollection = tripBillInfo.getEntries();
        if (tripBillEntryCollection == null) {
            errorString = MLUtile.getRes(AtsBillResEnum.NullBillInfo, ctx);
            return errorString;
        }
        Calendar applyCal = Calendar.getInstance();
        if (tripBillInfo.getId() != null && AtsWebUtils.isInWorkFlow(ctx, tripBillInfo.getId().toString())) {
            AtsTripBillInfo tripBillInfoDB = tripBillInfo;
            if (tripBillInfo.getApplyDate() == null) {
                tripBillInfoDB = AtsTripBillFactory.getLocalInstance(ctx).getAtsTripBillInfo((IObjectPK)new ObjectUuidPK(tripBillInfo.getId().toString()));
            }
            applyCal.setTime(tripBillInfoDB.getApplyDate());
        }
        applyCal.setTime(AttencePolicyFillUtil.formatCalendar(applyCal));
        java.util.Date applyDate = applyCal.getTime();
        Iterator itr = tripBillEntryCollection.iterator();
        AtsTripBillEntryInfo tripBillEntryInfo = new AtsTripBillEntryInfo();
        int rowNumber = 0;
        while (itr.hasNext()) {
            errorString = "";
            ++rowNumber;
            tripBillEntryInfo = (AtsTripBillEntryInfo)itr.next();
            String personId = tripBillEntryInfo != null && tripBillEntryInfo.getPerson() != null && tripBillEntryInfo.getPerson().getId() != null ? tripBillEntryInfo.getPerson().getId().toString() : "";
            Timestamp nowTime = new Timestamp(System.currentTimeMillis());
            String nowTimeString = HRTimeWebUtils.timestampToString(nowTime);
            Timestamp nowTimeAfterDeal = HRTimeWebUtils.stringShortToTimestamp(nowTimeString.substring(0, 10));
            long nowTimeLong = nowTimeAfterDeal.getTime();
            Timestamp start = tripBillEntryInfo != null ? tripBillEntryInfo.getTripStartTime() : null;
            Timestamp end = tripBillEntryInfo != null ? tripBillEntryInfo.getTripEndTime() : null;
            AttendanceFileHISInfo fileHisInfo = TripBillHelper.getAttendanceFileHisInfo(ctx, start, personId);
            AttencePolicyInfo attencePolicyInfo = fileHisInfo.getAttencePolicy();
            boolean isFillTrip = false;
            if (attencePolicyInfo == null) {
                errorString = MLUtile.getRes(AtsAttenceResEnum.LeakPolicyInfoToCompleteCheck, ctx);
            } else {
                isFillTrip = attencePolicyInfo.isIsFillTrip();
            }
            if (!isFillTrip) continue;
            if (null == tripBillEntryInfo || tripBillEntryInfo.getTripEndTime() == null || tripBillEntryInfo.getTripStartTime() == null) {
                errorString = MLUtile.getRes(AtsTripBillResEnum.NullTripTime, ctx) + "!";
            } else {
                long endTimeLong = tripBillEntryInfo.getTripEndTime().getTime();
                long beginTimeLong = tripBillEntryInfo.getTripStartTime().getTime();
                Timestamp tripEndDate = tripBillEntryInfo.getTripEndTime();
                boolean isFillTripByTimeCtl = attencePolicyInfo.isFillTripByTimeCtl();
                boolean isFillTripByCycleCtrl = attencePolicyInfo.isFillTripByCycleCtl();
                if (isFillTripByTimeCtl) {
                    BigDecimal amount = attencePolicyInfo.getFillTripAmount();
                    FillAmountUnitEnum unit = attencePolicyInfo.getFillTripAmountUnit();
                    errorString = AttencePolicyFillUtil.validateByTimeControle(ctx, amount, unit, applyDate, 1, attencePolicyInfo, tripEndDate);
                }
                if (isFillTripByCycleCtrl && StringUtils.isEmpty((String)errorString)) {
                    int fillTripCycleType = attencePolicyInfo.getFillTripCycleType().getValue();
                    BigDecimal afterDay = attencePolicyInfo.getFillTripAfterDay();
                    if (afterDay == null) {
                        errorString = MLUtile.getRes(AtsAttenceResEnum.LeakPolicyInfoToCheck, ctx);
                    } else if (AttencePolicyCycleTypeEnum.attendanceCycle.equals((Object)attencePolicyInfo.getFillTripCycleType()) && FillAmountUnitEnum.mouthEndDay.equals((Object)attencePolicyInfo.getFillTripAfterDayUnit())) {
                        Boolean ok = false;
                        try {
                            String attenceCycleId = attencePolicyInfo.getAttenceCycle().getId().toString();
                            String theDate = AtsDateUtils.timestampToShortString(start);
                            ok = AttencePolicyFillUtil.validMonthlyStatementDateByAttencecycle(ctx, attenceCycleId, afterDay.intValue(), theDate, tripBillInfo.getApplyDate());
                        }
                        catch (EASBizException e) {
                            e.printStackTrace();
                        }
                        errorString = null != ok && ok != false ? "" : MLUtile.getRes(AtsTripBillResEnum.OverBillFillTime, ctx) + "!";
                    } else {
                        errorString = AttencePolicyFillUtil.validateByCycleControle(ctx, attencePolicyInfo, beginTimeLong, fillTripCycleType, afterDay.intValue(), 1);
                    }
                }
            }
            if (StringUtils.isEmpty((String)errorString)) continue;
            buffer = errorString;
            if (tripBillInfo.getBillType() != null) {
                if (tripBillInfo.getBillType().getValue() == 1) continue;
                rows.add(rowNumber);
                continue;
            }
            if (tripBillEntryCollection.size() <= 1) continue;
            rows.add(rowNumber);
        }
        if (rows.size() > 0) {
            String rowTemp = "";
            for (int i = 0; i < rows.size(); ++i) {
                rowTemp = i == rows.size() - 1 ? rowTemp + rows.get(i) : rowTemp + rows.get(i) + ",";
            }
            extraString = MLUtile.getRes((ResourceEnum)AtsCommonResEnum.Row, ctx, rowTemp);
        }
        return extraString + buffer;
    }

    public static AttendanceFileHISInfo getAttendanceFileHisInfo(Context ctx, Timestamp beginTime, String proposerId) throws BOSException {
        AttendanceFileHISCollection attendanceFilehisColl = AttendanceFileHISFactory.getLocalInstance(ctx).getAttendanceFileHISCollection("select *,attencePolicy.* where proposer.id='" + proposerId + "' order by effdt desc");
        AttendanceFileHISInfo attendanceFileHisInfo = null;
        if (attendanceFilehisColl != null && attendanceFilehisColl.size() > 0) {
            for (int i = 0; i < attendanceFilehisColl.size(); ++i) {
                AttendanceFileHISInfo hisInfo = attendanceFilehisColl.get(i);
                java.util.Date effdt = hisInfo.getEFFDT();
                String leffdtStr = AtsDateUtils.dateShortToString(hisInfo.getLEFFDT());
                leffdtStr = leffdtStr + " 23:59:59";
                java.util.Date leffdt = AtsDateUtils.stringToLongDate(leffdtStr);
                if (beginTime.getTime() < effdt.getTime() || beginTime.getTime() > leffdt.getTime()) continue;
                attendanceFileHisInfo = hisInfo;
                break;
            }
        }
        return attendanceFileHisInfo;
    }

    public String getCrossTripMsg(AtsAffairEntryBaseInfo entryInfo) throws BOSException, EASBizException {
        String endTime;
        Context ctx = this.getCtx();
        String beginTime = AtsDateUtils.dateLongToString(AtsBillAssist.getRealBeginTime((CoreBaseInfo)entryInfo));
        int crossTrip = this.isCrossTrip(beginTime, endTime = AtsDateUtils.dateLongToString(AtsBillAssist.getRealEndTime((CoreBaseInfo)entryInfo)), CoreBaseUtile.getId(entryInfo.getPerson()), entryInfo.getBoolean("isAllDay"));
        if (crossTrip < 2) {
            String dayType = null;
            dayType = crossTrip == 0 ? MLUtile.getRes(AtsOrdinalCommonResEnum.naturalDay, ctx) : MLUtile.getRes(AtsOrdinalCommonResEnum.attendanceDay, ctx);
            return MLUtile.getRes((ResourceEnum)AtsOrdinalCommonResEnum.oneCrossDayMsg, ctx, dayType);
        }
        return null;
    }

    public String getCrossTimezoneMsg(AtsTripBillInfo billInfo) throws BOSException, EASBizException {
        boolean needValidate = billInfo != null && !AtsCollectionUtile.isEmpty((IObjectCollection)billInfo.getEntries());
        Context ctx = this.getCtx();
        StringBuffer crossMsg = new StringBuffer();
        if (needValidate && Boolean.parseBoolean(ParamUtile.getParamVal(ctx, "ShowTimeZoneForCtrl"))) {
            Map<Object, String> map = TimeZoneUtile.calTripCrossTimeZone(ctx, billInfo.getEntries(), true);
            map = AtsCollectionUtile.trim(map);
            for (String msg : map.values()) {
                crossMsg.append("\r\n").append(msg);
            }
            if (crossMsg.length() > 0) {
                crossMsg.insert(0, MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "CROSS_TIMEZOME", ctx));
            }
        }
        return crossMsg.toString();
    }

    public int isCrossTrip(String beginTimes, String endTimes, String personId, boolean isAllDay) throws BOSException, EASBizException {
        Timestamp endTimeCount;
        Timestamp beginTimeCount;
        Context ctx = this.getCtx();
        AttendanceFileHISInfo fileHisInfo = AtsLeaveBillUtil.getAttendanceFileHisInfo(ctx, beginTimeCount = AtsDateUtils.stringToTimestamp(beginTimes), endTimeCount = AtsDateUtils.stringToTimestamp(endTimes), personId, null);
        if (fileHisInfo == null) {
            throw new AtsFileBizException(AtsFileBizException.NOTEXISTFILEORNORANGE);
        }
        String oql = "where id = '" + fileHisInfo.getAttencePolicy().getId().toString() + "'";
        AttencePolicyInfo attencePolicyInfo = AttencePolicyFactory.getLocalInstance(ctx).getAttencePolicyInfo(oql);
        if (attencePolicyInfo.isCanCrossTripAtNoAllDay() || isAllDay) {
            return 2;
        }
        ControlTypeEnum controlType = attencePolicyInfo.getControlType();
        String beginDate = AtsDateUtils.dateShortToString(beginTimeCount);
        String endDate = AtsDateUtils.dateShortToString(endTimeCount);
        if (controlType.getValue() == 0) {
            if (beginDate.equalsIgnoreCase(endDate)) {
                return 2;
            }
            return 0;
        }
        Long startInAdvanceNUm = null;
        Long endDelayNum = null;
        ScheduleShiftInfo begingScheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftInfo(ctx, personId, beginDate);
        BOSUuid begingCardRuleId = begingScheduleShiftInfo.getCardRule().getId();
        CardRuleInfo begingCardRuleInfo = CardRuleFactory.getLocalInstance(ctx).getCardRuleInfo("where id = '" + begingCardRuleId.toString() + "'");
        startInAdvanceNUm = AtsLeaveBillUtil.getStartInAdvanceNUm(begingCardRuleInfo, begingScheduleShiftInfo.getItems().get(0).getPreDateTime());
        endDelayNum = AtsLeaveBillUtil.getEndDelayNum(begingCardRuleInfo, begingScheduleShiftInfo.getItems().get(begingScheduleShiftInfo.getItems().size() - 1).getNextDateTime());
        if (beginTimeCount.getTime() < startInAdvanceNUm && endTimeCount.getTime() > startInAdvanceNUm) {
            return 1;
        }
        if (endTimeCount.getTime() > endDelayNum && beginTimeCount.getTime() < endDelayNum) {
            return 1;
        }
        java.util.Date beginNextTime = AtsDateUtils.getNextDay(beginTimeCount);
        String beginNextDay = AtsDateUtils.dateShortToString(beginNextTime);
        ScheduleShiftInfo nextScheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftInfo(ctx, personId, beginNextDay);
        BOSUuid nextCardRuleId = nextScheduleShiftInfo.getCardRule().getId();
        CardRuleInfo nextCardRuleInfo = CardRuleFactory.getLocalInstance(ctx).getCardRuleInfo("where id = '" + nextCardRuleId.toString() + "'");
        startInAdvanceNUm = AtsLeaveBillUtil.getStartInAdvanceNUm(nextCardRuleInfo, nextScheduleShiftInfo.getItems().get(0).getPreDateTime());
        endDelayNum = AtsLeaveBillUtil.getEndDelayNum(nextCardRuleInfo, nextScheduleShiftInfo.getItems().get(nextScheduleShiftInfo.getItems().size() - 1).getNextDateTime());
        if (beginTimeCount.getTime() < startInAdvanceNUm && endTimeCount.getTime() > startInAdvanceNUm) {
            return 1;
        }
        if (endTimeCount.getTime() > endDelayNum && beginTimeCount.getTime() < endDelayNum) {
            return 1;
        }
        ScheduleShiftInfo endScheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftInfo(ctx, personId, endDate);
        BOSUuid endCardRuleId = endScheduleShiftInfo.getCardRule().getId();
        CardRuleInfo endCardRuleInfo = CardRuleFactory.getLocalInstance(ctx).getCardRuleInfo("where id = '" + endCardRuleId.toString() + "'");
        startInAdvanceNUm = AtsLeaveBillUtil.getStartInAdvanceNUm(endCardRuleInfo, endScheduleShiftInfo.getItems().get(0).getPreDateTime());
        endDelayNum = AtsLeaveBillUtil.getEndDelayNum(endCardRuleInfo, endScheduleShiftInfo.getItems().get(endScheduleShiftInfo.getItems().size() - 1).getNextDateTime());
        if (beginTimeCount.getTime() < startInAdvanceNUm && endTimeCount.getTime() > startInAdvanceNUm) {
            return 1;
        }
        if (endTimeCount.getTime() > endDelayNum && beginTimeCount.getTime() < endDelayNum) {
            return 1;
        }
        return 2;
    }

    @Override
    public <T extends AtsAffairBaseInfo> T storefields(Context ctx, T billInfo) throws BOSException, EASBizException {
        super.storefields(ctx, billInfo);
        PersonInfo curPerson = SHRBillUtil.getCurrPersonInfoNew(ctx);
        if (billInfo.getAdminOrg() == null) {
            PersonPositionInfo curPersonPosition = SHRBillUtil.getAdminOrgUnit(CoreBaseUtile.getId(curPerson), ctx);
            billInfo.setAdminOrg(curPersonPosition.getPersonDep());
        }
        if (billInfo.get("billSourceType") == null) {
            billInfo.put("billSourceType", (Object)BillSourceTypeEnum.empSelfService);
        }
        this.setCtx(ctx);
        AtsTripBillEntryCollection atsTripBillEntryCollection = ((AtsTripBillInfo)billInfo).getEntries();
        this.storeEntryfields(atsTripBillEntryCollection, CoreBaseUtile.getId(billInfo.getHrOrgUnit()));
        return billInfo;
    }

    protected void storeEntryfields(AtsTripBillEntryCollection entries, String hrOrgUnitId) throws EASBizException, BOSException {
        if (AtsCollectionUtile.isEmpty((IObjectCollection)entries)) {
            return;
        }
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        hrOrgUnitId = null;
        int entrySize = entries.size();
        for (int i = 0; i < entrySize; ++i) {
            Timestamp endTime;
            AtsTripBillEntryInfo atsBillEntryInfo = entries.get(i);
            Timestamp beginTime = atsBillEntryInfo.getTripStartTime();
            AttendanceFileHISInfo fileHisInfo = AtsAttendanceFileUtils.getAttendanceFileHISInfoByAttenceDate(this.ctx, beginTime, endTime = atsBillEntryInfo.getTripEndTime(), CoreBaseUtile.getId(atsBillEntryInfo.getPerson()));
            if (fileHisInfo == null) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{new AtsFileBizException(AtsFileBizException.NOTEXISTFILEHIS).getMessage()});
            }
            String string = hrOrgUnitId = hrOrgUnitId == null ? CoreBaseUtile.getId(fileHisInfo.getHrOrgUnit()) : hrOrgUnitId;
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)hrOrgUnitId, (CharSequence)CoreBaseUtile.getId(fileHisInfo.getHrOrgUnit()))) {
                throw new BOSException(new AtsBillBizException(AtsBillBizException.COMMITCROSSHRORG).getMessage());
            }
            atsBillEntryInfo.setAdminOrgUnit(fileHisInfo.getAdminOrgUnit());
            atsBillEntryInfo.setAttAdminOrgUnit(fileHisInfo.getAttAdminOrgUnit());
            atsBillEntryInfo.setPosition(fileHisInfo.getPosition());
            atsBillEntryInfo.setIsDefaultManage(fileHisInfo.isIsDefaultManage());
            if (!atsBillEntryInfo.containsKey("isCancelTrip")) {
                atsBillEntryInfo.setIsCancelTrip(TripbillCancelEnum.notconfirm);
            }
            if (atsBillEntryInfo.isIsDefaultManage() || !atsBillEntryInfo.containsKey("isCalOt")) {
                atsBillEntryInfo.setIsCalOt(false);
            }
            Timestamp tripStartTime = atsBillEntryInfo.getTripStartTime();
            Timestamp tripEndTime = atsBillEntryInfo.getTripEndTime();
            BigDecimal tripDays = atsBillEntryInfo.getTripDays();
            atsBillEntryInfo.setRealTripStartTime(tripStartTime);
            atsBillEntryInfo.setRealTripEndTime(tripEndTime);
            atsBillEntryInfo.setRealTripDays(tripDays);
            atsBillEntryInfo.setIsInitAllDay(atsBillEntryInfo.isIsAllDay());
            atsBillEntryInfo.setLastUpdateUser(currentUserInfo);
            atsBillEntryInfo.setLastUpdateTime(now);
            if (atsBillEntryInfo.getTripDays() == null) {
                BigDecimal len = atsBillEntryInfo.getRealTripDays();
                atsBillEntryInfo.setTripDays(len == null ? this.getBillLength(this.ctx, atsBillEntryInfo) : len);
            }
            if (atsBillEntryInfo.getRealTripDays() == null) {
                atsBillEntryInfo.setRealTripDays(atsBillEntryInfo.getTripDays());
            }
            if (atsBillEntryInfo.getTimeZone() != null) continue;
            TimeZoneInfo timeZone = TimeZoneUtil.getUserTimeZone((Context)this.ctx);
            atsBillEntryInfo.setTimeZone(timeZone);
        }
    }

    public String[] doAbortBill(Context ctx, String billIdParam) throws BOSException, EASBizException {
        String billIds = billIdParam.replaceAll(",", "','");
        String[] billIdArr = billIdParam.split(",");
        HashSet atsInfoIds = new HashSet();
        ArrayList<String> noSubmitBilList = new ArrayList<String>();
        ArrayList<String> approveBilList = new ArrayList<String>();
        String oql = " select number,billstate,id,entries.person where id in ( '" + billIds + "' )";
        IAtsTripBill iAtsTripBill = AtsTripBillFactory.getLocalInstance(ctx);
        AtsTripBillCollection atsTripBillCol = iAtsTripBill.getAtsTripBillCollection(oql);
        ValidateCtx validateCtx = ValidateUtile.getValidateCtx(ctx, billIdParam);
        for (int i = 0; i < atsTripBillCol.size(); ++i) {
            HRBillStateEnum billState = atsTripBillCol.get(i).getBillState();
            String billId = atsTripBillCol.get(i).getId().toString();
            if (HRBillStateEnum.SAVED.equals((Object)billState)) {
                noSubmitBilList.add(billId);
                continue;
            }
            if (!HRBillStateEnum.AUDITED.equals((Object)billState)) continue;
            approveBilList.add(billId);
        }
        if (noSubmitBilList.size() > 0) {
            throw new AtsStaticResourceBizException(AtsStaticResourceBizException.CHOOSEUNCOMMITORCOMMITINGBILL);
        }
        if (approveBilList.size() > 0) {
            throw new AtsStaticResourceBizException(AtsStaticResourceBizException.CHOOSEUNCOMMITORCOMMITINGBILL);
        }
        for (int j = 0; j < billIdArr.length; ++j) {
            String billId = billIdArr[j];
            try {
                ValidateUtile.setValidatorCtx(ctx, validateCtx, billId);
                iAtsTripBill.abortBizBill(billId);
                TripBillHelper.uptBillSourceTypeWithBack(ctx, billId);
                if (atsInfoIds.contains(billId)) continue;
                DataLogsRecordUtil.processListObjectsLog((CoreBaseInfo)AtsTripBillFactory.getLocalInstance(ctx).getAtsTripBillInfo(" select *,entries.* where id = ( '" + billId + "' )"), OperActionEnum.abort, ctx);
                continue;
            }
            catch (EASBizException e) {
                throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return billIdArr;
    }
}

