/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.validator;

import com.kingdee.eas.hr.ats.AtsAffairEntryBaseInfo;
import com.kingdee.eas.hr.ats.AtsTripBillEntryInfo;
import com.kingdee.eas.hr.ats.AtsTripBillInfo;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.validator.BillValidator;
import com.kingdee.eas.hr.ats.validator.TripBillHelper;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class TripBillValidator
extends BillValidator<AtsTripBillInfo> {
    TripBillHelper tripBillHelper;

    @Override
    protected void beforeValidate() throws Exception {
        super.beforeValidate();
        this.tripBillHelper = new TripBillHelper();
        this.tripBillHelper.setCtx(this.getValidateCtx().getBosCtx());
    }

    @Override
    protected String validateBiz(AtsTripBillInfo target) throws Exception {
        String errorMsg = super.validateBiz(target);
        errorMsg = StringUtils.isBlank((CharSequence)errorMsg) ? this.tripBillHelper.validateIsFillTrip(this.getValidateCtx().getBosCtx(), target) : errorMsg;
        errorMsg = StringUtils.isBlank((CharSequence)errorMsg) ? this.tripBillHelper.getCrossTimezoneMsg(target) : errorMsg;
        errorMsg = StringUtils.isBlank((CharSequence)errorMsg) ? this.tripBillHelper.doDateInterleaveVerify(target.getEntries()) : errorMsg;
        this.tripBillHelper.getDateOverlappingData(target);
        return errorMsg;
    }

    @Override
    protected String validateEntryBiz(String field, AtsAffairEntryBaseInfo entryBillInfo, AtsTripBillInfo billInfo) throws Exception {
        String errorMsg = super.validateEntryBiz(field, entryBillInfo, billInfo);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        AtsTripBillEntryInfo tripEntryInfo = (AtsTripBillEntryInfo)entryBillInfo;
        if (!tripEntryInfo.getRealTripStartTime().before(tripEntryInfo.getRealTripEndTime())) {
            return MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "BEGIN_LAGER_END", this.getValidateCtx().getBosCtx());
        }
        if (tripEntryInfo.getTripDays().compareTo(BigDecimal.ZERO) < 0) {
            return MLUtile.getRes("com.kingdee.eas.hr.ats.validatorResEnum", "LEN_POSI", this.getValidateCtx().getBosCtx());
        }
        errorMsg = this.tripBillHelper.getCrossTripMsg((AtsTripBillEntryInfo)entryBillInfo);
        return errorMsg;
    }
}

