/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.vo.common;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.hr.ats.AtsOtherBizException;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsConstants;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;

public class ArthasManager {
    private Monitor monitor;
    private Process arthasProcess;

    public Process startArthas(boolean isAnalizeMethod) throws BOSException {
        this.reset();
        if (this.arthasProcess == null || !isAnalizeMethod) {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            String pid = runtimeMXBean.getName().split("@")[0];
            String arthasPath = AtsConstants.PATH_EAS_HOME + "/arthas-packaging-3.1.4-bin";
            String startBatFile = arthasPath + "/start.bat";
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(SHRCheck.checkFilePath((String)startBatFile));
                StringBuffer startCommand = new StringBuffer();
                startCommand.append("set Path=").append(SHRCheck.checkFilePath((String)AtsConstants.PATH_EAS_HOME)).append("\\oracle-jdk1.7\\bin;%Path%\r\n");
                startCommand.append("cd /d ").append(arthasPath).append("\r\n");
                startCommand.append("java -jar arthas-boot.jar ").append(pid);
                os.write(startCommand.toString().getBytes());
                os.close();
                String command = startBatFile;
                if (!isAnalizeMethod) {
                    command = "cmd.exe /c start " + command;
                }
                this.arthasProcess = Runtime.getRuntime().exec(command);
                this.initMonitor();
                this.monitor.waitNow(60000L);
                this.monitor.setNull();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.arthasProcess;
    }

    private void initMonitor() {
        this.monitor = new Monitor();
        this.monitor.reset("arthas-tutorials");
        this.monitor.setMonitor(new Thread(){

            @Override
            public void run() {
                ArthasManager.this.monitor.lock();
                BufferedReader reader = new BufferedReader(new InputStreamReader(ArthasManager.this.arthasProcess.getInputStream()));
                try {
                    String lineContent;
                    while ((lineContent = reader.readLine()) != null) {
                        System.out.println(new String(lineContent.getBytes(), "utf-8"));
                        ArthasManager.this.monitor.unlock(lineContent);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.monitor.start();
        AtsCommonUtile.sleep(50L);
    }

    public void reset() {
        if (this.arthasProcess != null) {
            PrintWriter write = new PrintWriter(this.arthasProcess.getOutputStream());
            write.println("0x3");
            write.flush();
            write.println("reset\r\n");
            write.flush();
        }
    }

    public void releaseArthasProess() {
        if (this.arthasProcess != null) {
            this.reset();
            PrintWriter write = new PrintWriter(this.arthasProcess.getOutputStream());
            write.println("shutdown\r\n");
            write.flush();
            this.monitor.destroy();
            this.arthasProcess.destroy();
            this.arthasProcess = null;
        }
    }

    public void methodCostAnalize(String analizeClass, String analizeMethod, boolean ignoreJdkMethod) throws BOSException {
        if (StringUtils.isBlank((String)analizeMethod) || StringUtils.isBlank((String)analizeClass)) {
            return;
        }
        this.startArthas(true);
        this.monitor.reset("");
        PrintWriter write = new PrintWriter(this.arthasProcess.getOutputStream());
        write.write("options save-result true\r\n");
        write.flush();
        StringBuffer commond = new StringBuffer("trace ");
        if (ignoreJdkMethod) {
            commond.append("-j ");
        }
        commond.append(analizeClass).append(" ");
        commond.append(analizeMethod);
        write.println(commond.toString());
        write.flush();
        try {
            this.monitor.waitNow(60000L);
        }
        catch (InterruptedException e) {
            AtsLog.getLog().error((Object)e);
        }
        this.monitor.setNull();
    }

    public String fetchMethodCostResultAction(boolean downLoadModel) throws BOSException {
        File resultFile = new File(SHRCheck.checkFilePath((String)(System.getProperty("user.home") + "/logs/arthas-cache/result.log")));
        BufferedReader reader = null;
        StringBuffer result = new StringBuffer();
        try {
            String lineContent;
            reader = new BufferedReader(new FileReader(resultFile));
            while ((lineContent = reader.readLine()) != null) {
                result.append(lineContent);
                result.append(downLoadModel ? "\r\n" : "</Br>");
            }
        }
        catch (FileNotFoundException e) {
            throw new BOSException((Throwable)((Object)new AtsOtherBizException(AtsOtherBizException.NOTEXISTRESULT, e)));
        }
        catch (IOException e) {
            throw new BOSException((Throwable)((Object)new AtsOtherBizException(AtsOtherBizException.GETCHFILEERROR, e)));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result.toString();
    }

    class Monitor {
        private ReentrantLock lock = new ReentrantLock();
        private Thread monitor;
        private String monitorFlag;

        Monitor() {
        }

        public void lock() {
            if (this.lock != null) {
                this.lock.lock();
            }
        }

        public void setNull() {
            this.lock = null;
        }

        public void reset(String monitorFlag) {
            this.monitorFlag = monitorFlag;
            this.lock = new ReentrantLock();
        }

        public void unlock(String content) {
            if (this.lock != null && this.monitorFlag != null && this.monitorFlag.equals(content)) {
                this.lock.unlock();
                this.lock.notifyAll();
            }
        }

        public void waitNow(long time) throws InterruptedException {
            if (this.lock != null) {
                this.lock.wait(time);
            }
        }

        public void start() {
            if (this.monitor != null) {
                this.monitor.start();
            }
        }

        public ReentrantLock getLock() {
            return this.lock;
        }

        public void setLock(ReentrantLock lock) {
            this.lock = lock;
        }

        public Thread getMonitor() {
            return this.monitor;
        }

        public void setMonitor(Thread monitor) {
            this.monitor = monitor;
        }

        public void destroy() {
            if (this.lock != null) {
                this.lock.notifyAll();
            }
            if (this.monitor != null) {
                this.monitor.interrupt();
            }
        }
    }
}

