/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.wf.event;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.workflow.define.ProcessEvent;
import com.kingdee.bos.workflow.enactment.IWfProcess;
import com.kingdee.bos.workflow.enactment.handler.IProcessEventHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.wf.event.WFAbortedEventHandler;
import com.kingdee.eas.hr.ats.wf.event.WFLeaveBillAbortedEventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class WFEventHandler
implements IProcessEventHandler {
    private static Logger logger = Logger.getLogger(WFEventHandler.class);
    private static Map<String, Map<String, Class<? extends WFEventHandler>>> handlerMap = new HashMap<String, Map<String, Class<? extends WFEventHandler>>>();

    public static void initHandler() {
        WFEventHandler.registHandler(ProcessEvent.OnProcessAborted, "com.kingdee.eas.hr.ats.app.AtsLeaveBill", WFLeaveBillAbortedEventHandler.class);
        WFEventHandler.registHandler(ProcessEvent.OnProcessAborted, "com.kingdee.eas.hr.ats.app", WFAbortedEventHandler.class);
    }

    public void execute(ProcessEvent event, IWfProcess process) {
        String[] billIds = null;
        try {
            billIds = process.getBizObjIds();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (billIds == null || billIds.length == 0) {
            logger.error((Object)"WFEventHandler billIds is empty!");
            return;
        }
        Context ctx = process.getContext();
        for (String billId : billIds) {
            for (Class<? extends WFEventHandler> handler : this.getHandler(ctx, event, billId)) {
                try {
                    handler.newInstance().bizExecute(event, process, AtsEntityUtile.getData(ctx, billId));
                }
                catch (Exception e) {
                    this.handleException(event, process, e);
                }
            }
        }
    }

    protected void handleException(ProcessEvent event, IWfProcess process, Throwable t) {
        logger.error((Object)t.getMessage(), t);
    }

    protected void bizExecute(ProcessEvent event, IWfProcess process, CoreBaseInfo billInfo) throws Exception {
    }

    protected List<Class<? extends WFEventHandler>> getHandler(Context ctx, ProcessEvent event, String billId) {
        EntityObjectInfo entityObjectInfo = AtsEntityUtile.getEntityObj(ctx, billId);
        String curEntity = entityObjectInfo.getFullName();
        ArrayList<Class<? extends WFEventHandler>> handlers = new ArrayList<Class<? extends WFEventHandler>>();
        Map<String, Class<? extends WFEventHandler>> eventHandlerMap = handlerMap.get(event.getName());
        if (eventHandlerMap == null) {
            return handlers;
        }
        for (String entity : eventHandlerMap.keySet()) {
            if (curEntity.indexOf(entity) != 0 || curEntity.length() != entity.length() && curEntity.charAt(entity.length()) != '.') continue;
            handlers.add(eventHandlerMap.get(entity));
        }
        return handlers;
    }

    public static void registHandler(ProcessEvent event, String entity, Class<? extends WFEventHandler> handler) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entity}) && handler != null && event != null) {
            Map<String, Class<? extends WFEventHandler>> eventHandlerMap = handlerMap.get(event.getName());
            if (eventHandlerMap == null) {
                eventHandlerMap = new HashMap<String, Class<? extends WFEventHandler>>();
                handlerMap.put(event.getName(), eventHandlerMap);
            }
            eventHandlerMap.put(entity, handler);
        }
    }

    static {
        WFEventHandler.initHandler();
    }
}

