/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.ats.workShift.plan.autoSchedule;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.ats.AtsSchedulePlanCollection;
import com.kingdee.eas.hr.ats.AtsSchedulePlanFactory;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsSqlUtile;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

public class AutoScheduleUtile {
    public static AtsSchedulePlanCollection getPlanes(Context ctx, Collection<String> ids, boolean isEntryIds) {
        if (AtsCollectionUtile.isEmpty(ids)) {
            return null;
        }
        EntityViewInfo evi = AtsViewUtile.getViewBySelector(new String[]{"atsSchedulePlanSet.frontDate", "atsSchedulePlanSet.name", "atsSchedulePlanSet.adminOrgUnit.id", "atsSchedulePlanSet.adminOrgUnit.longNumber", "atsSchedulePlanSet.hrOrgUnit", "atsSchedulePlanSet.number", "*", "conditionItems.items.*"});
        AtsViewUtile.addSorter("atsSchedulePlanSet.number", SortType.ASCEND, evi);
        AtsViewUtile.addSorter("schedulePriority", SortType.ASCEND, evi);
        if (!isEntryIds) {
            ids = AtsSqlUtile.getOneField(ctx, "select fid from T_ATS_AtsSchedulePlan where FAtsSchedulePlanSetID in " + AtsCollectionUtile.joinForSqlWithBrackets(ids));
        }
        AtsViewUtile.getViewByFilter("id", ids, CompareType.INCLUDE, evi);
        try {
            return AtsSchedulePlanFactory.getLocalInstance(ctx).getAtsSchedulePlanCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AtsSchedulePlanCollection getPlane(Context ctx, String id, boolean isEntryIds) {
        return AutoScheduleUtile.getPlanes(ctx, Collections.singleton(id), isEntryIds);
    }

    public static Date getTimeShiftBeginDate(JSONObject scheduleParams, int frontDay, Date taskStartTime) {
        Date beginDate = null;
        Calendar curTime = Calendar.getInstance();
        curTime.setTime(taskStartTime);
        int year = curTime.get(1);
        if (scheduleParams.containsKey((Object)"beginDate")) {
            beginDate = AtsCommonUtile.getDayStart(AtsCommonUtile.getDate(year + "-" + scheduleParams.getString("beginDate")));
        }
        Date beginDateCal = AtsCommonUtile.dateAdd(taskStartTime, 5, -frontDay);
        if (beginDate == null) {
            return beginDateCal;
        }
        return beginDate.after(beginDateCal) ? beginDate : beginDateCal;
    }

    public static Date getTimeShiftEndDate(JSONObject scheduleParams, Date taskStartTime) {
        Date endDate = null;
        Calendar curTime = Calendar.getInstance();
        curTime.setTime(taskStartTime);
        int year = curTime.get(1);
        if (scheduleParams.containsKey((Object)"endDate")) {
            endDate = AtsCommonUtile.getDayEnd(AtsCommonUtile.getDate(year + "-" + scheduleParams.getString("endDate")));
        }
        Date analyzeEndDate = AtsCommonUtile.analyzeDate(taskStartTime, scheduleParams.getString("scheduleDate"));
        analyzeEndDate = AtsCommonUtile.dateAdd(analyzeEndDate, 6, -1);
        return endDate != null && endDate.before(analyzeEndDate) ? endDate : analyzeEndDate;
    }

    public static boolean validateTimeShiftDate(JSONObject scheduleParams, int frontDay, Date taskStartTime) {
        Date endDate;
        Date beginDate;
        return !scheduleParams.containsKey((Object)"beginDate") || !scheduleParams.containsKey((Object)"endDate") || !(beginDate = AutoScheduleUtile.getTimeShiftBeginDate(scheduleParams, frontDay, taskStartTime)).after(endDate = AutoScheduleUtile.getTimeShiftEndDate(scheduleParams, taskStartTime));
    }
}

