/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.baseconfig.BaseConfigException;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.EnumUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SqlGenerateUtils {
    private static Logger logger = Logger.getLogger(SqlGenerateUtils.class);
    private static List<Map<String, Object>> getLaborCostTypeQueryFieldLeafList = null;

    private SqlGenerateUtils() {
    }

    public static String getColumnName(Context ctx, StructureConfigInfo tableConfigInfo, String propertyName) throws EASBizException, BOSException {
        String sourceColumnName = null;
        if (StringUtils.isEmpty((String)propertyName) && StringUtils.isEmpty((String)tableConfigInfo.getEntityName())) {
            throw new BaseConfigException(BaseConfigException.TABLENAMEANDCOLUMNNAMENULL);
        }
        PropertyInfo prop = SqlGenerateUtils.getPropertyInfo(ctx, tableConfigInfo, propertyName);
        sourceColumnName = SqlGenerateUtils.getFieldClause(ctx, prop);
        StringBuilder columnString = new StringBuilder();
        columnString.append(SqlGenerateUtils.getQuoTableAlias(tableConfigInfo)).append(".");
        columnString.append(sourceColumnName);
        return columnString.toString();
    }

    public static String getColumnHisotryName(Map<String, String> historyColumn, String currentName) {
        if (historyColumn.containsKey(currentName.toUpperCase())) {
            return historyColumn.get(currentName.toUpperCase());
        }
        return currentName;
    }

    public static PropertyInfo getPropertyInfoFullPath(Context ctx, String scheme, String fullPath) throws EASBizException, BOSException {
        StructureConfigInfo clientInfo = StructureConfigConvertHelper.getStructureConfigByKey(ctx, fullPath, scheme);
        String[] keys = fullPath.split("\\.");
        return SqlGenerateUtils.getPropertyInfo(ctx, clientInfo, keys[1]);
    }

    public static PropertyInfo getPropertyInfo(Context ctx, StructureConfigInfo clientInfo, String propertyName) throws EASBizException, BOSException {
        EntityObjectInfo hisEntityInfo;
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)clientInfo.getEntityName()));
        PropertyInfo prop = null;
        String hisEntity = entityInfo.getExtendedProperty("shrHisEntity");
        if (entityInfo.isNeedHistory() && !StringUtils.isEmpty((String)(hisEntity = entityInfo.getHisEntity()))) {
            hisEntityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityInfo.getHisEntity()));
            prop = hisEntityInfo.getPropertyByNameRuntime(propertyName);
        }
        if (null == prop && !StringUtils.isEmpty((String)hisEntity)) {
            hisEntityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)hisEntity));
            prop = hisEntityInfo.getPropertyByNameRuntime(propertyName);
        }
        if (prop == null) {
            prop = entityInfo.getPropertyByNameRuntime(propertyName);
        }
        if (prop == null) {
            prop = SqlGenerateUtils.getCmpPropertyInfo(ctx, clientInfo, propertyName);
        }
        if (prop == null) {
            prop = SqlGenerateUtils.getAtsPropertyInfo(ctx, clientInfo, propertyName);
        }
        if (prop == null) {
            throw new BaseConfigException(BaseConfigException.ENTITYPROPTYNOTVALID, new Object[]{entityInfo.getAlias(), propertyName});
        }
        if (prop.getMappingField() == null) {
            throw new BaseConfigException(BaseConfigException.ENITTYPROPTYNOTTABLEMAPPING, new Object[]{entityInfo.getAlias(), propertyName});
        }
        return prop;
    }

    public static OwnPropertyInfo getCmpPropertyInfo(Context ctx, StructureConfigInfo clientInfo, String propertyName) throws EASBizException, BOSException {
        Map dataTypeValueMap = new HashMap();
        Map cnSn = new HashMap();
        Map labCostTypeNumberFieldMap = new HashMap();
        Map labCostTypeNameFieldMap = new HashMap();
        Map cnMap = new HashMap();
        Object getCnSn = OSFExecutor.executeOSFRedirect((Context)ctx, new HashMap(), (String)"getCnSn");
        if (null != getCnSn) {
            cnSn = (Map)getCnSn;
            labCostTypeNumberFieldMap = (Map)cnSn.get("labCostTypeNumberFieldMap");
            labCostTypeNameFieldMap = (Map)cnSn.get("labCostTypeNameFieldMap");
            dataTypeValueMap = (Map)cnSn.get("dataTypeValueMap");
            cnMap = (Map)cnSn.get("cnMap");
        }
        String alias = "";
        String name = propertyName;
        DataType dataType = DataType.INTEGER;
        SQLType sqlType = SQLType.NUMERIC;
        OwnPropertyInfo propInfo = new OwnPropertyInfo();
        if (propertyName.matches("(?i)s\\d+")) {
            alias = (String)cnMap.get(propertyName);
            name = propertyName;
            if (null == dataTypeValueMap.get(propertyName)) {
                return null;
            }
            if ((Integer)dataTypeValueMap.get(propertyName) == 1) {
                dataType = DataType.STRING;
                sqlType = SQLType.NCLOB;
            } else {
                dataType = DataType.INTEGER;
                sqlType = SQLType.NUMERIC;
            }
        } else {
            Set kset = labCostTypeNameFieldMap.keySet();
            for (String ks : kset) {
                if (!propertyName.equals(labCostTypeNameFieldMap.get(ks))) continue;
                alias = ks;
                break;
            }
            Set nset = labCostTypeNumberFieldMap.keySet();
            for (String ks : nset) {
                if (!propertyName.equals(labCostTypeNumberFieldMap.get(ks))) continue;
                name = ks;
                break;
            }
            dataType = DataType.INTEGER;
            sqlType = SQLType.NUMERIC;
        }
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)alias)) {
            return null;
        }
        propInfo.setAlias(alias);
        propInfo.setName(name);
        propInfo.setDataType(dataType);
        ColumnInfo mappingField = new ColumnInfo();
        mappingField.setAlias(alias);
        mappingField.setName(name);
        mappingField.setTypeName(sqlType);
        propInfo.setMappingField(mappingField);
        return propInfo;
    }

    public static OwnPropertyInfo getAtsPropertyInfo(Context ctx, StructureConfigInfo clientInfo, String propertyName) throws EASBizException, BOSException {
        Map cnSn = new HashMap();
        Map dataTypeValueMap = new HashMap();
        Map cnMap = new HashMap();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("columnName", propertyName);
        Object getCnSn = OSFExecutor.executeOSFRedirect((Context)ctx, param, (String)"getAtsProjectCnSn");
        String alias = "";
        String name = propertyName;
        DataType dataType = DataType.INTEGER;
        SQLType sqlType = SQLType.NUMERIC;
        int dataTypeValue = 1;
        if (null != getCnSn) {
            cnSn = (Map)getCnSn;
            dataTypeValueMap = (Map)cnSn.get("dataTypeMap");
            cnMap = (Map)cnSn.get("cnMap");
            alias = (String)cnMap.get(propertyName.toUpperCase());
            Map tempDataType = (Map)cnSn.get("dataTypeMap");
            if (tempDataType.containsKey(propertyName.toUpperCase())) {
                dataTypeValue = (Integer)tempDataType.get(propertyName.toUpperCase());
            }
        }
        OwnPropertyInfo propInfo = new OwnPropertyInfo();
        if (propertyName.matches("(?i)s\\d+")) {
            alias = (String)cnMap.get(propertyName);
            name = propertyName;
            if (null == dataTypeValueMap.get(propertyName)) {
                return null;
            }
            switch (dataTypeValue) {
                case 1: {
                    dataType = DataType.INTEGER;
                    sqlType = SQLType.NUMERIC;
                    break;
                }
                case 2: {
                    dataType = DataType.FLOAT;
                    sqlType = SQLType.NUMERIC;
                    break;
                }
                case 3: {
                    dataType = DataType.STRING;
                    sqlType = SQLType.NCLOB;
                    break;
                }
                case 4: {
                    dataType = DataType.BOOLEAN;
                    sqlType = SQLType.NUMERIC;
                    break;
                }
                case 5: {
                    dataType = DataType.DATE;
                    sqlType = SQLType.DATETIME;
                }
            }
        }
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)alias)) {
            return null;
        }
        propInfo.setAlias(alias);
        propInfo.setName(name);
        propInfo.setDataType(dataType);
        ColumnInfo mappingField = new ColumnInfo();
        mappingField.setAlias(alias);
        mappingField.setName(name);
        mappingField.setTypeName(sqlType);
        propInfo.setMappingField(mappingField);
        return propInfo;
    }

    public static String getTableAlias(StructureConfigInfo configInfo) {
        return configInfo.getClientNumber().toUpperCase();
    }

    public static String getQuoTableAlias(StructureConfigInfo configInfo) {
        return SqlGenerateUtils.appendQuo(SqlGenerateUtils.getTableAlias(configInfo));
    }

    public static String getTableName(Context ctx, StructureConfigInfo configInfo, boolean historyMode) {
        String tableName = null;
        EntityObjectInfo clientEntity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)configInfo.getEntityName()));
        if (clientEntity.isNeedHistory() && historyMode) {
            clientEntity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)clientEntity.getHisEntity()));
        }
        if (!StringUtils.isEmpty((String)clientEntity.getExtendedProperty("shrHisEntity")) && historyMode) {
            clientEntity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)clientEntity.getExtendedProperty("shrHisEntity")));
        }
        if (null == clientEntity.getTable()) {
            return null;
        }
        tableName = clientEntity.getTable().getName();
        return tableName.toUpperCase();
    }

    public static String getFieldClause(Context ctx, PropertyInfo prop) {
        if (prop instanceof OwnPropertyInfo && ((OwnPropertyInfo)prop).isMultilingual()) {
            return prop.getMappingField().getName() + "_" + ctx.getLocale().toString();
        }
        return prop.getMappingField().getName();
    }

    public static String appendQuo(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(name).append("\"");
        return sb.toString();
    }

    public static Object convertSQLTypeData2Java(DataType dataType, Object data, OwnPropertyInfo fld) {
        return SqlGenerateUtils.convertSQLTypeData2Java(dataType, data, fld, null);
    }

    public static Object convertSQLTypeData2Java(DataType dataType, Object data, OwnPropertyInfo fld, SqlParam param) {
        Object objData = data;
        if (dataType == null || data == null) {
            objData = data;
        } else if (DataType.STRING.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToString((Object)data);
        } else if (DataType.BOOLEAN.equals((Object)dataType)) {
            boolean result = TypeConversionUtils.objToBBoolean((Object)data);
            objData = result;
        } else if (DataType.FLOAT.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToFFloat((Object)data);
        }
        if (param.isAutoIgnoreZero() && ((Float)objData).floatValue() == 0.0f) {
            objData = null;
        } else if (DataType.INTEGER.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToInteger((Object)data);
        }
        if (param.isAutoIgnoreZero() && (Integer)objData == 0) {
            objData = null;
        } else if (DataType.LONG.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToLLong((Object)data);
        }
        if (param.isAutoIgnoreZero() && (Long)objData == 0L) {
            objData = null;
        } else if (DataType.DECIMAL.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToBigDecimal((Object)data);
        } else if (DataType.DOUBLE.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToDDouble((Object)data);
        }
        if (param.isAutoIgnoreZero() && (Double)objData == 0.0) {
            objData = null;
        } else if (DataType.TIME.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToTime((Object)data);
        } else if (DataType.TIMESTAMP.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToTimestamp((Object)data);
        } else if (DataType.UUID.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToUuid((Object)data);
        } else if (DataType.BOSUUID.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToBOSUuid((Object)data);
        } else if (DataType.BYTE.equals((Object)dataType)) {
            objData = Byte.valueOf(String.valueOf(TypeConversionUtils.objToByte((Object)data)));
        } else if (DataType.BYTEARRAY.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToBytes((Object)data);
        } else if (DataType.CHAR.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToString((Object)data);
        } else if (DataType.DATE.equals((Object)dataType)) {
            objData = TypeConversionUtils.objToDate((Object)data);
        } else if (DataType.ENUM.equals((Object)dataType)) {
            String enumClassName;
            if (DataType.ENUM.equals((Object)fld.getDataType()) && (enumClassName = fld.getMetaDataRef()) != null) {
                try {
                    Class<?> clazz = Class.forName(enumClassName);
                    Object e = null;
                    e = objData instanceof Integer ? EnumUtils.getEnum(clazz, (int)((Integer)objData)) : EnumUtils.getEnumByValue(clazz, (String)((String)objData));
                    return e;
                }
                catch (ClassNotFoundException e) {
                    return MetaDataUtil.findEnumByValue((String)enumClassName, (Object)objData);
                }
            }
        } else if (DataType.OBJECTVALUE.equals((Object)dataType)) {
            objData = data;
        } else if (DataType.SHORT.equals((Object)dataType)) {
            objData = Short.valueOf(String.valueOf(TypeConversionUtils.objToShort((Object)data)));
        }
        return objData;
    }

    public static String getLabCostColumnAlias(Context ctx, String key, String alias) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)alias)) {
            alias = key;
        }
        if (alias.indexOf("case") != -1 && alias.indexOf("then") != -1) {
            if (null == getLaborCostTypeQueryFieldLeafList || getLaborCostTypeQueryFieldLeafList.isEmpty()) {
                HashMap param = new HashMap();
                getLaborCostTypeQueryFieldLeafList = new ArrayList<Map<String, Object>>();
                Object getLaborCostTypeQueryField = OSFExecutor.executeOSFRedirect((Context)ctx, param, (String)"getLaborCostTypeQueryField");
                if (null != getLaborCostTypeQueryField) {
                    Map<String, Object> transBean2Map = SqlGenerateUtils.transBean2Map(getLaborCostTypeQueryField);
                    SqlGenerateUtils.findLastChildNode(transBean2Map, getLaborCostTypeQueryFieldLeafList);
                }
            }
            for (int i = 0; i < getLaborCostTypeQueryFieldLeafList.size(); ++i) {
                Map<String, Object> map = getLaborCostTypeQueryFieldLeafList.get(i);
                if (StringUtils.isEmpty((String)((String)map.get("field"))) || !((String)map.get("field")).equalsIgnoreCase(alias)) continue;
                return (String)map.get("number");
            }
        }
        return alias;
    }

    public static void clearLaborCostTypeQueryFieldLeafList() {
        getLaborCostTypeQueryFieldLeafList = null;
    }

    public static Map<String, Object> transBean2Map(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(obj, new Object[0]);
                map.put(key, value);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return map;
    }

    private static void findLastChildNode(Map<String, Object> map, List<Map<String, Object>> list) {
        List children = (List)map.get("children");
        if (null != map.get("leaf") && "true".equalsIgnoreCase(map.get("leaf").toString()) || children.isEmpty()) {
            list.add(map);
        } else {
            for (int i = 0; i < children.size(); ++i) {
                Map<String, Object> m = SqlGenerateUtils.transBean2Map(children.get(i));
                SqlGenerateUtils.findLastChildNode(m, list);
            }
        }
    }
}

