/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.baseconfig.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.view.UIViewRefresh;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.EntityCheckHisUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.baseconfig.BaseConfigException;
import com.kingdee.shr.baseconfig.CompareTypeEnum;
import com.kingdee.shr.baseconfig.IQueryConfigField;
import com.kingdee.shr.baseconfig.IStructureConfigColumns;
import com.kingdee.shr.baseconfig.QueryConfigFieldFactory;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigColumnsCollection;
import com.kingdee.shr.baseconfig.StructureConfigColumnsFactory;
import com.kingdee.shr.baseconfig.StructureConfigColumnsInfo;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnCollection;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnInfo;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.baseconfig.StructureConfigSchemeCollection;
import com.kingdee.shr.baseconfig.StructureConfigSchemeFactory;
import com.kingdee.shr.baseconfig.StructureConfigSchemeInfo;
import com.kingdee.shr.baseconfig.app.AbstractStructureConfigControllerBean;
import com.kingdee.shr.baseconfig.util.StructureConfigCheckUtil;
import com.kingdee.shr.common.util.SHREnumUtil;
import com.kingdee.shr.ml.util.MutilanUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class StructureConfigControllerBean
extends AbstractStructureConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.baseconfig.app.StructureConfigControllerBean");

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        StructureConfigInfo retValue = (StructureConfigInfo)super._getValue(ctx, pk, selector);
        retValue.getColumns().sort("index");
        return retValue;
    }

    private void verifyParent(Context ctx, StructureConfigInfo info) throws BOSException, EASBizException {
        if (null == info.getParent() || null == info.getParent().getId()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)info.getScheme().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("parent.id", null));
            if (null != info.getId()) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            }
            if (this._exists(ctx, filter)) {
                throw new BaseConfigException(BaseConfigException.PATER_NODE_NULL_ONLY_ONE);
            }
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StructureConfigInfo info = (StructureConfigInfo)model;
        this.verifyParent(ctx, info);
        this.checkIdentifierLength(info);
        info.setName(info.getAlias());
        if (info.getScheme() == null) {
            StructureConfigSchemeInfo scheme = new StructureConfigSchemeInfo();
            scheme.setId(BOSUuid.read((String)"KKHjvva+SkGWNHBA3r31N5odxk8="));
            info.setScheme(scheme);
        }
        this.setFieldDataType(ctx, info);
        this.checkNumberDup(ctx, info);
        StringBuffer sb = new StringBuffer();
        StructureConfigCheckUtil.checkStructureColumnInfo(ctx, sb, info);
        this.extendOptionsCheck(ctx, info);
        if (!StringUtils.isEmpty((String)sb.toString())) {
            throw new BaseConfigException(BaseConfigException.CUSTOM_EXCEPTION, new Object[]{sb.toString()});
        }
        IObjectPK pk = super._save(ctx, model);
        Object t = ctx.get((Object)"sHR_Structure_DepEnable");
        if (null == t) {
            StructureConfigConvertHelper.removeAll();
        }
        return pk;
    }

    private void extendOptionsCheck(Context ctx, StructureConfigInfo info) throws EASBizException {
        StructureConfigColumnsInfo sc = null;
        StringBuffer sb = new StringBuffer();
        boolean isError = false;
        int j = 0;
        int kTotal = info.getColumns().size();
        for (int k = 0; k < kTotal; ++k) {
            sc = info.getColumns().get(k);
            if (StringUtils.isEmpty((String)sc.getExtendOptions())) continue;
            try {
                JSONUtils.convertJsonToObject((Context)ctx, (String)sc.getExtendOptions());
                continue;
            }
            catch (Exception e) {
                isError = true;
                if (j > 0) {
                    sb.append(",");
                }
                ++j;
                sb.append(sc.getNumber());
            }
        }
        if (isError) {
            throw new BaseConfigException(BaseConfigException.EXTENDOPTIONSFORMATERROR, new Object[]{sb.toString()});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        StructureConfigConvertHelper.removeAll();
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StructureConfigInfo info = (StructureConfigInfo)model;
        info.setName(info.getAlias());
        if (info.getScheme() == null) {
            StructureConfigSchemeInfo scheme = new StructureConfigSchemeInfo();
            scheme.setId(BOSUuid.read((String)"KKHjvva+SkGWNHBA3r31N5odxk8="));
            info.setScheme(scheme);
        }
        this.setFieldDataType(ctx, info);
        IObjectPK pk = super._submit(ctx, model);
        StructureConfigConvertHelper.removeAll();
        return pk;
    }

    @Override
    protected String _getEntityNumber(Context ctx, String entityNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)entityNumber)) {
            return null;
        }
        int i = 1;
        if (!this.existNumber(ctx, entityNumber)) {
            return entityNumber;
        }
        do {
            entityNumber = entityNumber + i;
            ++i;
        } while (this.existNumber(ctx, entityNumber));
        return entityNumber;
    }

    private boolean existNumber(Context ctx, String entityNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from T_HR_StructureConfig where upper(FClientNumber)=  ? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{entityNumber.toUpperCase()});
        try {
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    private boolean isDupClientNumber(Context ctx, String schemeId, String clientNumber, String id) throws BOSException {
        StringBuffer sql = new StringBuffer("select count(*) t from T_HR_StructureConfig where LCASE(fclientnumber) = ? and FSchemeID = ? ");
        Object[] params = new Object[]{clientNumber.toLowerCase(), schemeId};
        if (!StringUtils.isEmpty((String)id)) {
            sql.append(" and fid <> ? ");
            params = new Object[]{clientNumber.toLowerCase(), schemeId, id};
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        int count = 0;
        try {
            while (rs.next()) {
                count = rs.getInt("t");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (count > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    protected PropertyInfo _getClientProp(Context ctx, String entityName, String propName) throws BOSException, EASBizException {
        PropertyInfo prop;
        if (StringUtils.isEmpty((String)entityName) || StringUtils.isEmpty((String)propName)) {
            return null;
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        RelationshipInfo relationInfo = ImplUtils.getRTRelation((EntityObjectInfo)entity, (LinkPropertyInfo)((LinkPropertyInfo)(prop = entity.getPropertyByName(propName))));
        CardinalityType cardinalityType = relationInfo.getChildCardinality(entity);
        if (CardinalityType.isOneORZero((CardinalityType)cardinalityType)) {
            return relationInfo.getSupplierProperty();
        }
        return null;
    }

    private void setFieldDataType(Context ctx, StructureConfigInfo info) throws EASBizException, BOSException {
        StructureConfigFilterColumnCollection coll;
        String entityName = info.getEntityName();
        if (entityName == null) {
            return;
        }
        StructureConfigColumnsCollection columns = info.getColumns();
        if (columns == null || columns.size() == 0) {
            return;
        }
        EntityObjectInfo entityObject = this.getEntityObjectByEntity(ctx, entityName);
        if (entityObject.getEntityProperties() != null && entityObject.getEntityProperties().size() == 0) {
            throw new BaseConfigException(BaseConfigException.ENTITYNOTEXISTS, new Object[]{entityName});
        }
        String number = null;
        PropertyInfo property = null;
        for (int i = 0; i < columns.size(); ++i) {
            number = columns.get(i).getNumber();
            property = entityObject.getPropertyByNameRuntime(number);
            if (property == null) {
                throw new BaseConfigException(BaseConfigException.FIELDNOTFOUND, new Object[]{number});
            }
            this.setColumnDataType(columns.get(i), property);
        }
        EntityObjectInfo parentEntity = null;
        if (info.getParent() != null) {
            StructureConfigInfo config = this.getStructureConfigInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getParent().getId()));
            parentEntity = this.getEntityObjectByEntity(ctx, config.getEntityName());
        }
        if ((coll = info.getFilterColumn()) != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                if (coll.get(i).getClientColumn() != null && entityObject.getPropertyByNameRuntime(coll.get(i).getClientColumn()) == null) {
                    throw new BaseConfigException(BaseConfigException.FIELDNOTFOUNDSON, new Object[]{coll.get(i).getClientColumn()});
                }
                if (coll.get(i).getParentColumn() == null || parentEntity != null && parentEntity.getPropertyByNameRuntime(coll.get(i).getParentColumn()) != null) continue;
                throw new BaseConfigException(BaseConfigException.FIELDNOTFOUNDPARENT, new Object[]{coll.get(i).getParentColumn()});
            }
        }
    }

    private EntityObjectInfo getEntityObjectByEntity(Context ctx, String entityName) {
        MetaDataPK entityPk = MetaDataPK.create((String)entityName);
        EntityObjectInfo entityObject = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)entityPk);
        return entityObject;
    }

    public void checkNumberDup(Context ctx, DataBaseInfo dataBaseInfo) throws BOSException, EASBizException {
        StructureConfigInfo info = (StructureConfigInfo)dataBaseInfo;
        if (info.getClientNumber() == null) {
            throw new BaseConfigException(BaseConfigException.CODE_NOT_EMPTY, new Object[]{info.getName()});
        }
        String id = null;
        if (null != info.getId()) {
            id = info.getId().toString();
        }
        if (this.isDupClientNumber(ctx, info.getScheme().getId().toString(), info.getClientNumber(), id)) {
            throw new BaseConfigException(BaseConfigException.CONFIG_ALREADY_EXIST, new Object[]{info.getName(), info.getClientNumber()});
        }
    }

    private void checkIdentifierLength(StructureConfigInfo info) throws EASBizException {
        String clientNumber = info.getClientNumber();
        if (clientNumber.length() > 30) {
            throw new BaseConfigException(BaseConfigException.IDENTIFIER_LONG, new Object[]{clientNumber});
        }
    }

    @Override
    protected void _depEnable(Context ctx, HashMap param) throws BOSException, EASBizException {
        FilterInfo hrInitFilter = new FilterInfo();
        hrInitFilter.getFilterItems().add(new FilterItemInfo("key", (Object)"IS_GENERATE_STRUCTURE_FROM_DEP"));
        hrInitFilter.getFilterItems().add(new FilterItemInfo("value", (Object)"FALSE"));
        if (HRInitFactory.getLocalInstance((Context)ctx).exists(hrInitFilter)) {
            logger.error((Object)"structureconfig depEnable skip, param IS_GENERATE_STRUCTURE_FROM_DEP value in t_hr_hrinit is not TRUE.");
            return;
        }
        List entityKeys = null;
        logger.error((Object)"structureconfig depEnable entitystart");
        if (param.get("entityKey") != null) {
            entityKeys = (List)param.get("entityKey");
        }
        try {
            if (entityKeys != null) {
                ctx.put((Object)"sHR_Structure_DepEnable", (Object)true);
                String entitykey = null;
                EntityObjectInfo entity = null;
                EntityObjectInfo hisEntity = null;
                StructureConfigSchemeCollection schemes = StructureConfigSchemeFactory.getLocalInstance(ctx).getStructureConfigSchemeCollection();
                IStructureConfigColumns iStructureConfigColumns = StructureConfigColumnsFactory.getLocalInstance(ctx);
                IQueryConfigField iQueryConfigField = QueryConfigFieldFactory.getLocalInstance(ctx);
                IMetaDataLoader iMetaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                int size = entityKeys.size();
                for (int i = 0; i < size; ++i) {
                    entitykey = (String)entityKeys.get(i);
                    logger.error((Object)("depEnable entity:" + entitykey));
                    entity = iMetaDataLoader.getEntity((IMetaDataPK)MetaDataPK.create((String)entitykey));
                    hisEntity = EntityCheckHisUtil.getHisEntityObjectInfo((Context)ctx, (EntityObjectInfo)entity);
                    PropertyCollection property = entity.getProperties();
                    StringBuffer sb = new StringBuffer();
                    int size2 = schemes.size();
                    for (int k = 0; k < size2; ++k) {
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("EntityName", (Object)entitykey));
                        filter.getFilterItems().add(new FilterItemInfo("scheme", (Object)schemes.get(k).getId().toString()));
                        viewInfo.setFilter(filter);
                        StructureConfigCollection structures = this.getStructureConfigCollection(ctx, viewInfo);
                        if (structures == null || structures.size() == 0) {
                            String parentName;
                            if (!entity.isDynamic() || null == entity.getParent() || !"com.kingdee.eas.hr.base.app.EmpInfoMultiPage".equals(parentName = entity.getParent().getFullName()) && !"com.kingdee.eas.hr.base.app.EmpInfoSinglePage".equals(parentName)) continue;
                            this.addStructureConfig(ctx, entity, schemes.get(k), iStructureConfigColumns);
                            continue;
                        }
                        int length = property.size();
                        for (int j = 0; j < length; ++j) {
                            PropertyInfo info = property.get(j);
                            if (!info.isConfigured()) continue;
                            if (hisEntity != null) {
                                PropertyInfo propertyByName = hisEntity.getPropertyByName(info.getName());
                                if (propertyByName != null) {
                                    this.addStructureConfigColumn(ctx, entity, structures, info, schemes.get(k), iStructureConfigColumns);
                                    continue;
                                }
                                sb.append(info.getName()).append(", ");
                                continue;
                            }
                            this.addStructureConfigColumn(ctx, entity, structures, info, schemes.get(k), iStructureConfigColumns);
                        }
                    }
                    if (StringUtils.isEmpty((String)sb.toString())) continue;
                    logger.error((Object)("The history model of model " + entitykey + " does not have the following fields configured: " + sb.toString() + " so it is not generated in the structure configuration."));
                }
                logger.error((Object)"structureconfig depEnable end");
                StructureConfigConvertHelper.removeAll();
                ctx.remove((Object)"sHR_Structure_DepEnable");
                UIViewRefresh cache = new UIViewRefresh();
                cache.hrRrefresh(ctx);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)("structureconfig depEnable error:" + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("structureconfig depEnable error:" + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    private void clear(Context ctx, EntityObjectInfo entity, IStructureConfigColumns iStructureConfigColumns, IQueryConfigField iQueryConfigField) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(StructureConfigConvertHelper.getSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("EntityName", (Object)entity.getFullName(), CompareType.EQUALS));
        view.setFilter(filter);
        StructureConfigCollection scoll = this.getStructureConfigCollection(ctx, view);
        if (null != scoll && scoll.size() > 0) {
            int total = scoll.size();
            for (int i = 0; i < total; ++i) {
                HashMap<String, Object> error = new HashMap<String, Object>();
                StructureConfigCheckUtil.clearOrCheckStructureConfig(ctx, scoll.get(i), true, error, iStructureConfigColumns, iQueryConfigField);
            }
        }
    }

    @Override
    protected void _depDisable(Context ctx, HashMap param) throws BOSException, EASBizException {
        param.get("entityKey");
        UIViewRefresh cache = new UIViewRefresh();
        cache.hrRrefresh(ctx);
    }

    private void addStructureConfig(Context ctx, EntityObjectInfo entity, StructureConfigSchemeInfo scheme, IStructureConfigColumns iStructureConfigColumns) throws BOSException, EASBizException {
        String oql = MessageFormat.format("where EntityName = ''{0}'' and scheme = ''{1}'' and parent is null ", "com.kingdee.eas.basedata.person.app.Person", scheme.getId().toString());
        StructureConfigInfo parent = null;
        if (this.exists(ctx, oql)) {
            parent = this.getStructureConfigInfo(ctx, oql);
        }
        if (null == parent) {
            return;
        }
        StructureConfigInfo structureConfig = this.addStructureConfig0(ctx, entity, scheme, parent, null, 0, iStructureConfigColumns);
        if (null == structureConfig) {
            return;
        }
        List propertyNameList = EntityCheckHisUtil.getPropertiesNotInHisEntity((Context)ctx, (String)structureConfig.getEntityName());
        StringBuffer sb = new StringBuffer();
        if (propertyNameList != null && propertyNameList.size() > 0) {
            StructureConfigColumnsCollection columns = structureConfig.getColumns();
            for (String name : propertyNameList) {
                for (int k = 0; k < columns.size(); ++k) {
                    StructureConfigColumnsInfo config = columns.get(k);
                    if (StringUtils.isEmpty((String)name) || !name.equals(config.getNumber())) continue;
                    columns.remove(config);
                    sb.append(name).append(", ");
                }
            }
        }
        if (!StringUtils.isEmpty((String)sb.toString())) {
            logger.error((Object)("The history model of model " + structureConfig.getEntityName() + " does not have the following fields configured: " + sb.toString() + " so it is not generated in the structure configuration."));
        }
        this._save(ctx, (IObjectValue)structureConfig);
    }

    private StructureConfigInfo addStructureConfig0(Context ctx, EntityObjectInfo entity, StructureConfigSchemeInfo scheme, StructureConfigInfo parent, PropertyInfo property0, int deep, IStructureConfigColumns iStructureConfigColumns) throws EASBizException, BOSException {
        FilterInfo filter00 = new FilterInfo();
        filter00.getFilterItems().add(new FilterItemInfo("EntityName", (Object)entity.getFullName()));
        filter00.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.NOTEQUALS));
        filter00.getFilterItems().add(new FilterItemInfo("scheme", (Object)scheme.getId().toString(), CompareType.EQUALS));
        if (this._exists(ctx, filter00)) {
            return null;
        }
        String realClientNumber = this.getRealClientNumber(entity);
        StructureConfigInfo structureConfig = new StructureConfigInfo();
        structureConfig.setId(BOSUuid.create((BOSObjectType)structureConfig.getBOSType()));
        structureConfig.setEntityName(entity.getFullName());
        structureConfig.setIsPreset(Boolean.FALSE);
        structureConfig.setMultiRow(Boolean.FALSE);
        structureConfig.setSupportSingleView(Boolean.FALSE);
        structureConfig.setNowDateFilter(Boolean.FALSE);
        int existsCount = this.getExistsStructureCounts(ctx, realClientNumber, scheme.getId().toString());
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        if (existsCount > 0) {
            aliasMap.put(LocaleUtils.locale_l1.getDisplayName(), parent.getAlias(LocaleUtils.locale_l1) + "_" + entity.getAlias(LocaleUtils.locale_l1));
            aliasMap.put(LocaleUtils.locale_l2.getDisplayName(), parent.getAlias(LocaleUtils.locale_l2) + "_" + entity.getAlias(LocaleUtils.locale_l2));
            aliasMap.put(LocaleUtils.locale_l3.getDisplayName(), parent.getAlias(LocaleUtils.locale_l3) + "_" + entity.getAlias(LocaleUtils.locale_l3));
            MutilanUtils.setMultiFieldValueToBean((Context)ctx, (String)"alias", (IObjectValue)structureConfig, aliasMap);
            MutilanUtils.setMultiFieldValueToBean((Context)ctx, (String)"name", (IObjectValue)structureConfig, aliasMap);
            structureConfig.setClientNumber(MessageFormat.format("{0}{1}", realClientNumber.toLowerCase(), existsCount + 1));
        } else {
            aliasMap.put(LocaleUtils.locale_l1.getDisplayName(), entity.getAlias(LocaleUtils.locale_l1));
            aliasMap.put(LocaleUtils.locale_l2.getDisplayName(), entity.getAlias(LocaleUtils.locale_l2));
            aliasMap.put(LocaleUtils.locale_l3.getDisplayName(), entity.getAlias(LocaleUtils.locale_l3));
            MutilanUtils.setMultiFieldValueToBean((Context)ctx, (String)"alias", (IObjectValue)structureConfig, aliasMap);
            MutilanUtils.setMultiFieldValueToBean((Context)ctx, (String)"name", (IObjectValue)structureConfig, aliasMap);
            structureConfig.setClientNumber(realClientNumber.toLowerCase());
        }
        structureConfig.setScheme(scheme);
        structureConfig.setParent(parent);
        if (null != entity.getParent() && "com.kingdee.eas.hr.base.app.EmpInfoMultiPage".equals(entity.getParent().getFullName())) {
            structureConfig.setMultiRow(true);
        }
        structureConfig.setBaseData(this.isBaseItem(entity));
        this.addFilterColumns(structureConfig, property0, entity);
        PropertyCollection properties = entity.getOwnerAndExtendedProperties();
        PropertyInfo property = entity.getPropertyByName("name");
        int columnIndex = 1;
        if (null != property) {
            columnIndex = this.addOwnPropertyColumns(ctx, structureConfig, (OwnPropertyInfo)property, columnIndex, iStructureConfigColumns);
        }
        if (null != (property = entity.getPropertyByName("number"))) {
            columnIndex = this.addOwnPropertyColumns(ctx, structureConfig, (OwnPropertyInfo)property, columnIndex, iStructureConfigColumns);
        }
        this._save(ctx, (IObjectValue)structureConfig);
        if (deep == 0 || deep == 1 && entity.isDynamic()) {
            this.addOtherProperties(ctx, properties, structureConfig, columnIndex, scheme, deep, iStructureConfigColumns);
        }
        return structureConfig;
    }

    private void addOtherProperties(Context ctx, PropertyCollection properties, StructureConfigInfo structureConfig, int columnIndex, StructureConfigSchemeInfo scheme, int deep, IStructureConfigColumns iStructureConfigColumns) throws EASBizException, BOSException {
        int length = properties.size();
        for (int j = 0; j < length; ++j) {
            if (properties.get(j) instanceof OwnPropertyInfo) {
                columnIndex = this.addOwnPropertyColumns(ctx, structureConfig, (OwnPropertyInfo)properties.get(j), columnIndex, iStructureConfigColumns);
                continue;
            }
            if (!(properties.get(j) instanceof LinkPropertyInfo) || deep == 1 && structureConfig.isBaseData()) continue;
            this.addDeepStructureConfig(ctx, properties.get(j), ((LinkPropertyInfo)properties.get(j)).getRelationship().getSupplierObject(), structureConfig, ++deep, scheme, iStructureConfigColumns);
        }
    }

    private int getExistsStructureCounts(Context ctx, String realClientNumber, String schemeId) throws BOSException {
        String sql = "select count(*) t from T_HR_StructureConfig where LCASE(fclientnumber) like ? and FSchemeID = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{realClientNumber.toLowerCase() + "%", schemeId});
        int hasCount = 0;
        try {
            while (rs.next()) {
                hasCount = rs.getInt("t");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hasCount;
    }

    private void addFilterColumns(StructureConfigInfo structureConfig, PropertyInfo info, EntityObjectInfo entity) {
        StructureConfigFilterColumnInfo filterColumn = new StructureConfigFilterColumnInfo();
        filterColumn.setSeq(1);
        if (null != entity.getParent() && ("com.kingdee.eas.hr.base.app.EmpInfoMultiPage".equals(entity.getParent().getFullName()) || "com.kingdee.eas.hr.base.app.EmpInfoSinglePage".equals(entity.getParent().getFullName()))) {
            filterColumn.setParentColumn("id");
            filterColumn.setClientColumn("person");
        } else {
            filterColumn.setParentColumn(info.getName());
            filterColumn.setClientColumn("id");
        }
        filterColumn.setCompareType(CompareTypeEnum.EQUAL);
        filterColumn.setIsPreset(Boolean.FALSE);
        structureConfig.getFilterColumn().add(filterColumn);
    }

    private int addOwnPropertyColumns(Context ctx, StructureConfigInfo structureConfig, OwnPropertyInfo property, int columnIndex, IStructureConfigColumns iStructureConfigColumns) throws EASBizException, BOSException {
        if (null == property) {
            return columnIndex;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("structureConfig", (Object)structureConfig.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)property.getName()));
        if (iStructureConfigColumns.exists(filter)) {
            return columnIndex;
        }
        StructureConfigColumnsInfo column = new StructureConfigColumnsInfo();
        this.setPropertyMultiLan(ctx, (PropertyInfo)property, column);
        column.setNumber(property.getName());
        column.setStructureConfig(structureConfig);
        column.setIndex(columnIndex++);
        column.setIsPreset(Boolean.FALSE);
        this.setColumnDataType(column, (PropertyInfo)property);
        structureConfig.getColumns().add(column);
        return columnIndex;
    }

    private void setPropertyMultiLan(Context ctx, PropertyInfo property, StructureConfigColumnsInfo column) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        aliasMap.put(LocaleUtils.locale_l1.getDisplayName(), property.getAlias(LocaleUtils.locale_l1));
        aliasMap.put(LocaleUtils.locale_l2.getDisplayName(), property.getAlias(LocaleUtils.locale_l2));
        aliasMap.put(LocaleUtils.locale_l3.getDisplayName(), property.getAlias(LocaleUtils.locale_l3));
        MutilanUtils.setMultiFieldValueToBean((Context)ctx, (String)"name", (IObjectValue)column, aliasMap);
    }

    private void setColumnDataType(StructureConfigColumnsInfo column, PropertyInfo property) {
        if (property instanceof OwnPropertyInfo) {
            OwnPropertyInfo own = (OwnPropertyInfo)property;
            column.setDataType(own.getDataType().toString());
            if (DataType.ENUM.equals((Object)own.getDataType())) {
                BizEnumInfo bizEnumInfo = SHREnumUtil.getBizEnumInfoByOwnProperty((OwnPropertyInfo)own);
                if (null != bizEnumInfo) {
                    column.setEnumSource(bizEnumInfo.getFullName());
                }
                column.setDataType(SHREnumUtil.getEnumByOwnProperty((OwnPropertyInfo)own));
            }
        }
    }

    private boolean existsStructureConfig(Context ctx, String entityFullName, String schmaId, String propertyName, String parentStructureId) throws BOSException {
        StringBuffer existsSql = new StringBuffer();
        Object[] params = new Object[]{entityFullName, schmaId, propertyName};
        existsSql.append("select count(1) result").append(" from T_HR_StructureConfig sc").append(" inner join T_HR_StructureCFC scf on sc.fid = scf.FParentID").append(" where").append(" sc.FEntityName = ?").append(" and sc.FSchemeID= ?").append(" and scf.FParentColumn = ?");
        if (!StringUtils.isEmpty((String)parentStructureId)) {
            params = new Object[]{entityFullName, schmaId, propertyName, parentStructureId};
            existsSql.append(" and exists (select 1 from T_HR_StructureConfig psc where psc.fid = sc.FParentID").append(" and psc.fid = ? )");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)existsSql.toString(), (Object[])params);
        try {
            if (rs.next()) {
                int result = rs.getInt("result");
                return result >= 1;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private String getRealClientNumber(EntityObjectInfo entity) {
        String realClientNumber = entity.getName();
        if (entity.getName().length() > 10) {
            realClientNumber = entity.getName().substring(0, 10);
        }
        return realClientNumber;
    }

    private void addDeepStructureConfig(Context ctx, PropertyInfo info, EntityObjectInfo entity, StructureConfigInfo parentStructure, int deep, StructureConfigSchemeInfo schema, IStructureConfigColumns iStructureConfigColumns) throws EASBizException, BOSException {
        if (deep > 2) {
            return;
        }
        if (entity.getFullName().equals(parentStructure.getEntityName()) && this.existsStructureConfig(ctx, entity.getFullName(), schema.getId().toString(), info.getName(), null)) {
            return;
        }
        if (!entity.getFullName().equals(parentStructure.getEntityName()) && this.existsStructureConfig(ctx, entity.getFullName(), schema.getId().toString(), info.getName(), parentStructure.getId().toString())) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("EntityName", (Object)entity.getFullName()));
        filter.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)schema.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentStructure.getId().toString()));
        if (this.exists(ctx, filter)) {
            return;
        }
        StructureConfigInfo structureConfig = this.addStructureConfig0(ctx, entity, schema, parentStructure, info, deep, iStructureConfigColumns);
        if (logger.isDebugEnabled()) {
            String message = MessageFormat.format("deep = {0},structureConfig = {1} , current_entity= {2}, parent_entity = {3},current_clientNumber={4}, parent_clientNumber={5},current_schemaId={6}", deep, structureConfig.toString(), structureConfig.getEntityName(), parentStructure.getEntityName(), structureConfig.getClientNumber(), parentStructure.getClientNumber(), schema.getId().toString());
            logger.error((Object)message);
        }
        if (null != structureConfig) {
            this._save(ctx, (IObjectValue)structureConfig);
        }
    }

    private void addStructureConfigColumn(Context ctx, EntityObjectInfo entity, StructureConfigCollection structures, PropertyInfo info, StructureConfigSchemeInfo schema, IStructureConfigColumns iStructureConfigColumns) throws EASBizException, BOSException {
        CoreBaseCollection collection = new CoreBaseCollection();
        int size = structures.size();
        for (int i = 0; i < size; ++i) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("structureConfig", (Object)structures.get(i).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getName()));
            StructureConfigColumnsCollection columns = iStructureConfigColumns.getStructureConfigColumnsCollection("where structureConfig = '" + structures.get(i).getId().toString() + "' ");
            int index = columns.size();
            ++index;
            if (iStructureConfigColumns.exists(filter)) continue;
            StructureConfigColumnsInfo column = new StructureConfigColumnsInfo();
            this.setPropertyMultiLan(ctx, info, column);
            column.setNumber(info.getName());
            column.setStructureConfig(structures.get(i));
            column.setIndex(index++);
            column.setIsPreset(Boolean.FALSE);
            if (info instanceof OwnPropertyInfo) {
                this.setColumnDataType(column, info);
                collection.add((CoreBaseInfo)column);
                continue;
            }
            if (!(info instanceof LinkPropertyInfo) || this.isBaseItem(entity)) continue;
            LinkPropertyInfo _info = (LinkPropertyInfo)info;
            EntityObjectInfo pEntityObjectInfo = _info.getRelationship().getSupplierObject();
            this.addDeepStructureConfig(ctx, info, pEntityObjectInfo, structures.get(i), 1, schema, iStructureConfigColumns);
        }
        if (null != collection && collection.size() > 0) {
            iStructureConfigColumns.addnew(collection);
        }
    }

    private boolean isBaseItem(EntityObjectInfo entity) {
        if (null != entity.getParent()) {
            if ("com.kingdee.eas.basedata.hraux.app.BasicItem".equals(entity.getParent().getFullName())) {
                return true;
            }
            if ("com.kingdee.eas.ep.app.DataBaseCustom".equals(entity.getParent().getFullName())) {
                return true;
            }
            if ("com.kingdee.shr.base.syssetting.app.SHRBaseItem".equals(entity.getParent().getFullName())) {
                return true;
            }
            if ("com.kingdee.shr.base.syssetting.app.BaseItemCustom".equals(entity.getParent().getFullName())) {
                return true;
            }
        }
        return false;
    }
}

