/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cloudservice.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.portal.common.util.Base64Util;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.cloudservice.util.UserInfo;
import com.kingdee.shr.cloudservice.util.WSContext;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.net.ConnectException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.xml.namespace.QName;
import org.apache.axis.AxisProperties;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CloudServiceUtil {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.cloudservice.util.CloudServiceUtil");
    private static Integer TIMEOUT_SECOND = 600000;

    public static String doWSLogin(Context ctx, CloudServiceConfigInfo info) throws BOSException {
        String result;
        block13: {
            result = null;
            String sessionId = null;
            UserInfo userInfo = new UserInfo();
            String easAddrWs = CloudServiceUtil.dealEasAddr(info.getEnterPubNetwork());
            String loginURL = easAddrWs + "/ormrpc/services/EASLogin?wsdl";
            Call call = null;
            try {
                Service service = new Service();
                call = (Call)service.createCall();
                userInfo = CloudServiceUtil.assembleUserInfo(ctx, info);
                sessionId = CloudServiceUtil.doLogin(call, loginURL, userInfo);
                if (sessionId != null && sessionId.trim().length() != 0) {
                    break block13;
                }
                logger.error("webservice login fail, username: " + userInfo.getUserName() + ", datacenter: " + userInfo.getDcName());
                throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.cloudservice.CloudServiceResource", (String)"serviceAccountOrPwdError", (Context)ctx));
            }
            catch (ConnectException e) {
                String errMsg = SHRServerResource.getString((String)"com.kingdee.shr.cloudservice.CloudServiceResource", (String)"label47", (Context)ctx);
                logger.error(errMsg + " occur connection exception...", (Throwable)e);
                throw new BOSException(errMsg);
            }
            catch (Exception e) {
                String errorInfo = e.getCause() == null ? e.getMessage() : e.getCause().toString();
                logger.error("webservice login fail, username: " + userInfo.getUserName() + ", datacenter: " + userInfo.getDcName(), (Throwable)e);
                if (errorInfo.contains("java.net.ConnectException") || errorInfo.contains("(404)Not Found")) {
                    errorInfo = SHRServerResource.getString((String)"com.kingdee.shr.cloudservice.CloudServiceResource", (String)"label47", (Context)ctx);
                }
                throw new BOSException(errorInfo);
            }
            finally {
                if (!StringUtils.isEmpty(sessionId)) {
                    try {
                        CloudServiceUtil.doLogout(call, loginURL, userInfo);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    private static String dealEasAddr(String easAddr) {
        if (!StringUtils.isEmpty((Object)easAddr) && (easAddr.endsWith("/shr") || easAddr.endsWith("/shr/"))) {
            easAddr = easAddr.substring(0, easAddr.lastIndexOf("/shr"));
        }
        return easAddr;
    }

    private static UserInfo assembleUserInfo(Context ctx, CloudServiceConfigInfo info) throws SQLException {
        UserInfo userInfo = new UserInfo();
        Connection conn = EJBFactory.getConnection((Context)ctx);
        userInfo.setUserName(info.getServiceUser());
        userInfo.setPassword(Base64Util.decode((String)info.getServicePwd()));
        userInfo.setLanguage(ctx.getLocale().getLanguage());
        userInfo.setDcName(ctx.getAIS());
        userInfo.setSlnName(ctx.getSolution());
        userInfo.setDbType(KSqlUtil.getDbType((Connection)conn));
        return userInfo;
    }

    private static String doLogin(Call call, String loginURL, UserInfo userInfo) throws Exception {
        call.setOperationName("login");
        call.setTargetEndpointAddress(loginURL);
        if (!StringUtils.isEmpty((Object)loginURL) && loginURL.startsWith("https")) {
            AxisProperties.setProperty((String)"axis.socketSecureFactory", (String)"org.apache.axis.components.net.SunFakeTrustSocketFactory");
        }
        call.setReturnType(new QName("urn:client", "WSContext"));
        call.setReturnClass(WSContext.class);
        call.setReturnQName(new QName("", "loginReturn"));
        call.setTimeout(Integer.valueOf(TIMEOUT_SECOND));
        call.setMaintainSession(true);
        WSContext context = (WSContext)call.invoke(new Object[]{userInfo.getUserName(), userInfo.getPassword(), userInfo.getSlnName(), userInfo.getDcName(), userInfo.getLanguage(), userInfo.getDbType()});
        return context.getSessionId();
    }

    private static void doLogout(Call call, String loginURL, UserInfo userInfo) throws Exception {
        if (call != null) {
            call.clearOperation();
            call.setOperationName("logout");
            call.setTargetEndpointAddress(loginURL);
            call.setReturnQName(new QName("", "logoutReturn"));
            call.setTimeout(TIMEOUT_SECOND);
            call.setMaintainSession(true);
            call.invoke(new Object[]{userInfo.getUserName(), userInfo.getSlnName(), userInfo.getDcName(), userInfo.getLanguage()});
        }
    }
}

