/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.cmpdesign.AdjustHrBillEntryCollection;
import com.kingdee.shr.cmpdesign.AdjustSalaryCauseInfo;
import com.kingdee.shr.cmpdesign.CmpStandardInfo;
import com.kingdee.shr.cmpdesign.CmpStdLevelInfo;
import com.kingdee.shr.cmpdesign.CmpStdPointInfo;
import com.kingdee.shr.cmpdesign.CmpStdScopeInfo;
import com.kingdee.shr.cmpdesign.service.BatchAdjustSerive;
import com.kingdee.shr.cmpdesign.sql.BatchAdjustSql;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.FixAdjustSalaryInfo;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class BatchAdjustSeriveImpl
implements BatchAdjustSerive {
    private Logger logger = Logger.getLogger(BatchAdjustSeriveImpl.class);

    @Override
    public List<FixAdjustSalaryInfo> getFixAdjustSalaryInfos(Context ctx, String hrOrgUnitId, String personIds, String itemIds) {
        ArrayList<FixAdjustSalaryInfo> list = new ArrayList<FixAdjustSalaryInfo>();
        String sql = BatchAdjustSql.getLastAdjustInfos(hrOrgUnitId, personIds, itemIds, ctx);
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.logger.error((Object)e.getMessage());
        }
        if (null == rowSet) {
            return list;
        }
        try {
            while (rowSet.next()) {
                FixAdjustSalaryInfo info = this.combineAdjustSalaryInfo(rowSet);
                list.add(info);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.logger.error((Object)e.getMessage());
        }
        return list;
    }

    private FixAdjustSalaryInfo combineAdjustSalaryInfo(IRowSet rowSet) throws SQLException {
        FixAdjustSalaryInfo info = new FixAdjustSalaryInfo();
        info.setMoney(rowSet.getBigDecimal("MONEY"));
        info.setEffectDay((Date)rowSet.getDate("EFFECTDAY"));
        info.setRemark(rowSet.getString("REMARK"));
        info.setRange(rowSet.getFloat("RANGE"));
        info.setLeffectDay((Date)rowSet.getDate("LEFFECTDAY"));
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)rowSet.getString("PERSONID")));
        person.setName(rowSet.getString("PERSONNAME"));
        info.setPerson(person);
        CmpItemInfo item = new CmpItemInfo();
        item.setId(BOSUuid.read((String)rowSet.getString("ITEMID")));
        item.setName(rowSet.getString("ITEMNAME"));
        info.setCmpItem(item);
        CmpStandardInfo std = new CmpStandardInfo();
        String id = rowSet.getString("STDID");
        if (!CmpStrUtil.isEmpty((String)id)) {
            std.setId(BOSUuid.read((String)id));
            std.setName(rowSet.getString("STDNAME"));
            std.setNumber(rowSet.getString("STDNUMBER"));
        }
        info.setStandard(std);
        CmpStdLevelInfo level = new CmpStdLevelInfo();
        id = rowSet.getString("LEVID");
        if (!CmpStrUtil.isEmpty((String)id)) {
            level.setId(BOSUuid.read((String)id));
            level.setName(rowSet.getString("LEVNAME"));
            level.setNumber(rowSet.getString("LEVNUMBER"));
            level.setFloatRate(rowSet.getString("FLOATRATE"));
        }
        info.setStdLevel(level);
        CmpStdPointInfo point = new CmpStdPointInfo();
        id = rowSet.getString("POINTID");
        if (!CmpStrUtil.isEmpty((String)id)) {
            point.setId(BOSUuid.read((String)id));
            point.setName(rowSet.getString("POINTNAME"));
            point.setNumber(rowSet.getString("POINTNUMBER"));
        }
        info.setStdPoint(point);
        CmpStdScopeInfo scope = new CmpStdScopeInfo();
        id = rowSet.getString("SCOPEID");
        if (!CmpStrUtil.isEmpty((String)id)) {
            scope.setId(BOSUuid.read((String)id));
            scope.setName(rowSet.getString("SCOPENAME"));
            scope.setNumber(rowSet.getString("SCOPENUMBER"));
        }
        info.setStdScope(scope);
        HROrgUnitInfo adjustHr = new HROrgUnitInfo();
        adjustHr.setId(BOSUuid.read((String)rowSet.getString("ADJHRID")));
        adjustHr.setName(rowSet.getString("ADJHRNAME"));
        info.setAdjHrOrgUnit(adjustHr);
        HROrgUnitInfo cmpHr = new HROrgUnitInfo();
        info.put("payHrOrgUnit", (Object)new AdjustHrBillEntryCollection());
        AdjustSalaryCauseInfo cause = new AdjustSalaryCauseInfo();
        id = rowSet.getString("CAUSEID");
        if (!CmpStrUtil.isEmpty((String)id)) {
            cause.setId(BOSUuid.read((String)id));
            cause.setName(rowSet.getString("CAUSENAME"));
        }
        info.setAdjustSalaryCause(cause);
        return info;
    }
}

