/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.AdjustPersonRecordCollection;
import com.kingdee.shr.compensation.AdjustPersonRecordFactory;
import com.kingdee.shr.compensation.AdjustPersonRecordInfo;
import com.kingdee.shr.compensation.FixAdjustSalaryCollection;
import com.kingdee.shr.compensation.FixAdjustSalaryFactory;
import com.kingdee.shr.compensation.FixAdjustSalaryInfo;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchAdjustBillUtils {
    public static Map<String, AdjustPersonRecordInfo> getAdjPersonRecord(Context ctx, String personSqlIds, String adjOrgId) throws BOSException {
        HashMap<String, AdjustPersonRecordInfo> dateMap = new HashMap<String, AdjustPersonRecordInfo>();
        AdjustPersonRecordCollection coll = new AdjustPersonRecordCollection();
        try {
            String oql = "select person.id, effectDate, leffectDate where person.id in (" + personSqlIds + ") and hrOrgUnit.id = '" + adjOrgId + "' ";
            coll = AdjustPersonRecordFactory.getLocalInstance((Context)ctx).getAdjustPersonRecordCollection(oql);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        AdjustPersonRecordInfo recordInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            recordInfo = coll.get(i);
            dateMap.put(recordInfo.getPerson().getId().toString(), recordInfo);
        }
        return dateMap;
    }

    public static List<Map<String, String>> getWorkflowBillDate(Context ctx, String personSqlIds, String itemSqlIds, String billId) throws BOSException {
        ArrayList<Map<String, String>> itemList = new ArrayList<Map<String, String>>();
        StringBuffer str = new StringBuffer();
        str.append(" select distinct entry.FPersonId perId, entry.FCmpItemId itemId, entry.FPayHrOrgUnitID, bill.FNumber number ");
        str.append(" from T_HR_SBatchAdjustBill bill ");
        str.append(" inner join T_HR_SBatchAdjustBillEntry entry on bill.fid = entry.FBillId ");
        str.append(" where entry.FPersonId in (" + personSqlIds + ") and entry.FCmpItemId in (" + itemSqlIds + ") ");
        str.append(" and bill.FBillState in (0, 1, 2) ");
        if (!StringUtils.isEmpty((String)billId)) {
            str.append(" and bill.Fid <> '" + billId + "' ");
        }
        HashMap<String, String> itemMap = null;
        String mainField = "";
        try {
            IRowSet r = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (r.next()) {
                itemMap = new HashMap<String, String>();
                if (r.getString("FPayHrOrgUnitID") == null) {
                    mainField = r.getString("perId") + "_" + r.getString("itemId") + "_" + null;
                    itemMap.put("isPayHrNull", "true");
                } else {
                    mainField = r.getString("perId") + "_" + r.getString("itemId") + "_" + r.getString("FPayHrOrgUnitID");
                    itemMap.put("isPayHrNull", "false");
                }
                itemMap.put("key", mainField);
                itemMap.put("number", r.getString("number"));
                itemList.add(itemMap);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return itemList;
    }

    public static List<FixAdjustSalaryInfo> getExistFixAdjSalary(Context ctx, String personSqlIds, String itemSqlIds) throws BOSException {
        ArrayList<FixAdjustSalaryInfo> fixList = new ArrayList<FixAdjustSalaryInfo>();
        try {
            String oql = "select perosn.id, cmpItem.id, effectDay, leffectDay, payHrOrgUnit.id where person.id in (" + personSqlIds + ") and cmpItem.id in (" + itemSqlIds + ") ";
            FixAdjustSalaryCollection fixColl = FixAdjustSalaryFactory.getLocalInstance((Context)ctx).getFixAdjustSalaryCollection(oql);
            for (int i = 0; i < fixColl.size(); ++i) {
                fixList.add(fixColl.get(i));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return fixList;
    }

    public static Map<String, String> getFixAdjSalaryEffectDate(Context ctx, String personIds, String itemIds, String hrOrgIds, String effDays, String leffDays) throws BOSException {
        String personSqlIds = "'" + personIds.replace(",", "','") + "'";
        String itemSqlIds = "'" + itemIds.replace(",", "','") + "'";
        String hrOrgSqlIds = "'" + hrOrgIds.replace(",", "','") + "'";
        HashMap<String, String> fixMap = new HashMap<String, String>();
        try {
            String key;
            String sql = "select fix.FPersonID, fix.FCmpItemID, fix.FEffectDay, fix.FLeffectDay, fix.fpayHrOrgUnitid from t_hr_sfixadjustsalary fix where fix.fpersonid in (" + personSqlIds + ") and fix.fcmpitemid in (" + itemSqlIds + ") ";
            sql = hrOrgSqlIds.contains("") ? sql + " and (fix.fpayHrOrgUnitid in (" + hrOrgSqlIds + ") or fix.fpayHrOrgUnitid is null) " : sql + " and fix.fpayHrOrgUnitid in (" + hrOrgSqlIds + ") ";
            sql = sql + "order by fpersonid, fcmpitemid, FEffectDay";
            IRowSet rs = CmpSQLUtil.executeQuery((Context)ctx, (String)sql);
            HashMap fixAdjustMap = new HashMap();
            while (rs.next()) {
                List<FixAdjustSalaryInfo> list;
                String payHrOrgUnitId = rs.getString("fpayHrOrgUnitid") == null ? "" : rs.getString("fpayHrOrgUnitid");
                key = rs.getString("FPersonID") + rs.getString("FCmpItemID") + payHrOrgUnitId;
                if (fixAdjustMap.get(key) != null) {
                    list = (List)fixAdjustMap.get(key);
                } else {
                    list = new ArrayList();
                    fixAdjustMap.put(key, list);
                }
                FixAdjustSalaryInfo info = new FixAdjustSalaryInfo();
                info.setEffectDay((Date)rs.getDate("FEffectDay"));
                info.setLeffectDay((Date)rs.getDate("FLeffectDay"));
                list.add(info);
            }
            String[] personIdArr = personIds.split(",");
            String[] itemIdArr = itemIds.split(",");
            String[] payHrOrgIdArr = hrOrgIds.split(",", personIdArr.length);
            String[] effDayArr = effDays.split(",", personIdArr.length);
            String[] leffDayArr = leffDays.split(",", personIdArr.length);
            Date effDate = null;
            List list2 = null;
            for (int i = 0; i < personIdArr.length; ++i) {
                String effDay = effDayArr[i];
                effDate = CmpDateUtil.toDate((Object)effDay);
                String leffDay = leffDayArr[i];
                if (effDate == null || (list2 = (List)fixAdjustMap.get(key = personIdArr[i] + itemIdArr[i] + payHrOrgIdArr[i])) == null || !BatchAdjustBillUtils.checkFixAdjust(list2, effDate, leffDay)) continue;
                fixMap.put(personIdArr[i], personIdArr[i]);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return fixMap;
    }

    public static boolean checkFixAdjust(List<FixAdjustSalaryInfo> fixList, Date effdt, String leffDay) throws ParseException {
        FixAdjustSalaryInfo lastInfo = null;
        FixAdjustSalaryInfo nextInfo = null;
        Date maxDate = CmpDateUtil.getMaxEndDate();
        int size = fixList.size();
        for (int i = 0; i < size; ++i) {
            FixAdjustSalaryInfo fixInfo = fixList.get(i);
            if (fixInfo.getEffectDay().before(effdt)) {
                lastInfo = fixInfo;
                continue;
            }
            if (!fixInfo.getEffectDay().after(effdt) || null != nextInfo) continue;
            nextInfo = fixInfo;
        }
        if (CmpStrUtil.isNotEmpty((String)leffDay) && null != nextInfo && CmpDateUtil.toDate((Object)leffDay).compareTo(maxDate) < 0 && CmpDateUtil.toDate((Object)leffDay).compareTo(nextInfo.getEffectDay()) >= 0) {
            return true;
        }
        return null != lastInfo && lastInfo.getLeffectDay().compareTo(maxDate) < 0 && lastInfo.getLeffectDay().compareTo(effdt) >= 0;
    }
}

