/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.budget.budgetadjust.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.SubBudgetManageFacadeFactory;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetItemMapInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetAdjustService;
import com.kingdee.shr.compensation.budget.budgetadjust.util.BudgetAdjustSqlUtils;
import com.kingdee.shr.compensation.pojo.budget.BudgetImportData;
import com.kingdee.shr.compensation.pojo.budget.ImportItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BudgetManageHelper {
    private static Logger logger = Logger.getLogger(BudgetManageHelper.class);
    private String billId;
    private Context ctx;
    private CmpBudgetSchemeInfo budgetScheme;
    private List<String> fieldSnList = null;
    private boolean updateHis = false;
    private Map<String, Integer> itemDataTypeMap = null;

    public BudgetManageHelper(Context ctx, String billId, CmpBudgetSchemeInfo budgetScheme, boolean updateHis) throws BOSException, EASBizException {
        this.billId = billId;
        this.ctx = ctx;
        this.budgetScheme = budgetScheme;
        this.updateHis = updateHis;
        BudgetAdjustService service = new BudgetAdjustService();
        BudgetItemMapInfo itemMap = service.getItemMapByScheme(ctx, budgetScheme.getId().toString());
        this.fieldSnList = itemMap.getFieldSnList();
        this.itemDataTypeMap = itemMap.getItemDataTypeMap();
    }

    public void update(String addFilterSql) throws BOSException, EASBizException, SQLException {
        List<BudgetImportData> importDataList = this.assembleBudgetList(addFilterSql);
        if (!importDataList.isEmpty()) {
            SubBudgetManageFacadeFactory.getLocalInstance((Context)this.ctx).updateBudgetManage(this.budgetScheme.getId().toString(), importDataList);
        }
    }

    public List<BudgetImportData> assembleBudgetList(String addFilterSql) throws BOSException, SQLException {
        ArrayList<BudgetImportData> importDataList = new ArrayList<BudgetImportData>();
        if (this.itemDataTypeMap == null) {
            logger.error((Object)"itemDataTypeMap is null!");
            return importDataList;
        }
        StringBuilder whereSql = new StringBuilder();
        whereSql.append("where fbillid = ? ");
        if (!StringUtils.isEmpty((CharSequence)addFilterSql)) {
            whereSql.append(addFilterSql);
        }
        String entrySql = BudgetAdjustSqlUtils.queryBudgetAdjustEntrySql(this.ctx, this.fieldSnList, whereSql.toString());
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)entrySql, (Object[])new Object[]{this.billId});
        while (rs.next()) {
            BudgetImportData importData = new BudgetImportData();
            importData.setId(rs.getString("budgetManageId"));
            importData.setIdNew(rs.getInt("backupVersion") == -1);
            importData.setAdminId(rs.getString("adminOrgUnitId"));
            importData.setCostTypeId(rs.getString("costTypeId"));
            importData.setState(1);
            importData.setVersionPositive(this.updateHis);
            importData.setRemark1(rs.getString("description1"));
            importData.setRemark(rs.getString("description2"));
            importData.setRemark3(rs.getString("description3"));
            importData.setNotAssign(this.updateHis);
            ArrayList<ImportItem> itemList = new ArrayList<ImportItem>();
            for (String fieldSn : this.fieldSnList) {
                BigDecimal bigValue;
                String updateKey;
                ImportItem item = new ImportItem();
                item.setColumn("T" + fieldSn);
                String value = null;
                String string = updateKey = this.updateHis ? "T" + fieldSn : "M" + fieldSn;
                value = 0 == this.itemDataTypeMap.get(fieldSn) ? ((bigValue = BudgetAdjustSqlUtils.handleZero(rs.getBigDecimal(updateKey))) == null ? "" : bigValue.toString()) : rs.getString(updateKey);
                item.setValue(value);
                itemList.add(item);
            }
            Collections.sort(itemList);
            importData.setImportItemList(itemList);
            importDataList.add(importData);
        }
        return importDataList;
    }
}

