/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.budget.budgetadjust.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.app.budget.BudgetManageInfo;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateInfo;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateTypeEnum;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemDataType;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustEntryCollection;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustEntryInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetManageExpense;
import com.kingdee.shr.compensation.app.budget.budgetadjust.SubBudgetAdjustEntryCollection;
import com.kingdee.shr.compensation.app.budget.budgetadjust.SubBudgetAdjustEntryInfo;
import com.kingdee.shr.compensation.app.integrate.multiinspire.CostTypeFactory;
import com.kingdee.shr.compensation.app.integrate.multiinspire.CostTypeInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetItemMapInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetPeriodMapInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetAdjustService;
import com.kingdee.shr.compensation.budget.budgetadjust.util.BudgetAdjustSqlUtils;
import com.kingdee.shr.compensation.exception.BudgetEASBizException;
import com.kingdee.shr.compensation.util.budget.BudgetUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class BudgetadjustEntryValidateHelper {
    private CmpBudgetSchemeInfo budgetScheme = null;
    private Context ctx;
    private Locale locale;
    private List<String> budgetItemFields = null;
    private List<String> budgetItemFieldSn = null;
    private Map<String, Integer> itemColDataTypeMap = null;
    private Map<String, Integer> itemDataTypeMap = null;
    private Map<String, CmpBudgetItemInfo> itemInfoMap = null;
    private BudgetAdjustService service = new BudgetAdjustService();
    private List<String> periodColLiasList = null;
    private List<String> periodColNameList = null;
    private List<String> periodFieldList = null;
    private Set<String> requireColNameSet = null;
    private Set<String> entrySet = new HashSet<String>();
    private Set<String> calItemColNames = null;
    private BudgetAdjustEntryCollection entryCol = null;
    private SubBudgetAdjustEntryCollection subEntryCol = null;

    public BudgetadjustEntryValidateHelper(Context ctx, CmpBudgetSchemeInfo budgetScheme) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.locale = ctx.getLocale();
        this.budgetScheme = budgetScheme;
        if (budgetScheme == null || budgetScheme.getId() == null) {
            return;
        }
        BudgetItemMapInfo itemMap = this.service.getItemMapByScheme(ctx, budgetScheme.getId().toString());
        this.budgetItemFields = itemMap.getColNameList();
        this.itemColDataTypeMap = itemMap.getItemColDataTypeMap();
        this.requireColNameSet = itemMap.getRequireColNameSet();
        this.budgetItemFieldSn = itemMap.getFieldSnList();
        this.itemDataTypeMap = itemMap.getItemDataTypeMap();
        this.itemInfoMap = itemMap.getItemInfoMap();
        if (this.service.hasSubEntry(this.budgetScheme)) {
            BudgetPeriodMapInfo subItemMap = this.service.getSubItemMapByScheme(ctx, budgetScheme);
            this.periodColLiasList = subItemMap.getColLiasList();
            this.periodFieldList = subItemMap.getFieldNameList();
            this.periodColNameList = subItemMap.getColNameList();
        }
    }

    public BudgetadjustEntryValidateHelper(Context ctx, CmpBudgetSchemeInfo budgetScheme, String billId) throws EASBizException, BOSException, SQLException {
        this(ctx, budgetScheme);
        this.entryCol = BudgetAdjustSqlUtils.queryAndAssembleEntryColByBill(ctx, billId, this.budgetItemFieldSn, this.itemDataTypeMap);
        if (this.service.hasSubEntry(budgetScheme)) {
            this.subEntryCol = BudgetAdjustSqlUtils.queryAndAssembleSubEntryColByBill(ctx, billId, this.periodColNameList, this.periodFieldList, "where subentry.FBillId = ?");
        }
    }

    public BudgetadjustEntryValidateHelper(Context ctx, CmpBudgetSchemeInfo budgetScheme, String billId, Set<String> calItemColNames) throws BOSException, EASBizException, SQLException {
        this(ctx, budgetScheme, billId);
        this.calItemColNames = calItemColNames;
    }

    public void checkNagetive(BudgetAdjustEntryCollection entryCol, SubBudgetAdjustEntryCollection subEntryCol) throws EASBizException, BOSException {
        this.checkNagetive(entryCol, this.budgetItemFields, this.itemInfoMap);
        this.checkNagetive(subEntryCol, this.periodColNameList, this.periodColLiasList);
    }

    public void checkNageTive(BudgetAdjustEntryCollection entryCol) throws EASBizException, BOSException {
        this.checkNagetive(entryCol, this.budgetItemFields, this.itemInfoMap);
    }

    public void checkNagetive(BudgetAdjustEntryCollection entryCol, List<String> budgetItemFields, Map<String, CmpBudgetItemInfo> itemInfoMap) throws EASBizException, BOSException {
        if (entryCol == null || entryCol.isEmpty() || budgetItemFields == null || budgetItemFields.isEmpty() || itemInfoMap == null) {
            return;
        }
        for (int i = 0; i < entryCol.size(); ++i) {
            BudgetAdjustEntryInfo entryInfo = entryCol.get(i);
            for (String field : budgetItemFields) {
                BigDecimal bigValue;
                CmpBudgetItemInfo itemInfo = itemInfoMap.get(field);
                if (itemInfo == null || itemInfo.getId() == null || itemInfo.getDataType() != CmpBudgetItemDataType.NUMBER || this.isCalItem(field) || (bigValue = entryInfo.getBigDecimal(field)) == null || bigValue.compareTo(BigDecimal.ZERO) >= 0) continue;
                this.assemableEntryBizExceptionData(entryInfo);
                String adminOrgUnitName = entryInfo.getAdminOrgUnit() == null ? null : entryInfo.getAdminOrgUnit().getName(this.locale);
                String costTypeName = entryInfo.getCostType() == null ? null : entryInfo.getCostType().getName(this.locale);
                String itemName = itemInfo.getName(this.locale);
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION33, new Object[]{adminOrgUnitName, costTypeName, itemName});
            }
        }
    }

    public boolean isCalItem(String colName) {
        if (StringUtils.isEmpty((CharSequence)colName) || this.calItemColNames == null) {
            return false;
        }
        colName = colName.replace("M", "T");
        return this.calItemColNames.contains(colName);
    }

    public void checkNagetive(SubBudgetAdjustEntryCollection subEntryCol) throws EASBizException, BOSException {
        this.checkNagetive(subEntryCol, this.periodColNameList, this.periodColLiasList);
    }

    public void checkNagetive(SubBudgetAdjustEntryCollection subEntryCol, List<String> periodColNames, List<String> colLiasList) throws EASBizException, BOSException {
        if (subEntryCol == null || subEntryCol.isEmpty() || colLiasList == null || colLiasList.isEmpty() || periodColNames == null || periodColNames.isEmpty()) {
            return;
        }
        for (int i = 0; i < subEntryCol.size(); ++i) {
            SubBudgetAdjustEntryInfo entryInfo = subEntryCol.get(i);
            this.assemableSubEntryBudgetItemInfo(entryInfo);
            for (int j = 0; j < periodColNames.size(); ++j) {
                String colName = periodColNames.get(j);
                BigDecimal bigValue = entryInfo.getBigDecimal(colName);
                if (bigValue == null || bigValue.compareTo(BigDecimal.ZERO) >= 0) continue;
                this.assemableSubEntryBizExceptionData(entryInfo);
                String adminOrgUnitName = entryInfo.getAdminOrgUnit() == null ? null : entryInfo.getAdminOrgUnit().getName(this.locale);
                String costTypeName = entryInfo.getCostType() == null ? null : entryInfo.getCostType().getName(this.locale);
                String itemName = entryInfo.getBudgetItem() == null ? null : entryInfo.getBudgetItem().getName(this.locale);
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION34, new Object[]{adminOrgUnitName, costTypeName, itemName, colLiasList.get(j)});
            }
        }
    }

    public void saveEntryValid(BudgetAdjustEntryCollection entryCol, SubBudgetAdjustEntryCollection subEntryCol, List<String> budgetPeriodColNames) throws EASBizException, BOSException {
        this.checkNagetive(entryCol, subEntryCol);
        this.checkRequire(entryCol);
        this.saveEntryExpenseValid(entryCol, subEntryCol);
        if (this.service.hasSubEntry(this.budgetScheme)) {
            this.saveSubEntryBudgetValid(subEntryCol, budgetPeriodColNames);
        }
    }

    public void checkRequire(BudgetAdjustEntryCollection entryCol) throws BudgetEASBizException {
        if (entryCol == null || entryCol.isEmpty() || this.requireColNameSet == null || this.requireColNameSet.isEmpty()) {
            return;
        }
        for (int i = 0; i < entryCol.size(); ++i) {
            BudgetAdjustEntryInfo entryInfo = entryCol.get(i);
            if (entryInfo.getAdminOrgUnit() == null || entryInfo.getAdminOrgUnit().getId() == null || entryInfo.getCostType() == null || entryInfo.getCostType().getId() == null) {
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION35);
            }
            for (String field : this.budgetItemFields) {
                if (!this.requireColNameSet.contains(field) || entryInfo.get(field) != null) continue;
                throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION35);
            }
        }
    }

    public void saveEntryValid(BudgetAdjustEntryCollection entryCol, SubBudgetAdjustEntryCollection subEntryCol) throws EASBizException, BOSException {
        this.saveEntryValid(entryCol, subEntryCol, this.periodColNameList);
    }

    public void saveSubEntryBudgetValid(SubBudgetAdjustEntryCollection subEntryCol, List<String> budgetPeriodColNames) throws EASBizException, BOSException {
        if (subEntryCol == null || subEntryCol.isEmpty() || budgetPeriodColNames == null || budgetPeriodColNames.isEmpty()) {
            return;
        }
        for (int i = 0; i < subEntryCol.size(); ++i) {
            SubBudgetAdjustEntryInfo entryInfo = subEntryCol.get(i);
            BigDecimal yearBudget = entryInfo.getAdjustYearBudget() == null ? BigDecimal.ZERO : entryInfo.getAdjustYearBudget();
            BigDecimal periodSum = BigDecimal.ZERO;
            for (String colName : budgetPeriodColNames) {
                BigDecimal bigValue = entryInfo.getBigDecimal(colName);
                periodSum = periodSum.add(bigValue == null ? BigDecimal.ZERO : bigValue);
            }
            if (periodSum.compareTo(yearBudget) <= 0) continue;
            this.assemableSubEntryBizExceptionData(entryInfo);
            String adminOrgUnitName = entryInfo.getAdminOrgUnit() == null ? null : entryInfo.getAdminOrgUnit().getName(this.locale);
            String costTypeName = entryInfo.getCostType() == null ? null : entryInfo.getCostType().getName(this.locale);
            String budgetItemName = entryInfo.getBudgetItem() == null ? null : entryInfo.getBudgetItem().getName(this.locale);
            throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION23, new Object[]{adminOrgUnitName, costTypeName, budgetItemName, periodSum.setScale(2, RoundingMode.HALF_UP).toString(), yearBudget.setScale(2, RoundingMode.HALF_UP).toString()});
        }
    }

    public void saveEntryExpenseValid(BudgetAdjustEntryCollection entryCol, SubBudgetAdjustEntryCollection subEntryCol) throws BOSException, EASBizException {
        this.saveEntryExpenseValid(entryCol, this.budgetItemFields, subEntryCol);
    }

    public void saveEntryExpenseValid() throws BOSException, EASBizException {
        this.saveEntryExpenseValid(this.entryCol, this.budgetItemFields, this.subEntryCol);
    }

    public void saveYearEntryExpenseValid(BudgetAdjustEntryCollection entryCol, List<BudgetManageExpense> budgetManageExpenseInfo) throws EASBizException, BOSException {
        this.saveYearEntryExpenseValid(entryCol, this.budgetItemFields, this.itemColDataTypeMap, this.itemInfoMap, budgetManageExpenseInfo);
    }

    public void saveEntryExpenseValid(BudgetAdjustEntryCollection entryCol, List<String> budgetItemFields, SubBudgetAdjustEntryCollection subEntryCol) throws BOSException, EASBizException {
        if (entryCol == null || entryCol.isEmpty() || budgetItemFields == null || budgetItemFields.isEmpty() || this.budgetScheme == null || this.budgetScheme.getId() == null) {
            return;
        }
        Map<String, Object> manageMap = this.getBudgetManageExcenseInfo(entryCol);
        if (manageMap == null || manageMap.get("budgetManageExpenseInfo") == null || manageMap.get("manageIdMap") == null) {
            return;
        }
        List budgetManageExpenseInfo = (List)manageMap.get("budgetManageExpenseInfo");
        Map manageIdMap = (Map)manageMap.get("manageIdMap");
        this.saveYearEntryExpenseValid(entryCol, budgetItemFields, this.itemColDataTypeMap, this.itemInfoMap, budgetManageExpenseInfo);
        if (this.service.hasSubEntry(this.budgetScheme)) {
            this.savePeriodEntryExpenseValid(subEntryCol, manageIdMap, this.periodColNameList, this.periodColLiasList, budgetManageExpenseInfo);
        }
    }

    public void saveEntryExpenseValid(BudgetAdjustEntryCollection entryCol, List<String> budgetItemFields, SubBudgetAdjustEntryCollection subEntryCol, List<BudgetManageExpense> budgetManageExpenseInfo, Map<String, String> manageIdMap) throws BOSException, EASBizException {
        if (entryCol == null || entryCol.isEmpty() || budgetItemFields == null || budgetManageExpenseInfo == null || budgetManageExpenseInfo.isEmpty() || budgetItemFields.isEmpty() || manageIdMap == null || manageIdMap.isEmpty() || this.budgetScheme == null || this.budgetScheme.getId() == null) {
            return;
        }
        this.saveYearEntryExpenseValid(entryCol, budgetItemFields, this.itemColDataTypeMap, this.itemInfoMap, budgetManageExpenseInfo);
        if (this.service.hasSubEntry(this.budgetScheme)) {
            this.savePeriodEntryExpenseValid(subEntryCol, manageIdMap, this.periodColNameList, this.periodColLiasList, budgetManageExpenseInfo);
        }
    }

    public Map<String, Object> getBudgetManageExcenseInfo(BudgetAdjustEntryCollection entryCol) throws BOSException {
        if (entryCol == null || entryCol.isEmpty() || this.budgetScheme == null) {
            return null;
        }
        BudgetTemplateInfo template = this.budgetScheme.getTemplate();
        if (template != null && template.getTemplateType() == BudgetTemplateTypeEnum.SALARY_TYPE) {
            return null;
        }
        HashMap<String, String> manageIdMap = new HashMap<String, String>();
        ArrayList<String> budgetManageIdList = new ArrayList<String>();
        for (int i = 0; i < entryCol.size(); ++i) {
            BudgetAdjustEntryInfo entryInfo = entryCol.get(i);
            if (entryInfo.getBudgetManage() == null || entryInfo.getBudgetManage().getId() == null) continue;
            String manageId = entryInfo.getBudgetManage().getId().toString();
            budgetManageIdList.add(manageId);
            if (entryInfo.getAdminOrgUnit() == null || entryInfo.getAdminOrgUnit().getId() == null || entryInfo.getCostType() == null || entryInfo.getCostType().getId() == null) continue;
            String manageKey = entryInfo.getAdminOrgUnit().getId() + "_" + entryInfo.getCostType().getId().toString();
            manageIdMap.put(manageKey, manageId);
        }
        List<BudgetManageExpense> budgetManageExpenseInfo = BudgetUtil.getBudgetManageExpenseInfoWithCmpUsedAmount(this.ctx, this.budgetScheme, budgetManageIdList, this.service.hasSubEntry(this.budgetScheme));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("budgetManageExpenseInfo", budgetManageExpenseInfo);
        resultMap.put("manageIdMap", manageIdMap);
        return resultMap;
    }

    public List<String> getBudgetManageExpenseIdList(BudgetAdjustEntryCollection entryCol) throws BOSException {
        Map<String, Object> excenseInfo = this.getBudgetManageExcenseInfo(entryCol);
        if (excenseInfo == null) {
            return null;
        }
        List budgetManageExpenseList = (List)excenseInfo.get("budgetManageExpenseInfo");
        if (budgetManageExpenseList.isEmpty()) {
            return null;
        }
        ArrayList<String> manageIds = new ArrayList<String>();
        block0: for (BudgetManageExpense expenseInfo : budgetManageExpenseList) {
            Map budgetItemMap = expenseInfo.getBudgetItemMap();
            if (budgetItemMap == null || budgetItemMap.isEmpty()) continue;
            for (Map.Entry entry : budgetItemMap.entrySet()) {
                if (entry.getValue() == null || ((BigDecimal)entry.getValue()).compareTo(BigDecimal.ZERO) <= 0) continue;
                manageIds.add(expenseInfo.getBudgetManageId());
                continue block0;
            }
        }
        return manageIds;
    }

    public void savePeriodEntryExpenseValid(SubBudgetAdjustEntryCollection subEntryCol, Map<String, String> manageIdMap, List<String> colNameList, List<String> colLiasList, List<BudgetManageExpense> budgetManageExpenseInfo) throws EASBizException, BOSException {
        if (subEntryCol == null || subEntryCol.isEmpty() || manageIdMap == null || budgetManageExpenseInfo == null || budgetManageExpenseInfo.isEmpty() || colLiasList == null || colLiasList.isEmpty()) {
            return;
        }
        for (int i = 0; i < subEntryCol.size(); ++i) {
            SubBudgetAdjustEntryInfo entryInfo = subEntryCol.get(i);
            this.assemableSubEntryBudgetItemInfo(entryInfo);
            String manageKey = BudgetAdjustSqlUtils.assembleEntryKey(entryInfo);
            if (StringUtils.isEmpty((CharSequence)manageKey) || StringUtils.isEmpty((CharSequence)manageIdMap.get(manageKey)) || entryInfo.getBudgetItem() == null || entryInfo.getBudgetItem().getId() == null) continue;
            String manageId = manageIdMap.get(manageKey);
            String itemId = entryInfo.getBudgetItem().getId().toString();
            for (int j = 0; j < budgetManageExpenseInfo.size(); ++j) {
                Map subExpenses;
                BudgetManageExpense expenseInfo = budgetManageExpenseInfo.get(j);
                if (StringUtils.isEmpty((CharSequence)manageId) || !manageId.equals(expenseInfo.getBudgetManageId()) || (subExpenses = expenseInfo.getSubStandingBookExpenses()) == null || subExpenses.get(itemId) == null) continue;
                Map subQueryExpenses = (Map)subExpenses.get(itemId);
                for (int k = 0; k < colLiasList.size(); ++k) {
                    BigDecimal adjustBigValue;
                    String queryName = colLiasList.get(k);
                    BigDecimal expenseValue = subQueryExpenses.get(queryName) == null ? BigDecimal.ZERO : (BigDecimal)subQueryExpenses.get(queryName);
                    String colName = colNameList.get(k);
                    BigDecimal bigDecimal = adjustBigValue = entryInfo.getBigDecimal(colName) == null ? BigDecimal.ZERO : entryInfo.getBigDecimal(colName);
                    if (expenseValue.compareTo(adjustBigValue) <= 0) continue;
                    this.assemableSubEntryBizExceptionData(entryInfo);
                    String adminOrgUnitName = entryInfo.getAdminOrgUnit() == null ? null : entryInfo.getAdminOrgUnit().getName(this.locale);
                    String costTypeName = entryInfo.getCostType() == null ? null : entryInfo.getCostType().getName(this.locale);
                    String itemName = entryInfo.getBudgetItem() == null ? null : entryInfo.getBudgetItem().getName(this.locale);
                    throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION27, new Object[]{adminOrgUnitName, costTypeName, itemName, queryName, adjustBigValue.setScale(2, RoundingMode.HALF_UP).toString(), expenseValue.setScale(2, RoundingMode.HALF_UP).toString()});
                }
            }
        }
    }

    public void saveYearEntryExpenseValid(BudgetAdjustEntryCollection entryCol, List<String> budgetItemFields, Map<String, Integer> itemColDataTypeMap, Map<String, CmpBudgetItemInfo> itemInfoMap, List<BudgetManageExpense> budgetManageExpenseInfo) throws EASBizException, BOSException {
        if (budgetManageExpenseInfo == null || budgetManageExpenseInfo.isEmpty() || itemInfoMap == null) {
            return;
        }
        for (int i = 0; i < entryCol.size(); ++i) {
            BudgetAdjustEntryInfo entryInfo = entryCol.get(i);
            BudgetManageInfo budgetManage = entryInfo.getBudgetManage();
            if (budgetManage == null || budgetManage.getId() == null) continue;
            String manageId = budgetManage.getId().toString();
            block1: for (int j = 0; j < budgetManageExpenseInfo.size(); ++j) {
                BudgetManageExpense expenseInfo = budgetManageExpenseInfo.get(j);
                if (!manageId.equals(expenseInfo.getBudgetManageId())) continue;
                for (String field : budgetItemFields) {
                    if (0 != itemColDataTypeMap.get(field) || this.isCalItem(field)) continue;
                    BigDecimal adjustBigValue = entryInfo.getBigDecimal(field) == null ? BigDecimal.ZERO : entryInfo.getBigDecimal(field);
                    Map budgetItemMap = expenseInfo.getBudgetItemMap();
                    CmpBudgetItemInfo itemInfo = itemInfoMap.get(field);
                    if (budgetItemMap == null || itemInfo == null || itemInfo.getId() == null) continue block1;
                    BigDecimal expenseValue = (BigDecimal)budgetItemMap.get(itemInfo.getId().toString());
                    if (expenseValue == null || expenseValue.compareTo(adjustBigValue) <= 0) continue;
                    this.assemableEntryBizExceptionData(entryInfo);
                    String adminOrgUnitName = entryInfo.getAdminOrgUnit() == null ? null : entryInfo.getAdminOrgUnit().getName(this.locale);
                    String costTypeName = entryInfo.getCostType() == null ? null : entryInfo.getCostType().getName(this.locale);
                    String itemName = itemInfo.getName(this.locale);
                    throw new BudgetEASBizException(BudgetEASBizException.EXCEPTION26, new Object[]{adminOrgUnitName, costTypeName, itemName, adjustBigValue.setScale(2, RoundingMode.HALF_UP).toString(), expenseValue.setScale(2, RoundingMode.HALF_UP).toString()});
                }
            }
        }
    }

    public void assemableEntryBizExceptionData(BudgetAdjustEntryInfo entryInfo) throws EASBizException, BOSException {
        AdminOrgUnitInfo adminOrgUnitInfo = this.assemableAdminOrgUnitInfo(this.ctx, entryInfo.getAdminOrgUnit());
        entryInfo.setAdminOrgUnit(adminOrgUnitInfo);
        CostTypeInfo costTypeInfo = this.assemableCostTypeInfo(this.ctx, entryInfo.getCostType());
        entryInfo.setCostType(costTypeInfo);
    }

    public void assemableSubEntryBizExceptionData(SubBudgetAdjustEntryInfo entryInfo) throws EASBizException, BOSException {
        AdminOrgUnitInfo adminOrgUnitInfo = this.assemableAdminOrgUnitInfo(this.ctx, entryInfo.getAdminOrgUnit());
        entryInfo.setAdminOrgUnit(adminOrgUnitInfo);
        CostTypeInfo costTypeInfo = this.assemableCostTypeInfo(this.ctx, entryInfo.getCostType());
        entryInfo.setCostType(costTypeInfo);
        this.assemableSubEntryBudgetItemInfo(entryInfo);
        CmpBudgetItemInfo itemInfo = this.assemableBudgetItemInfo(this.ctx, entryInfo.getBudgetItem());
        entryInfo.setBudgetItem(itemInfo);
    }

    public void assemableSubEntryBudgetItemInfo(SubBudgetAdjustEntryInfo entryInfo) {
        if (!StringUtils.isEmpty((CharSequence)entryInfo.getString("budgetitem.id"))) {
            CmpBudgetItemInfo itemInfo = new CmpBudgetItemInfo();
            itemInfo.setId(BOSUuid.read((String)entryInfo.getString("budgetitem.id")));
            itemInfo.setName(entryInfo.getString("budgetitem.name"), this.locale);
            entryInfo.setBudgetItem(itemInfo);
        }
    }

    public CmpBudgetItemInfo assemableBudgetItemInfo(Context ctx, CmpBudgetItemInfo budgetItem) throws EASBizException, BOSException {
        Locale locale;
        String itemName;
        if (budgetItem != null && budgetItem.getId() != null && StringUtils.isEmpty((CharSequence)(itemName = budgetItem.getName(locale = ctx.getLocale())))) {
            budgetItem = CmpBudgetItemFactory.getLocalInstance((Context)ctx).getCmpBudgetItemInfo("select id, name where id = '" + budgetItem.getId() + "'");
        }
        return budgetItem;
    }

    public CostTypeInfo assemableCostTypeInfo(Context ctx, CostTypeInfo costType) throws EASBizException, BOSException {
        Locale locale;
        String costTypeName;
        if (costType != null && costType.getId() != null && StringUtils.isEmpty((CharSequence)(costTypeName = costType.getName(locale = ctx.getLocale())))) {
            costType = CostTypeFactory.getLocalInstance((Context)ctx).getCostTypeInfo("select id, name where id ='" + costType.getId() + "'");
        }
        return costType;
    }

    public AdminOrgUnitInfo assemableAdminOrgUnitInfo(Context ctx, AdminOrgUnitInfo adminOrgUnit) throws EASBizException, BOSException {
        Locale locale;
        String adminOrgUnitName;
        if (adminOrgUnit != null && adminOrgUnit.getId() != null && StringUtils.isEmpty((CharSequence)(adminOrgUnitName = adminOrgUnit.getName(locale = ctx.getLocale())))) {
            adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnit.getId().toString()));
        }
        return adminOrgUnit;
    }

    public boolean checkRepeat(BudgetAdjustEntryInfo entryInfo) {
        if (entryInfo == null) {
            return false;
        }
        String entryKey = BudgetAdjustSqlUtils.assembleEntryKey(entryInfo);
        if (!StringUtils.isEmpty((CharSequence)entryKey) && this.entrySet.contains(entryKey)) {
            return true;
        }
        this.entrySet.add(entryKey);
        return false;
    }

    public void clearRepeat() {
        this.entrySet.clear();
    }

    public Map<String, String> assembleUniqueEntryMap() {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        if (this.entryCol == null || this.entryCol.isEmpty()) {
            return entryMap;
        }
        for (int i = 0; i < this.entryCol.size(); ++i) {
            BudgetAdjustEntryInfo entryInfo = this.entryCol.get(i);
            String entryKey = BudgetAdjustSqlUtils.assembleEntryKey(entryInfo);
            if (StringUtils.isEmpty((CharSequence)entryKey)) continue;
            entryMap.put(entryKey, entryInfo.getId().toString());
        }
        return entryMap;
    }

    public Map<String, String> assembleUniqueSubEntryMap() {
        if (this.subEntryCol == null || this.subEntryCol.isEmpty()) {
            return null;
        }
        HashMap<String, String> entryMap = new HashMap<String, String>();
        for (int i = 0; i < this.subEntryCol.size(); ++i) {
            SubBudgetAdjustEntryInfo entryInfo = this.subEntryCol.get(i);
            String entryKey = BudgetAdjustSqlUtils.assembleSubEntryKey(entryInfo);
            if (StringUtils.isEmpty((CharSequence)entryKey)) continue;
            entryMap.put(entryKey, entryInfo.getId().toString());
        }
        return entryMap;
    }
}

