/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budgetstatistic.dataservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateCollection;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateFactory;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetServiceParam;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.factory.BudgetItemConfigStrategyFactory;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.factory.IBudgetDataServiceProcessor;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.util.BudgetAmountUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.dataset.model.ParamsItem;
import com.kingdee.shr.dataset.service.java.AbstractJavaDataQueryService;
import com.kingdee.shr.dataset.service.util.SQLExcuteHelper;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public abstract class BaseCmpBudgetAmountDataQueryService
extends AbstractJavaDataQueryService {
    private IBudgetDataServiceProcessor processor;
    private AdminOrgUnitCollection childOrgColl;
    private BudgetServiceParam budgetServiceParam;
    protected boolean childOrg = true;
    protected boolean needSubCostType = false;

    protected boolean isChildOrg() {
        return this.childOrg;
    }

    protected boolean isNeedSubCostType() {
        return this.needSubCostType;
    }

    public AdminOrgUnitCollection getChildOrgColl() {
        return this.childOrgColl;
    }

    public IBudgetDataServiceProcessor getProcessor() {
        return this.processor;
    }

    public BudgetServiceParam getBudgetServiceParam() {
        return this.budgetServiceParam;
    }

    public DataResult getAllData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult dr = new DataResult();
        if (!this.checkAndSetParam(ctx, param)) {
            return dr;
        }
        boolean finished = BudgetAmountUtil.budgetInit(ctx);
        if (!finished) {
            return dr;
        }
        Object detailData = this.getDetailData(ctx, this.isChildOrg(), this.isNeedSubCostType());
        if (detailData != null) {
            dr.setRows(this.assembleRowData(ctx, detailData));
        }
        return dr;
    }

    protected abstract List<Map<String, Object>> assembleRowData(Context var1, Object var2) throws BOSException;

    protected boolean checkAndSetParam(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        BudgetTemplateCollection templates;
        int year;
        String adminOrgId;
        String templateId = (String)this.getParamValue(ctx, "templateId", param);
        if (CmpStrUtil.isNullOrEmpty(templateId, adminOrgId = (String)this.getParamValue(ctx, "adminOrg", param)) || "''".equals(templateId) || "''".equals(adminOrgId)) {
            return false;
        }
        ParamsItem p = SQLExcuteHelper.getSourceParamsItem((List)param.getDesignDataSetJava().getParams(), (String)"year");
        if (p == null) {
            Calendar c = Calendar.getInstance();
            year = c.get(1);
        } else {
            year = (Integer)this.getParamValue(ctx, "year", param);
        }
        boolean period = false;
        p = SQLExcuteHelper.getSourceParamsItem((List)param.getDesignDataSetJava().getParams(), (String)"isPeriod");
        if (p != null) {
            Object isPeriodV = this.getParamValue(ctx, "isPeriod", param);
            period = "1".equals(String.valueOf(isPeriodV));
        }
        if ((templates = BudgetTemplateFactory.getLocalInstance((Context)ctx).getBudgetTemplateCollection("where id = " + templateId)) == null || templates.size() == 0) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"param 'templateId'  is invalid in DataSetConfig."});
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String adminOrgRangeSql = SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSQL((Context)ctx, (String)userId, (String)param.getPermItemId());
        AdminOrgUnitCollection coll = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where id = " + adminOrgId);
        if (coll == null || coll.size() == 0) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"param 'adminOrg'  is invalid in DataSetConfig."});
        }
        AdminOrgUnitInfo adminOrgUnitInfo = coll.get(0);
        this.budgetServiceParam = new BudgetServiceParam();
        this.budgetServiceParam.setAdminOrg(adminOrgUnitInfo);
        this.budgetServiceParam.setYear(year);
        this.budgetServiceParam.setPeriod(period);
        this.budgetServiceParam.setTemplateInfo(templates.get(0));
        this.budgetServiceParam.setAdminOrgRangeSql(adminOrgRangeSql);
        this.processor = BudgetItemConfigStrategyFactory.getInstance().getProcessor(ctx, this.budgetServiceParam);
        return true;
    }

    protected Object getDetailData(Context ctx, boolean childOrg, boolean needSubCostType) throws BOSException {
        if (childOrg) {
            this.childOrgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where parent.id = '" + this.budgetServiceParam.getAdminOrg().getId() + "' and isStartSHR = 1  and id in (" + this.budgetServiceParam.getAdminOrgRangeSql() + ") order by index");
            if (this.childOrgColl == null || this.childOrgColl.size() == 0) {
                return null;
            }
        } else {
            this.childOrgColl = new AdminOrgUnitCollection();
            this.childOrgColl.add(this.budgetServiceParam.getAdminOrg());
        }
        return this.processor.getAdminDetailData(this.childOrgColl, needSubCostType);
    }

    public DataResult getPageData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        return this.getAllData(ctx, param);
    }
}

