/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budgetstatistic.dataservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dataservice.BaseCmpBudgetAmountDataQueryService;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetItemBoard;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.PeriodProp;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.YearPeriodProp;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmpBudgetComparisonAmountDataQueryService
extends BaseCmpBudgetAmountDataQueryService {
    @Override
    protected Object getDetailData(Context ctx, boolean childOrg, boolean needSubCostType) throws BOSException {
        return this.getProcessor().getPre3YearBudgetSumData();
    }

    @Override
    protected List<Map<String, Object>> assembleRowData(Context ctx, Object detailDataObj) throws BOSException {
        List detailData = (List)detailDataObj;
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        detailData.stream().sorted(Comparator.comparing(YearPeriodProp::getYear)).forEach(yearPeriodProp -> {
            Map<String, PeriodProp> periodPropMap = yearPeriodProp.getPeriodPropMap();
            if (periodPropMap.isEmpty()) {
                yearPeriodProp.getTag_periodPropMap().forEach((periodTag, periodProp) -> {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("year", String.valueOf(yearPeriodProp.getYear()));
                    row.put("period", periodProp.getPeriodAlias());
                    row.put("allAmount", 0);
                    row.put("usedAmount", 0);
                    row.put("remainAmount", 0);
                    rows.add(row);
                });
            } else {
                periodPropMap.forEach((period, periodProp) -> {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("year", String.valueOf(yearPeriodProp.getYear()));
                    row.put("period", periodProp.getPeriodAlias());
                    BudgetItemBoard budgetItemBoard = periodProp.mergeAllItemBoard();
                    BigDecimal allAmount = budgetItemBoard.getAllAmount();
                    BigDecimal realUsedAmount = budgetItemBoard.getRealUsedAmount();
                    BigDecimal remainAmount = allAmount.subtract(realUsedAmount);
                    row.put("allAmount", allAmount);
                    row.put("usedAmount", realUsedAmount);
                    row.put("remainAmount", remainAmount);
                    rows.add(row);
                });
            }
        });
        return rows;
    }
}

