/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.confirm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmInfo;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.PersonCmpInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelMatchDataInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelState;
import com.kingdee.shr.compensation.intelligent.confirm.AbstractCmpIntelConfirm;
import com.kingdee.shr.compensation.record.factory.impl.CmpRecordImpl;
import com.kingdee.shr.compensation.record.util.RecordInstanceFactory;
import com.kingdee.shr.compensation.record.validator.CmpRecordValidator;
import com.kingdee.shr.compensation.record.validator.RocordValidatorInfo;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.biz.PersonCmpBizUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CmpPersonDecreaseConfirm
extends AbstractCmpIntelConfirm {
    @Override
    public Map<String, Object> confirm() throws EASBizException, BOSException {
        HashMap<String, Object> confirmMap = new HashMap<String, Object>();
        ArrayList<CmpIntelMatchDataInfo> loseList = new ArrayList<CmpIntelMatchDataInfo>();
        List<Object> stopList = new ArrayList<CmpIntelMatchDataInfo>();
        List<CmpIntelMatchDataInfo> matchDatas = this.getMatchDataInfos();
        CmpIntelMatchDataInfo matchDataInfo = null;
        java.util.Date handleDate = null;
        CmpIntelState state = null;
        java.util.Date now = new java.util.Date();
        String msg = "";
        String errorMsg = "";
        String flag = "";
        flag = EASResource.getString((String)"com.kingdee.shr.compensation.resource.ConstantResource", (String)"STOPCMP_MSG", (Locale)this.ctx.getLocale());
        String loseFlag = EASResource.getString((String)"com.kingdee.shr.compensation.resource.ConstantResource", (String)"LOSECMP_MSG", (Locale)this.ctx.getLocale());
        int size = matchDatas.size();
        for (int i = 0; i < size; ++i) {
            matchDataInfo = matchDatas.get(i);
            state = matchDataInfo.getState();
            if (CmpIntelState.CONFIRMED.equals((Object)state)) {
                String label25;
                errorMsg = label25 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label25", (Locale)this.ctx.getLocale());
                continue;
            }
            msg = matchDataInfo.getMsg();
            handleDate = matchDataInfo.getHandleDate();
            if (handleDate.after(now) && flag.equals(msg)) {
                String label27;
                errorMsg = label27 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label27", (Locale)this.ctx.getLocale());
                continue;
            }
            if (flag.equals(msg) || "Stop Salary Payment".equals(msg)) {
                stopList.add(matchDataInfo);
                continue;
            }
            if (!loseFlag.equals(msg) && !"Salary archives failure".equals(msg)) continue;
            loseList.add(matchDataInfo);
        }
        int loseSize = 0;
        int stopSize = 0;
        HashSet loseSuccessSet = new HashSet();
        HashSet stopSuccessSet = new HashSet();
        if (loseList.size() > 0) {
            Map<String, Object> loseDataMap = this.filterLoseData(loseList);
            Map validDataMap = (Map)loseDataMap.get("validDataMap");
            loseSuccessSet = (HashSet)loseDataMap.get("successSet");
            errorMsg = (String)loseDataMap.get("errorMsg");
            if (validDataMap.size() > 0) {
                CmpRecordImpl cmpRecordImpl = (CmpRecordImpl)RecordInstanceFactory.getRecordInstance(RecordInstanceFactory.CATEGORY.CMP);
                cmpRecordImpl.loseRecords(this.ctx, validDataMap);
            }
            loseSize = validDataMap.size();
        }
        if (stopList.size() > 0) {
            Map<String, Object> stopDataMap = this.filterStopData(stopList);
            stopList = (List)stopDataMap.get("stopList");
            stopSuccessSet = (HashSet)stopDataMap.get("successSet");
            errorMsg = (String)stopDataMap.get("errorMsg");
            this.stopPersonCmp(stopList);
            stopSize = stopList.size();
        }
        loseSuccessSet.addAll(stopSuccessSet);
        this.changeState(loseSuccessSet);
        int successSize = loseSize + stopSize;
        confirmMap.put("successSize", successSize);
        confirmMap.put("errorMsg", errorMsg);
        return confirmMap;
    }

    private Map<String, Object> filterLoseData(List<CmpIntelMatchDataInfo> loseList) {
        StringBuffer recordIds = new StringBuffer();
        String matchDataId = "";
        String personId = "";
        String personCmpId = "";
        String hrOrgId = "";
        String key = "";
        java.util.Date loseDate = null;
        PersonBURelaConfirmInfo pbuConfirm = null;
        CmpIntelMatchDataInfo matchDataInfo = null;
        HashMap<String, java.util.Date> allLoseDateMap = new HashMap<String, java.util.Date>();
        List<RocordValidatorInfo> errorList = new ArrayList<RocordValidatorInfo>();
        Map<String, PersonCmpInfo> personCmpMap = PersonCmpBizUtil.getPersonCmpMap(this.ctx);
        HashMap<String, String> matchToPersonCmp = new HashMap<String, String>();
        int size = loseList.size();
        for (int i = 0; i < size; ++i) {
            matchDataInfo = loseList.get(i);
            matchDataId = matchDataInfo.getId().toString();
            pbuConfirm = matchDataInfo.getPbuConfirm();
            hrOrgId = matchDataInfo.getCmpIntelRule().getHrOrgUnit().getId().toString();
            personId = pbuConfirm.getPerson().getId().toString();
            key = hrOrgId + "_" + personId;
            if (!personCmpMap.containsKey(key)) {
                matchToPersonCmp.put(matchDataId, null);
                continue;
            }
            personCmpId = personCmpMap.get(key).getId().toString();
            recordIds.append(personCmpId).append(",");
            loseDate = matchDataInfo.getHandleDate();
            allLoseDateMap.put(personCmpId, loseDate);
            matchToPersonCmp.put(matchDataId, personCmpId);
        }
        CmpRecordValidator validator = (CmpRecordValidator)RecordInstanceFactory.getRecordValidatorInstance(RecordInstanceFactory.CATEGORY.CMP);
        try {
            if (recordIds.length() > 0) {
                errorList = validator.loseRecord(this.ctx, recordIds.substring(0, recordIds.length() - 1), loseDate);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        Map<String, RocordValidatorInfo> validateErrorMap = this.buildRecordDataMap(errorList);
        Map<String, Object> result = this.getResult(matchToPersonCmp, validateErrorMap, allLoseDateMap);
        return result;
    }

    private Map<String, Object> getResult(Map<String, String> matchToPersonCmp, Map<String, RocordValidatorInfo> validateErrorMap, Map<String, java.util.Date> allLoseDateMap) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        Set<Map.Entry<String, String>> entrySet = matchToPersonCmp.entrySet();
        Iterator<Map.Entry<String, String>> it = entrySet.iterator();
        String matchId = "";
        String personCmpId = "";
        String msg = "";
        String errorMsg = "";
        java.util.Date loseDate = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<String> successSet = new HashSet<String>();
        HashMap<String, Date> validDataMap = new HashMap<String, Date>();
        RocordValidatorInfo info = null;
        while (it.hasNext()) {
            Map.Entry<String, String> next = it.next();
            matchId = next.getKey();
            personCmpId = next.getValue();
            if (validateErrorMap.containsKey(personCmpId)) {
                info = validateErrorMap.get(personCmpId);
                msg = info.getMsg();
                errorMap.put(matchId, msg);
                errorMsg = msg;
                continue;
            }
            if (CmpStrUtil.isEmpty(personCmpId)) {
                String label28 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label28", (Locale)this.ctx.getLocale());
                errorMap.put(matchId, label28);
                errorMsg = label28;
                continue;
            }
            loseDate = allLoseDateMap.get(personCmpId);
            validDataMap.put(personCmpId, new Date(loseDate.getTime()));
            successSet.add(matchId);
        }
        result.put("validDataMap", validDataMap);
        result.put("errorMap", errorMap);
        result.put("successSet", successSet);
        result.put("errorMsg", errorMsg);
        return result;
    }

    private Map<String, RocordValidatorInfo> buildRecordDataMap(List<RocordValidatorInfo> errorList) {
        HashMap<String, RocordValidatorInfo> map = new HashMap<String, RocordValidatorInfo>();
        String recordId = "";
        RocordValidatorInfo info = null;
        int size = errorList.size();
        for (int i = 0; i < size; ++i) {
            info = errorList.get(i);
            recordId = info.getCode();
            map.put(recordId, info);
        }
        return map;
    }

    private Map<String, Object> filterStopData(List<CmpIntelMatchDataInfo> stopList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String matchDataId = "";
        String msg = "";
        String personId = "";
        String key = "";
        String personCmpId = "";
        String hrOrgId = "";
        String errorMsg = "";
        Map<String, PersonCmpInfo> personCmpMap = PersonCmpBizUtil.getPersonCmpMap(this.ctx);
        HashSet<String> successSet = new HashSet<String>();
        HashMap<String, String> errorMap = new HashMap<String, String>();
        ArrayList<CmpIntelMatchDataInfo> successList = new ArrayList<CmpIntelMatchDataInfo>();
        Map<String, String> personCmpCalTableMap = this.getPersonCmpCalTableMap();
        PersonBURelaConfirmInfo pbuConfirm = null;
        CmpIntelMatchDataInfo matchDataInfo = null;
        int size = stopList.size();
        for (int i = 0; i < size; ++i) {
            matchDataInfo = stopList.get(i);
            matchDataId = matchDataInfo.getId().toString();
            pbuConfirm = matchDataInfo.getPbuConfirm();
            hrOrgId = matchDataInfo.getCmpIntelRule().getHrOrgUnit().getId().toString();
            personId = pbuConfirm.getPerson().getId().toString();
            key = hrOrgId + "_" + personId;
            if (!personCmpMap.containsKey(key)) {
                String label28;
                errorMsg = msg = (label28 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label28", (Locale)this.ctx.getLocale()));
                errorMap.put(matchDataId, msg);
                continue;
            }
            personCmpId = personCmpMap.get(key).getId().toString();
            if (personCmpCalTableMap.containsKey(personCmpId)) {
                String label29 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label29", (Locale)this.ctx.getLocale());
                errorMsg = msg = label29 + ":" + personCmpCalTableMap.get(personCmpId);
                errorMap.put(matchDataId, msg);
                continue;
            }
            successList.add(matchDataInfo);
            successSet.add(matchDataId);
        }
        result.put("stopList", successList);
        result.put("errorMap", errorMap);
        result.put("successSet", successSet);
        result.put("errorMsg", errorMsg);
        return result;
    }

    private void stopPersonCmp(List<CmpIntelMatchDataInfo> stopList) {
        Map<String, PersonCmpInfo> personCmpMap = PersonCmpBizUtil.getPersonCmpMap(this.ctx);
        CmpIntelMatchDataInfo matchDataInfo = null;
        PersonBURelaConfirmInfo pbuConfirm = null;
        String personId = "";
        String personCmpId = "";
        String hrOrgId = "";
        String key = "";
        Object[] param = new Object[]{};
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        int size = stopList.size();
        for (int i = 0; i < size; ++i) {
            matchDataInfo = stopList.get(i);
            pbuConfirm = matchDataInfo.getPbuConfirm();
            hrOrgId = matchDataInfo.getCmpIntelRule().getHrOrgUnit().getId().toString();
            personId = pbuConfirm.getPerson().getId().toString();
            key = hrOrgId + "_" + personId;
            personCmpId = personCmpMap.get(key).getId().toString();
            param = new Object[]{personCmpId};
            params.add(param);
        }
        String sql = "update T_HR_SPersonCmp set FIsSendSalary = 0 where fid=?";
        try {
            DbUtil.executeBatch((Context)this.ctx, (String)sql, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> getPersonCmpCalTableMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String l = LocaleUtils.getShortCode((Context)this.ctx);
        String sql = "select cmpEmp.FPersonCmpID, scheme.fname_" + l + ",calTable.fperiodYear,calTable.fperiodMonth, calTable.fcalTime from t_hr_scmpcaltable calTable left join T_HR_SCmpEmpORelation cmpEmp  on calTable.FCmpEmpORelationID=cmpEmp.fid left join t_hr_scalscheme scheme on calTable.fcalschemeid=scheme.fid where calTable.FCalState!=20";
        try {
            String personCmpId = "";
            String schemeDetail = "";
            String schemeName = "";
            String periodYear = "";
            String periodMonth = "";
            String calTime = "";
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            String scheme = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"scheme", (Locale)this.ctx.getLocale());
            while (rs.next()) {
                personCmpId = rs.getString("FPersonCmpID");
                if (map.containsKey(personCmpId)) continue;
                schemeName = rs.getString("fname_" + l + "");
                periodYear = rs.getString("fperiodYear");
                periodMonth = rs.getString("fperiodMonth");
                calTime = rs.getString("fcalTime");
                schemeDetail = scheme + "\u3010" + schemeName + "\u3011" + periodYear + "-" + periodMonth + "-" + calTime;
                map.put(personCmpId, schemeDetail);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }
}

