/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.translator;

import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelFilterType;
import com.kingdee.shr.compensation.intelligent.translator.CmpTransForConnector;
import com.kingdee.shr.compensation.intelligent.translator.CmpTransForDate;
import com.kingdee.shr.compensation.intelligent.translator.CmpTransForNormal;
import com.kingdee.shr.compensation.intelligent.translator.CmpTransForTree;
import com.kingdee.shr.compensation.intelligent.translator.ICmpFilterTrans;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.util.HashMap;
import java.util.Map;

public class CmpIntelligentTranslatorStore {
    private static Map<String, String> map;
    private static CmpIntelligentTranslatorStore instance;

    private CmpIntelligentTranslatorStore() {
        this.initTranslatorMap();
    }

    private void initTranslatorMap() {
        map = new HashMap<String, String>();
        map.put(CmpIntelFilterType.CONNECTOR.getName(), CmpTransForConnector.class.getName());
        map.put(CmpIntelFilterType.WRAPPER.getName(), CmpTransForDate.class.getName());
        map.put(CmpIntelFilterType.NORMAL.getName(), CmpTransForNormal.class.getName());
        map.put(CmpIntelFilterType.TREE.getName(), CmpTransForTree.class.getName());
    }

    public Map<String, String> getTranslatorMap() {
        return map;
    }

    public String getTranslatorName(String key) {
        return map.get(key);
    }

    public ICmpFilterTrans getTranslator(String key) {
        String translatorName = this.getTranslatorName(key);
        if (CmpStrUtil.isEmpty(translatorName)) {
            return null;
        }
        try {
            Class clazz = MsfClassLoaderFactory.forName((String)translatorName);
            return (ICmpFilterTrans)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static synchronized CmpIntelligentTranslatorStore getInstance() {
        if (instance == null) {
            instance = new CmpIntelligentTranslatorStore();
        }
        return instance;
    }
}

