/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record.assemble;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.record.dto.RecordDataInfo;
import com.kingdee.shr.compensation.sql.record.RecordCommonSQL;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RecordUtil {
    public static Map<String, List<String>> getClassifyPBUData(Context ctx, List<String> list, String sqlStr, String colName) throws BOSException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> errorIdList = new ArrayList<String>();
        ArrayList<String> rightIdList = new ArrayList<String>();
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sqlStr.toString());
        try {
            while (rowSet.next()) {
                String PBUId = rowSet.getString(colName);
                errorIdList.add(PBUId);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (errorIdList.size() <= 0) {
            map.put("errorIds", new ArrayList());
            map.put("rightIds", list);
            return map;
        }
        for (String id : list) {
            if (errorIdList.contains(id)) continue;
            rightIdList.add(id);
        }
        map.put("errorIds", errorIdList);
        map.put("rightIds", rightIdList);
        return map;
    }

    public static void updatePBUState(Context ctx, List<String> pbuList, int itemState, int state, boolean isEnable) throws BOSException, EASBizException {
        if (pbuList.size() == 0) {
            return;
        }
        StringBuilder updateSql = new StringBuilder();
        updateSql.append(" update T_HR_PersonBURelation set FItemState = ");
        updateSql.append(itemState);
        updateSql.append(", FState = ");
        updateSql.append(state);
        if (isEnable) {
            updateSql.append(", FbeginDate = NOW() ");
        } else {
            updateSql.append(", FEndDate = NOW() ");
        }
        updateSql.append(" where fid in (").append(CmpStrUtil.convertListToString(pbuList)).append(")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    public static void updateIsDefault(Context ctx, List<String> pbuList, String bizType) throws BOSException, EASBizException {
        String pbuIds = CmpStrUtil.convertListToString(pbuList);
        List<String> sqlList = RecordCommonSQL.getUpdateIsDefaultSql(pbuIds, bizType);
        for (String updateIsDefaultSql : sqlList) {
            CmpSQLUtil.executeUpdate(ctx, updateIsDefaultSql);
        }
    }

    public static void updatePBUState(Context ctx, List<String> pbuList, int state, boolean isEnable) throws BOSException, EASBizException {
        if (null == pbuList || pbuList.size() <= 0) {
            return;
        }
        RecordUtil.updatePBUState(ctx, CmpStrUtil.convertListToString(pbuList), state, isEnable);
    }

    public static void updatePBUState(Context ctx, String pbuIds, int state, boolean isEnable) throws BOSException, EASBizException {
        StringBuilder updateSql = new StringBuilder();
        if (CmpStrUtil.isEmpty(pbuIds)) {
            return;
        }
        if (!pbuIds.contains("'")) {
            pbuIds = "'" + pbuIds + "'";
        }
        updateSql.append(" update T_HR_PersonBURelation set ");
        updateSql.append(" FState = ");
        updateSql.append(state);
        if (isEnable) {
            updateSql.append(", FbeginDate = NOW() ");
        } else {
            updateSql.append(", FEndDate = NOW() ");
        }
        updateSql.append(" where fid in (").append(pbuIds).append(")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    public static RecordDataInfo getRecordDataInfo(IRowSet rowSet) throws BOSException {
        RecordDataInfo recotdDataInfo = new RecordDataInfo();
        try {
            recotdDataInfo.setRecordId(rowSet.getString("recFid"));
            recotdDataInfo.setPersonBURelId(rowSet.getString("FPersonBURelId"));
            recotdDataInfo.setUseDefault(rowSet.getString("useDefault"));
            recotdDataInfo.setPersonId(rowSet.getString("FPersonId"));
            recotdDataInfo.setHrOrgUnitId(rowSet.getString("FHrOrgUnitID"));
            recotdDataInfo.setEmpOrgRelationId(rowSet.getString("FEmpOrgRelationID"));
            recotdDataInfo.setEmpPostExpHisId(rowSet.getString("FEmpPostExpHisID"));
            recotdDataInfo.setEffdt(rowSet.getDate("Feffdt"));
            recotdDataInfo.setOldFEffDate(rowSet.getDate("oldFEffDate"));
            recotdDataInfo.setEnterDate(rowSet.getDate("enterDate"));
            recotdDataInfo.setEmpEffdt(rowSet.getDate("empFEffdt"));
            recotdDataInfo.setEmpFLEffdt(rowSet.getDate("empFLEffdt"));
            recotdDataInfo.setAssignType(rowSet.getString("assignType"));
        }
        catch (SQLException e) {
            throw new BOSException(new Throwable(e.getMessage()));
        }
        return recotdDataInfo;
    }

    public static void updateDefaultBU(Context ctx, List<String> pbuList, String bizType) throws BOSException, EASBizException {
        String pbuIds = CmpStrUtil.convertListToString(pbuList);
        String sql = RecordCommonSQL.getAdminOrgBUDefaultSql(pbuIds, bizType);
        IRowSet rowSet = CmpSQLUtil.executeQuery(ctx, sql);
        ArrayList<String> isDefaultBU = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                String fNewManageHrOrgID;
                String pbufid = rowSet.getString("fid");
                String fHrOrgUnitID = rowSet.getString("FHrOrgUnitID");
                if (!fHrOrgUnitID.equals(fNewManageHrOrgID = rowSet.getString("FManageHrOrgID"))) continue;
                isDefaultBU.add(pbufid);
            }
            if (isDefaultBU.size() > 0) {
                String updateSql = " update T_HR_PersonBURelation set FUseDefault = 1 where fid in (" + CmpStrUtil.convertListToString(isDefaultBU) + ") ";
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

