/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.budget.BudgetSchemeTableRelFactory;
import com.kingdee.shr.compensation.app.budget.BudgetSnapshotCollection;
import com.kingdee.shr.compensation.app.budget.BudgetSnapshotFactory;
import com.kingdee.shr.compensation.app.budget.BudgetSnapshotInfo;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemCollection;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemInfo;
import com.kingdee.shr.compensation.app.budget.CmpUsedAmountCollection;
import com.kingdee.shr.compensation.app.budget.CmpUsedAmountFacadeFactory;
import com.kingdee.shr.compensation.app.budget.CmpUsedAmountFactory;
import com.kingdee.shr.compensation.app.budget.CmpUsedAmountInfo;
import com.kingdee.shr.compensation.app.budget.DataStateEnum;
import com.kingdee.shr.compensation.app.budget.IBudgetSnapshot;
import com.kingdee.shr.compensation.app.budget.MiaBudgetDataUpgradeFacadeFactory;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigCollection;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigFactory;
import com.kingdee.shr.compensation.app.budget.StandingBookItemCollection;
import com.kingdee.shr.compensation.app.budget.StandingBookItemFactory;
import com.kingdee.shr.compensation.app.budget.StandingBookItemInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeCollection;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.compensation.helper.CmpConstants;
import com.kingdee.shr.compensation.service.budget.ExpenseDetailsVO;
import com.kingdee.shr.compensation.service.budget.SubmitBillExpenseDetailsVO;
import com.kingdee.shr.compensation.service.budget.impl.SubmitBillDeductionService;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class BudgetTableService {
    private static final Logger LOG = Logger.getLogger(BudgetTableService.class);
    private static final String FIX_DATA_KEY = "budget.stand.book";
    private static final String FIX_DATA_VALUE = "fixData";
    private static Map<String, String> standingBook2BudgetManage = new HashMap<String, String>();
    private static Map<String, String> subStandingBook2SubBudgetQuery = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fixData(Context ctx) throws BOSException {
        boolean flag = CmpDistributedLockUtils.tryLock(ctx, FIX_DATA_KEY, FIX_DATA_VALUE);
        if (!flag) {
            return;
        }
        try {
            BudgetTableService.fixBudgetStandingBookItemRelation(ctx);
            BudgetTableService.fixPeriodUsedAmount(ctx);
            String sql = "select 1 from KSQL_UserColumns where KSQL_COL_NAME ='T1' and KSQL_COL_TabName='T_HR_SBudgetManage'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() > 0) {
                return;
            }
            CmpBudgetItemCollection budgetItems = CmpBudgetItemFactory.getLocalInstance((Context)ctx).getCmpBudgetItemCollection("order by fieldSn");
            ArrayList<String> sqlList = new ArrayList<String>();
            for (int i = 0; i < budgetItems.size(); ++i) {
                CmpBudgetItemInfo item = budgetItems.get(i);
                sqlList.addAll(BudgetTableService.getAddItemColumnSql("T", item.getFieldSn(), item.getDataLength(), item.getDataType().getValue(), CmpConstants.BUDGET_TABLES));
            }
            StandingBookItemCollection bookItems = StandingBookItemFactory.getLocalInstance((Context)ctx).getStandingBookItemCollection("order by fieldSn");
            for (int i = 0; i < bookItems.size(); ++i) {
                StandingBookItemInfo item = bookItems.get(i);
                sqlList.addAll(BudgetTableService.getAddItemColumnSql("S", item.getFieldSn(), item.getDataLength(), item.getDataType().getValue(), CmpConstants.STANDING_BOOK_TABLES));
            }
            CmpSQLUtil.executeBatchSql(ctx, sqlList.toArray());
            try {
                MiaBudgetDataUpgradeFacadeFactory.getLocalInstance((Context)ctx).upgrade();
            }
            catch (BOSException | EASBizException e) {
                e.printStackTrace();
            }
            BudgetSchemeTableRelFactory.getLocalInstance((Context)ctx).transferData();
            BudgetTableService.createExpenseDetailsFromSnapshots(ctx);
        }
        finally {
            CmpDistributedLockUtils.unlock(ctx, FIX_DATA_KEY, FIX_DATA_VALUE);
        }
    }

    private static void fixPeriodUsedAmount(Context ctx) {
        try {
            String countSQL = "select top 1 1 from T_HR_SCmpPeriodUsedAmount";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)countSQL);
            boolean flag = true;
            while (rs.next()) {
                flag = false;
            }
            if (!flag) {
                return;
            }
            String oql = "select *, template.templateType, cmpBudgetItem.fieldSn where template.budgetPeriod != 0";
            CmpUsedAmountCollection usedAmountCollection = CmpUsedAmountFactory.getLocalInstance((Context)ctx).getCmpUsedAmountCollection(oql);
            if (usedAmountCollection.isEmpty()) {
                return;
            }
            for (int i = 0; i < usedAmountCollection.size(); ++i) {
                CmpUsedAmountInfo usedAmountInfo = usedAmountCollection.get(i);
                CmpUsedAmountFacadeFactory.getLocalInstance((Context)ctx).genPeriodUsedAmount(usedAmountInfo);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"fixPeriodUsedAmount error: ", (Throwable)e);
        }
    }

    private static void fixBudgetStandingBookItemRelation(Context ctx) {
        try {
            String schemeDeduConfigOql = "select templateStbItem.id, cmpBudgetItem.id";
            SchemeDeduConfigCollection relations = SchemeDeduConfigFactory.getLocalInstance((Context)ctx).getSchemeDeduConfigCollection(schemeDeduConfigOql);
            if (!relations.isEmpty()) {
                ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
                for (int i = 0; i < relations.size(); ++i) {
                    Object[] param = new Object[2];
                    if (relations.get(i).getCmpBudgetItem() == null || relations.get(i).getTemplateStbItem() == null) continue;
                    param[0] = relations.get(i).getCmpBudgetItem().getId().toString();
                    param[1] = relations.get(i).getTemplateStbItem().getId().toString();
                    updateParams.add(param);
                }
                String updateSQL = "update T_HR_SBudgetTemplateSTBItem set FCmpBudgetItemId = ? where fid = ? and FCmpBudgetItemId is null";
                DbUtil.executeBatch((Context)ctx, (String)updateSQL, updateParams);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"fixBudgetStandingBookItemRelation error: ", (Throwable)e);
        }
    }

    private static void createExpenseDetailsFromSnapshots(Context ctx) {
        String countSQL = "select top 1 1 from T_HR_SExpenseDetailsSubmitBill";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)countSQL);
            boolean flag = true;
            while (rs.next()) {
                flag = false;
            }
            if (!flag) {
                return;
            }
            String submitSchemeOql = "select id where budgetTemplate.id != null";
            CalSubmitSchemeCollection collection = CalSubmitSchemeFactory.getLocalInstance((Context)ctx).getCalSubmitSchemeCollection(submitSchemeOql);
            if (collection.isEmpty()) {
                return;
            }
            BudgetTableService.initRelationMap(ctx);
            IBudgetSnapshot budgetSnapshot = BudgetSnapshotFactory.getLocalInstance((Context)ctx);
            ArrayList<ExpenseDetailsVO> expenseList = new ArrayList<ExpenseDetailsVO>();
            for (int i = 0; i < collection.size(); ++i) {
                CalSubmitSchemeInfo submitScheme = collection.get(i);
                String snapshotOql = "select calSubmitItem.id, dataState, cmpBudgetItem.id, bookTableId, subBookTableId, bill.id, billEntry.id, billEntry.cmpEmpORelation.id, createTime, updateNode, standingBookItem.fieldSn, rate, budgetYear, value, currency.id, costBearOrg.id, costType.id, person.id, budgetScheme.id, budgetTemplate.id, budgetCurrency.id where scheme = '" + submitScheme.getId().toString() + "' and dataState != " + 30 + " order by createTime desc, updateNode desc";
                BudgetSnapshotCollection snapshotCollection = budgetSnapshot.getBudgetSnapshotCollection(snapshotOql);
                if (snapshotCollection.isEmpty()) continue;
                Map<String, List<BudgetSnapshotInfo>> groups = BudgetTableService.groupBySubmitEntry(snapshotCollection);
                for (Map.Entry<String, List<BudgetSnapshotInfo>> billEntry : groups.entrySet()) {
                    ArrayList<ExpenseDetailsVO> entryExpenseList = new ArrayList<ExpenseDetailsVO>();
                    List<BudgetSnapshotInfo> snapshots = billEntry.getValue();
                    Map<String, List<BudgetSnapshotInfo>> map = snapshots.stream().collect(Collectors.groupingBy(e -> e.getCalSubmitItem().getId().toString()));
                    for (Map.Entry<String, List<BudgetSnapshotInfo>> cmpBudgetItemEntry : map.entrySet()) {
                        List<BudgetSnapshotInfo> singleBudgetItemSnapshots = cmpBudgetItemEntry.getValue();
                        List<BudgetSnapshotInfo> newestDeductionSnapshot = BudgetTableService.filterNewestDeductionSnapshot(singleBudgetItemSnapshots);
                        if (null == newestDeductionSnapshot) continue;
                        List<ExpenseDetailsVO> list = BudgetTableService.initExpenseDetailsBySnapshot(newestDeductionSnapshot);
                        BudgetTableService.mergeExpenseList(entryExpenseList, list);
                    }
                    expenseList.addAll(entryExpenseList);
                }
            }
            if (!expenseList.isEmpty()) {
                SubmitBillDeductionService deductionService = new SubmitBillDeductionService();
                deductionService.setCtx(ctx);
                deductionService.setExpenseList(expenseList);
                UserInfo user = new UserInfo();
                String currentUserId = HRFilterUtils.getCurrentUserId((Context)ctx);
                user.setId(BOSUuid.read((String)currentUserId));
                deductionService.setUser(user);
                deductionService.batchInsertExpenseDetails();
            }
        }
        catch (Exception e2) {
            LOG.error((Object)"createExpenseDetailsFromSnapshots error: ", (Throwable)e2);
        }
    }

    private static void mergeExpenseList(List<ExpenseDetailsVO> expenseList, List<ExpenseDetailsVO> list) {
        list.forEach(e -> {
            SubmitBillExpenseDetailsVO vo = (SubmitBillExpenseDetailsVO)e;
            Optional<ExpenseDetailsVO> optional = expenseList.stream().filter(ele -> {
                SubmitBillExpenseDetailsVO expense = (SubmitBillExpenseDetailsVO)ele;
                boolean flag = vo.getStandingBookId().equals(expense.getStandingBookId());
                if (!StringUtils.isEmpty((String)vo.getSubStandingBookId())) {
                    flag = flag && vo.getSubStandingBookId().equals(expense.getSubStandingBookId());
                }
                return flag;
            }).findAny();
            if (optional.isPresent()) {
                ExpenseDetailsVO expenseDetailsVO = optional.get();
                for (Map.Entry<String, BigDecimal> entry : vo.getExpenseMap().entrySet()) {
                    String expenseCol = entry.getKey();
                    BigDecimal expenseVal = entry.getValue();
                    if (expenseDetailsVO.getExpenseMap().containsKey(expenseCol)) {
                        BigDecimal expense = expenseDetailsVO.getExpenseMap().get(expenseCol);
                        expenseDetailsVO.getExpenseMap().put(expenseCol, expenseVal.add(expense));
                        continue;
                    }
                    expenseDetailsVO.getExpenseMap().put(expenseCol, expenseVal);
                }
            } else {
                expenseList.add(vo);
            }
        });
    }

    private static void initRelationMap(Context ctx) {
        String sql = "SELECT csb.fid standingBookId, bm.fid budgetManageId, scb.fid subStandingBookId, scb.FSubBudgetQueryID FROM T_HR_SCmpStandingBook csb inner join T_HR_SBudgetManage bm on csb.FBudgetManageID = bm.fid left join T_HR_SubCmpStandingBook scb on csb.fid = scb.FCmpStandingBookID";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String standingBookId = rs.getString("standingBookId");
                String budgetManageId = rs.getString("budgetManageId");
                standingBook2BudgetManage.put(standingBookId, budgetManageId);
                String subStandingBookId = rs.getString("subStandingBookId");
                String subBudgetQueryId = rs.getString("FSubBudgetQueryID");
                if (StringUtils.isEmpty((String)subStandingBookId)) continue;
                subStandingBook2SubBudgetQuery.put(subStandingBookId, subBudgetQueryId);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"initRelationMap error: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static List<ExpenseDetailsVO> initExpenseDetailsBySnapshot(List<BudgetSnapshotInfo> newestDeductionSnapshot) {
        ArrayList<ExpenseDetailsVO> list = new ArrayList<ExpenseDetailsVO>();
        for (BudgetSnapshotInfo snapshotInfo : newestDeductionSnapshot) {
            int fieldSn;
            SubmitBillExpenseDetailsVO vo = new SubmitBillExpenseDetailsVO();
            vo.setEntryId(snapshotInfo.getBillEntry().getId().toString());
            vo.setSubmitBillCurrencyId(snapshotInfo.getCurrency().getId().toString());
            vo.setBillId(snapshotInfo.getBill().getId().toString());
            vo.setSubmitBillCurrencyId(snapshotInfo.getCurrency().getId().toString());
            vo.setRate(snapshotInfo.getRate());
            String standingBookId = snapshotInfo.getBookTableId();
            vo.setStandingBookId(standingBookId);
            String budgetManageId = standingBook2BudgetManage.get(standingBookId);
            vo.setBudgetManageId(budgetManageId);
            vo.setBudgetYear(snapshotInfo.getBudgetYear());
            vo.setBudgetSchemeId(snapshotInfo.getBudgetScheme().getId().toString());
            vo.setCostTypeId(snapshotInfo.getCostType().getId().toString());
            vo.setBudgetTemplateId(snapshotInfo.getBudgetTemplate().getId().toString());
            vo.setCurrencyId(snapshotInfo.getBudgetCurrency().getId().toString());
            vo.setCostBearOrgId(snapshotInfo.getCostBearOrg().getId().toString());
            vo.setCmpEmpORelationId(snapshotInfo.getBillEntry().getCmpEmpORelation().getId().toString());
            vo.setPersonId(snapshotInfo.getPerson().getId().toString());
            String subStandingBookId = snapshotInfo.getSubBookTableId();
            if (!StringUtils.isEmpty((String)subStandingBookId)) {
                vo.setSubStandingBookId(subStandingBookId);
                vo.setSubBudgetQueryId(subStandingBook2SubBudgetQuery.get(subStandingBookId));
            }
            if ((fieldSn = snapshotInfo.getStandingBookItem().getFieldSn()) == 0) continue;
            String expenseCol = "S" + fieldSn;
            vo.getExpenseMap().put(expenseCol, snapshotInfo.getValue());
            list.add(vo);
        }
        return list;
    }

    public static List<BudgetSnapshotInfo> filterNewestDeductionSnapshot(List<BudgetSnapshotInfo> singleBudgetItemSnapshots) {
        if (singleBudgetItemSnapshots.isEmpty()) {
            return null;
        }
        BudgetSnapshotInfo first = singleBudgetItemSnapshots.get(0);
        List<BudgetSnapshotInfo> firstBatch = BudgetTableService.filterPeriodBudgetSnapshotList(first, singleBudgetItemSnapshots);
        if (first.getDataState() == DataStateEnum.DEDUCT) {
            return firstBatch;
        }
        BudgetSnapshotInfo second = singleBudgetItemSnapshots.get(firstBatch.size());
        List<BudgetSnapshotInfo> secondBatch = BudgetTableService.filterPeriodBudgetSnapshotList(second, singleBudgetItemSnapshots);
        singleBudgetItemSnapshots.removeAll(firstBatch);
        singleBudgetItemSnapshots.removeAll(secondBatch);
        return BudgetTableService.filterNewestDeductionSnapshot(singleBudgetItemSnapshots);
    }

    private static List<BudgetSnapshotInfo> filterPeriodBudgetSnapshotList(BudgetSnapshotInfo first, List<BudgetSnapshotInfo> singleBudgetItemSnapshots) {
        return singleBudgetItemSnapshots.stream().filter(e -> e.getDataState() == first.getDataState() && e.getCreateTime().compareTo(first.getCreateTime()) == 0 && first.getUpdateNode() == e.getUpdateNode()).collect(Collectors.toList());
    }

    private static Map<String, List<BudgetSnapshotInfo>> groupBySubmitEntry(BudgetSnapshotCollection snapshotCollection) {
        HashMap<String, List<BudgetSnapshotInfo>> groups = new HashMap<String, List<BudgetSnapshotInfo>>();
        for (int i = 0; i < snapshotCollection.size(); ++i) {
            BudgetSnapshotInfo info = snapshotCollection.get(i);
            String submitEntry = info.getBillEntry().getId().toString();
            List list = groups.computeIfAbsent(submitEntry, k -> new ArrayList());
            list.add(info);
        }
        return groups;
    }

    public static List<String> getAddItemColumnSql(String prefix, int fieldSn, int dataLength, int dataType, List<String> tableList) {
        String field = prefix + fieldSn;
        ArrayList<String> sqlList = new ArrayList<String>();
        for (String table : tableList) {
            StringBuilder sql = new StringBuilder();
            sql.append("if not exists (select * from KSQL_UserColumns where KSQL_COL_NAME ='").append(field).append("' and KSQL_COL_TabName='").append(table).append("') ").append("alter table ").append(table);
            sql.append(" add ").append(field);
            if (dataType == 0) {
                sql.append(" numeric(20, 10)");
            } else {
                sql.append(" nvarchar(").append(dataLength).append(")");
            }
            sqlList.add(sql.toString());
            if (!table.equalsIgnoreCase("T_HR_SBudgetAdjustEntry")) continue;
            sql = new StringBuilder();
            field = "M" + fieldSn;
            sql.append("if not exists (select * from KSQL_UserColumns where KSQL_COL_NAME ='").append(field).append("' and KSQL_COL_TabName='").append(table).append("') ").append("alter table ").append(table);
            sql.append(" add ").append(field);
            if (dataType == 0) {
                sql.append(" numeric(20, 10)");
            } else {
                sql.append(" nvarchar(").append(dataLength).append(")");
            }
            sqlList.add(sql.toString());
        }
        return sqlList;
    }
}

