/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.budget.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemInfo;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigCollection;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigFactory;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigInfo;
import com.kingdee.shr.compensation.service.budget.BudgetColumn;
import com.kingdee.shr.compensation.service.budget.StandBookColumn;
import com.kingdee.shr.compensation.service.budget.impl.AbstractUsedAmountDeductionService;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Locale;

public class SubmitBillRefreshBalanceService
extends AbstractUsedAmountDeductionService {
    @Override
    protected void dealWithError(String period, BigDecimal budget, BigDecimal totalUsed) throws EASBizException {
        String messageTemplate = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label26", (Locale)this.ctx.getLocale());
        String formatMsg = MessageFormat.format(messageTemplate, period, budget, totalUsed);
        throw new EASBizException(new NumericExceptionSubItem("022", formatMsg));
    }

    @Override
    public BudgetColumn getBudgetColumnByDeductionConfig(CmpBudgetItemInfo cmpBudgetItemInfo) throws BOSException {
        String oql = "select calSubmitScheme.id, calSubmitItem.id, cmpBudgetItem.fieldSn, templateStbItem.standingBookItem.fieldSn, templateStbItem.balanceLedgerItem.fieldSn, deduNode where calSubmitScheme.budgetTemplate = '" + this.budgetTemplateId + "' and cmpBudgetItem.id ='" + cmpBudgetItemInfo.getId().toString() + "' order by calSubmitScheme.id, calSubmitItem.id, deduNode";
        SchemeDeduConfigCollection collection = SchemeDeduConfigFactory.getLocalInstance((Context)this.ctx).getSchemeDeduConfigCollection(oql);
        if (collection.isEmpty()) {
            return null;
        }
        BudgetColumn budgetColumn = new BudgetColumn();
        String firstSubmitScheme = collection.get(0).getCalSubmitScheme().getId().toString();
        String firstCalSubmitItem = collection.get(0).getCalSubmitItem().getId().toString();
        budgetColumn.setBudget("T" + collection.get(0).getCmpBudgetItem().getFieldSn());
        for (int i = 0; i < collection.size(); ++i) {
            SchemeDeduConfigInfo deduConfig = collection.get(i);
            String submitSchemeId = deduConfig.getCalSubmitScheme().getId().toString();
            String submitItemId = deduConfig.getCalSubmitItem().getId().toString();
            if (!submitSchemeId.equals(firstSubmitScheme) || !submitItemId.equals(firstCalSubmitItem)) continue;
            StandBookColumn standBookColumn = new StandBookColumn();
            standBookColumn.setExpense("S" + deduConfig.getTemplateStbItem().getStandingBookItem().getFieldSn());
            standBookColumn.setBalance("S" + deduConfig.getTemplateStbItem().getBalanceLedgerItem().getFieldSn());
            budgetColumn.getStandBookColumnList().add(standBookColumn);
        }
        return budgetColumn;
    }
}

