/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.timepiece;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.service.timepiece.CacheMrData;
import com.kingdee.shr.compensation.service.timepiece.DataTableCa;
import com.kingdee.shr.compensation.service.timepiece.MRDataInfo;
import com.kingdee.shr.compensation.service.timepiece.MRRowData;
import com.kingdee.shr.compensation.service.timepiece.MatchField;
import com.kingdee.shr.compensation.service.timepiece.MrCell;
import com.kingdee.shr.compensation.service.timepiece.ReturnField;
import com.kingdee.shr.validaterule.formula.SalaryCalFunction2;
import com.kingdee.shr.validaterule.util.DateUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CalFunGetDataStagTableService
extends SalaryCalFunction2 {
    private static Logger logger = Logger.getLogger(CalFunGetDataStagTableService.class);
    private String startPointStr = "";
    private String endPointStr = "";

    public String getDataStagTableData(Context ctx, String mainTableName, Map<String, Object> paramMap, HashMap<String, Object> tempMap, String tableNumber, String resName) {
        CacheMrData cacheMrData;
        String tempMapKey = "CalFunGetDataStagTableService_DataStagTableData_" + tableNumber;
        if (!tempMap.containsKey(tempMapKey)) {
            this.startPointStr = EASResource.getString((String)"com.kingdee.shr.validaterule.resource.BaseStrResource", (String)"startPoint", (Locale)ctx.getLocale());
            this.endPointStr = EASResource.getString((String)"com.kingdee.shr.validaterule.resource.BaseStrResource", (String)"endPoint", (Locale)ctx.getLocale());
            cacheMrData = this.initMRData(ctx, tableNumber, mainTableName);
            tempMap.put(tempMapKey, cacheMrData);
            logger.info((Object)("com.kingdee.shr.compensation.service.timepiece.CalFunGetDataStagTableService:  " + cacheMrData));
        } else {
            cacheMrData = (CacheMrData)tempMap.get(tempMapKey);
        }
        java.util.Date effectDate = this.getEffectDate(mainTableName, paramMap);
        return this.getDataTableValue(mainTableName, paramMap, cacheMrData, resName, effectDate);
    }

    protected DataTableCa getCategory(String mainTableName) {
        if (mainTableName.startsWith("CT_COM_CmpDyCreate")) {
            return DataTableCa.EXTData;
        }
        if (mainTableName.equalsIgnoreCase("T_HR_TimepieceBillEntry")) {
            return DataTableCa.Timepice;
        }
        if (mainTableName.equalsIgnoreCase("T_HR_SCmpCalTable")) {
            return DataTableCa.CmpCal;
        }
        return DataTableCa.Timepice;
    }

    protected java.util.Date getEffectDate(String mainTableName, Map<String, Object> paramMap) {
        String effectDateKey = "";
        effectDateKey = mainTableName.startsWith("CT_COM_CmpDyCreate") ? mainTableName.toUpperCase(Locale.ENGLISH) + "_EXTDATA_EFFECTDATE" : mainTableName.toUpperCase(Locale.ENGLISH) + "_CMP_SMT002_FEFFECTDATE";
        java.util.Date effectDate = (java.util.Date)paramMap.get(effectDateKey);
        return effectDate;
    }

    protected String getDataTableValue(String mainTableName, Map<String, Object> paramMap, CacheMrData cacheMrData, String resName, java.util.Date effectDate) {
        Map<String, MRDataInfo> data = cacheMrData.getData();
        Map<String, String> fieldMapper = cacheMrData.getFieldMapper();
        if (!fieldMapper.containsKey(resName)) {
            return null;
        }
        Set<Map.Entry<String, MRDataInfo>> entries = data.entrySet();
        Iterator<Map.Entry<String, MRDataInfo>> iterator = entries.iterator();
        boolean isGetMRDataInfo = false;
        while (iterator.hasNext() && !isGetMRDataInfo) {
            Map.Entry<String, MRDataInfo> next = iterator.next();
            if (!this.isDateMatch(next.getKey(), effectDate)) continue;
            isGetMRDataInfo = true;
            MRDataInfo mrDataInfo = next.getValue();
            List<MatchField> matchFields = mrDataInfo.getMatchFields();
            List<MRRowData> mrRowDataList = mrDataInfo.getMrRowDataList();
            for (int i = 0; i < mrRowDataList.size(); ++i) {
                MatchField matchField;
                boolean isMatch = true;
                MRRowData mrRowData = mrRowDataList.get(i);
                for (int j = 0; j < matchFields.size() && (isMatch = this.isDataMatch(mainTableName, paramMap, mrRowData, matchField = matchFields.get(j))); ++j) {
                }
                if (!isMatch) continue;
                String dbName = fieldMapper.get(resName);
                MrCell cell = mrRowData.getCell(dbName);
                Object value = cell.getValue();
                return null == value ? null : value.toString();
            }
        }
        return null;
    }

    protected boolean isDataMatch(String mainTableName, Map<String, Object> paramMap, MRRowData mrRowData, MatchField matchField) {
        boolean isMatch = true;
        int submitItemSN = matchField.getSubmitItemSN();
        String submitItemDbName = mainTableName.toUpperCase(Locale.ENGLISH) + "_S" + submitItemSN;
        int type = matchField.getType();
        int tn = matchField.getTn();
        Object o = paramMap.get(submitItemDbName);
        if (10 == type) {
            String dbName = "t_" + tn;
            MrCell cell = mrRowData.getCell(dbName);
            Object value = cell.getValue();
            if (o == null && value == null) {
                isMatch = true;
            } else if (o == null || value == null) {
                isMatch = false;
            } else if (o instanceof BigDecimal) {
                try {
                    BigDecimal oDecimal = new BigDecimal(value.toString());
                    isMatch = ((BigDecimal)o).compareTo(oDecimal) == 0;
                }
                catch (Exception e) {
                    isMatch = false;
                }
            } else {
                isMatch = o instanceof Timestamp ? DateUtil.getDateStr((java.util.Date)((Timestamp)o)).equals(value) : value.toString().equals(o);
            }
            return isMatch;
        }
        String tl = "tl_" + tn;
        String tr = "tr_" + tn;
        MrCell tlCell = mrRowData.getCell(tl);
        MrCell trCell = mrRowData.getCell(tr);
        BigDecimal tlValue = new BigDecimal(tlCell.getValue().toString());
        BigDecimal trValue = new BigDecimal(trCell.getValue().toString());
        BigDecimal submitItemValue = null == o ? BigDecimal.ZERO : new BigDecimal(o.toString());
        switch (type) {
            case 20: {
                isMatch = tlValue.compareTo(submitItemValue) < 0 && trValue.compareTo(submitItemValue) > 0;
                break;
            }
            case 25: {
                isMatch = tlValue.compareTo(submitItemValue) < 0 && trValue.compareTo(submitItemValue) >= 0;
                break;
            }
            case 30: {
                isMatch = tlValue.compareTo(submitItemValue) <= 0 && trValue.compareTo(submitItemValue) > 0;
                break;
            }
            case 35: {
                isMatch = tlValue.compareTo(submitItemValue) <= 0 && trValue.compareTo(submitItemValue) >= 0;
            }
        }
        return isMatch;
    }

    protected boolean isDateMatch(String dateKey, java.util.Date effectDate) {
        String[] dateArr = dateKey.split("###");
        String effectDateStr = dateArr[0];
        String leffectDateStr = dateArr[1];
        java.util.Date effectDateT = null;
        java.util.Date leffectDateT = null;
        try {
            effectDateT = DateUtil.parseDate((String)effectDateStr);
            leffectDateT = DateUtil.parseDate((String)leffectDateStr);
        }
        catch (ParseException e) {
            logger.error((Object)"parse date error", (Throwable)e);
        }
        return !effectDate.before(effectDateT) && !effectDate.after(leffectDateT);
    }

    protected String queryMatchFieldSql4Timepiece(Context ctx, String tableNumber) {
        String localeString = LocaleUtils.getShortCode((Context)ctx);
        return "SELECT \ndistinct\na.FEFFECTDATE ,a.FLEFFECTDATE ,b.FTYPE ,b.FTN ,c.fname_" + localeString + " itemName,c.FIELDSN  \nFROM T_HR_SDataStagTableHis a\ninner join T_HR_SDSTableMatchFieldHis b on b.FDATATABLEID = a.FID  inner join T_HR_SCalSubmitItem c on b.FieldNum = c.FID  \nwhere a.FNUMBER =?\norder by a.FEFFECTDATE ";
    }

    protected String queryMatchFieldSql4ExtData(Context ctx, String tableNumber, String mainTableName) {
        int tableIndex = Integer.parseInt(mainTableName.replace("CT_COM_CmpDyCreate", ""));
        return "SELECT \ndistinct\na.FEFFECTDATE ,a.FLEFFECTDATE ,b.FTYPE ,b.FTN ,d.fsimplename itemName,d.fdbname FIELDSN  \nFROM T_HR_SDataStagTableHis a \ninner join T_HR_SDSTableMatchFieldHis b on b.FDATATABLEID = a.FID \ninner join T_HR_SCalSubmitItem c on b.FieldNum = c.FID \ninner join T_HR_SExtDataConfigEntry d on c.FID = d.FQUERYFIELDID\ninner join T_HR_SExtDataConfig e on d.FBillId = e.fid\nwhere e.findex = " + tableIndex + " and a.FNUMBER =?\n order by a.FEFFECTDATE ";
    }

    protected CacheMrData initMRData(Context ctx, String tableNumber, String mainTableName) {
        IRowSet rowSet;
        MRDataInfo mrDataInfo;
        String tempDateKey;
        String leffectDateStr;
        String effectDateStr;
        Date leffectDate;
        Date effectDate;
        DataTableCa category = this.getCategory(mainTableName);
        CacheMrData cacheMrData = new CacheMrData();
        LinkedHashMap data = Maps.newLinkedHashMap();
        HashMap fieldMapper = Maps.newHashMap();
        ArrayList queryFieldList = Lists.newArrayList();
        StringBuilder queryDataSql = new StringBuilder();
        queryDataSql.append("select FEFFECTDATE ,FLEFFECTDATE ,FINDEX  ");
        String queryMatchFieldSql = "";
        switch (category) {
            case Timepice: {
                queryMatchFieldSql = this.queryMatchFieldSql4Timepiece(ctx, tableNumber);
                break;
            }
            case EXTData: {
                queryMatchFieldSql = this.queryMatchFieldSql4ExtData(ctx, tableNumber, mainTableName);
                break;
            }
        }
        if (StringUtils.isEmpty((CharSequence)queryMatchFieldSql)) {
            return cacheMrData;
        }
        try {
            IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)queryMatchFieldSql, (Object[])new Object[]{tableNumber});
            String dateKey = "";
            while (rowSet2.next()) {
                effectDate = rowSet2.getDate("FEFFECTDATE");
                leffectDate = rowSet2.getDate("FLEFFECTDATE");
                effectDateStr = DateUtil.getDateStr((java.util.Date)effectDate);
                leffectDateStr = DateUtil.getDateStr((java.util.Date)leffectDate);
                tempDateKey = effectDateStr + "###" + leffectDateStr;
                if (dateKey.equals(tempDateKey) && data.containsKey(dateKey)) {
                    mrDataInfo = (MRDataInfo)data.get(dateKey);
                } else {
                    dateKey = tempDateKey;
                    mrDataInfo = new MRDataInfo();
                }
                mrDataInfo.setDateKey(dateKey);
                String itemName = rowSet2.getString("itemName");
                int type = rowSet2.getInt("FTYPE");
                int tn = rowSet2.getInt("FTN");
                if (10 == type) {
                    String dbName = "t_" + tn;
                    if (!queryFieldList.contains(dbName)) {
                        queryFieldList.add(dbName);
                        queryDataSql.append(",").append(dbName);
                        fieldMapper.put(itemName, dbName);
                    }
                } else {
                    String tl = "tl_" + tn;
                    String tr = "tr_" + tn;
                    if (!queryFieldList.contains(tl)) {
                        queryFieldList.add(tl);
                        queryFieldList.add(tr);
                        queryDataSql.append(",").append(tl);
                        queryDataSql.append(",").append(tr);
                        fieldMapper.put(itemName + this.startPointStr, tl);
                        fieldMapper.put(itemName + this.endPointStr, tr);
                    }
                }
                String submitItemFieldSn = rowSet2.getString("FIELDSN");
                List<MatchField> matchFields = mrDataInfo.getMatchFields();
                MatchField matchField = new MatchField();
                matchField.setName(itemName);
                matchField.setTn(tn);
                matchField.setSubmitItemSN(Integer.parseInt(submitItemFieldSn.startsWith("S") ? submitItemFieldSn.substring(1) : submitItemFieldSn));
                matchField.setType(type);
                matchFields.add(matchField);
                data.put(dateKey, mrDataInfo);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)("query datastagtable matchField failed, table number is " + tableNumber), e);
        }
        String queryReturnFieldSql = "SELECT distinct \na.FEFFECTDATE ,a.FLEFFECTDATE ,b.FRN ,b.FNUMBER  \nFROM T_HR_SDataStagTableHis a\ninner join T_HR_SDSTableResultHis b on b.FDATATABLEID = a.FID  \nwhere a.FNUMBER =?\norder by a.FEFFECTDATE ";
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)queryReturnFieldSql, (Object[])new Object[]{tableNumber});
            while (rowSet.next()) {
                effectDate = rowSet.getDate("FEFFECTDATE");
                leffectDate = rowSet.getDate("FLEFFECTDATE");
                effectDateStr = DateUtil.getDateStr((java.util.Date)effectDate);
                leffectDateStr = DateUtil.getDateStr((java.util.Date)leffectDate);
                tempDateKey = effectDateStr + "###" + leffectDateStr;
                mrDataInfo = (MRDataInfo)data.get(tempDateKey);
                List<ReturnField> returnFields = mrDataInfo.getReturnFields();
                ReturnField returnField = new ReturnField();
                String itemName = rowSet.getString("FNUMBER");
                int rn = rowSet.getInt("FRN");
                String dbName = "r_" + rn;
                returnField.setRn(rn);
                returnField.setName(itemName);
                returnFields.add(returnField);
                if (queryFieldList.contains(dbName)) continue;
                fieldMapper.put(itemName, dbName);
                queryFieldList.add(dbName);
                queryDataSql.append(",").append(dbName);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)("query datastagtable return field failed, table number is " + tableNumber), e);
        }
        queryDataSql.append(" from T_HR_SDataStagTableHis a ");
        queryDataSql.append(" inner join T_HR_SDataStagTableMRHis  b on a.FID =b.fdatatableid ");
        queryDataSql.append(" where fnumber = ?");
        queryDataSql.append(" order by FEFFECTDATE ,FINDEX ");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)queryDataSql.toString(), (Object[])new Object[]{tableNumber});
            while (rowSet.next()) {
                effectDate = rowSet.getDate("FEFFECTDATE");
                leffectDate = rowSet.getDate("FLEFFECTDATE");
                effectDateStr = DateUtil.getDateStr((java.util.Date)effectDate);
                leffectDateStr = DateUtil.getDateStr((java.util.Date)leffectDate);
                tempDateKey = effectDateStr + "###" + leffectDateStr;
                mrDataInfo = (MRDataInfo)data.get(tempDateKey);
                List<MRRowData> mrRowDataList = mrDataInfo.getMrRowDataList();
                int index = rowSet.getInt("FINDEX");
                MRRowData mrRowData = new MRRowData();
                mrRowData.setIndex(index);
                for (int i = 0; i < queryFieldList.size(); ++i) {
                    String field = (String)queryFieldList.get(i);
                    Object object = rowSet.getObject(field);
                    MrCell cell = new MrCell(field, object);
                    mrRowData.addCell(cell);
                }
                mrRowDataList.add(mrRowData);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)("query datastagtable data failed, table number is " + tableNumber), e);
        }
        cacheMrData.setFieldMapper(fieldMapper);
        cacheMrData.setData(data);
        return cacheMrData;
    }
}

