/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.exception.CmpSQLException;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class CmpSQLUtil {
    private static final Logger logger = Logger.getLogger(CmpSQLUtil.class);

    public static boolean isTableExist(Context ctx, String tableName) throws BOSException {
        if (StringUtils.isEmpty((String)tableName)) {
            throw new BOSException("tableName cannot be empty!");
        }
        boolean isExist = false;
        String sql = "select * from KSQL_USERTABLES where KSQL_TABNAME = ?";
        Object[] param = new Object[]{tableName};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            while (rowSet.next()) {
                isExist = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return isExist;
    }

    public static int[] executeBatch(Context ctx, String sql, List<Object[]> paramsList) throws BOSException {
        return DbUtil.executeBatchAndReturn((Context)ctx, (String)sql, paramsList);
    }

    public static int[] executeBatchAndReturn(Context ctx, String sql, List<Object[]> paramsList) throws BOSException {
        PreparedStatement ps;
        Connection conn;
        block12: {
            int[] nArray;
            conn = null;
            ps = null;
            try {
                conn = CmpSQLUtil.getConnection(ctx);
                ps = conn.prepareStatement(sql);
                conn.setAutoCommit(false);
                int k = 1;
                boolean flag = false;
                int[] result = new int[]{};
                int batchSize = 8000;
                for (int i = 0; i < paramsList.size(); ++i) {
                    Object[] params = paramsList.get(i);
                    for (int j = 0; j < params.length; ++j) {
                        if (params[j] != null) {
                            ps.setObject(j + 1, params[j]);
                            continue;
                        }
                        ps.setNull(j + 1, 12);
                    }
                    ps.addBatch();
                    if (i == k * batchSize) {
                        flag = true;
                    }
                    if (i <= k * batchSize || !flag) continue;
                    int[] temp = ps.executeBatch();
                    conn.commit();
                    int[] tempresult = new int[result.length + temp.length];
                    if (result.length > 0) {
                        System.arraycopy(temp, 0, tempresult, result.length, temp.length);
                    }
                    System.arraycopy(temp, 0, tempresult, tempresult.length - temp.length, temp.length);
                    result = tempresult;
                    ++k;
                    flag = false;
                    ps.clearBatch();
                }
                if (flag) break block12;
                int[] temp = ps.executeBatch();
                conn.commit();
                int[] tempresult = new int[result.length + temp.length];
                if (result.length > 0) {
                    System.arraycopy(temp, 0, tempresult, result.length, temp.length);
                }
                System.arraycopy(temp, 0, tempresult, tempresult.length - temp.length, temp.length);
                nArray = result = tempresult;
            }
            catch (SQLException exc) {
                try {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException e) {
                        throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
                    }
                    throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            return nArray;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return new int[0];
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] parameter) throws BOSException {
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])parameter);
    }

    public static Connection getConnection(Context ctx) throws BOSException {
        if (ctx == null) {
            throw new BOSException(new CmpSQLException(CmpSQLException.NOCONTEXT).getMessage());
        }
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static void execute(Context ctx, String sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException((Throwable)exc);
        }
        try {
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException exc) {
            logger.error((Object)("sql 1 sql is:" + exc.getMessage()), (Throwable)exc);
            throw new BOSException("Sql1 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)statement, (Connection)conn);
        }
    }

    public static int executeUpdate(Context ctx, String updateSql) throws BOSException {
        int count = 0;
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException((Throwable)e);
        }
        try {
            statement = conn.createStatement();
            count = statement.executeUpdate(updateSql);
        }
        catch (SQLException e) {
            logger.error((Object)("sql 1 sql is:" + e.getMessage()), (Throwable)e);
            throw new BOSException("Sql1 execute exception : " + updateSql, (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)statement, (Connection)conn);
        }
        return count;
    }

    public static String createInSql(Context ctx, String strs, String tableName, String fieldName) throws BOSException {
        String inSql = "";
        String[] arr = strs.split(",");
        if (arr.length >= 500) {
            String tempTable = SQLHandleUtil.createTempTableName(ctx);
            String creatTable = "select " + fieldName + " tempColumn into " + tempTable + " from " + tableName + " where 1<>1";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            Object[] params = null;
            int size = arr.length;
            for (int i = 0; i < size; ++i) {
                String str = arr[i].trim();
                params = new Object[]{str};
                paramList.add(params);
            }
            DbUtil.execute((Context)ctx, (String)creatTable);
            String insertSql = "insert into " + tempTable + "(tempColumn) values(?)";
            DbUtil.executeBatch((Context)ctx, (String)insertSql, paramList);
            inSql = "select tempColumn from " + tempTable;
        } else {
            inSql = "'" + CmpStrUtil.join(arr, "','", null) + "'";
        }
        return inSql;
    }

    public static String createInSql(Context ctx, String[] ids, String tableName, String fieldName) throws BOSException {
        String inSql = "";
        String[] arr = ids;
        if (arr.length >= 500) {
            String tempTable = SQLHandleUtil.createTempTableName(ctx);
            String creatTable = "select " + fieldName + " tempColumn into " + tempTable + " from " + tableName + " where 1<>1";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            Object[] params = null;
            for (String str : arr) {
                params = new Object[]{str};
                paramList.add(params);
            }
            DbUtil.execute((Context)ctx, (String)creatTable);
            String insertSql = "insert into " + tempTable + "(tempColumn) values(?)";
            DbUtil.executeBatch((Context)ctx, (String)insertSql, paramList);
            inSql = "select tempColumn from " + tempTable;
        } else {
            inSql = "'" + CmpStrUtil.join(arr, "','", null) + "'";
        }
        return inSql;
    }

    public static String createInSqlWithOutBrackets(Context ctx, Collection<String> idColl, String tableName, String fieldName) throws BOSException {
        String createInSql = CmpSQLUtil.createInSql(ctx, idColl, tableName, fieldName);
        return createInSql.replace("(", "").replace(")", "");
    }

    public static String createInSqlWithType(Context ctx, Collection<?> values, String tableName, String fieldName, boolean stringFieldTag) throws BOSException {
        String fieldTag = stringFieldTag ? "'" : "";
        StringBuffer inSqlBuffer = new StringBuffer();
        if (values == null || values.size() == 0) {
            inSqlBuffer.append(" ('') ");
            return inSqlBuffer.toString();
        }
        int size = values.size();
        if (size <= 500) {
            inSqlBuffer.append(" (");
            boolean isFirst = true;
            for (Object id : values) {
                if (isFirst) {
                    inSqlBuffer.append(fieldTag).append(id).append(fieldTag);
                    isFirst = false;
                    continue;
                }
                inSqlBuffer.append(",").append(fieldTag).append(id).append(fieldTag);
            }
            inSqlBuffer.append(") ");
            return inSqlBuffer.toString();
        }
        String tempTable = SQLHandleUtil.createTempTableName(ctx);
        String creatTable = "select " + fieldName + " tempColumn into " + tempTable + " from " + tableName + " where 1<>1";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] params = null;
        for (Object id : values) {
            params = new Object[]{id};
            paramList.add(params);
        }
        DbUtil.execute((Context)ctx, (String)creatTable);
        String insertSql = "insert into " + tempTable + "(tempColumn) values(?)";
        CmpSQLUtil.executeBatchAndReturn(ctx, insertSql, paramList);
        String inSql = " ( select tempColumn from " + tempTable + " )";
        return inSql;
    }

    public static String createInSqlWithType(Context ctx, Collection<?> values, String tableName, String fieldName, boolean stringFieldTag, int transNum) throws BOSException {
        if (transNum == 0) {
            return CmpSQLUtil.createInSqlWithType(ctx, values, tableName, fieldName, stringFieldTag);
        }
        String fieldTag = stringFieldTag ? "'" : "";
        StringBuffer inSqlBuffer = new StringBuffer();
        if (values == null || values.size() == 0) {
            inSqlBuffer.append(" ('') ");
            return inSqlBuffer.toString();
        }
        int size = values.size();
        if (size <= transNum) {
            inSqlBuffer.append(" (");
            boolean isFirst = true;
            for (Object id : values) {
                if (isFirst) {
                    inSqlBuffer.append(fieldTag).append(id).append(fieldTag);
                    isFirst = false;
                    continue;
                }
                inSqlBuffer.append(",").append(fieldTag).append(id).append(fieldTag);
            }
            inSqlBuffer.append(") ");
            return inSqlBuffer.toString();
        }
        String tempTable = SQLHandleUtil.createTempTableName(ctx);
        String creatTable = "select " + fieldName + " tempColumn into " + tempTable + " from " + tableName + " where 1<>1";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] params = null;
        for (Object id : values) {
            params = new Object[]{id};
            paramList.add(params);
        }
        DbUtil.execute((Context)ctx, (String)creatTable);
        String insertSql = "insert into " + tempTable + "(tempColumn) values(?)";
        CmpSQLUtil.executeBatchAndReturn(ctx, insertSql, paramList);
        String inSql = " ( select tempColumn from " + tempTable + " )";
        return inSql;
    }

    public static String createInSql(Context ctx, Collection<String> idColl, String tableName, String fieldName) throws BOSException {
        return CmpSQLUtil.createInSqlWithType(ctx, idColl, tableName, fieldName, true);
    }

    public static String createInSql(Context ctx, Collection<String> idColl, String tableName, String fieldName, int transNum) throws BOSException {
        return CmpSQLUtil.createInSqlWithType(ctx, idColl, tableName, fieldName, true, transNum);
    }

    public static int executeBatchSql(Context ctx, Object[] sqlLists) {
        long stime = System.currentTimeMillis();
        if (sqlLists == null || sqlLists.length == 0) {
            return 0;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        int executeUpdate = 0;
        int i = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            conn.setAutoCommit(false);
            for (i = 0; i < sqlLists.length; ++i) {
                executeUpdate += stmt.executeUpdate(sqlLists[i].toString());
            }
            conn.commit();
            int n = executeUpdate;
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("errorSQL sqlLists[" + i + "]:" + e.getMessage()), (Throwable)e);
            try {
                if (null != conn) {
                    conn.rollback();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException(e);
        }
        finally {
            CmpSQLUtil.closeAllDBSource(conn, stmt, rs);
        }
    }

    public static void closeAllDBSource(Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static void executeBatchNoAutoCommit(Context ctx, String sql, List<Object[]> paramsList) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = CmpSQLUtil.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            conn.setAutoCommit(false);
            Object[] params = null;
            int batchSize = 8000;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, 0);
                }
                ps.addBatch();
                if (i % batchSize != 0) continue;
                ps.executeBatch();
                conn.commit();
                ps.clearBatch();
            }
            ps.executeBatch();
            conn.commit();
        }
        catch (SQLException exc) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException e) {
                    throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
                }
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static String generateSqlDateFilter(String beginproperty, String endproperty, String dateStr) {
        String[] beginDateArr = dateStr.split("-");
        String[] endDateArr = dateStr.split("-");
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(beginDateArr[0]), Integer.parseInt(beginDateArr[1]) - 1, 1, 0, 0, 0);
        Date beginDate = calendar.getTime();
        calendar.set(Integer.parseInt(endDateArr[0]), Integer.parseInt(endDateArr[1]) - 1, 1, 23, 59, 59);
        calendar.set(5, calendar.getActualMaximum(5));
        Date endDate = calendar.getTime();
        String beginDateStr = CmpDateUtil.toKSqlDate(beginDate);
        String endDateStr = CmpDateUtil.toKSqlDate(endDate);
        return beginproperty + ">=" + beginDateStr + " and " + endproperty + "<=" + endDateStr;
    }

    public static void releaseTemptTable(Context ctx, String temptTableName) {
        if (temptTableName != null && !"".equals(temptTableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(temptTableName);
        }
    }

    public static void cloneTableStruct(Context ctx, String newTableName, String cloneTableName) throws BOSException {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select * into ").append(newTableName).append(" FROM ").append(cloneTableName).append(" where 1<>1 ");
        DbUtil.execute((Context)ctx, (String)sqlBuilder.toString());
    }

    public static void createSimpleIndex(Context ctx, String indexName, String tableName, String columnName) throws BOSException {
        if (StringUtils.isEmpty((String)indexName) || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)columnName)) {
            throw new BOSException("indexName\u3001tableName\u3001columnName can not be null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" if not exists ( select 1 from KSQL_INDEXES where KSQL_INDNAME = '").append(indexName).append("' )");
        sb.append(" create index ").append(indexName).append(" on ").append(tableName).append(" (").append(columnName).append(") ");
        String createIndexSql = sb.toString();
        DbUtil.execute((Context)ctx, (String)createIndexSql);
    }
}

