/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.integrate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.compensation.app.integrate.SchemeBizKeyDefineCollection;
import com.kingdee.shr.compensation.app.integrate.SchemeBizKeyDefineFactory;
import com.kingdee.shr.compensation.app.integrate.SchemeBizKeyDefineInfo;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.db.CmpTempTable;
import com.kingdee.shr.compensation.util.db.CmpTempTableFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SubmitBizKeyHelper {
    private static final String JOIN_CHAR = "&&";
    public static final String BIZ_KEY_DEFINE_TABLE_NAME = "T_HR_SchemeBizKeyDefine";

    private SubmitBizKeyHelper() {
    }

    public static SchemeBizKeyDefineCollection getSchemeBizKeyDefineCollectionByBillId(Context ctx, String billId) throws EASBizException, BOSException {
        String oql = "select submitScheme where id = '" + billId + "'";
        BatchSubmitShemeBillInfo info = BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).getBatchSubmitShemeBillInfo(oql);
        return SubmitBizKeyHelper.getSchemeBizKeyDefineCollectionBySchemeId(ctx, info.getSubmitScheme().getId().toString());
    }

    public static SchemeBizKeyDefineCollection getSchemeBizKeyDefineCollectionBySchemeId(Context ctx, String schemeId) throws BOSException {
        String oql = "select isUsePerson,isUseAdminOrg,isUseEmpRelation,submitElement where submitScheme = '%s' and state = %s";
        oql = String.format(oql, schemeId, 1);
        return SchemeBizKeyDefineFactory.getLocalInstance((Context)ctx).getSchemeBizKeyDefineCollection(oql);
    }

    public static SchemeBizKeyDefineInfo getSchemeBizKeyDefineInfoBySchemeNumber(Context ctx, String schemeNumber, String submitEleNumber) throws BOSException, EASBizException {
        String oql = "select isUsePerson,isUseAdminOrg,isUseEmpRelation,submitElement where submitScheme.number = '%s' and state = %s and submitElement.number = '%s'";
        oql = String.format(oql, schemeNumber, 1, submitEleNumber);
        SchemeBizKeyDefineCollection cols = SchemeBizKeyDefineFactory.getLocalInstance((Context)ctx).getSchemeBizKeyDefineCollection(oql);
        return SubmitBizKeyHelper.lookup(cols, (String)null);
    }

    public static String getSchemeBizKey(SchemeBizKeyDefineCollection schemeBizKeyDefineCols, BatchSubmitShemeBillEntryInfo entry) {
        SchemeBizKeyDefineInfo schemeBizKeyDefine = SubmitBizKeyHelper.lookup(schemeBizKeyDefineCols, entry);
        return SubmitBizKeyHelper.getBizKey(entry, schemeBizKeyDefine);
    }

    public static String getSchemeBizKey(SchemeBizKeyDefineCollection schemeBizKeyDefineCols, IRowSet rowSet) throws SQLException {
        SchemeBizKeyDefineInfo schemeBizKeyDefine = SubmitBizKeyHelper.lookup(schemeBizKeyDefineCols, rowSet.getString("FSubmitElementID"));
        return SubmitBizKeyHelper.getBizKey(rowSet, schemeBizKeyDefine);
    }

    public static String getSchemeBizKey(SchemeBizKeyDefineInfo schemeBizKeyDefine, IRowSet rowSet) throws SQLException {
        return SubmitBizKeyHelper.getBizKey(rowSet, schemeBizKeyDefine);
    }

    protected static String getBizKey(BatchSubmitShemeBillEntryInfo entry, SchemeBizKeyDefineInfo schemeBizKeyDefine) {
        StringBuilder keyBuilder = new StringBuilder();
        if (entry.getSubmitElement() != null) {
            keyBuilder.append(entry.getSubmitElement().getId().toString());
            keyBuilder.append(JOIN_CHAR);
        }
        if (schemeBizKeyDefine.isIsUsePerson()) {
            keyBuilder.append(entry.getPerson().getId().toString());
        }
        if (schemeBizKeyDefine.isIsUseAdminOrg()) {
            keyBuilder.append(JOIN_CHAR).append(entry.getAdminOrgUnit().getId().toString());
        }
        if (schemeBizKeyDefine.isIsUseEmpRelation()) {
            keyBuilder.append(JOIN_CHAR).append(entry.getCmpEmpORelation().getId().toString());
        }
        return keyBuilder.toString();
    }

    protected static String getBizKey(IRowSet rowSet, SchemeBizKeyDefineInfo schemeBizKeyDefine) throws SQLException {
        StringBuilder keyBuilder = new StringBuilder();
        String submitElementId = rowSet.getString("FSubmitElementID");
        if (!StringUtils.isEmpty((CharSequence)submitElementId)) {
            keyBuilder.append(submitElementId);
            keyBuilder.append(JOIN_CHAR);
        }
        if (schemeBizKeyDefine.isIsUsePerson()) {
            keyBuilder.append(rowSet.getString("FPersonID"));
        }
        if (schemeBizKeyDefine.isIsUseAdminOrg()) {
            keyBuilder.append(JOIN_CHAR).append(rowSet.getString("FAdminOrgUnitID"));
        }
        if (schemeBizKeyDefine.isIsUseEmpRelation()) {
            keyBuilder.append(JOIN_CHAR).append(rowSet.getString("FCmpEmpORelationID"));
        }
        return keyBuilder.toString();
    }

    public static SchemeBizKeyDefineInfo lookup(SchemeBizKeyDefineCollection schemeBizKeyDefineCols, BatchSubmitShemeBillEntryInfo entry) {
        if (schemeBizKeyDefineCols.isEmpty()) {
            return SubmitBizKeyHelper.getDefaultSchemeBizKeyDefineInfo();
        }
        if (entry.getSubmitElement() == null) {
            return schemeBizKeyDefineCols.get(0);
        }
        return SubmitBizKeyHelper.doLookup(schemeBizKeyDefineCols, entry.getSubmitElement().getId().toString());
    }

    public static SchemeBizKeyDefineInfo lookup(SchemeBizKeyDefineCollection schemeBizKeyDefineCols, String entrySubmitElementId) {
        if (schemeBizKeyDefineCols.isEmpty()) {
            return SubmitBizKeyHelper.getDefaultSchemeBizKeyDefineInfo();
        }
        if (StringUtils.isEmpty((CharSequence)entrySubmitElementId)) {
            return schemeBizKeyDefineCols.get(0);
        }
        return SubmitBizKeyHelper.doLookup(schemeBizKeyDefineCols, entrySubmitElementId);
    }

    protected static SchemeBizKeyDefineInfo doLookup(SchemeBizKeyDefineCollection schemeBizKeyDefineCols, String entrySubmitElementId) {
        for (int i = 0; i < schemeBizKeyDefineCols.size(); ++i) {
            SchemeBizKeyDefineInfo info = schemeBizKeyDefineCols.get(i);
            if (info.getSubmitElement() == null || !entrySubmitElementId.equals(info.getSubmitElement().getId().toString())) continue;
            return info;
        }
        return SubmitBizKeyHelper.getDefaultSchemeBizKeyDefineInfo();
    }

    public static void updateDefaultSchemeBizKeyDefineInfo(Context ctx, CalSubmitSchemeInfo submitScheme) throws EASBizException, BOSException {
        String oql = "select submitElement where submitScheme = '" + submitScheme.getId().toString() + "'";
        SchemeBizKeyDefineCollection cols = SchemeBizKeyDefineFactory.getLocalInstance((Context)ctx).getSchemeBizKeyDefineCollection(oql);
        if (submitScheme.isIscycle() && !submitScheme.isIsEnableSubmitElement() && cols.isEmpty()) {
            SubmitBizKeyHelper.saveDefaultSchemeBizKeyDefine(ctx, submitScheme);
            return;
        }
        String deleteOql = "where submitScheme = '" + submitScheme.getId().toString() + "'";
        if (!cols.isEmpty()) {
            SchemeBizKeyDefineInfo define = cols.get(0);
            if (!submitScheme.isIscycle() || submitScheme.isIsEnableSubmitElement() && define.getSubmitElement() == null) {
                SchemeBizKeyDefineFactory.getLocalInstance((Context)ctx).delete(deleteOql);
                return;
            }
            if (!submitScheme.isIsEnableSubmitElement() && define.getSubmitElement() != null) {
                SchemeBizKeyDefineFactory.getLocalInstance((Context)ctx).delete(deleteOql);
                SubmitBizKeyHelper.saveDefaultSchemeBizKeyDefine(ctx, submitScheme);
            }
        }
    }

    protected static void saveDefaultSchemeBizKeyDefine(Context ctx, CalSubmitSchemeInfo submitScheme) throws EASBizException, BOSException {
        SchemeBizKeyDefineInfo schemeBizKeyDefineInfo = SubmitBizKeyHelper.getDefaultSchemeBizKeyDefineInfo();
        schemeBizKeyDefineInfo.setSubmitScheme(submitScheme);
        schemeBizKeyDefineInfo.setState(StateEnum.ENABLE);
        SchemeBizKeyDefineFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)schemeBizKeyDefineInfo);
    }

    public static void batchDeleteSchemeBizKeyDefineInfo(Context ctx, List<String> submitSchemeds) throws BOSException, EASBizException {
        if (submitSchemeds == null || submitSchemeds.isEmpty()) {
            return;
        }
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String oql = "where submitScheme in " + cmpInSql.createInSqlBaseOnFId(ctx, submitSchemeds);
        SchemeBizKeyDefineFactory.getLocalInstance((Context)ctx).delete(oql);
        cmpInSql.release(ctx);
    }

    protected static SchemeBizKeyDefineInfo getDefaultSchemeBizKeyDefineInfo() {
        SchemeBizKeyDefineInfo schemeBizKeyDefineInfo = new SchemeBizKeyDefineInfo();
        schemeBizKeyDefineInfo.setIsUsePerson(true);
        schemeBizKeyDefineInfo.setIsUseAdminOrg(false);
        schemeBizKeyDefineInfo.setIsUseEmpRelation(false);
        return schemeBizKeyDefineInfo;
    }

    public static Set<String> mapDistinctSubmitElementId(BatchSubmitShemeBillEntryCollection entryCols) {
        HashSet submitElementSet = Sets.newHashSet();
        for (int i = 0; i < entryCols.size(); ++i) {
            BatchSubmitShemeBillEntryInfo entry = entryCols.get(i);
            if (entry.getSubmitElement() == null) continue;
            submitElementSet.add(entry.getSubmitElement().getId().toString());
        }
        return submitElementSet;
    }

    public static List<String> getBizKeyFilterSql(SchemeBizKeyDefineInfo bizKeyDefine) {
        ArrayList existsWhereSqlPartList = Lists.newArrayList();
        if (bizKeyDefine.isIsUsePerson()) {
            existsWhereSqlPartList.add("#source.FPersonId = #target.FPersonId");
        }
        if (bizKeyDefine.isIsUseAdminOrg()) {
            existsWhereSqlPartList.add("#source.FAdminOrgUnitID = #target.FAdminOrgUnitID");
        }
        if (bizKeyDefine.isIsUseEmpRelation()) {
            existsWhereSqlPartList.add("#source.FCmpEmpORelationID = #target.FCmpEmpORelationID");
        }
        return existsWhereSqlPartList;
    }

    public static CmpTempTable insertIntoTempTableForBizKeyInfo(Context ctx, String dynamicEntryTable, BatchSubmitShemeBillEntryCollection entryCols) throws BOSException {
        ArrayList paramList = Lists.newArrayList();
        for (int i = 0; i < entryCols.size(); ++i) {
            BatchSubmitShemeBillEntryInfo entry = entryCols.get(i);
            Object[] param = new Object[]{entry.getPerson().getId().toString(), entry.getAdminOrgUnit().getId().toString(), entry.getCmpEmpORelation().getId().toString(), entry.getSubmitElement() == null ? null : entry.getSubmitElement().getId().toString(), CmpDateUtil.toSqlDate(entry.getEffectDate()), CmpDateUtil.toSqlDate(entry.getLeffectDate() != null ? entry.getLeffectDate() : CmpDateUtil.getMaxEndDate())};
            paramList.add(param);
        }
        ArrayList propList = Lists.newArrayList((Object[])new String[]{"FPersonId", "FAdminOrgUnitID", "FCmpEmpORelationID", "FSubmitElementId", "FEffectDate", "FLeffectDate"});
        CmpTempTable cmptempTable = CmpTempTableFactory.getInstance();
        cmptempTable.insertIntoCopiedTempTable(ctx, dynamicEntryTable, propList, paramList);
        return cmptempTable;
    }

    public static String getExistsWhereSql(Context ctx, CalSubmitSchemeInfo submitScheme, Set<String> submitElementIdSet, List<String> sqlPartList, String entryAlias, String targetAlias) throws BOSException {
        String existsWhereSql;
        SchemeBizKeyDefineCollection bizKeyCols = SubmitBizKeyHelper.getSchemeBizKeyDefineCollectionBySchemeId(ctx, submitScheme.getId().toString());
        if (submitScheme.isIsEnableSubmitElement()) {
            HashMap categotyMap = Maps.newHashMap();
            for (String submitElementId : submitElementIdSet) {
                SchemeBizKeyDefineInfo bizKeyDefine = SubmitBizKeyHelper.lookup(bizKeyCols, submitElementId);
                SchemeBizKeyDefineCategory categoty = new SchemeBizKeyDefineCategory(bizKeyDefine);
                if (categotyMap.containsKey(categoty.getCategoryId())) {
                    ((SchemeBizKeyDefineCategory)categotyMap.get(categoty.getCategoryId())).addSubmitElementIdList(submitElementId);
                    continue;
                }
                categoty.addSubmitElementIdList(submitElementId);
                categotyMap.put(categoty.getCategoryId(), categoty);
            }
            ArrayList submitElementSqlOrPartList = Lists.newArrayList();
            for (String categotyId : categotyMap.keySet()) {
                SchemeBizKeyDefineCategory category = (SchemeBizKeyDefineCategory)categotyMap.get(categotyId);
                List<String> existsWhereSqlAndPartList = SubmitBizKeyHelper.getBizKeyFilterSql(category.getBizKeyDefine());
                existsWhereSqlAndPartList.add("#target.FSubmitElementId in ('" + StringUtils.join(category.getSubmitElementIdList(), (String)"','") + "')");
                submitElementSqlOrPartList.add("(" + StringUtils.join(existsWhereSqlAndPartList, (String)" AND ") + ")");
            }
            sqlPartList.add("(" + StringUtils.join((Iterable)submitElementSqlOrPartList, (String)" OR ") + ")");
            sqlPartList.add("#source.FSubmitElementId = #target.FSubmitElementId");
            existsWhereSql = StringUtils.join(sqlPartList, (String)" AND ");
        } else {
            SchemeBizKeyDefineInfo bizKeyDefine = SubmitBizKeyHelper.lookup(bizKeyCols, (String)null);
            List<String> existsWhereSqlPartList = SubmitBizKeyHelper.getBizKeyFilterSql(bizKeyDefine);
            existsWhereSqlPartList.addAll(sqlPartList);
            existsWhereSql = StringUtils.join(existsWhereSqlPartList, (String)" AND ");
        }
        return existsWhereSql.replace("#source", entryAlias).replace("#target", targetAlias);
    }

    static class SchemeBizKeyDefineCategory {
        private String categoryId;
        private SchemeBizKeyDefineInfo bizKeyDefine;
        private List<String> submitElementIdList;

        SchemeBizKeyDefineCategory(SchemeBizKeyDefineInfo schemeBizKeyDefineInfo) {
            this.bizKeyDefine = schemeBizKeyDefineInfo;
            this.categoryId = String.valueOf(schemeBizKeyDefineInfo.isIsUsePerson()) + String.valueOf(schemeBizKeyDefineInfo.isIsUseAdminOrg()) + String.valueOf(schemeBizKeyDefineInfo.isIsUseEmpRelation());
        }

        public String getCategoryId() {
            return this.categoryId;
        }

        public void setCategoryId(String categoryId) {
            this.categoryId = categoryId;
        }

        public SchemeBizKeyDefineInfo getBizKeyDefine() {
            return this.bizKeyDefine;
        }

        public void setBizKeyDefine(SchemeBizKeyDefineInfo bizKeyDefine) {
            this.bizKeyDefine = bizKeyDefine;
        }

        public List<String> getSubmitElementIdList() {
            return this.submitElementIdList;
        }

        public void addSubmitElementIdList(String submitElementId) {
            if (this.submitElementIdList == null) {
                this.submitElementIdList = Lists.newArrayList();
            }
            this.submitElementIdList.add(submitElementId);
        }
    }
}

