/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.timepiece.dep;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.UIType;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.UIViewTreeInfo;
import com.kingdee.shr.base.syssetting.app.cache.PermItemURLCache;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.timepiece.externaldata.ExtDataEntryMetaDataFactory;
import com.kingdee.shr.compensation.app.timepiece.externaldata.ExtDataMetaDataFactory;
import com.kingdee.shr.compensation.app.timepiece.externaldata.ExtDataMetaDataInfo;
import com.kingdee.shr.compensation.util.timepiece.ExternalConfigUtil;
import com.kingdee.shr.compensation.util.timepiece.dep.DepModel;
import com.kingdee.shr.compensation.util.timepiece.dep.InheritedPropertyWrapper;
import com.kingdee.shr.shrimport.ISHRFileTemplate;
import com.kingdee.shr.shrimport.ImportTempDisplayEnum;
import com.kingdee.shr.shrimport.ImportTemplateMutexType;
import com.kingdee.shr.shrimport.ImportTemplateStateEnum;
import com.kingdee.shr.shrimport.SHRFileTemplateCollection;
import com.kingdee.shr.shrimport.SHRFileTemplateFactory;
import com.kingdee.shr.shrimport.SHRFileTemplateFieldsCollection;
import com.kingdee.shr.shrimport.SHRFileTemplateFieldsInfo;
import com.kingdee.shr.shrimport.SHRFileTemplateInfo;
import com.kingdee.shr.shrimport.SHRImportTypeEnum;
import com.kingdee.shr.validaterule.util.Pair;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractDepWrapper {
    private static Logger logger = Logger.getLogger(AbstractDepWrapper.class);

    protected String getDynamicEntityName(int index) {
        return "CmpDyCreate" + this.format(index);
    }

    protected String format(int index) {
        return String.format("%04d", index);
    }

    protected abstract String getConfigTable();

    public abstract String getDepSchemeId();

    protected String getNewCusUnitName(Context ctx, String configId) throws BOSException, EASBizException {
        return null;
    }

    public Map<String, Object> newCusUnit(Context ctx, String configId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String name = this.getNewCusUnitName(ctx, configId);
            String sql = "select findex from T_HR_SExtDataMetaData where FConfigId = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{configId});
            int index = 0;
            while (rowSet.next()) {
                index = rowSet.getInt("findex");
            }
            boolean exists = true;
            if (index == 0) {
                int maxInd = 62;
                rowSet = DbUtil.executeQuery((Context)ctx, (String)"select max(findex) maxInd from T_HR_SExtDataMetaData");
                while (rowSet.next()) {
                    int tempInd = rowSet.getInt("maxInd") + 1;
                    if (tempInd <= maxInd) continue;
                    maxInd = tempInd;
                }
                index = maxInd;
                exists = false;
                this.updateIndexAfterNewCusUnit(ctx, index, configId);
            }
            if (exists) {
                String cusUnitId = this._getCusUnitId(ctx, configId);
                result.put("cusUnitId", cusUnitId);
            }
            result.put("suffix", this.format(index));
            result.put("name", name);
            result.put("exists", exists);
            result.put("schemeId", this.getDepSchemeId());
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected void updateIndexAfterNewCusUnit(Context ctx, int index, String configId) throws BOSException, EASBizException {
        ExtDataMetaDataInfo dataMetaDataInfo = new ExtDataMetaDataInfo();
        dataMetaDataInfo.setConfigId(configId);
        dataMetaDataInfo.setIndex(index);
        ExtDataMetaDataFactory.getLocalInstance((Context)ctx).addnew(dataMetaDataInfo);
    }

    public void recordMetadataRelation(Context ctx, String configId) throws BOSException, EASBizException {
        CoreBaseCollection baseCollection = this.assembleMetaDataEntryColl(ctx, configId);
        if (!baseCollection.isEmpty()) {
            ExtDataEntryMetaDataFactory.getLocalInstance((Context)ctx).saveBatchData(baseCollection);
        }
    }

    protected CoreBaseCollection assembleMetaDataEntryColl(Context ctx, String configId) throws BOSException, EASBizException {
        return new CoreBaseCollection();
    }

    public Map<String, Object> getCusUnitId(Context ctx, String configId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("cusUnitId", this._getCusUnitId(ctx, configId));
        return result;
    }

    protected String _getCusUnitId(Context ctx, String configId) throws BOSException {
        String cusUnitId = "";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"SELECT findex FROM T_HR_SExtDataMetaData where FConfigId =?", (Object[])new Object[]{configId});
        try {
            int index = 0;
            while (rowSet.next()) {
                index = rowSet.getInt("findex");
            }
            String cusUnitNumber = this.getDynamicEntityName(index);
            rowSet = DbUtil.executeQuery((Context)ctx, (String)"SELECT fid FROM t_ep_customizedunit where fnumber = ?", (Object[])new Object[]{cusUnitNumber});
            while (rowSet.next()) {
                cusUnitId = rowSet.getString("fid");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return cusUnitId;
    }

    public Map<String, Object> getModel(Context ctx, String configId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String localeString = LocaleUtils.getShortCode((Context)ctx);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select findex from T_HR_SExtDataMetaData where FConfigId = ?", (Object[])new Object[]{configId});
        int entityIndex = 0;
        try {
            while (rowSet.next()) {
                entityIndex = rowSet.getInt("findex");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        int fieldIndex = 0;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)"select max(findex) ind from T_HR_SExtDataEntryMetaData where FConfigId = ?", (Object[])new Object[]{configId});
            while (rowSet.next()) {
                fieldIndex = rowSet.getInt("ind");
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
        }
        ArrayList updateDbNameParams = Lists.newArrayList();
        String name = this.getDynamicEntityName(entityIndex);
        String table = "CT_COM_" + name;
        String entityPK = "com.kingdee.shr.compensation.app." + name;
        String query = entityPK + "Query";
        DepModel model = new DepModel();
        model.setEntityPK(entityPK);
        model.setSchemeID(this.getDepSchemeId());
        model.setStart(false);
        model.setName(name);
        model.setAlias(name);
        model.setTable(table);
        model.setDescription("");
        model.setCommonInheritedProperties(ctx);
        model.setCommonExtendedProperties(ctx, query);
        model.addInheritedProperty(InheritedPropertyWrapper.dataSource(ctx));
        model.addInheritedProperty(InheritedPropertyWrapper.calState(ctx));
        model.addInheritedProperty(InheritedPropertyWrapper.getSelfDateProperty("effectDate", ExternalConfigUtil.getResoureString(ctx, "EffectDate")));
        String queryFieldSql = "SELECT  entry.fid entryID,sc.FCLIENTNUMBER ,sc.FENTITYNAME ,sc.FNAME_" + localeString + " scName, entry.FieldType,entry.FIndex,entry.fdbname,entry.FDataType,entry.FSimpleName entryName  FROM  T_HR_SExtDataConfigEntry entry left join T_HR_QueryConfigField qcf on entry.FQUERYFIELDID = qcf.FID  left join T_HR_StructureConfigColumns scc on qcf.FFactFieldID = scc.FID  left join T_HR_StructureConfig sc on scc.FSTRUCTURECONFIGID = sc.FID  where entry.fbillid = ? order by entry.FIndex ";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)queryFieldSql, (Object[])new Object[]{configId});
        try {
            HashMap structureMap = Maps.newHashMap();
            while (rowSet.next()) {
                String dbName = rowSet.getString("fdbname");
                String clientnumber = rowSet.getString("FCLIENTNUMBER");
                if (StringUtils.isEmpty((CharSequence)clientnumber) || StringUtils.isEmpty((CharSequence)dbName)) continue;
                structureMap.put(clientnumber, new Pair((Object)dbName, (Object)false));
            }
            rowSet.beforeFirst();
            while (rowSet.next()) {
                Object[] updateDbNameParam = new Object[2];
                int fieldType = rowSet.getInt("FieldType");
                String entryID = rowSet.getString("entryID");
                String dbName = rowSet.getString("fdbname");
                String clientnumber = rowSet.getString("FCLIENTNUMBER");
                boolean isNeedUpdateDbName = false;
                if (!StringUtils.isEmpty((CharSequence)clientnumber)) {
                    if (StringUtils.isEmpty((CharSequence)dbName)) {
                        dbName = structureMap.containsKey(clientnumber) ? (String)((Pair)structureMap.get(clientnumber)).getFirst() : "CFS" + ++fieldIndex + "ID";
                        isNeedUpdateDbName = true;
                    }
                    if (!structureMap.containsKey(clientnumber) || !((Boolean)((Pair)structureMap.get(clientnumber)).getSecond()).booleanValue()) {
                        String fentityname = rowSet.getString("FENTITYNAME");
                        String scName = rowSet.getString("scName");
                        String clientNumberT = dbName.substring(2, dbName.length() - 2);
                        model.addInheritedProperty(InheritedPropertyWrapper.getBaseDataProperty(clientNumberT, fentityname, scName, dbName));
                        structureMap.put(clientnumber, new Pair((Object)dbName, (Object)true));
                    }
                } else {
                    int dataType = rowSet.getInt("FDataType");
                    if (StringUtils.isEmpty((CharSequence)dbName)) {
                        dbName = "S" + ++fieldIndex;
                        isNeedUpdateDbName = true;
                    }
                    String entryName = rowSet.getString("entryName");
                    if (0 == dataType) {
                        model.addInheritedProperty(InheritedPropertyWrapper.getSelfNumberProperty(dbName, entryName));
                    } else {
                        model.addInheritedProperty(InheritedPropertyWrapper.getSelfStringProperty(dbName, entryName));
                    }
                }
                if (!isNeedUpdateDbName) continue;
                updateDbNameParam[0] = dbName;
                updateDbNameParam[1] = entryID;
                updateDbNameParams.add(updateDbNameParam);
            }
            DbUtil.executeBatch((Context)ctx, (String)"update T_HR_SExtDataConfigEntry set FDbName = ? where fid = ?", (List)updateDbNameParams);
            result.put("model", model);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected boolean isNeedHandleUiView() {
        return false;
    }

    public List<UIViewInfo> generateUiviewAndOTHERData(Context ctx, String configId) throws BOSException, EASBizException {
        ArrayList result = Lists.newArrayList();
        if (!this.isNeedHandleUiView()) {
            return result;
        }
        String sql = "select fname_l1,fname_l2,fname_l3,FEntity,findex,fuipk,FDateDisplayType from T_HR_SExtDataConfig where fid = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{configId});
        UIViewInfo listUiViewInfo = new UIViewInfo();
        UIViewInfo searchUiViewInfo = new UIViewInfo();
        try {
            UIViewTreeInfo treeInfo = new UIViewTreeInfo();
            treeInfo.setId(BOSUuid.read((String)"srjWgCGESDynzh6TxURO6XdTPHE="));
            StringBuilder uiViewContent = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\r\n");
            StringBuilder searchUiViewContent = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\r\n");
            listUiViewInfo.setTree(treeInfo);
            searchUiViewInfo.setTree(treeInfo);
            listUiViewInfo.setInner(false);
            searchUiViewInfo.setInner(false);
            listUiViewInfo.setType(UIType.list);
            searchUiViewInfo.setType(UIType.search);
            String entity = "";
            int dateDisplayType = 0;
            if (rowSet.next()) {
                listUiViewInfo.setName(rowSet.getString("fname_l1"), LocaleUtils.locale_l1);
                listUiViewInfo.setName(rowSet.getString("fname_l2"), LocaleUtils.locale_l2);
                listUiViewInfo.setName(rowSet.getString("fname_l3"), LocaleUtils.locale_l3);
                String searchL1 = EASResource.getString((String)"com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataConfigResource", (String)"search", (Locale)LocaleUtils.locale_l1);
                String searchL2 = EASResource.getString((String)"com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataConfigResource", (String)"search", (Locale)LocaleUtils.locale_l2);
                String searchL3 = EASResource.getString((String)"com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataConfigResource", (String)"search", (Locale)LocaleUtils.locale_l3);
                searchUiViewInfo.setName(rowSet.getString("fname_l1") + "_" + searchL1, LocaleUtils.locale_l1);
                searchUiViewInfo.setName(rowSet.getString("fname_l2") + "_" + searchL2, LocaleUtils.locale_l2);
                searchUiViewInfo.setName(rowSet.getString("fname_l3") + "_" + searchL3, LocaleUtils.locale_l3);
                entity = rowSet.getString("FEntity");
                dateDisplayType = rowSet.getInt("FDateDisplayType");
            }
            listUiViewInfo.setModel(entity);
            searchUiViewInfo.setModel(entity);
            String listUipk = entity + ".list";
            String searchUipk = entity + ".search";
            listUiViewInfo.setUipk(listUipk);
            searchUiViewInfo.setUipk(searchUipk);
            rowSet = DbUtil.executeQuery((Context)ctx, (String)"select fid,fuipk from S_BS_uiview where fuipk in( ?,?)", (Object[])new Object[]{listUipk, searchUipk});
            while (rowSet.next()) {
                String uipk = rowSet.getString("fuipk");
                String fid = rowSet.getString("fid");
                if (listUipk.equals(uipk)) {
                    listUiViewInfo.setId(BOSUuid.read((String)fid));
                    continue;
                }
                if (!searchUipk.equals(uipk)) continue;
                searchUiViewInfo.setId(BOSUuid.read((String)fid));
            }
            String descriptionNa = ExternalConfigUtil.getResoureString(ctx, "description");
            String effectDateNa = ExternalConfigUtil.getResoureString(ctx, "EffectDate");
            searchUiViewContent.append("<search>").append("\r\n");
            searchUiViewContent.append("<quickSearch>").append("\r\n");
            searchUiViewContent.append("<field name=\"description\" label=\"" + descriptionNa + "\"/>").append("\r\n");
            searchUiViewContent.append("</quickSearch>").append("\r\n");
            uiViewContent.append("<main>").append("\r\n");
            uiViewContent.append("<header>").append("\r\n");
            uiViewContent.append("<title value=\"").append(listUiViewInfo.getName()).append("\" />").append("\r\n");
            uiViewContent.append("<toolbar>").append("\r\n");
            uiViewContent.append("<button name=\"addNew\" visible=\"false\" />").append("\r\n");
            String importNa = ExternalConfigUtil.getResoureString(ctx, "import");
            uiViewContent.append("<button name=\"import\" caption=\"" + importNa + "\" />").append("\r\n");
            String deleteNa = ExternalConfigUtil.getResoureString(ctx, "delete");
            uiViewContent.append("<button name=\"delete\" caption=\"" + deleteNa + "\" />").append("\r\n");
            String calNa = ExternalConfigUtil.getResoureString(ctx, "calculate");
            uiViewContent.append("<button name=\"calculate\" caption=\"" + calNa + "\" />").append("\r\n");
            String exportNa = ExternalConfigUtil.getResoureString(ctx, "export");
            uiViewContent.append("<dropDownButton name=\"export\" caption=\"" + exportNa + "\">").append("\r\n");
            String exportCurrentNa = ExternalConfigUtil.getResoureString(ctx, "exportCurrent");
            uiViewContent.append("<button name=\"exportCurrent\" caption=\"" + exportCurrentNa + "\" />").append("\r\n");
            String exportAllNa = ExternalConfigUtil.getResoureString(ctx, "exportAll");
            uiViewContent.append(" <button name=\"exportToExcel\" caption=\"" + exportAllNa + "\" />").append("\r\n");
            uiViewContent.append("</dropDownButton>").append("\r\n");
            uiViewContent.append("</toolbar>").append("\r\n");
            uiViewContent.append("<searchView uipk=\"").append(searchUipk).append("\" />").append("\r\n");
            uiViewContent.append("<handler class=\"").append("com.kingdee.shr.compensation.web.handler.timepiece.externaldata.ExternalDataListHandler").append("\" />").append("\r\n");
            uiViewContent.append("<jsClass name=\"shr.compensation.externalDataSelectedList\" />");
            uiViewContent.append("<script src=\"${appPath}/compensation/web/js/timepiece/externaldata/externalDataSelectedList.js\" />");
            uiViewContent.append("</header>").append("\r\n");
            uiViewContent.append("<body>").append("\r\n");
            uiViewContent.append("<fastFilter>").append("\r\n");
            String dataSourceNa = ExternalConfigUtil.getResoureString(ctx, "dataSource");
            String calStateNa = ExternalConfigUtil.getResoureString(ctx, "calState");
            String yesterdayNa = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"yesterday", (Locale)ctx.getLocale());
            uiViewContent.append("<filterItem name=\"effectDate\" alias=\"" + effectDateNa + "\" widgetType=\"date\" selectValue=\"today\" dateSourceConfig=\"{'dateSelectData':[{'value':'today'},{'value':'serverData','alias':'" + yesterdayNa + "','dataMode':'server','method':'getYesterday'},{'value':'thisWeek'},{'value':'lastWeek'},{'value':'prevWeek'},{'value':'thisMonth'},{'value':'lastMonth'},{'value':'prevMonth'},{'value':'custom'}]}\" />").append("\r\n");
            uiViewContent.append("<filterItem name=\"calState\" alias=\"" + calStateNa + "\" enumSource=\"com.kingdee.shr.compensation.app.integrate.BillEntryCalState\" />").append("\r\n");
            uiViewContent.append("<filterItem name=\"dataSource\" alias=\"" + dataSourceNa + "\" enumSource=\"com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataSource\" />").append("\r\n");
            uiViewContent.append("</fastFilter>").append("\r\n");
            searchUiViewContent.append("<advancedSearch>").append("\r\n");
            uiViewContent.append("<grid name=\"name\" showLink=\"false\" shrinkToFit=\"false\" sorterItems=\"effectDate desc\">\r\n");
            uiViewContent.append("<field name=\"effectDate\" dataType=\"date\" label=\"").append(effectDateNa).append("\"");
            searchUiViewContent.append("<field name=\"effectDate\" dataType=\"date\" label=\"").append(effectDateNa).append("\"");
            if (dateDisplayType == 20) {
                uiViewContent.append(" isRemoveDay=").append("\"true\"");
                searchUiViewContent.append(" isRemoveDay=").append("\"true\"");
            }
            uiViewContent.append(" width=\"150\" />").append("\r\n");
            searchUiViewContent.append(" />").append("\r\n");
            String queryFieldSql = "SELECT  sc.FCLIENTNUMBER , scc.FNUMBER sccNumber,scc.FEnumSource,scc.FDataType SCCDATATYPE, entry.FieldType,entry.FIndex,entry.fdbname,entry.FDataType,entry.FsimpleName entryName,entry.FRequired,entry.FInputType  FROM  T_HR_SExtDataConfigEntry entry left join T_HR_QueryConfigField qcf on entry.FQUERYFIELDID = qcf.FID  left join T_HR_StructureConfigColumns scc on qcf.FFactFieldID = scc.FID  left join T_HR_StructureConfig sc on scc.FSTRUCTURECONFIGID = sc.FID  where entry.fbillid = ? order by entry.FIndex ";
            rowSet = DbUtil.executeQuery((Context)ctx, (String)queryFieldSql, (Object[])new Object[]{configId});
            while (rowSet.next()) {
                String sccDataType;
                String enumSource;
                int fieldType = rowSet.getInt("FieldType");
                String lable = rowSet.getString("entryName");
                String name = rowSet.getString("fdbname");
                String clientnumber = rowSet.getString("FCLIENTNUMBER");
                int fDataType = rowSet.getInt("FDataType");
                if (!StringUtils.isEmpty((CharSequence)clientnumber)) {
                    String sccNumber = rowSet.getString("sccNumber");
                    String clientnumberT = name.substring(2, name.length() - 2);
                    name = clientnumberT + "." + sccNumber;
                }
                uiViewContent.append("<field name=\"").append(name).append("\"");
                searchUiViewContent.append("<field name=\"").append(name).append("\"");
                String dataType = "String";
                if (fDataType == 0) {
                    dataType = "number";
                }
                if (!StringUtils.isEmpty((CharSequence)(enumSource = rowSet.getString("FEnumSource")))) {
                    uiViewContent.append(" enumSource = \"").append(enumSource).append("\"");
                    dataType = "enum";
                }
                if (!StringUtils.isEmpty((CharSequence)(sccDataType = rowSet.getString("SCCDATATYPE")))) {
                    if ("Date".equals(sccDataType)) {
                        dataType = "Date";
                    } else if ("Boolean".equals(sccDataType)) {
                        dataType = "Boolean";
                    }
                }
                uiViewContent.append(" label=\"").append(lable).append("\"");
                uiViewContent.append(" dataType=\"").append(dataType).append("\"");
                uiViewContent.append(" width=\"150\" />").append("\r\n");
                searchUiViewContent.append(" label=\"").append(lable).append("\" />").append("\r\n");
            }
            uiViewContent.append("<field name=\"description\" label=\"" + descriptionNa + "\" width=\"150\" />").append("\r\n");
            uiViewContent.append("<field name=\"calState\" label=\"" + calStateNa + "\" width=\"150\"  dataType=\"enum\" />").append("\r\n");
            uiViewContent.append("<field name=\"dataSource\" label=\"" + dataSourceNa + "\" dataType=\"enum\"  width=\"150\" />").append("\r\n");
            searchUiViewContent.append("<field name=\"description\" label=\"" + descriptionNa + "\" />").append("\r\n");
            searchUiViewContent.append("<field name=\"calState\" label=\"" + calStateNa + "\"  dataType=\"enum\" />").append("\r\n");
            searchUiViewContent.append("<field name=\"dataSource\" label=\"" + dataSourceNa + "\" dataType=\"enum\"  />").append("\r\n");
            uiViewContent.append("<field name=\"id\" label=\"id\" type=\"hidden\"/>").append("\r\n");
            uiViewContent.append("</grid>").append("\r\n");
            uiViewContent.append("</body>").append("\r\n");
            uiViewContent.append("</main>").append("\r\n");
            searchUiViewContent.append("</advancedSearch>").append("\r\n");
            searchUiViewContent.append("</search>").append("\r\n");
            listUiViewInfo.setContent(uiViewContent.toString());
            searchUiViewInfo.setContent(searchUiViewContent.toString());
            DbUtil.execute((Context)ctx, (String)"update T_HR_SExtDataConfig set fuipk = ? where fid = ?", (Object[])new Object[]{listUipk, configId});
            this.savePermItemUrl(ctx, configId, listUipk, listUiViewInfo.getName());
            this.generateImportTemplate(ctx, rowSet, listUiViewInfo);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        result.add(listUiViewInfo);
        result.add(searchUiViewInfo);
        return result;
    }

    protected void generateImportTemplate(Context ctx, IRowSet rowSet, UIViewInfo listUiViewInfo) throws BOSException, EASBizException {
        String listUipk = listUiViewInfo.getUipk();
        String entity = listUiViewInfo.getModel();
        String oql = "select id where bindFun = '" + listUipk + "#import'";
        ISHRFileTemplate iFileTemplate = SHRFileTemplateFactory.getLocalInstance((Context)ctx);
        SHRFileTemplateCollection shrFileTemplateCollection = iFileTemplate.getSHRFileTemplateCollection(oql);
        SHRFileTemplateInfo importTemplate = new SHRFileTemplateInfo();
        if (!shrFileTemplateCollection.isEmpty()) {
            importTemplate.setId(shrFileTemplateCollection.get(0).getId());
        }
        importTemplate.setName(listUiViewInfo.getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
        importTemplate.setName(listUiViewInfo.getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
        importTemplate.setName(listUiViewInfo.getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        importTemplate.setEntityFullName(entity);
        importTemplate.setShowtype(false);
        importTemplate.setUipk(listUipk);
        importTemplate.setBindFun(listUipk + "#import");
        importTemplate.setState(ImportTemplateStateEnum.ENABLE);
        importTemplate.setIsPreset(false);
        importTemplate.setBizImplClass("com.kingdee.shr.compensation.cmpExcelImport.timepiece.externaldata.ExternalDataBaseImportService");
        importTemplate.setMutexType(ImportTemplateMutexType.KEY_FIELD);
        String entityName = entity.substring(entity.lastIndexOf(".") + 1);
        importTemplate.setEntityName(entityName);
        importTemplate.setEntityName(entityName, LocaleUtils.locale_l1);
        importTemplate.setEntityName(entityName, LocaleUtils.locale_l2);
        importTemplate.setEntityName(entityName, LocaleUtils.locale_l3);
        importTemplate.setEntityTable("CT_COM_" + entityName);
        importTemplate.setImportDisplayFormat(ImportTempDisplayEnum.NUMBERANDNAME);
        SHRImportTypeEnum importType = SHRImportTypeEnum.UPDATE_ADD_IMPORT;
        String alias = importType.getAlias();
        String alias_l1 = importType.getAlias(LocaleUtils.locale_L1);
        String alias_l2 = importType.getAlias(LocaleUtils.locale_L2);
        String alias_l3 = importType.getAlias(LocaleUtils.locale_L3);
        StringBuilder importTypes = new StringBuilder();
        importTypes.append("[{\"value\":\"").append(importType.getValue()).append("\",");
        importTypes.append("\"name\":\"").append(importType.getName()).append("\",");
        importTypes.append("\"alias\":\"").append(alias).append("\",");
        importTypes.append("\"aliasMultiLan\":{\"l1\":\"").append(alias_l1).append("\",");
        importTypes.append("\"l2\":\"").append(alias_l2).append("\",");
        importTypes.append("\"l3\":\"").append(alias_l3).append("\"},");
        importTypes.append("\"desc\":\"\",");
        importTypes.append("\"descMultiLan\":{\"l1\":\"\",\"l2\":\"\",\"l3\":\"\"},");
        importTypes.append("\"sortNum\":1,\"using\":true}]");
        importTemplate.setImportTypes(importTypes.toString());
        importTemplate.setSpecification(ExternalConfigUtil.getResoureString(ctx, "extdataimportTemplateDesc"));
        SHRFileTemplateFieldsCollection fieldsCollection = importTemplate.getEntry();
        SHRFileTemplateFieldsInfo effectDateField = new SHRFileTemplateFieldsInfo();
        effectDateField.setIncludeData(false);
        effectDateField.setWidth(8);
        effectDateField.setIsPrimayField(true);
        effectDateField.setCustomField(false);
        effectDateField.setIsEnableFilter(false);
        effectDateField.setSortSn(0);
        effectDateField.setPropName("effectDate");
        effectDateField.setIsNeed(true);
        effectDateField.setName(ExternalConfigUtil.getResoureString(ctx, "EffectDate"));
        fieldsCollection.add(effectDateField);
        int index = 1;
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                int inputType = rowSet.getInt("FInputType");
                if (20 == inputType) continue;
                String lable = rowSet.getString("entryName");
                String clientnumber = rowSet.getString("FCLIENTNUMBER");
                String name = rowSet.getString("fdbname");
                SHRFileTemplateFieldsInfo fieldsInfo = new SHRFileTemplateFieldsInfo();
                fieldsInfo.setIncludeData(false);
                fieldsInfo.setCustomField(false);
                if (!StringUtils.isEmpty((CharSequence)clientnumber)) {
                    String sccNumber = rowSet.getString("sccNumber");
                    String clientnumberT = name.substring(2, name.length() - 2);
                    name = clientnumberT + "." + sccNumber;
                    fieldsInfo.setCustomField(true);
                }
                fieldsInfo.setWidth(8);
                boolean required = rowSet.getBoolean("FRequired");
                fieldsInfo.setIsPrimayField(required);
                fieldsInfo.setIsEnableFilter(false);
                fieldsInfo.setSortSn(index++);
                fieldsInfo.setPropName(name);
                fieldsInfo.setIsNeed(required);
                fieldsInfo.setName(lable.trim());
                fieldsCollection.add(fieldsInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        SHRFileTemplateFieldsInfo descFiled = new SHRFileTemplateFieldsInfo();
        descFiled.setWidth(12);
        descFiled.setIsPrimayField(false);
        descFiled.setCustomField(false);
        descFiled.setIncludeData(false);
        descFiled.setIsEnableFilter(false);
        descFiled.setSortSn(index);
        descFiled.setPropName("description");
        descFiled.setIsNeed(false);
        descFiled.setName(ExternalConfigUtil.getResoureString(ctx, "description"));
        fieldsCollection.add(descFiled);
        IObjectPK pk = iFileTemplate.save((CoreBaseInfo)importTemplate);
    }

    public void deleteViewAndOtherData(Context ctx, String configId) throws BOSException, EASBizException {
        if (!this.isNeedHandleUiView()) {
            return;
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"SELECT findex FROM T_HR_SExtDataMetaData where FConfigId =?", (Object[])new Object[]{configId});
        try {
            int index = 0;
            while (rowSet.next()) {
                index = rowSet.getInt("findex");
            }
            String entityName = this.getDynamicEntityName(index);
            String model = "com.kingdee.shr.compensation.app." + entityName;
            DbUtil.execute((Context)ctx, (String)"delete from S_BS_UIVIEW where fmodel = ?", (Object[])new Object[]{model});
            String permItemUrl = "/dynamic.do?method=initalize#uri=" + model + ".list";
            DbUtil.execute((Context)ctx, (String)"delete from T_PM_PermItemUrl where furl = ?", (Object[])new Object[]{permItemUrl});
            SHRFileTemplateFactory.getLocalInstance((Context)ctx).delete("where entityFullName = '" + model + "'");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void savePermItemUrl(Context ctx, String configId, String listUipk, String name) throws BOSException, EASBizException {
        StringBuilder permItemUrlSql = new StringBuilder();
        String permItemId = this.getDefaultPermItemId(ctx, configId);
        permItemUrlSql.append("if not exists(select * from T_PM_PermItemURL where furl = '/dynamic.do?method=initalize#uri=");
        permItemUrlSql.append(listUipk).append("')");
        permItemUrlSql.append("INSERT INTO T_PM_PermItemURL (furl,FPARENTID ,fname,fid ) VALUES (");
        permItemUrlSql.append("'/dynamic.do?method=initalize#uri=").append(listUipk).append("',");
        permItemUrlSql.append("'" + permItemId + "',");
        permItemUrlSql.append("'").append(name).append("',");
        permItemUrlSql.append("newbosid('8AFAE318'));");
        DbUtil.execute((Context)ctx, (String)permItemUrlSql.toString());
        PermItemInfo parentPerm = PermItemFactory.getLocalInstance((Context)ctx).getPermItemInfo("select *,urls.* where id = '" + permItemId + "'");
        PermItemURLCache.addPermItemToCache((PermItemInfo)parentPerm);
    }

    protected String getDefaultPermItemId(Context ctx, String configId) {
        return null;
    }
}

