/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.agentpay;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillEntryCollection;
import com.kingdee.eas.fi.cas.AgentPayBillEntryInfo;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillEntryCollection;
import com.kingdee.shr.compensation.CmpAgentPayBillEntryFactory;
import com.kingdee.shr.compensation.CmpAgentPayBillEntryInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillFactory;
import com.kingdee.shr.compensation.CmpAgentPayBillInfo;
import com.kingdee.shr.compensation.CmpBillStatusEnum;
import com.kingdee.shr.compensation.ICmpAgentPayBill;
import com.kingdee.shr.compensation.ICmpAgentPayBillEntry;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AgentBillReBack
implements IPaymentDisposer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.agentpay.AgentBillReBack");

    public void dispose(Context context, BillDisposerAction billDisposer) throws BOSException, EASBizException {
        DisposerActionEnum actionType = billDisposer.getActionType();
        AgentPayBillInfo agentPayBillInfo = (AgentPayBillInfo)billDisposer.getDestBill();
        if (null == billDisposer.getDestBill()) {
            return;
        }
        String srcBillId = agentPayBillInfo.getSourceBillId();
        if (StringUtils.isEmpty((String)srcBillId)) {
            return;
        }
        ICmpAgentPayBill cmpAgentPayBill = CmpAgentPayBillFactory.getLocalInstance(context);
        CmpAgentPayBillInfo cmpAgentPayBillInfo = cmpAgentPayBill.getCmpAgentPayBillInfo((IObjectPK)new ObjectUuidPK(srcBillId));
        if (DisposerActionEnum.PAY.equals((Object)actionType)) {
            this.changeCmpAgentPayBillState(context, CmpBillStatusEnum.PAYED, cmpAgentPayBillInfo);
            this.synchCmpAgentPayBillState(context, agentPayBillInfo);
        } else if (DisposerActionEnum.DELETE.equals((Object)actionType)) {
            this.changeCmpAgentPayBillState(context, CmpBillStatusEnum.DELETED, cmpAgentPayBillInfo);
        } else if (DisposerActionEnum.CANCEL_PAY.equals((Object)actionType)) {
            this.changeCmpAgentPayBillState(context, CmpBillStatusEnum.CANCE_PAY, cmpAgentPayBillInfo);
            this.synchCmpAgentPayBillState(context, agentPayBillInfo);
        } else if (DisposerActionEnum.SUBMIT.equals((Object)actionType)) {
            this.changeCmpAgentPayBillState(context, CmpBillStatusEnum.SUBMIT, cmpAgentPayBillInfo);
        } else if (DisposerActionEnum.AUDIT.equals((Object)actionType)) {
            this.changeCmpAgentPayBillState(context, CmpBillStatusEnum.AUDITED, cmpAgentPayBillInfo);
        } else if (DisposerActionEnum.ANTI_AUDIT.equals((Object)actionType)) {
            this.changeCmpAgentPayBillState(context, CmpBillStatusEnum.SAVE, cmpAgentPayBillInfo);
        } else if (DisposerActionEnum.AgentPayBankStateChange.equals((Object)actionType)) {
            this.synchCmpAgentPayBillState(context, agentPayBillInfo);
        }
    }

    private void changeCmpAgentPayBillState(Context context, CmpBillStatusEnum stateEnum, CmpAgentPayBillInfo cmpAgentPayBillInfo) throws EASBizException, BOSException {
        ICmpAgentPayBill cmpAgentPayBill = CmpAgentPayBillFactory.getLocalInstance(context);
        String billId = cmpAgentPayBillInfo.getId().toString();
        cmpAgentPayBillInfo.setState(stateEnum);
        cmpAgentPayBill.update((IObjectPK)new ObjectUuidPK(billId), cmpAgentPayBillInfo);
    }

    private void synchCmpAgentPayBillState(Context ctx, AgentPayBillInfo agentPayBillInfo) throws BOSException, EASBizException {
        AgentPayBillEntryCollection coll = agentPayBillInfo.getEntrys();
        if (coll == null || coll.size() == 0) {
            return;
        }
        Map<String, CmpAgentPayBillEntryInfo> map = this.getCmpAgentPayBillEntryMap(ctx);
        CoreBaseCollection updateColl = new CoreBaseCollection();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            AgentPayBillEntryInfo agentPayBillEntryInfo = coll.get(i);
            boolean isSuccess = agentPayBillEntryInfo.isIsSuccess();
            String sourceEntryId = agentPayBillEntryInfo.getSourceBillId();
            CmpAgentPayBillEntryInfo cmpAgentPayBillEntryInfo = map.get(sourceEntryId);
            if (cmpAgentPayBillEntryInfo == null) continue;
            cmpAgentPayBillEntryInfo.setIsSuccess(isSuccess);
            updateColl.add((CoreBaseInfo)cmpAgentPayBillEntryInfo);
        }
        ICmpAgentPayBillEntry cmpAgentPayBillEntry = CmpAgentPayBillEntryFactory.getLocalInstance(ctx);
        cmpAgentPayBillEntry.updateBatchData(updateColl);
    }

    private Map<String, CmpAgentPayBillEntryInfo> getCmpAgentPayBillEntryMap(Context ctx) throws BOSException {
        HashMap<String, CmpAgentPayBillEntryInfo> map = new HashMap<String, CmpAgentPayBillEntryInfo>();
        ICmpAgentPayBillEntry cmpAgentPayBillEntry = CmpAgentPayBillEntryFactory.getLocalInstance(ctx);
        CmpAgentPayBillEntryCollection coll = cmpAgentPayBillEntry.getCmpAgentPayBillEntryCollection();
        if (coll != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                CmpAgentPayBillEntryInfo info = coll.get(i);
                String entryId = info.getId().toString();
                map.put(entryId, info);
            }
        }
        return map;
    }

    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }
}

