/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalSchemeItemCollection;
import com.kingdee.shr.compensation.CalSchemeItemFactory;
import com.kingdee.shr.compensation.CmpGiveAccountFactory;
import com.kingdee.shr.compensation.CmpGiveAccountInfo;
import com.kingdee.shr.compensation.ICmpGiveAccount;
import com.kingdee.shr.compensation.app.AbstractCmpGiveAccountControllerBean;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.currency.CurrencyUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Deprecated
public class CmpGiveAccountControllerBean
extends AbstractCmpGiveAccountControllerBean {
    private static final long serialVersionUID = 2472081194147779278L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.CmpGiveAccountControllerBean");

    @Override
    protected void _calculatePaymentAcount(Context ctx, Map param) throws BOSException, EASBizException {
        CalSchemeInfo calScheme = (CalSchemeInfo)param.get("calSchemeInfo");
        String oql = "select id, isGrant, cmpItem.fieldSn, cmpItem.dataDot where calScheme = '" + calScheme.getId().toString() + "' and isGrant = 1";
        CalSchemeItemCollection grantCalSchemeItemCol = CalSchemeItemFactory.getLocalInstance(ctx).getCalSchemeItemCollection(oql);
        if (grantCalSchemeItemCol.size() == 0) {
            return;
        }
        ArrayList<String> calTableRecordIds = new ArrayList<String>();
        String sql = this.generatePreUpdateSql(ctx, grantCalSchemeItemCol);
        List<Object[]> paramList = this.calculGiveAccountAndGetParamsList(ctx, grantCalSchemeItemCol, calTableRecordIds, param);
        ICmpGiveAccount giveAccount = CmpGiveAccountFactory.getLocalInstance(ctx);
        String deleteOql = "where cmpCalTable in ('" + StringUtils.join((Object[])calTableRecordIds.toArray(), (String)"','") + "')";
        giveAccount.delete(deleteOql);
        DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
    }

    private Map<String, BigDecimal> getExchangeRateMap(Context ctx, CalSchemeInfo calScheme) throws BOSException {
        Date ruleEffdt = CurrencyUtil.getEffdtByExchangeRule(calScheme.getExchangeRule(), calScheme.getBeginDate(), calScheme.getEndDate());
        ExchangeRateCollection coll = CurrencyUtil.getExchangeRate(ctx, calScheme.getExchangeTable().getId().toString(), calScheme.getCurrency().getId().toString(), ruleEffdt);
        HashMap<String, BigDecimal> targetExchangeRateMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < coll.size(); ++i) {
            ExchangeRateInfo exchangeRateInfo = coll.get(i);
            targetExchangeRateMap.put(exchangeRateInfo.getTargetCurrency().getId().toString(), exchangeRateInfo.getConvertRate());
        }
        return targetExchangeRateMap;
    }

    private String generatePreUpdateSql(Context ctx, CalSchemeItemCollection grantCalSchemeItemCol) throws BOSException {
        StringBuilder sqlBuilder = new StringBuilder("insert into T_HR_SCmpGiveAccount (Fid,FCMPCALTABLEID,");
        StringBuilder subSql = new StringBuilder();
        for (int i = 0; i < grantCalSchemeItemCol.size(); ++i) {
            int fieldSn = grantCalSchemeItemCol.get(i).getCmpItem().getFieldSn();
            String cmpGiveAccountField = "s" + fieldSn + "_account";
            String cmpGiveCurrencyField = "s" + fieldSn + "_currency";
            sqlBuilder.append(cmpGiveAccountField + "," + cmpGiveCurrencyField + ",");
            subSql.append("?,?,");
        }
        sqlBuilder = sqlBuilder.deleteCharAt(sqlBuilder.lastIndexOf(","));
        subSql = subSql.deleteCharAt(subSql.lastIndexOf(","));
        sqlBuilder.append(") values (?, ?,").append(subSql.toString()).append(")");
        return sqlBuilder.toString();
    }

    private List<Object[]> calculGiveAccountAndGetParamsList(Context ctx, CalSchemeItemCollection grantCalSchemeItemCol, List<String> calTableRecordIds, Map inputParam) throws BOSException, EASBizException {
        List listData = (List)inputParam.get("listData");
        StringBuilder exchageRateErrorMessage = new StringBuilder();
        StringBuilder hadCreatePerErrorMessage = new StringBuilder();
        StringBuilder giveAccountSettingErrorMessage = new StringBuilder();
        String baseCurrencyId = (String)inputParam.get("currencyId");
        CalSchemeInfo calScheme = (CalSchemeInfo)inputParam.get("calSchemeInfo");
        Map<String, BigDecimal> targetExchangeRateMap = this.getExchangeRateMap(ctx, calScheme);
        List<String> personIds = this.getPersonIds(listData);
        Map<String, Map<Integer, String>> filAccountSetting = this.getFilAccountSetting(ctx, personIds, inputParam);
        Map<String, CurrencyInfo> currencyMap = this.getCurrencyMap(ctx);
        Set<String> existPers = this.hadCreatedPers(ctx, inputParam, personIds);
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        HashSet<String> errorExchangeRate = new HashSet<String>();
        for (Map calTableRecord : listData) {
            String calTableId = (String)calTableRecord.get("cmp_ctb.id");
            String personId = (String)calTableRecord.get("cmp_person.id");
            if (hadCreatePerErrorMessage.length() == 0 && existPers.contains(personId)) {
                hadCreatePerErrorMessage.append("\u90e8\u5206\u5458\u5de5\u5df2\u7ecf\u751f\u6210\u4e86\u94f6\u884c\u4ee3\u53d1\u5355\uff0c\u8be5\u90e8\u5206\u5458\u5de5\u4e0d\u751f\u6210\u53d1\u653e\u91d1\u989d\uff01");
                continue;
            }
            Map<Integer, String> fieldSn_currencyMap = filAccountSetting.get(personId);
            ArrayList<String> param = new ArrayList<String>();
            param.add(BOSUuid.create((BOSObjectType)new CmpGiveAccountInfo().getBOSType()).toString());
            param.add(calTableId);
            for (int i = 0; i < grantCalSchemeItemCol.size(); ++i) {
                int grantCmpItemFieldSn = grantCalSchemeItemCol.get(i).getCmpItem().getFieldSn();
                String cmp_ctbField = "cmp_ctb.s" + grantCmpItemFieldSn;
                int cmpItemDataDot = grantCalSchemeItemCol.get(i).getCmpItem().getDataDot().getValue();
                Object originItemValue = calTableRecord.get(cmp_ctbField);
                if (originItemValue != null) {
                    BigDecimal exchangeRate;
                    String giveCurrency;
                    if (fieldSn_currencyMap == null) {
                        giveCurrency = baseCurrencyId;
                    } else {
                        String string = giveCurrency = fieldSn_currencyMap.containsKey(grantCmpItemFieldSn) ? fieldSn_currencyMap.get(grantCmpItemFieldSn) : fieldSn_currencyMap.get(9999);
                        if (giveCurrency == null) {
                            giveCurrency = baseCurrencyId;
                        }
                        if ("repeatAndSkip".equals(giveCurrency)) {
                            if (giveAccountSettingErrorMessage.length() == 0) {
                                giveAccountSettingErrorMessage.append("\u90e8\u5206\u5458\u5de5\u7684\u85aa\u916c\u53d1\u653e\u8bbe\u7f6e\u4e2d\u5b58\u5728\u591a\u6761\u8bb0\u5f55\u540c\u4e00\u85aa\u916c\u9879\u76ee\uff0c\u8def\u5f84\uff1a\u5458\u5de5\u85aa\u916c\u6863\u6848-\u85aa\u916c\u53d1\u653e\u8bbe\u7f6e");
                            }
                            param.add(null);
                            param.add(null);
                            continue;
                        }
                    }
                    BigDecimal bigDecimal = exchangeRate = giveCurrency.equals(baseCurrencyId) ? new BigDecimal(1) : targetExchangeRateMap.get(giveCurrency);
                    if (exchangeRate == null) {
                        if (!errorExchangeRate.contains(giveCurrency)) {
                            CurrencyInfo sourceCurrency = currencyMap.get(baseCurrencyId);
                            CurrencyInfo targetCurrency = currencyMap.get(giveCurrency);
                            exchageRateErrorMessage.append("\u539f\u5e01\uff1a").append(sourceCurrency.getName()).append("&nbsp;&nbsp;&nbsp;").append("\u76ee\u6807\u5e01\uff1a").append(targetCurrency.getName()).append("</br>");
                            errorExchangeRate.add(giveCurrency);
                        }
                        param.add(null);
                        param.add(null);
                        continue;
                    }
                    BigDecimal giveItemValue = new BigDecimal((String)originItemValue).multiply(exchangeRate).setScale(cmpItemDataDot, 4);
                    param.add(FunctionTools.getRound(cmpItemDataDot, giveItemValue.doubleValue()));
                    param.add(giveCurrency);
                    continue;
                }
                param.add(null);
                param.add(null);
            }
            calTableRecordIds.add(calTableId);
            result.add(param.toArray());
        }
        inputParam.put("exchageRateErrorMessage", exchageRateErrorMessage);
        inputParam.put("hadCreatePerErrorMessage", hadCreatePerErrorMessage);
        inputParam.put("giveAccountSettingErrorMessage", giveAccountSettingErrorMessage);
        return result;
    }

    private Map<String, Map<Integer, String>> getFilAccountSetting(Context ctx, List<String> personIds, Map inputParam) throws BOSException, EASBizException {
        HashMap<String, Map<Integer, String>> result = new HashMap<String, Map<Integer, String>>();
        String hrOrgUnitId = (String)inputParam.get("hrOrgUnitId");
        String sql = "SELECT * FROM T_HR_SCmpEmpAccount fil_account LEFT JOIN t_hr_scmppaymentcurrency payCur on payCur.FPersonCmpID = fil_account.FPersonCmpID AND payCur.FPersonBankID = fil_account.FPersonBankID LEFT JOIN T_HR_SCmpItem item on payCur.FCmpItemID = item.FID WHERE payCur.FHROrgUnitID = '" + hrOrgUnitId + "' AND FIsEnable = 1 AND fil_account.FPersonID in ('" + StringUtils.join((Object[])personIds.toArray(), (String)"','") + "')";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        int fieldSn = 0;
        try {
            while (rowSet.next()) {
                Map<Integer, Object> filedSn_currency;
                String personId = rowSet.getString("fpersonid");
                if (result.containsKey(personId)) {
                    filedSn_currency = (Map)result.get(personId);
                } else {
                    filedSn_currency = new HashMap();
                    result.put(personId, filedSn_currency);
                }
                String cmpItemId = rowSet.getString("cmpitemid");
                if (cmpItemId == null && filedSn_currency.containsKey(9999)) {
                    filedSn_currency.put(8888, null);
                    continue;
                }
                if (cmpItemId != null) {
                    fieldSn = rowSet.getInt("fieldsn");
                    filedSn_currency.put(fieldSn, rowSet.getString("fcurrencyId"));
                    continue;
                }
                filedSn_currency.put(9999, rowSet.getString("fcurrencyId"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<String> getPersonIds(List<Map<String, Object>> listData) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map<String, Object> calTableRecord : listData) {
            result.add((String)calTableRecord.get("cmp_person.id"));
        }
        return result;
    }

    private Map<String, CurrencyInfo> getCurrencyMap(Context ctx) throws BOSException {
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        ICurrency currency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection currencyCollection = currency.getCurrencyCollection();
        for (int i = 0; i < currencyCollection.size(); ++i) {
            currencyMap.put(currencyCollection.get(i).getId().toString(), currencyCollection.get(i));
        }
        return currencyMap;
    }

    private Set<String> hadCreatedPers(Context ctx, Map param, List<String> personIds) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        CalSchemeInfo schemeInfo = (CalSchemeInfo)param.get("calSchemeInfo");
        String cmpSchemeId = schemeInfo.getId().toString();
        int periodYear = schemeInfo.getPeriodYear();
        int periodMonth = schemeInfo.getPeriodMonth();
        int calTime = schemeInfo.getCalTime();
        String sql = this.bulidIntegrateCQNoPayOrPaySuccess(cmpSchemeId, periodYear, periodMonth, calTime);
        if (!((Boolean)param.get("isAll")).booleanValue()) {
            sql = sql + " AND fpersonid in ('" + StringUtils.join((Object[])personIds.toArray(), (String)"','") + "')";
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String personId = rowSet.getString("fpersonid");
                set.add(personId);
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("002", e.getMessage()));
        }
        return set;
    }

    private String bulidIntegrateCQNoPayOrPaySuccess(String cmpSchemeId, int periodYear, int periodMonth, int calTime) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select fpersonid from T_HR_SCmpAgentPayBill bill LEFT OUTER JOIN T_HR_SCmpAgentPayBillEntry entry on bill.fid = entry.fBillId");
        sb.append(" where bill.FCalSchemeID = '" + cmpSchemeId + "' ");
        sb.append(" and bill.FPeriodYear = " + periodYear + " and bill.FPeriodMonth = " + periodMonth + " and bill.FCalTime = " + calTime + " ");
        sb.append(" and (bill.FState = 4 and entry.FIsSuccess = 1 or bill.FState in (1,2,3,6,7,8))");
        return sb.toString();
    }
}

